/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.JsonPointer;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.databind.JsonSerializable;
import com.privatefasterxml.jackson.databind.b;
import com.privatefasterxml.jackson.databind.node.ArrayNode;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.MissingNode;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class JsonNode
extends JsonSerializable.Base
implements TreeNode,
Iterable<JsonNode> {
    public abstract <T extends JsonNode> T deepCopy();

    @Override
    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean isValueNode() {
        int n2 = b.a[this.getNodeType().ordinal()];
        return n2 != 1 && n2 != 2 && n2 != 3;
    }

    @Override
    public final boolean isContainerNode() {
        JsonNodeType jsonNodeType = this.getNodeType();
        return jsonNodeType == JsonNodeType.OBJECT || jsonNodeType == JsonNodeType.ARRAY;
    }

    @Override
    public boolean isMissingNode() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public abstract JsonNode get(int var1);

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public abstract JsonNode path(String var1);

    @Override
    public abstract JsonNode path(int var1);

    @Override
    public Iterator<String> fieldNames() {
        return ClassUtil.emptyIterator();
    }

    @Override
    public final JsonNode at(JsonPointer jsonPointer) {
        if (jsonPointer.matches()) {
            return this;
        }
        if ((this = this._at(jsonPointer)) == null) {
            return MissingNode.getInstance();
        }
        return this.at(jsonPointer.tail());
    }

    @Override
    public final JsonNode at(String string) {
        return this.at(JsonPointer.compile(string));
    }

    public abstract JsonNode _at(JsonPointer var1);

    public abstract JsonNodeType getNodeType();

    public final boolean isPojo() {
        return this.getNodeType() == JsonNodeType.POJO;
    }

    public final boolean isNumber() {
        return this.getNodeType() == JsonNodeType.NUMBER;
    }

    public boolean isIntegralNumber() {
        return false;
    }

    public boolean isFloatingPointNumber() {
        return false;
    }

    public boolean isShort() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isBigDecimal() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public final boolean isTextual() {
        return this.getNodeType() == JsonNodeType.STRING;
    }

    public final boolean isBoolean() {
        return this.getNodeType() == JsonNodeType.BOOLEAN;
    }

    public final boolean isNull() {
        return this.getNodeType() == JsonNodeType.NULL;
    }

    public final boolean isBinary() {
        return this.getNodeType() == JsonNodeType.BINARY;
    }

    public boolean canConvertToInt() {
        return false;
    }

    public boolean canConvertToLong() {
        return false;
    }

    public boolean canConvertToExactIntegral() {
        return this.isIntegralNumber();
    }

    public String textValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public boolean booleanValue() {
        return false;
    }

    public Number numberValue() {
        return null;
    }

    public short shortValue() {
        return 0;
    }

    public int intValue() {
        return 0;
    }

    public long longValue() {
        return 0L;
    }

    public float floatValue() {
        return 0.0f;
    }

    public double doubleValue() {
        return 0.0;
    }

    public BigDecimal decimalValue() {
        return BigDecimal.ZERO;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.ZERO;
    }

    public abstract String asText();

    public String asText(String object) {
        if ((this = ((JsonNode)this).asText()) != null) {
            object = this;
        }
        return object;
    }

    public int asInt() {
        return this.asInt(0);
    }

    public int asInt(int n2) {
        return n2;
    }

    public long asLong() {
        return this.asLong(0L);
    }

    public long asLong(long l2) {
        return l2;
    }

    public double asDouble() {
        return this.asDouble(0.0);
    }

    public double asDouble(double d2) {
        return d2;
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public boolean asBoolean(boolean bl) {
        return bl;
    }

    public <T extends JsonNode> T require() {
        return this._this();
    }

    public <T extends JsonNode> T requireNonNull() {
        return this._this();
    }

    public JsonNode required(String objectArray) {
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = this.getClass().getName();
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no fields", objectArray);
    }

    public JsonNode required(int n2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getClass().getName();
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no indexed values", objectArray2);
    }

    public JsonNode requiredAt(String string) {
        return this.requiredAt(JsonPointer.compile(string));
    }

    public final JsonNode requiredAt(JsonPointer jsonPointer) {
        JsonNode jsonNode = this;
        JsonPointer jsonPointer2 = jsonPointer;
        while (!jsonPointer2.matches()) {
            if ((jsonNode = jsonNode._at(jsonPointer2)) == null) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = jsonPointer;
                objectArray[1] = jsonPointer2;
                this._reportRequiredViolation("No node at '%s' (unmatched part: '%s')", objectArray2);
            }
            jsonPointer2 = jsonPointer2.tail();
        }
        return jsonNode;
    }

    public boolean has(String string) {
        return this.get(string) != null;
    }

    public boolean has(int n2) {
        return this.get(n2) != null;
    }

    public boolean hasNonNull(String string) {
        return (this = this.get(string)) != null && !this.isNull();
    }

    public boolean hasNonNull(int n2) {
        return (this = this.get(n2)) != null && !this.isNull();
    }

    @Override
    public final Iterator<JsonNode> iterator() {
        return this.elements();
    }

    public Iterator<JsonNode> elements() {
        return ClassUtil.emptyIterator();
    }

    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return ClassUtil.emptyIterator();
    }

    public abstract JsonNode findValue(String var1);

    /*
     * WARNING - void declaration
     */
    public final List<JsonNode> findValues(String string) {
        void var1_2;
        List<JsonNode> list = this.findValues((String)var1_2, null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> findValuesAsText(String string) {
        void var1_2;
        List<String> list = this.findValuesAsText((String)var1_2, null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public abstract JsonNode findPath(String var1);

    public abstract JsonNode findParent(String var1);

    /*
     * WARNING - void declaration
     */
    public final List<JsonNode> findParents(String string) {
        void var1_2;
        List<JsonNode> list = this.findParents((String)var1_2, null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public abstract List<JsonNode> findValues(String var1, List<JsonNode> var2);

    public abstract List<String> findValuesAsText(String var1, List<String> var2);

    public abstract List<JsonNode> findParents(String var1, List<JsonNode> var2);

    public final ObjectNode withObject(String string) {
        return this.withObject(JsonPointer.compile(string));
    }

    public final ObjectNode withObject(String string, OverwriteMode overwriteMode, boolean bl) {
        return this.withObject(JsonPointer.compile(string), overwriteMode, bl);
    }

    public final ObjectNode withObject(JsonPointer jsonPointer) {
        return this.withObject(jsonPointer, OverwriteMode.NULLS, true);
    }

    public ObjectNode withObject(JsonPointer jsonPointer, OverwriteMode overwriteMode, boolean bl) {
        throw new UnsupportedOperationException("`withObject(JsonPointer)` not implemented by `" + this.getClass().getName() + "`");
    }

    @Deprecated
    public <T extends JsonNode> T with(String string) {
        throw new UnsupportedOperationException("`JsonNode` not of type `ObjectNode` (but " + this.getClass().getName() + "), cannot call `with(String)` on it");
    }

    public <T extends JsonNode> T withArray(String string) {
        throw new UnsupportedOperationException("`JsonNode` not of type `ObjectNode` (but `" + this.getClass().getName() + ")`, cannot call `withArray()` on it");
    }

    public ArrayNode withArray(String string, OverwriteMode overwriteMode, boolean bl) {
        return this.withArray(JsonPointer.compile(string), overwriteMode, bl);
    }

    public final ArrayNode withArray(JsonPointer jsonPointer) {
        return this.withArray(jsonPointer, OverwriteMode.NULLS, true);
    }

    public ArrayNode withArray(JsonPointer jsonPointer, OverwriteMode overwriteMode, boolean bl) {
        throw new UnsupportedOperationException("`withArray(JsonPointer)` not implemented by ".concat(this.getClass().getName()));
    }

    public boolean equals(Comparator<JsonNode> comparator, JsonNode jsonNode) {
        return comparator.compare(this, jsonNode) == 0;
    }

    public abstract String toString();

    public String toPrettyString() {
        return this.toString();
    }

    public abstract boolean equals(Object var1);

    public <T extends JsonNode> T _this() {
        return (T)this;
    }

    public <T> T _reportRequiredViolation(String string, Object ... objectArray) {
        throw new IllegalArgumentException(String.format(string, objectArray));
    }

    public static enum OverwriteMode {
        NONE,
        NULLS,
        SCALARS,
        ALL;

    }
}

