/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MappingIterator<T>
implements Iterator<T>,
Closeable {
    protected static final MappingIterator<?> EMPTY_ITERATOR = new MappingIterator(null, null, null, null, false, null);
    protected static final int STATE_CLOSED = 0;
    protected static final int STATE_NEED_RESYNC = 1;
    protected static final int STATE_MAY_HAVE_VALUE = 2;
    protected static final int STATE_HAS_VALUE = 3;
    protected final JavaType _type;
    protected final DeserializationContext _context;
    protected final JsonDeserializer<T> _deserializer;
    protected final JsonParser _parser;
    protected final JsonStreamContext _seqContext;
    protected final T _updatedValue;
    protected final boolean _closeParser;
    protected int _state;

    public MappingIterator(JavaType object, JsonParser object2, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer, boolean bl, Object object3) {
        this._type = object;
        this._parser = object2;
        this._context = deserializationContext;
        this._deserializer = jsonDeserializer;
        this._closeParser = bl;
        this._updatedValue = object3 == null ? null : object3;
        if (object2 == null) {
            MappingIterator mappingIterator = this;
            mappingIterator._seqContext = null;
            mappingIterator._state = 0;
        } else {
            object = object2.getParsingContext();
            if (bl && object2.isExpectedStartArrayToken()) {
                object2.clearCurrentToken();
            } else if ((object2 = object2.currentToken()) == JsonToken.START_OBJECT || object2 == JsonToken.START_ARRAY) {
                object = ((JsonStreamContext)object).getParent();
            }
            MappingIterator mappingIterator = this;
            mappingIterator._seqContext = object;
            mappingIterator._state = 2;
        }
    }

    public static <T> MappingIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (IOException iOException) {
            return (Boolean)this._handleIOException(iOException);
        }
        catch (JsonMappingException jsonMappingException) {
            return (Boolean)this._handleMappingException(jsonMappingException);
        }
    }

    @Override
    public T next() {
        try {
            return this.nextValue();
        }
        catch (IOException iOException) {
            return (T)this._handleIOException(iOException);
        }
        catch (JsonMappingException jsonMappingException) {
            return (T)this._handleMappingException(jsonMappingException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (((MappingIterator)closeable)._state != 0) {
            ((MappingIterator)closeable)._state = 0;
            Closeable closeable = ((MappingIterator)closeable)._parser;
            if (closeable != null) {
                ((JsonParser)closeable).close();
            }
        }
    }

    public boolean hasNextValue() {
        int n2 = this._state;
        if (n2 != 0) {
            Object object;
            if (n2 != 1) {
                if (n2 != 2) {
                    return true;
                }
            } else {
                this._resync();
            }
            if ((object = this._parser) == null) {
                return false;
            }
            if (object.currentToken() == null && ((object = this._parser.nextToken()) == null || object == JsonToken.END_ARRAY)) {
                this._state = 0;
                if (this._closeParser) {
                    this._parser.close();
                }
                return false;
            }
            this._state = 3;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T nextValue() {
        Throwable throwable2;
        int n2;
        block8: {
            T t2;
            n2 = this._state;
            if (n2 == 0) {
                return (T)this._throwNoSuchElement();
            }
            if (!(n2 != 1 && n2 != 2 || this.hasNextValue())) {
                return (T)this._throwNoSuchElement();
            }
            n2 = 1;
            try {
                T t3;
                Object object = this._updatedValue;
                if (object == null) {
                    MappingIterator mappingIterator = this;
                    object = mappingIterator._parser;
                    t3 = this._deserializer.deserialize((JsonParser)object, mappingIterator._context);
                } else {
                    MappingIterator mappingIterator = this;
                    MappingIterator mappingIterator2 = this;
                    JsonParser jsonParser = mappingIterator2._parser;
                    mappingIterator._deserializer.deserialize(jsonParser, mappingIterator2._context, object);
                    t3 = mappingIterator._updatedValue;
                }
                t2 = t3;
            }
            catch (Throwable throwable2) {
                break block8;
            }
            this._state = 2;
            this._parser.clearCurrentToken();
            return t2;
        }
        this._state = n2;
        this._parser.clearCurrentToken();
        throw throwable2;
    }

    public List<T> readAll() {
        return this.readAll((Collection)new ArrayList());
    }

    public <L extends List<? super T>> L readAll(L l2) {
        while (this.hasNextValue()) {
            l2.add(this.nextValue());
        }
        return l2;
    }

    public <C extends Collection<? super T>> C readAll(C c2) {
        while (this.hasNextValue()) {
            c2.add(this.nextValue());
        }
        return c2;
    }

    public JsonParser getParser() {
        return this._parser;
    }

    public FormatSchema getParserSchema() {
        return this._parser.getSchema();
    }

    public JsonLocation getCurrentLocation() {
        return this._parser.getCurrentLocation();
    }

    public void _resync() {
        JsonParser jsonParser = this._parser;
        if (jsonParser.getParsingContext() == this._seqContext) {
            return;
        }
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT) {
                if (jsonToken != JsonToken.START_ARRAY && jsonToken != JsonToken.START_OBJECT) {
                    if (jsonToken != null) continue;
                    return;
                }
                jsonParser.skipChildren();
                continue;
            }
            if (jsonParser.getParsingContext() == this._seqContext) break;
        }
        jsonParser.clearCurrentToken();
    }

    public <R> R _throwNoSuchElement() {
        throw new NoSuchElementException();
    }

    public <R> R _handleMappingException(JsonMappingException jsonMappingException) {
        throw new RuntimeJsonMappingException(jsonMappingException.getMessage(), jsonMappingException);
    }

    public <R> R _handleIOException(IOException iOException) {
        throw new RuntimeException(iOException.getMessage(), iOException);
    }
}

