/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.JsonAutoDetect;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.annotation.JsonSetter;
import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.annotation.PropertyAccessor;
import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonEncoding;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonProcessingException;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.StreamWriteFeature;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.SegmentedStringWriter;
import com.privatefasterxml.jackson.core.type.ResolvedType;
import com.privatefasterxml.jackson.core.type.TypeReference;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.InjectableValues;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.MappingIterator;
import com.privatefasterxml.jackson.databind.MappingJsonFactory;
import com.privatefasterxml.jackson.databind.Module;
import com.privatefasterxml.jackson.databind.ObjectReader;
import com.privatefasterxml.jackson.databind.ObjectWriter;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.c;
import com.privatefasterxml.jackson.databind.cfg.BaseSettings;
import com.privatefasterxml.jackson.databind.cfg.CoercionConfigs;
import com.privatefasterxml.jackson.databind.cfg.ConfigOverrides;
import com.privatefasterxml.jackson.databind.cfg.ConstructorDetector;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfigBase;
import com.privatefasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.privatefasterxml.jackson.databind.cfg.MutableConfigOverride;
import com.privatefasterxml.jackson.databind.d;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.privatefasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.privatefasterxml.jackson.databind.e;
import com.privatefasterxml.jackson.databind.exc.MismatchedInputException;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.privatefasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonschema.JsonSchema;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.privatefasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.privatefasterxml.jackson.databind.node.ArrayNode;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.node.POJONode;
import com.privatefasterxml.jackson.databind.node.TreeTraversingParser;
import com.privatefasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.privatefasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.privatefasterxml.jackson.databind.ser.FilterProvider;
import com.privatefasterxml.jackson.databind.ser.SerializerFactory;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.RootNameLookup;
import com.privatefasterxml.jackson.databind.util.StdDateFormat;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectMapper
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 2L;
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR;
    protected static final BaseSettings DEFAULT_BASE;
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final ConfigOverrides _configOverrides;
    protected final CoercionConfigs _coercionConfigs;
    protected SimpleMixInResolver _mixIns;
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected Set<Object> _registeredModuleTypes;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    public ObjectMapper(ObjectMapper objectMapper) {
        this(objectMapper, null);
    }

    public ObjectMapper(ObjectMapper object, JsonFactory serializable) {
        DeserializationConfig deserializationConfig;
        SerializationConfig serializationConfig;
        RootNameLookup rootNameLookup;
        ConcurrentHashMap concurrentHashMap;
        Serializable serializable2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap(64, 0.6f, 2);
        this._rootDeserializers = serializable2;
        if (serializable == null) {
            serializable = ((ObjectMapper)object)._jsonFactory.copy();
        }
        ObjectMapper objectMapper = object;
        this._jsonFactory = serializable;
        serializable.setCodec(this);
        this._subtypeResolver = objectMapper._subtypeResolver.copy();
        this._typeFactory = objectMapper._typeFactory;
        this._injectableValues = objectMapper._injectableValues;
        serializable = objectMapper._configOverrides.copy();
        this._configOverrides = serializable;
        serializable2 = objectMapper._coercionConfigs.copy();
        this._coercionConfigs = serializable2;
        this._mixIns = objectMapper._mixIns.copy();
        RootNameLookup rootNameLookup2 = rootNameLookup;
        rootNameLookup = new RootNameLookup();
        MapperConfigBase mapperConfigBase = serializationConfig;
        serializationConfig = new SerializationConfig(((ObjectMapper)object)._serializationConfig, this._subtypeResolver, this._mixIns, rootNameLookup2, (ConfigOverrides)serializable);
        this._serializationConfig = mapperConfigBase;
        mapperConfigBase = deserializationConfig;
        deserializationConfig = new DeserializationConfig(((ObjectMapper)object)._deserializationConfig, this._subtypeResolver, this._mixIns, rootNameLookup2, (ConfigOverrides)serializable, (CoercionConfigs)serializable2);
        this._deserializationConfig = mapperConfigBase;
        this._serializerProvider = objectMapper._serializerProvider.copy();
        this._deserializationContext = objectMapper._deserializationContext.copy();
        this._serializerFactory = objectMapper._serializerFactory;
        object = objectMapper._registeredModuleTypes;
        if (object == null) {
            this._registeredModuleTypes = null;
        } else {
            LinkedHashSet linkedHashSet;
            serializable = linkedHashSet;
            linkedHashSet = new LinkedHashSet(object);
            this._registeredModuleTypes = serializable;
        }
    }

    public ObjectMapper(JsonFactory serializable, DefaultSerializerProvider defaultSerializerProvider, DefaultDeserializationContext defaultDeserializationContext) {
        DeserializationConfig deserializationConfig;
        SerializationConfig serializationConfig;
        CoercionConfigs coercionConfigs;
        ConfigOverrides configOverrides;
        SimpleMixInResolver simpleMixInResolver;
        RootNameLookup rootNameLookup;
        StdSubtypeResolver stdSubtypeResolver;
        ConcurrentHashMap concurrentHashMap;
        Object object = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap(64, 0.6f, 2);
        this._rootDeserializers = object;
        if (serializable == null) {
            MappingJsonFactory mappingJsonFactory;
            serializable = mappingJsonFactory;
            mappingJsonFactory = new MappingJsonFactory(this);
            this._jsonFactory = serializable;
        } else {
            this._jsonFactory = serializable;
            if (serializable.getCodec() == null) {
                serializable.setCodec(this);
            }
        }
        serializable = stdSubtypeResolver;
        stdSubtypeResolver = new StdSubtypeResolver();
        this._subtypeResolver = serializable;
        serializable = rootNameLookup;
        rootNameLookup = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        object = simpleMixInResolver;
        simpleMixInResolver = new SimpleMixInResolver(null);
        this._mixIns = object;
        Object object2 = DEFAULT_BASE.withClassIntrospector(this.defaultClassIntrospector());
        ConfigOverrides configOverrides2 = configOverrides;
        configOverrides = new ConfigOverrides();
        this._configOverrides = configOverrides2;
        CoercionConfigs coercionConfigs2 = coercionConfigs;
        coercionConfigs = new CoercionConfigs();
        this._coercionConfigs = coercionConfigs2;
        MapperConfigBase mapperConfigBase = serializationConfig;
        Object object3 = this._subtypeResolver;
        DatatypeFeatures datatypeFeatures = DatatypeFeatures.defaultFeatures();
        serializationConfig = new SerializationConfig((BaseSettings)object2, (SubtypeResolver)object3, (SimpleMixInResolver)object, (RootNameLookup)serializable, configOverrides2, datatypeFeatures);
        this._serializationConfig = mapperConfigBase;
        mapperConfigBase = deserializationConfig;
        BaseSettings baseSettings = object2;
        object2 = this._subtypeResolver;
        object3 = DatatypeFeatures.defaultFeatures();
        deserializationConfig = new DeserializationConfig(baseSettings, (SubtypeResolver)object2, (SimpleMixInResolver)object, (RootNameLookup)serializable, configOverrides2, coercionConfigs2, (DatatypeFeatures)object3);
        this._deserializationConfig = mapperConfigBase;
        boolean bl = this._jsonFactory.requiresPropertyOrdering();
        object = MapperFeature.SORT_PROPERTIES_ALPHABETICALLY;
        if (bl ^ this._serializationConfig.isEnabled((MapperFeature)object)) {
            this.configure((MapperFeature)object, bl);
        }
        if (defaultSerializerProvider == null) {
            DefaultSerializerProvider.Impl impl;
            defaultSerializerProvider = impl;
            impl = new DefaultSerializerProvider.Impl();
        }
        this._serializerProvider = defaultSerializerProvider;
        if (defaultDeserializationContext == null) {
            DefaultDeserializationContext.Impl impl;
            defaultDeserializationContext = impl;
            impl = new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance);
        }
        this._deserializationContext = defaultDeserializationContext;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    public static List<Module> findModules() {
        return ObjectMapper.findModules(null);
    }

    public static List<Module> findModules(ClassLoader object) {
        ArrayList<Module> arrayList;
        ArrayList<Module> arrayList2 = arrayList;
        arrayList = new ArrayList<Module>();
        object = ObjectMapper.secureGetServiceLoader(Module.class, (ClassLoader)object).iterator();
        while (object.hasNext()) {
            arrayList2.add((Module)object.next());
        }
        return arrayList2;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new d(clazz, classLoader));
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) {
        Closeable closeable = (Closeable)object;
        Closeable closeable2 = closeable;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            closeable2 = null;
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable2, exception);
            return;
        }
        closeable.close();
        jsonGenerator.close();
    }

    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) {
        Exception exception2;
        block4: {
            block3: {
                ObjectMapper objectMapper = closeable;
                Closeable closeable = (Closeable)object;
                try {
                    objectMapper._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
                    if (!serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) break block3;
                }
                catch (Exception exception2) {
                    break block4;
                }
                jsonGenerator.flush();
            }
            closeable.close();
            return;
        }
        ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception2);
    }

    static {
        DefaultAccessorNamingStrategy.Provider provider;
        JacksonAnnotationIntrospector jacksonAnnotationIntrospector;
        JacksonAnnotationIntrospector jacksonAnnotationIntrospector2 = jacksonAnnotationIntrospector;
        DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        StdDateFormat stdDateFormat = StdDateFormat.instance;
        Locale locale = Locale.getDefault();
        Base64Variant base64Variant = Base64Variants.getDefaultVariant();
        LaissezFaireSubTypeValidator laissezFaireSubTypeValidator = LaissezFaireSubTypeValidator.instance;
        DefaultAccessorNamingStrategy.Provider provider2 = provider;
        provider = new DefaultAccessorNamingStrategy.Provider();
        DEFAULT_BASE = new BaseSettings(null, jacksonAnnotationIntrospector2, null, typeFactory, null, stdDateFormat, null, locale, null, base64Variant, laissezFaireSubTypeValidator, provider2);
    }

    public ClassIntrospector defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this);
    }

    public ObjectMapper copyWith(JsonFactory jsonFactory) {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this, jsonFactory);
    }

    public void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() == clazz) {
            return;
        }
        throw new IllegalStateException("Failed copy()/copyWith(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy()/copyWith(); it has to");
    }

    public ObjectReader _newReader(DeserializationConfig deserializationConfig) {
        return new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader _newReader(DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        return new ObjectReader(this, deserializationConfig, javaType, object, formatSchema, injectableValues);
    }

    public ObjectWriter _newWriter(SerializationConfig serializationConfig) {
        return new ObjectWriter(this, serializationConfig);
    }

    public ObjectWriter _newWriter(SerializationConfig serializationConfig, FormatSchema formatSchema) {
        return new ObjectWriter(this, serializationConfig, formatSchema);
    }

    public ObjectWriter _newWriter(SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        return new ObjectWriter(this, serializationConfig, javaType, prettyPrinter);
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    public ObjectMapper registerModule(Module object) {
        this._assertNotNull("module", object);
        if (((Module)object).getModuleName() != null) {
            if (((Module)object).version() != null) {
                c c2;
                Object object2 = ((Module)object).getDependencies().iterator();
                while (object2.hasNext()) {
                    this.registerModule(object2.next());
                }
                if (this.isEnabled(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS) && (object2 = ((Module)object).getTypeId()) != null) {
                    if (this._registeredModuleTypes == null) {
                        LinkedHashSet<Object> linkedHashSet;
                        LinkedHashSet<Object> linkedHashSet2 = linkedHashSet;
                        linkedHashSet = new LinkedHashSet<Object>();
                        this._registeredModuleTypes = linkedHashSet2;
                    }
                    if (!this._registeredModuleTypes.add(object2)) {
                        return this;
                    }
                }
                Module module = object;
                object = c2;
                c2 = new c(this);
                module.setupModule((Module.SetupContext)object);
                return this;
            }
            throw new IllegalArgumentException("Module without defined version");
        }
        throw new IllegalArgumentException("Module without defined name");
    }

    public ObjectMapper registerModules(Module ... moduleArray) {
        int n2 = moduleArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.registerModule(moduleArray[i2]);
        }
        return this;
    }

    public ObjectMapper registerModules(Iterable<? extends Module> object) {
        this._assertNotNull("modules", object);
        object = object.iterator();
        while (object.hasNext()) {
            this.registerModule((Module)object.next());
        }
        return this;
    }

    public Set<Object> getRegisteredModuleIds() {
        Set<Object> set = ((ObjectMapper)((Object)set))._registeredModuleTypes;
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public ObjectMapper findAndRegisterModules() {
        return this.registerModules(ObjectMapper.findModules());
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("out", outputStream);
        JsonGenerator jsonGenerator = objectMapper._jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        this._serializationConfig.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("out", outputStream);
        JsonGenerator jsonGenerator = objectMapper._jsonFactory.createGenerator(outputStream, jsonEncoding);
        this._serializationConfig.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public JsonGenerator createGenerator(Writer writer) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("w", writer);
        JsonGenerator jsonGenerator = objectMapper._jsonFactory.createGenerator(writer);
        this._serializationConfig.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("outputFile", file);
        JsonGenerator jsonGenerator = objectMapper._jsonFactory.createGenerator(file, jsonEncoding);
        this._serializationConfig.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public JsonGenerator createGenerator(DataOutput dataOutput) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("out", dataOutput);
        JsonGenerator jsonGenerator = objectMapper._jsonFactory.createGenerator(dataOutput);
        this._serializationConfig.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public JsonParser createParser(File file) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", file);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(file));
    }

    public JsonParser createParser(URL uRL) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", uRL);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(uRL));
    }

    public JsonParser createParser(InputStream inputStream) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("in", inputStream);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(inputStream));
    }

    public JsonParser createParser(Reader reader) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("r", reader);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(reader));
    }

    public JsonParser createParser(byte[] byArray) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", byArray);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(byArray));
    }

    public JsonParser createParser(byte[] byArray, int n2, int n3) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", byArray);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(byArray, n2, n3));
    }

    public JsonParser createParser(String string) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", string);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(string));
    }

    public JsonParser createParser(char[] cArray) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", cArray);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(cArray));
    }

    public JsonParser createParser(char[] cArray, int n2, int n3) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", cArray);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(cArray, n2, n3));
    }

    public JsonParser createParser(DataInput dataInput) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", dataInput);
        return objectMapper._deserializationConfig.initialize(this._jsonFactory.createParser(dataInput));
    }

    public JsonParser createNonBlockingByteArrayParser() {
        return this._deserializationConfig.initialize(this._jsonFactory.createNonBlockingByteArrayParser());
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public DeserializationContext getDeserializationContext() {
        return this._deserializationContext;
    }

    public ObjectMapper setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        return this;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    public ObjectMapper setSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        this._serializerProvider = defaultSerializerProvider;
        return this;
    }

    public SerializerProvider getSerializerProvider() {
        return this._serializerProvider;
    }

    public SerializerProvider getSerializerProviderInstance() {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper._serializationConfig);
    }

    public ObjectMapper setMixIns(Map<Class<?>, Class<?>> map) {
        ObjectMapper objectMapper = this;
        objectMapper._mixIns.setLocalDefinitions(map);
        return objectMapper;
    }

    public ObjectMapper addMixIn(Class<?> clazz, Class<?> clazz2) {
        ObjectMapper objectMapper = this;
        objectMapper._mixIns.addLocalDefinition(clazz, clazz2);
        return objectMapper;
    }

    public ObjectMapper setMixInResolver(ClassIntrospector.MixInResolver mixInResolver) {
        if ((mixInResolver = this._mixIns.withOverrides(mixInResolver)) != this._mixIns) {
            ObjectMapper objectMapper = this;
            objectMapper._mixIns = mixInResolver;
            objectMapper._deserializationConfig = new DeserializationConfig(this._deserializationConfig, (SimpleMixInResolver)mixInResolver);
            objectMapper._serializationConfig = new SerializationConfig(this._serializationConfig, (SimpleMixInResolver)mixInResolver);
        }
        return this;
    }

    public Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixIns.findMixInClassFor(clazz);
    }

    public int mixInCount() {
        return this._mixIns.localSize();
    }

    @Deprecated
    public void setMixInAnnotations(Map<Class<?>, Class<?>> map) {
        this.setMixIns(map);
    }

    @Deprecated
    public final void addMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
        this.addMixIn(clazz, clazz2);
    }

    public VisibilityChecker<?> getVisibilityChecker() {
        return this._serializationConfig.getDefaultVisibilityChecker();
    }

    public ObjectMapper setVisibility(VisibilityChecker<?> visibilityChecker) {
        ObjectMapper objectMapper = this;
        objectMapper._configOverrides.setDefaultVisibility(visibilityChecker);
        return objectMapper;
    }

    public ObjectMapper setVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        ObjectMapper objectMapper = objectMapper2;
        ObjectMapper objectMapper2 = objectMapper._configOverrides.getDefaultVisibility().withVisibility(propertyAccessor, visibility);
        objectMapper._configOverrides.setDefaultVisibility((VisibilityChecker<?>)((Object)objectMapper2));
        return objectMapper;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setSubtypeResolver(SubtypeResolver subtypeResolver) {
        ObjectMapper objectMapper = this;
        objectMapper._subtypeResolver = subtypeResolver;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(subtypeResolver);
        objectMapper._serializationConfig = objectMapper._serializationConfig.with(subtypeResolver);
        return objectMapper;
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(annotationIntrospector);
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(annotationIntrospector);
        return objectMapper;
    }

    public ObjectMapper setAnnotationIntrospectors(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(annotationIntrospector);
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(annotationIntrospector2);
        return objectMapper;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(propertyNamingStrategy);
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(propertyNamingStrategy);
        return objectMapper;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._serializationConfig.getPropertyNamingStrategy();
    }

    public ObjectMapper setAccessorNaming(AccessorNamingStrategy.Provider provider) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(provider);
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(provider);
        return objectMapper;
    }

    public ObjectMapper setDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = objectMapper._serializationConfig.withDefaultPrettyPrinter(prettyPrinter);
        return objectMapper;
    }

    @Deprecated
    public void setVisibilityChecker(VisibilityChecker<?> visibilityChecker) {
        this.setVisibility(visibilityChecker);
    }

    public ObjectMapper setPolymorphicTypeValidator(PolymorphicTypeValidator polymorphicTypeValidator) {
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper._deserializationConfig.getBaseSettings().with(polymorphicTypeValidator);
        objectMapper._deserializationConfig = objectMapper._deserializationConfig._withBase((BaseSettings)serializable);
        return objectMapper;
    }

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        return this._deserializationConfig.getBaseSettings().getPolymorphicTypeValidator();
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include include) {
        ObjectMapper objectMapper = this;
        JsonInclude.Include include2 = include;
        objectMapper.setPropertyInclusion(JsonInclude.Value.construct(include2, include2));
        return objectMapper;
    }

    @Deprecated
    public ObjectMapper setPropertyInclusion(JsonInclude.Value value) {
        return this.setDefaultPropertyInclusion(value);
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Value value) {
        ObjectMapper objectMapper = this;
        objectMapper._configOverrides.setDefaultInclusion(value);
        return objectMapper;
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Include include) {
        ObjectMapper objectMapper = this;
        JsonInclude.Include include2 = include;
        objectMapper._configOverrides.setDefaultInclusion(JsonInclude.Value.construct(include2, include2));
        return objectMapper;
    }

    public ObjectMapper setDefaultSetterInfo(JsonSetter.Value value) {
        ObjectMapper objectMapper = this;
        objectMapper._configOverrides.setDefaultSetterInfo(value);
        return objectMapper;
    }

    public ObjectMapper setDefaultVisibility(JsonAutoDetect.Value value) {
        ObjectMapper objectMapper = this;
        objectMapper._configOverrides.setDefaultVisibility(VisibilityChecker.Std.construct(value));
        return objectMapper;
    }

    public ObjectMapper setDefaultMergeable(Boolean bl) {
        ObjectMapper objectMapper = this;
        objectMapper._configOverrides.setDefaultMergeable(bl);
        return objectMapper;
    }

    public ObjectMapper setDefaultLeniency(Boolean bl) {
        ObjectMapper objectMapper = this;
        objectMapper._configOverrides.setDefaultLeniency(bl);
        return objectMapper;
    }

    public void registerSubtypes(Class<?> ... classArray) {
        this.getSubtypeResolver().registerSubtypes(classArray);
    }

    public void registerSubtypes(NamedType ... namedTypeArray) {
        this.getSubtypeResolver().registerSubtypes(namedTypeArray);
    }

    public void registerSubtypes(Collection<Class<?>> collection) {
        this.getSubtypeResolver().registerSubtypes(collection);
    }

    public ObjectMapper activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator) {
        return this.activateDefaultTyping(polymorphicTypeValidator, DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public ObjectMapper activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, DefaultTyping defaultTyping) {
        return this.activateDefaultTyping(polymorphicTypeValidator, defaultTyping, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    public ObjectMapper activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, DefaultTyping defaultTyping, JsonTypeInfo.As as) {
        if (as != JsonTypeInfo.As.EXTERNAL_PROPERTY) {
            ObjectMapper objectMapper = this;
            return objectMapper.setDefaultTyping((TypeResolverBuilder<?>)objectMapper._constructDefaultTypeResolverBuilder(defaultTyping, polymorphicTypeValidator).init(JsonTypeInfo.Id.CLASS, null).inclusion(as));
        }
        throw new IllegalArgumentException("Cannot use includeAs of " + (Object)((Object)as));
    }

    public ObjectMapper activateDefaultTypingAsProperty(PolymorphicTypeValidator polymorphicTypeValidator, DefaultTyping defaultTyping, String string) {
        ObjectMapper objectMapper = this;
        return objectMapper.setDefaultTyping((TypeResolverBuilder<?>)objectMapper._constructDefaultTypeResolverBuilder(defaultTyping, polymorphicTypeValidator).init(JsonTypeInfo.Id.CLASS, null).inclusion(JsonTypeInfo.As.PROPERTY).typeProperty(string));
    }

    public ObjectMapper deactivateDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public ObjectMapper setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(typeResolverBuilder);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(typeResolverBuilder);
        return objectMapper;
    }

    @Deprecated
    public ObjectMapper enableDefaultTyping() {
        ObjectMapper objectMapper = this;
        return objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator());
    }

    @Deprecated
    public ObjectMapper enableDefaultTyping(DefaultTyping defaultTyping) {
        return this.enableDefaultTyping(defaultTyping, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    @Deprecated
    public ObjectMapper enableDefaultTyping(DefaultTyping defaultTyping, JsonTypeInfo.As as) {
        ObjectMapper objectMapper = this;
        return objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), defaultTyping, as);
    }

    @Deprecated
    public ObjectMapper enableDefaultTypingAsProperty(DefaultTyping defaultTyping, String string) {
        ObjectMapper objectMapper = this;
        return objectMapper.activateDefaultTypingAsProperty(objectMapper.getPolymorphicTypeValidator(), defaultTyping, string);
    }

    @Deprecated
    public ObjectMapper disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public MutableConfigOverride configOverride(Class<?> clazz) {
        return this._configOverrides.findOrCreateOverride(clazz);
    }

    public MutableCoercionConfig coercionConfigDefaults() {
        return this._coercionConfigs.defaultCoercions();
    }

    public MutableCoercionConfig coercionConfigFor(LogicalType logicalType) {
        return this._coercionConfigs.findOrCreateCoercion(logicalType);
    }

    public MutableCoercionConfig coercionConfigFor(Class<?> clazz) {
        return this._coercionConfigs.findOrCreateCoercion(clazz);
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public ObjectMapper setTypeFactory(TypeFactory typeFactory) {
        ObjectMapper objectMapper = this;
        objectMapper._typeFactory = typeFactory;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(typeFactory);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(typeFactory);
        return objectMapper;
    }

    public JavaType constructType(Type type) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("t", type);
        return objectMapper._typeFactory.constructType(type);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("typeRef", typeReference);
        return objectMapper._typeFactory.constructType(typeReference);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    public ObjectMapper setNodeFactory(JsonNodeFactory jsonNodeFactory) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(jsonNodeFactory);
        return objectMapper;
    }

    public ObjectMapper setConstructorDetector(ConstructorDetector constructorDetector) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(constructorDetector);
        return objectMapper;
    }

    public ObjectMapper addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.withHandler(deserializationProblemHandler);
        return objectMapper;
    }

    public ObjectMapper clearProblemHandlers() {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.withNoProblemHandlers();
        return objectMapper;
    }

    public ObjectMapper setConfig(DeserializationConfig deserializationConfig) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("config", deserializationConfig);
        objectMapper._deserializationConfig = deserializationConfig;
        return objectMapper;
    }

    @Deprecated
    public void setFilters(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
    }

    public ObjectMapper setFilterProvider(FilterProvider filterProvider) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = objectMapper._serializationConfig.withFilters(filterProvider);
        return objectMapper;
    }

    public ObjectMapper setBase64Variant(Base64Variant base64Variant) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(base64Variant);
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(base64Variant);
        return objectMapper;
    }

    public ObjectMapper setConfig(SerializationConfig serializationConfig) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("config", serializationConfig);
        objectMapper._serializationConfig = serializationConfig;
        return objectMapper;
    }

    public JsonFactory tokenStreamFactory() {
        return this._jsonFactory;
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(dateFormat);
        objectMapper._serializationConfig = objectMapper._serializationConfig.with(dateFormat);
        return objectMapper;
    }

    public DateFormat getDateFormat() {
        return this._serializationConfig.getDateFormat();
    }

    public Object setHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(handlerInstantiator);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(handlerInstantiator);
        return objectMapper;
    }

    public ObjectMapper setInjectableValues(InjectableValues injectableValues) {
        this._injectableValues = injectableValues;
        return this;
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public ObjectMapper setLocale(Locale locale) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(locale);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(locale);
        return objectMapper;
    }

    public ObjectMapper setTimeZone(TimeZone timeZone) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(timeZone);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(timeZone);
        return objectMapper;
    }

    public ObjectMapper setDefaultAttributes(ContextAttributes contextAttributes) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(contextAttributes);
        objectMapper._serializationConfig = objectMapper._serializationConfig.with(contextAttributes);
        return objectMapper;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    @Deprecated
    public ObjectMapper configure(MapperFeature object, boolean bl) {
        SerializationConfig serializationConfig = bl ? (SerializationConfig)this._serializationConfig.with(new MapperFeature[]{object}) : (SerializationConfig)this._serializationConfig.without(new MapperFeature[]{object});
        this._serializationConfig = serializationConfig;
        object = bl ? (DeserializationConfig)this._deserializationConfig.with(new MapperFeature[]{object}) : (DeserializationConfig)this._deserializationConfig.without(new MapperFeature[]{object});
        this._deserializationConfig = object;
        return this;
    }

    @Deprecated
    public ObjectMapper enable(MapperFeature ... mapperFeatureArray) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(mapperFeatureArray);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(mapperFeatureArray);
        return objectMapper;
    }

    @Deprecated
    public ObjectMapper disable(MapperFeature ... mapperFeatureArray) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.without(mapperFeatureArray);
        objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.without(mapperFeatureArray);
        return objectMapper;
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._serializationConfig.isEnabled(serializationFeature);
    }

    public ObjectMapper configure(SerializationFeature object, boolean bl) {
        object = bl ? this._serializationConfig.with((SerializationFeature)object) : this._serializationConfig.without((SerializationFeature)object);
        this._serializationConfig = object;
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = objectMapper._serializationConfig.with(serializationFeature);
        return objectMapper;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = objectMapper._serializationConfig.with(serializationFeature, serializationFeatureArray);
        return objectMapper;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = objectMapper._serializationConfig.without(serializationFeature);
        return objectMapper;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectMapper objectMapper = this;
        objectMapper._serializationConfig = objectMapper._serializationConfig.without(serializationFeature, serializationFeatureArray);
        return objectMapper;
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._deserializationConfig.isEnabled(deserializationFeature);
    }

    public ObjectMapper configure(DeserializationFeature object, boolean bl) {
        object = bl ? this._deserializationConfig.with((DeserializationFeature)object) : this._deserializationConfig.without((DeserializationFeature)object);
        this._deserializationConfig = object;
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(deserializationFeature);
        return objectMapper;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(deserializationFeature, deserializationFeatureArray);
        return objectMapper;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.without(deserializationFeature);
        return objectMapper;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        ObjectMapper objectMapper = this;
        objectMapper._deserializationConfig = objectMapper._deserializationConfig.without(deserializationFeature, deserializationFeatureArray);
        return objectMapper;
    }

    public ObjectMapper configure(DatatypeFeature datatypeFeature, boolean bl) {
        if (bl) {
            ObjectMapper objectMapper = this;
            objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.with(datatypeFeature);
            objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.with(datatypeFeature);
        } else {
            ObjectMapper objectMapper = this;
            objectMapper._deserializationConfig = (DeserializationConfig)objectMapper._deserializationConfig.without(datatypeFeature);
            objectMapper._serializationConfig = (SerializationConfig)objectMapper._serializationConfig.without(datatypeFeature);
        }
        return this;
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._deserializationConfig.isEnabled(feature, this._jsonFactory);
    }

    public ObjectMapper configure(JsonParser.Feature feature, boolean bl) {
        ObjectMapper objectMapper = this;
        objectMapper._jsonFactory.configure(feature, bl);
        return objectMapper;
    }

    public ObjectMapper enable(JsonParser.Feature ... featureArray) {
        for (JsonParser.Feature feature : featureArray) {
            this._jsonFactory.enable(feature);
        }
        return this;
    }

    public ObjectMapper disable(JsonParser.Feature ... featureArray) {
        for (JsonParser.Feature feature : featureArray) {
            this._jsonFactory.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this._serializationConfig.isEnabled(feature, this._jsonFactory);
    }

    public ObjectMapper configure(JsonGenerator.Feature feature, boolean bl) {
        ObjectMapper objectMapper = this;
        objectMapper._jsonFactory.configure(feature, bl);
        return objectMapper;
    }

    public ObjectMapper enable(JsonGenerator.Feature ... featureArray) {
        for (JsonGenerator.Feature feature : featureArray) {
            this._jsonFactory.enable(feature);
        }
        return this;
    }

    public ObjectMapper disable(JsonGenerator.Feature ... featureArray) {
        for (JsonGenerator.Feature feature : featureArray) {
            this._jsonFactory.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(JsonFactory.Feature feature) {
        return this._jsonFactory.isEnabled(feature);
    }

    public boolean isEnabled(StreamReadFeature streamReadFeature) {
        return this.isEnabled(streamReadFeature.mappedFeature());
    }

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this.isEnabled(streamWriteFeature.mappedFeature());
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("p", jsonParser);
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("p", jsonParser);
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(typeReference));
    }

    @Override
    public final <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) {
        ObjectMapper objectMapper = serializable;
        ObjectMapper objectMapper2 = serializable;
        objectMapper2._assertNotNull("p", jsonParser);
        Serializable serializable = objectMapper2.getDeserializationConfig();
        resolvedType = (JavaType)resolvedType;
        return (T)objectMapper._readValue((DeserializationConfig)serializable, jsonParser, (JavaType)resolvedType);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("p", jsonParser);
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, javaType);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser object) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("p", object);
        DeserializationConfig deserializationConfig = objectMapper.getDeserializationConfig();
        if (((JsonParser)object).currentToken() == null && ((JsonParser)object).nextToken() == null) {
            return null;
        }
        if ((object = (JsonNode)this._readValue(deserializationConfig, (JsonParser)object, this.constructType((Type)((Object)JsonNode.class)))) == null) {
            object = this.getNodeFactory().nullNode();
        }
        return (T)object;
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, JavaType javaType) {
        ObjectMapper objectMapper = serializable;
        objectMapper._assertNotNull("p", jsonParser);
        Serializable serializable = objectMapper.createDeserializationContext(jsonParser, objectMapper.getDeserializationConfig());
        JsonDeserializer<Object> jsonDeserializer = objectMapper._findRootDeserializer((DeserializationContext)serializable, javaType);
        return new MappingIterator(javaType, jsonParser, (DeserializationContext)serializable, jsonDeserializer, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, Class<T> clazz) {
        return this.readValues(jsonParser, this._typeFactory.constructType(clazz));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, TypeReference<T> typeReference) {
        return this.readValues(jsonParser, this._typeFactory.constructType(typeReference));
    }

    public JsonNode readTree(InputStream inputStream) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("in", inputStream);
        return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(inputStream));
    }

    public JsonNode readTree(Reader reader) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("r", reader);
        return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(reader));
    }

    public JsonNode readTree(String string) {
        JsonProcessingException jsonProcessingException2;
        block4: {
            IOException iOException2;
            ObjectMapper objectMapper = this;
            objectMapper._assertNotNull("content", string);
            try {
                try {
                    return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(string));
                }
                catch (IOException iOException2) {
                }
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block4;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException2);
        }
        throw jsonProcessingException2;
    }

    public JsonNode readTree(byte[] byArray) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", byArray);
        return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(byArray));
    }

    public JsonNode readTree(byte[] byArray, int n2, int n3) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", byArray);
        return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(byArray, n2, n3));
    }

    public JsonNode readTree(File file) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("file", file);
        return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(file));
    }

    public JsonNode readTree(URL uRL) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("source", uRL);
        return objectMapper._readTreeAndClose(objectMapper._jsonFactory.createParser(uRL));
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT) && jsonGenerator.getPrettyPrinter() == null) {
            jsonGenerator.setPrettyPrinter(serializationConfig.constructDefaultPrettyPrinter());
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, serializationConfig);
        } else {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, treeNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeTree(JsonGenerator jsonGenerator, JsonNode jsonNode) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, jsonNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    @Override
    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode missingNode() {
        return this._deserializationConfig.getNodeFactory().missingNode();
    }

    @Override
    public JsonNode nullNode() {
        return this._deserializationConfig.getNodeFactory().nullNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        this._assertNotNull("n", treeNode);
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) {
        if (treeNode == null) {
            return null;
        }
        try {
            if (TreeNode.class.isAssignableFrom(clazz) && clazz.isAssignableFrom(treeNode.getClass())) {
                return (T)treeNode;
            }
            if (treeNode.asToken() == JsonToken.VALUE_EMBEDDED_OBJECT && treeNode instanceof POJONode) {
                Object object = ((POJONode)treeNode).getPojo();
                if (object == null) return (T)object;
                if (clazz.isInstance(object)) {
                    return (T)object;
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        ObjectMapper objectMapper = this;
        return objectMapper.readValue(objectMapper.treeAsTokens(treeNode), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T treeToValue(TreeNode treeNode, JavaType javaType) {
        if (treeNode == null) {
            return null;
        }
        try {
            if (javaType.isTypeOrSubTypeOf(TreeNode.class) && javaType.isTypeOrSuperTypeOf(treeNode.getClass())) {
                return (T)treeNode;
            }
            if (treeNode.asToken() == JsonToken.VALUE_EMBEDDED_OBJECT && treeNode instanceof POJONode) {
                Object object = ((POJONode)treeNode).getPojo();
                if (object == null) return (T)object;
                if (javaType.isTypeOrSuperTypeOf(object.getClass())) {
                    return (T)object;
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        ObjectMapper objectMapper = this;
        return objectMapper.readValue(objectMapper.treeAsTokens(treeNode), javaType);
    }

    /*
     * Exception decompiling
     */
    public <T extends JsonNode> T valueToTree(Object var1_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 98->105)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean canSerialize(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper.getSerializationConfig()).hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper.getSerializationConfig()).hasSerializerFor(clazz, atomicReference);
    }

    public boolean canDeserialize(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper.createDeserializationContext(null, objectMapper.getDeserializationConfig()).hasValueDeserializerFor(javaType, null);
    }

    public boolean canDeserialize(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        ObjectMapper objectMapper = this;
        return objectMapper.createDeserializationContext(null, objectMapper.getDeserializationConfig()).hasValueDeserializerFor(javaType, atomicReference);
    }

    public <T> T readValue(File file, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", file);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(file), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(File file, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", file);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(file), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(File file, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", file);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(file), javaType);
    }

    public <T> T readValue(URL uRL, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", uRL);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(uRL), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(URL uRL, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", uRL);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(uRL), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(URL uRL, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", uRL);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(uRL), javaType);
    }

    public <T> T readValue(String string, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", string);
        return this.readValue(string, objectMapper._typeFactory.constructType(clazz));
    }

    public <T> T readValue(String string, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("content", string);
        return this.readValue(string, objectMapper._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(String string, JavaType javaType) {
        JsonProcessingException jsonProcessingException2;
        block4: {
            IOException iOException2;
            ObjectMapper objectMapper = this;
            objectMapper._assertNotNull("content", string);
            try {
                try {
                    return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(string), javaType);
                }
                catch (IOException iOException2) {
                }
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block4;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException2);
        }
        throw jsonProcessingException2;
    }

    public <T> T readValue(Reader reader, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", reader);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(Reader reader, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", reader);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(reader), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(Reader reader, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", reader);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(reader), javaType);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", inputStream);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(inputStream), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(InputStream inputStream, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", inputStream);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(inputStream), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(InputStream inputStream, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", inputStream);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(inputStream), javaType);
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", byArray);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(byArray), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", byArray);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(byArray, n2, n3), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", byArray);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(byArray), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", byArray);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(byArray, n2, n3), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", byArray);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(byArray), javaType);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", byArray);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(byArray, n2, n3), javaType);
    }

    public <T> T readValue(DataInput dataInput, Class<T> clazz) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", dataInput);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(dataInput), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(DataInput dataInput, JavaType javaType) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("src", dataInput);
        return (T)objectMapper._readMapAndClose(objectMapper._jsonFactory.createParser(dataInput), javaType);
    }

    public void writeValue(File file, Object object) {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(dataOutput), object);
    }

    public void writeValue(Writer writer, Object object) {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) {
        JsonProcessingException jsonProcessingException2;
        block3: {
            SegmentedStringWriter segmentedStringWriter;
            ObjectMapper objectMapper = this;
            SegmentedStringWriter segmentedStringWriter2 = segmentedStringWriter;
            try {
                objectMapper._writeValueAndClose(objectMapper.createGenerator(new SegmentedStringWriter(this._jsonFactory._getBufferRecycler())), object);
                return segmentedStringWriter2.getAndClear();
            }
            catch (IOException iOException) {
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block3;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        throw jsonProcessingException2;
    }

    /*
     * Exception decompiling
     */
    public byte[] writeValueAsBytes(Object var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [9, 8 : 55->62)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ObjectWriter writer() {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig());
    }

    public ObjectWriter writer(SerializationFeature serializationFeature) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(serializationFeature));
    }

    public ObjectWriter writer(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter writer(DateFormat dateFormat) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(dateFormat));
    }

    public ObjectWriter writerWithView(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter((SerializationConfig)objectMapper.getSerializationConfig().withView((Class)clazz));
    }

    public ObjectWriter writerFor(Class<?> type) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        type = type == null ? null : this._typeFactory.constructType(type);
        return this._newWriter(serializationConfig, (JavaType)type, null);
    }

    public ObjectWriter writerFor(TypeReference<?> object) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        object = object == null ? null : this._typeFactory.constructType((TypeReference<?>)object);
        return this._newWriter(serializationConfig, (JavaType)object, null);
    }

    public ObjectWriter writerFor(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writer(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == null) {
            prettyPrinter = ObjectWriter.NULL_PRETTY_PRINTER;
        }
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), null, prettyPrinter);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        ObjectMapper objectMapper = this;
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig();
        return objectMapper._newWriter(serializationConfig, null, serializationConfig.getDefaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema formatSchema) {
        ObjectMapper objectMapper = this;
        objectMapper._verifySchemaType(formatSchema);
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), formatSchema);
    }

    public ObjectWriter writer(Base64Variant base64Variant) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter((SerializationConfig)objectMapper.getSerializationConfig().with(base64Variant));
    }

    public ObjectWriter writer(CharacterEscapes characterEscapes) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig()).with(characterEscapes);
    }

    public ObjectWriter writer(ContextAttributes contextAttributes) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(contextAttributes));
    }

    @Deprecated
    public ObjectWriter writerWithType(Class<?> type) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        type = type == null ? null : this._typeFactory.constructType(type);
        return this._newWriter(serializationConfig, (JavaType)type, null);
    }

    @Deprecated
    public ObjectWriter writerWithType(TypeReference<?> object) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        object = object == null ? null : this._typeFactory.constructType((TypeReference<?>)object);
        return this._newWriter(serializationConfig, (JavaType)object, null);
    }

    @Deprecated
    public ObjectWriter writerWithType(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), javaType, null);
    }

    public ObjectReader reader() {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig().with(deserializationFeature));
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig().with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader readerForUpdating(Object object) {
        JavaType javaType = object == null ? null : serializable._typeFactory.constructType(object.getClass());
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper.getDeserializationConfig();
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, javaType, object, null, injectableValues);
    }

    public ObjectReader readerFor(JavaType javaType) {
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper.getDeserializationConfig();
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, javaType, null, null, injectableValues);
    }

    public ObjectReader readerFor(Class<?> type) {
        type = type == null ? null : serializable._typeFactory.constructType(type);
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper.getDeserializationConfig();
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)type, null, null, injectableValues);
    }

    public ObjectReader readerFor(TypeReference<?> object) {
        ObjectMapper objectMapper = serializable;
        objectMapper._assertNotNull("type", object);
        Serializable serializable = objectMapper.getDeserializationConfig();
        object = objectMapper._typeFactory.constructType((TypeReference<?>)object);
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)object, null, null, injectableValues);
    }

    public ObjectReader readerForArrayOf(Class<?> type) {
        ObjectMapper objectMapper = serializable;
        objectMapper._assertNotNull("type", type);
        Serializable serializable = objectMapper.getDeserializationConfig();
        type = objectMapper._typeFactory.constructArrayType((Class<?>)type);
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)type, null, null, injectableValues);
    }

    public ObjectReader readerForListOf(Class<?> type) {
        ObjectMapper objectMapper = serializable;
        objectMapper._assertNotNull("type", type);
        Serializable serializable = objectMapper.getDeserializationConfig();
        type = objectMapper._typeFactory.constructCollectionType((Class<? extends Collection>)List.class, (Class<?>)type);
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)type, null, null, injectableValues);
    }

    public ObjectReader readerForMapOf(Class<?> type) {
        ObjectMapper objectMapper = serializable;
        objectMapper._assertNotNull("type", type);
        Serializable serializable = objectMapper.getDeserializationConfig();
        type = objectMapper._typeFactory.constructMapType((Class<? extends Map>)Map.class, String.class, (Class<?>)type);
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)type, null, null, injectableValues);
    }

    public ObjectReader reader(JsonNodeFactory jsonNodeFactory) {
        ObjectMapper objectMapper = this;
        objectMapper._assertNotNull("nodeFactory", jsonNodeFactory);
        return objectMapper._newReader(objectMapper.getDeserializationConfig()).with(jsonNodeFactory);
    }

    public ObjectReader reader(FormatSchema formatSchema) {
        ObjectMapper objectMapper = serializable;
        objectMapper._verifySchemaType(formatSchema);
        Serializable serializable = objectMapper.getDeserializationConfig();
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, null, null, formatSchema, injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader((DeserializationConfig)objectMapper.getDeserializationConfig().withView((Class)clazz));
    }

    public ObjectReader reader(Base64Variant base64Variant) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader((DeserializationConfig)objectMapper.getDeserializationConfig().with(base64Variant));
    }

    public ObjectReader reader(ContextAttributes contextAttributes) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig().with(contextAttributes));
    }

    @Deprecated
    public ObjectReader reader(JavaType javaType) {
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper.getDeserializationConfig();
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, javaType, null, null, injectableValues);
    }

    @Deprecated
    public ObjectReader reader(Class<?> type) {
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper.getDeserializationConfig();
        type = objectMapper._typeFactory.constructType(type);
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)type, null, null, injectableValues);
    }

    @Deprecated
    public ObjectReader reader(TypeReference<?> object) {
        ObjectMapper objectMapper = serializable;
        Serializable serializable = objectMapper.getDeserializationConfig();
        object = objectMapper._typeFactory.constructType((TypeReference<?>)object);
        InjectableValues injectableValues = objectMapper._injectableValues;
        return objectMapper._newReader((DeserializationConfig)serializable, (JavaType)object, null, null, injectableValues);
    }

    public <T> T convertValue(Object object, Class<T> clazz) {
        return (T)this._convert(object, this._typeFactory.constructType(clazz));
    }

    public <T> T convertValue(Object object, TypeReference<T> typeReference) {
        return (T)this._convert(object, this._typeFactory.constructType(typeReference));
    }

    public <T> T convertValue(Object object, JavaType javaType) {
        return (T)this._convert(object, javaType);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _convert(Object var1_2, JavaType var2_3) {
        block10: {
            block9: {
                block11: {
                    v0 = this;
                    var3_4 /* !! */  = v0._serializerProvider(v0.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE));
                    var4_5 /* !! */  = var3_4 /* !! */ .bufferForValueConversion((ObjectCodec)this);
                    if (v0.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        var4_5 /* !! */  = var4_5 /* !! */ .forceUseOfBigDecimal(true);
                    }
                    try {
                        v1 = this;
                        var3_4 /* !! */ .serializeValue(var4_5 /* !! */ , var1_2);
                        var1_2 = var4_5 /* !! */ .asParser();
                        var3_4 /* !! */  = v1.getDeserializationConfig();
                        var4_5 /* !! */  = v1._initForReading((JsonParser)var1_2, var2_3);
                        if (var4_5 /* !! */  != JsonToken.VALUE_NULL) ** GOTO lbl21
                        v2 = this;
                        v3 = v2;
                        this = v2.createDeserializationContext((JsonParser)var1_2, (DeserializationConfig)var3_4 /* !! */ );
                    }
                    catch (IOException var0_1) {
                        throw new IllegalArgumentException(var0_1.getMessage(), var0_1);
                    }
                    v4 = v3._findRootDeserializer((DeserializationContext)this, var2_3).getNullValue((DeserializationContext)this);
                    break block11;
lbl21:
                    // 1 sources

                    if (var4_5 /* !! */  == JsonToken.END_ARRAY) break block9;
                    if (var4_5 /* !! */  == JsonToken.END_OBJECT) break block9;
                    v5 = this;
                    v6 = v5;
                    this = v5.createDeserializationContext((JsonParser)var1_2, (DeserializationConfig)var3_4 /* !! */ );
                    v4 = v6._findRootDeserializer((DeserializationContext)this, var2_3).deserialize((JsonParser)var1_2, (DeserializationContext)this);
                }
                this = v4;
                break block10;
            }
            this = null;
        }
        var1_2.close();
        return this;
    }

    public <T> T updateValue(T t2, Object object) {
        if (t2 != null && object != null) {
            JsonParser jsonParser;
            ObjectMapper objectMapper = this;
            DefaultSerializerProvider defaultSerializerProvider = objectMapper._serializerProvider(objectMapper.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE));
            TokenBuffer tokenBuffer = defaultSerializerProvider.bufferForValueConversion(this);
            if (objectMapper.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                tokenBuffer = tokenBuffer.forceUseOfBigDecimal(true);
            }
            try {
                defaultSerializerProvider.serializeValue(tokenBuffer, object);
                jsonParser = tokenBuffer.asParser();
            }
            catch (IOException iOException) {
                if (iOException instanceof JsonMappingException) {
                    throw (JsonMappingException)iOException;
                }
                throw JsonMappingException.fromUnexpectedIOE(iOException);
            }
            t2 = this.readerForUpdating(t2).readValue(jsonParser);
            jsonParser.close();
        }
        return t2;
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper.getSerializationConfig()).generateJsonSchema(clazz);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        ObjectMapper objectMapper = this;
        objectMapper.acceptJsonFormatVisitor(objectMapper._typeFactory.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        if (javaType != null) {
            ObjectMapper objectMapper = this;
            objectMapper._serializerProvider(objectMapper.getSerializationConfig()).acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
            return;
        }
        throw new IllegalArgumentException("type must be provided");
    }

    public TypeResolverBuilder<?> _constructDefaultTypeResolverBuilder(DefaultTyping defaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
        return DefaultTypeResolverBuilder.construct(defaultTyping, polymorphicTypeValidator);
    }

    public DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    public final void _writeValueAndClose(JsonGenerator jsonGenerator, Object object) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object, serializationConfig);
            return;
        }
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            jsonGenerator.close();
            return;
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
    }

    @Deprecated
    public final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) {
        this.getSerializationConfig().initialize(jsonGenerator);
        this._writeValueAndClose(jsonGenerator, object);
    }

    public Object _readValue(DeserializationConfig deserializationConfig, JsonParser jsonParser, JavaType javaType) {
        Object object = this._initForReading(jsonParser, javaType);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        if (object == JsonToken.VALUE_NULL) {
            object = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext);
        } else if (object != JsonToken.END_ARRAY && object != JsonToken.END_OBJECT) {
            object = this._findRootDeserializer(defaultDeserializationContext, javaType);
            object = defaultDeserializationContext.readRootValue(jsonParser, javaType, (JsonDeserializer<Object>)object, null);
        } else {
            object = null;
        }
        jsonParser.clearCurrentToken();
        if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, javaType);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _readMapAndClose(JsonParser var1_2, JavaType var2_3) {
        block10: {
            try {
                v0 = this;
                v1 = var1_2;
                v2 = this;
                v3 = var1_2;
                var3_4 = this.getDeserializationConfig();
            }
            catch (Throwable var0_1) {
                break block10;
            }
            {
                var4_5 = v2.createDeserializationContext(v3, var3_4);
                var5_6 /* !! */  = v0._initForReading(v1, var2_3);
            }
            {
                if (var5_6 /* !! */  != JsonToken.VALUE_NULL) ** GOTO lbl-1000
            }
            var5_6 /* !! */  = this._findRootDeserializer(var4_5, var2_3).getNullValue(var4_5);
            ** GOTO lbl22
lbl-1000:
            // 1 sources

            {
                if (var5_6 /* !! */  == JsonToken.END_ARRAY || var5_6 /* !! */  == JsonToken.END_OBJECT) ** GOTO lbl21
            }
            {
                block11: {
                    v4 = var4_5;
                    var5_6 /* !! */  = this._findRootDeserializer(var4_5, var2_3);
                    var5_6 /* !! */  = v4.readRootValue(var1_2, var2_3, (JsonDeserializer<Object>)var5_6 /* !! */ , null);
                    v4.checkUnresolvedObjectId();
                    break block11;
lbl21:
                    // 1 sources

                    var5_6 /* !! */  = null;
                }
                if (var3_4.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    this._verifyNoTrailingTokens(var1_2, var4_5, var2_3);
                }
                if (var1_2 == null) return var5_6 /* !! */ ;
                var1_2.close();
                return var5_6 /* !! */ ;
            }
        }
        if (var1_2 == null) throw var0_1;
        try {
            var1_2.close();
            throw var0_1;
        }
        catch (Throwable v5) {
            var0_1.addSuppressed(v5);
        }
        throw var0_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode _readTreeAndClose(JsonParser jsonParser) {
        Throwable throwable2;
        block14: {
            JsonNode jsonNode;
            Object object;
            DeserializationConfig deserializationConfig;
            JavaType javaType;
            block13: {
                block12: {
                    block11: {
                        JsonParser jsonParser2;
                        try {
                            jsonParser2 = jsonParser;
                            ObjectMapper objectMapper = this;
                            javaType = objectMapper.constructType((Type)((Object)JsonNode.class));
                            deserializationConfig = objectMapper.getDeserializationConfig();
                            deserializationConfig.initialize(jsonParser);
                        }
                        catch (Throwable throwable2) {}
                        object = jsonParser2.currentToken();
                        if (object != null) break block11;
                        object = jsonParser.nextToken();
                        if (object != null) break block11;
                        JsonNode jsonNode2 = deserializationConfig.getNodeFactory().missingNode();
                        jsonParser.close();
                        return jsonNode2;
                    }
                    JsonToken jsonToken = object;
                    object = this.createDeserializationContext(jsonParser, deserializationConfig);
                    if (jsonToken != JsonToken.VALUE_NULL) break block12;
                    jsonNode = deserializationConfig.getNodeFactory().nullNode();
                    break block13;
                    break block14;
                }
                jsonNode = (JsonNode)((DefaultDeserializationContext)object).readRootValue(jsonParser, javaType, this._findRootDeserializer((DeserializationContext)object, javaType), null);
            }
            if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(jsonParser, (DeserializationContext)object, javaType);
            }
            jsonParser.close();
            return jsonNode;
        }
        if (jsonParser == null) throw throwable2;
        try {
            jsonParser.close();
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throwable2.addSuppressed(throwable3);
        }
        throw throwable2;
    }

    public DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._deserializationContext.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    public JsonToken _initForReading(JsonParser jsonParser, JavaType javaType) {
        object._deserializationConfig.initialize(jsonParser);
        Object object = jsonParser.currentToken();
        if (object == null && (object = jsonParser.nextToken()) == null) {
            throw MismatchedInputException.from(jsonParser, javaType, "No content to map due to end-of-input");
        }
        return object;
    }

    public final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) {
        Object object = jsonParser.nextToken();
        if (object != null) {
            deserializationContext.reportTrailingTokens(ClassUtil.rawClass(javaType), jsonParser, (JsonToken)((Object)object));
        }
    }

    public JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    public void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._jsonFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._jsonFactory.getFormatName());
        }
    }

    public final void _assertNotNull(String string, Object object) {
        if (object != null) {
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        throw new IllegalArgumentException(String.format("argument \"%s\" is null", objectArray2));
    }

    public static enum DefaultTyping {
        JAVA_LANG_OBJECT,
        OBJECT_AND_NON_CONCRETE,
        NON_CONCRETE_AND_ARRAYS,
        NON_FINAL,
        EVERYTHING;

    }

    public static class DefaultTypeResolverBuilder
    extends StdTypeResolverBuilder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final DefaultTyping _appliesFor;
        protected final PolymorphicTypeValidator _subtypeValidator;

        @Deprecated
        public DefaultTypeResolverBuilder(DefaultTyping defaultTyping) {
            this(defaultTyping, LaissezFaireSubTypeValidator.instance);
        }

        public DefaultTypeResolverBuilder(DefaultTyping defaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
            this._appliesFor = DefaultTypeResolverBuilder._requireNonNull(defaultTyping, "Can not pass `null` DefaultTyping");
            this._subtypeValidator = DefaultTypeResolverBuilder._requireNonNull(polymorphicTypeValidator, "Can not pass `null` PolymorphicTypeValidator");
        }

        public DefaultTypeResolverBuilder(DefaultTypeResolverBuilder defaultTypeResolverBuilder, Class<?> clazz) {
            super(defaultTypeResolverBuilder, clazz);
            this._appliesFor = defaultTypeResolverBuilder._appliesFor;
            this._subtypeValidator = defaultTypeResolverBuilder._subtypeValidator;
        }

        private static <T> T _requireNonNull(T t2, String string) {
            if (t2 != null) {
                return t2;
            }
            throw new NullPointerException(string);
        }

        public static DefaultTypeResolverBuilder construct(DefaultTyping defaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
            return new DefaultTypeResolverBuilder(defaultTyping, polymorphicTypeValidator);
        }

        @Override
        public DefaultTypeResolverBuilder withDefaultImpl(Class<?> clazz) {
            if (this._defaultImpl == clazz) {
                return this;
            }
            ClassUtil.verifyMustOverride(DefaultTypeResolverBuilder.class, this, "withDefaultImpl");
            return new DefaultTypeResolverBuilder(this, clazz);
        }

        @Override
        public PolymorphicTypeValidator subTypeValidator(MapperConfig<?> mapperConfig) {
            return this._subtypeValidator;
        }

        @Override
        public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> collection) {
            return this.useForType(javaType) ? super.buildTypeDeserializer(deserializationConfig, javaType, collection) : null;
        }

        @Override
        public TypeSerializer buildTypeSerializer(SerializationConfig serializationConfig, JavaType javaType, Collection<NamedType> collection) {
            return this.useForType(javaType) ? super.buildTypeSerializer(serializationConfig, javaType, collection) : null;
        }

        public boolean useForType(JavaType javaType) {
            if (javaType.isPrimitive()) {
                return false;
            }
            switch (e.a[this._appliesFor.ordinal()]) {
                default: {
                    return javaType.isJavaLangObject();
                }
                case 4: {
                    return true;
                }
                case 3: {
                    while (javaType.isArrayType()) {
                        javaType = javaType.getContentType();
                    }
                    while (javaType.isReferenceType()) {
                        javaType = javaType.getReferencedType();
                    }
                    return !javaType.isFinal() && !TreeNode.class.isAssignableFrom(javaType.getRawClass());
                }
                case 1: {
                    while (javaType.isArrayType()) {
                        javaType = javaType.getContentType();
                    }
                    break;
                }
                case 2: 
            }
            while (javaType.isReferenceType()) {
                javaType = javaType.getReferencedType();
            }
            return javaType.isJavaLangObject() || !javaType.isConcrete() && !TreeNode.class.isAssignableFrom(javaType.getRawClass());
        }
    }
}

