/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JacksonException;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParseException;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonPointer;
import com.privatefasterxml.jackson.core.JsonProcessingException;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.filter.FilteringParserDelegate;
import com.privatefasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.privatefasterxml.jackson.core.filter.TokenFilter;
import com.privatefasterxml.jackson.core.type.ResolvedType;
import com.privatefasterxml.jackson.core.type.TypeReference;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.InjectableValues;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.MappingIterator;
import com.privatefasterxml.jackson.databind.ObjectMapper;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.deser.DataFormatReaders;
import com.privatefasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.privatefasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.TreeTraversingParser;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;
    protected transient JavaType _jsonNodeType;

    public ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig) {
        this(objectMapper, deserializationConfig, null, null, null, null);
    }

    public ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectMapper._deserializationContext;
        this._rootDeserializers = objectMapper._rootDeserializers;
        this._parserFactory = objectMapper._jsonFactory;
        this._valueType = javaType;
        this._valueToUpdate = object;
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(javaType);
        this._dataFormatReaders = null;
        this._filter = null;
    }

    public ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = javaType;
        this._rootDeserializer = jsonDeserializer;
        this._valueToUpdate = object;
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
        this._filter = objectReader._filter;
    }

    public ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = objectReader._filter;
    }

    public ObjectReader(ObjectReader objectReader, JsonFactory jsonFactory) {
        ObjectReader objectReader2 = mapperFeature;
        ObjectReader objectReader3 = mapperFeature;
        ObjectReader objectReader4 = mapperFeature;
        ObjectReader objectReader5 = mapperFeature;
        ObjectReader objectReader6 = mapperFeature;
        ObjectReader objectReader7 = mapperFeature;
        ObjectReader objectReader8 = mapperFeature;
        ObjectReader objectReader9 = mapperFeature;
        ObjectReader objectReader10 = mapperFeature;
        ObjectReader objectReader11 = mapperFeature;
        ObjectReader objectReader12 = mapperFeature;
        ObjectReader objectReader13 = mapperFeature;
        MapperFeature mapperFeature = MapperFeature.SORT_PROPERTIES_ALPHABETICALLY;
        objectReader13._config = (DeserializationConfig)objectReader._config.with(mapperFeature, jsonFactory.requiresPropertyOrdering());
        objectReader12._context = objectReader._context;
        objectReader11._rootDeserializers = objectReader._rootDeserializers;
        objectReader10._parserFactory = jsonFactory;
        objectReader9._valueType = objectReader._valueType;
        objectReader8._rootDeserializer = objectReader._rootDeserializer;
        objectReader7._valueToUpdate = objectReader._valueToUpdate;
        objectReader6._schema = objectReader._schema;
        objectReader5._injectableValues = objectReader._injectableValues;
        objectReader4._unwrapRoot = objectReader._unwrapRoot;
        objectReader3._dataFormatReaders = objectReader._dataFormatReaders;
        objectReader2._filter = objectReader._filter;
    }

    public ObjectReader(ObjectReader objectReader, TokenFilter tokenFilter) {
        this._config = objectReader._config;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = objectReader._unwrapRoot;
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = tokenFilter;
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    public ObjectReader _new(ObjectReader objectReader, JsonFactory jsonFactory) {
        return new ObjectReader(objectReader, jsonFactory);
    }

    public ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        return new ObjectReader(objectReader, deserializationConfig);
    }

    public ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        return new ObjectReader(objectReader, deserializationConfig, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    public <T> MappingIterator<T> _newIterator(JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer, boolean bl) {
        ObjectReader objectReader = serializable;
        Serializable serializable = objectReader._valueType;
        Object object = objectReader._valueToUpdate;
        return new MappingIterator((JavaType)serializable, jsonParser, deserializationContext, jsonDeserializer, bl, object);
    }

    public JsonToken _initForReading(DeserializationContext objectArray, JsonParser jsonParser) {
        serializable._config.initialize(jsonParser, serializable._schema);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            Object[] objectArray2 = objectArray;
            Serializable serializable = serializable._valueType;
            objectArray = new Object[]{};
            objectArray2.reportInputMismatch((JavaType)serializable, "No content to map due to end-of-input", objectArray);
        }
        return jsonToken;
    }

    public void _initForMultiRead(DeserializationContext deserializationContext, JsonParser jsonParser) {
        this._config.initialize(jsonParser, this._schema);
    }

    public ObjectReader with(DeserializationFeature deserializationFeature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(deserializationFeature));
    }

    public ObjectReader with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withFeatures(deserializationFeatureArray));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.without(deserializationFeature));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.without(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withoutFeatures(deserializationFeatureArray));
    }

    public ObjectReader with(DatatypeFeature datatypeFeature) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.with(datatypeFeature));
    }

    public ObjectReader withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withFeatures(datatypeFeatureArray));
    }

    public ObjectReader without(DatatypeFeature datatypeFeature) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.without(datatypeFeature));
    }

    public ObjectReader withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withoutFeatures(datatypeFeatureArray));
    }

    public ObjectReader with(JsonParser.Feature feature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(feature));
    }

    public ObjectReader withFeatures(JsonParser.Feature ... featureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withFeatures(featureArray));
    }

    public ObjectReader without(JsonParser.Feature feature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.without(feature));
    }

    public ObjectReader withoutFeatures(JsonParser.Feature ... featureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withoutFeatures(featureArray));
    }

    public ObjectReader with(StreamReadFeature streamReadFeature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(streamReadFeature.mappedFeature()));
    }

    public ObjectReader without(StreamReadFeature streamReadFeature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.without(streamReadFeature.mappedFeature()));
    }

    public ObjectReader with(FormatFeature formatFeature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(formatFeature));
    }

    public ObjectReader withFeatures(FormatFeature ... formatFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withFeatures(formatFeatureArray));
    }

    public ObjectReader without(FormatFeature formatFeature) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.without(formatFeature));
    }

    public ObjectReader withoutFeatures(FormatFeature ... formatFeatureArray) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectReader at(String string) {
        JsonPointerBasedFilter jsonPointerBasedFilter;
        this._assertNotNull("pointerExpr", string);
        JsonPointerBasedFilter jsonPointerBasedFilter2 = jsonPointerBasedFilter;
        jsonPointerBasedFilter = new JsonPointerBasedFilter(string);
        return new ObjectReader(this, jsonPointerBasedFilter2);
    }

    public ObjectReader at(JsonPointer jsonPointer) {
        JsonPointerBasedFilter jsonPointerBasedFilter;
        this._assertNotNull("pointer", jsonPointer);
        JsonPointerBasedFilter jsonPointerBasedFilter2 = jsonPointerBasedFilter;
        jsonPointerBasedFilter = new JsonPointerBasedFilter(jsonPointer);
        return new ObjectReader(this, jsonPointerBasedFilter2);
    }

    public ObjectReader with(DeserializationConfig deserializationConfig) {
        return this._with(deserializationConfig);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (serializable._injectableValues == injectableValues) {
            return serializable;
        }
        ObjectReader objectReader = serializable;
        Serializable serializable = objectReader._config;
        JavaType javaType = objectReader._valueType;
        JsonDeserializer<Object> jsonDeserializer = objectReader._rootDeserializer;
        Object object = objectReader._valueToUpdate;
        FormatSchema formatSchema = objectReader._schema;
        DataFormatReaders dataFormatReaders = objectReader._dataFormatReaders;
        return objectReader._new(objectReader, (DeserializationConfig)serializable, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    public ObjectReader with(JsonNodeFactory jsonNodeFactory) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(jsonNodeFactory));
    }

    public ObjectReader with(JsonFactory jsonFactory) {
        if (jsonFactory == objectReader2._parserFactory) {
            return objectReader2;
        }
        ObjectReader objectReader = objectReader2;
        ObjectReader objectReader2 = objectReader._new(objectReader, jsonFactory);
        if (jsonFactory.getCodec() == null) {
            jsonFactory.setCodec(objectReader2);
        }
        return objectReader2;
    }

    public ObjectReader withRootName(String string) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withRootName(string));
    }

    public ObjectReader withRootName(PropertyName propertyName) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withRootName(propertyName));
    }

    public ObjectReader withoutRootName() {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectReader with(FormatSchema formatSchema) {
        if (serializable._schema == formatSchema) {
            return serializable;
        }
        ObjectReader objectReader = serializable;
        objectReader._verifySchemaType(formatSchema);
        Serializable serializable = objectReader._config;
        JavaType javaType = objectReader._valueType;
        JsonDeserializer<Object> jsonDeserializer = objectReader._rootDeserializer;
        Object object = objectReader._valueToUpdate;
        InjectableValues injectableValues = objectReader._injectableValues;
        DataFormatReaders dataFormatReaders = objectReader._dataFormatReaders;
        return objectReader._new(objectReader, (DeserializationConfig)serializable, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    public ObjectReader forType(JavaType javaType) {
        if (javaType != null && javaType.equals(serializable._valueType)) {
            return serializable;
        }
        ObjectReader objectReader = serializable;
        JsonDeserializer<Object> jsonDeserializer = objectReader._prefetchRootDeserializer(javaType);
        DataFormatReaders dataFormatReaders = objectReader._dataFormatReaders;
        if (dataFormatReaders != null) {
            dataFormatReaders = dataFormatReaders.withType(javaType);
        }
        ObjectReader objectReader2 = serializable;
        Serializable serializable = objectReader2._config;
        Object object = objectReader2._valueToUpdate;
        FormatSchema formatSchema = objectReader2._schema;
        InjectableValues injectableValues = objectReader2._injectableValues;
        return objectReader2._new(objectReader2, (DeserializationConfig)serializable, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    public ObjectReader forType(Class<?> clazz) {
        ObjectReader objectReader = this;
        return objectReader.forType(objectReader._config.constructType(clazz));
    }

    public ObjectReader forType(TypeReference<?> typeReference) {
        ObjectReader objectReader = this;
        return objectReader.forType(objectReader._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectReader withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectReader withType(Class<?> clazz) {
        ObjectReader objectReader = this;
        return objectReader.forType(objectReader._config.constructType(clazz));
    }

    @Deprecated
    public ObjectReader withType(Type type) {
        ObjectReader objectReader = this;
        return objectReader.forType(objectReader._config.getTypeFactory().constructType(type));
    }

    @Deprecated
    public ObjectReader withType(TypeReference<?> typeReference) {
        ObjectReader objectReader = this;
        return objectReader.forType(objectReader._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectReader withValueToUpdate(Object object) {
        Serializable serializable;
        if (object == serializable._valueToUpdate) {
            return serializable;
        }
        if (object == null) {
            ObjectReader objectReader = serializable;
            serializable = objectReader._config;
            object = objectReader._valueType;
            JsonDeserializer<Object> jsonDeserializer = objectReader._rootDeserializer;
            FormatSchema formatSchema = objectReader._schema;
            InjectableValues injectableValues = objectReader._injectableValues;
            DataFormatReaders dataFormatReaders = objectReader._dataFormatReaders;
            return objectReader._new(objectReader, (DeserializationConfig)serializable, (JavaType)object, jsonDeserializer, null, formatSchema, injectableValues, dataFormatReaders);
        }
        JavaType javaType = serializable._valueType;
        if (javaType == null) {
            javaType = serializable._config.constructType(object.getClass());
        }
        ObjectReader objectReader = serializable;
        serializable = objectReader._config;
        JsonDeserializer<Object> jsonDeserializer = objectReader._rootDeserializer;
        FormatSchema formatSchema = objectReader._schema;
        InjectableValues injectableValues = objectReader._injectableValues;
        DataFormatReaders dataFormatReaders = objectReader._dataFormatReaders;
        return objectReader._new(objectReader, (DeserializationConfig)serializable, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    public ObjectReader withView(Class<?> clazz) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withView((Class)clazz));
    }

    public ObjectReader with(Locale locale) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.with(locale));
    }

    public ObjectReader with(TimeZone timeZone) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.with(timeZone));
    }

    public ObjectReader withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.withHandler(deserializationProblemHandler));
    }

    public ObjectReader with(Base64Variant base64Variant) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.with(base64Variant));
    }

    public ObjectReader withFormatDetection(ObjectReader ... objectReaderArray) {
        return this.withFormatDetection(new DataFormatReaders(objectReaderArray));
    }

    public ObjectReader withFormatDetection(DataFormatReaders dataFormatReaders) {
        ObjectReader objectReader = serializable;
        Serializable serializable = objectReader._config;
        JavaType javaType = objectReader._valueType;
        JsonDeserializer<Object> jsonDeserializer = objectReader._rootDeserializer;
        Object object = objectReader._valueToUpdate;
        FormatSchema formatSchema = objectReader._schema;
        InjectableValues injectableValues = objectReader._injectableValues;
        return objectReader._new(objectReader, (DeserializationConfig)serializable, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    public ObjectReader with(ContextAttributes contextAttributes) {
        ObjectReader objectReader = this;
        return objectReader._with(objectReader._config.with(contextAttributes));
    }

    public ObjectReader withAttributes(Map<?, ?> map) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withAttributes(map));
    }

    public ObjectReader withAttribute(Object object, Object object2) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withAttribute(object, object2));
    }

    public ObjectReader withoutAttribute(Object object) {
        ObjectReader objectReader = this;
        return objectReader._with((DeserializationConfig)objectReader._config.withoutAttribute(object));
    }

    public ObjectReader _with(DeserializationConfig deserializationConfig) {
        if (deserializationConfig == objectReader2._config) {
            return objectReader2;
        }
        ObjectReader objectReader = objectReader2;
        ObjectReader objectReader2 = objectReader._new(objectReader, deserializationConfig);
        DataFormatReaders dataFormatReaders = objectReader._dataFormatReaders;
        if (dataFormatReaders != null) {
            objectReader2 = objectReader2.withFormatDetection(dataFormatReaders.with(deserializationConfig));
        }
        return objectReader2;
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._config.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._config.isEnabled(datatypeFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._config.isEnabled(feature, this._parserFactory);
    }

    public boolean isEnabled(StreamReadFeature streamReadFeature) {
        ObjectReader objectReader = object;
        Object object = streamReadFeature.mappedFeature();
        return object._config.isEnabled((JsonParser.Feature)((Object)object), objectReader._parserFactory);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    public JsonParser createParser(File file) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("src", file);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(file);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(URL uRL) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("src", uRL);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(uRL);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(InputStream inputStream) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("in", inputStream);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(inputStream);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(Reader reader) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("r", reader);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(reader);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(byte[] byArray) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("content", byArray);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(byArray);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(byte[] byArray, int n2, int n3) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("content", byArray);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(byArray, n2, n3);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(String string) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("content", string);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(string);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(char[] cArray) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("content", cArray);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(cArray);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(char[] cArray, int n2, int n3) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("content", cArray);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(cArray, n2, n3);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createParser(DataInput dataInput) {
        ObjectReader objectReader = versioned;
        objectReader._assertNotNull("content", dataInput);
        ObjectReader objectReader2 = versioned;
        Versioned versioned = objectReader2._parserFactory.createParser(dataInput);
        return objectReader._config.initialize((JsonParser)versioned, objectReader2._schema);
    }

    public JsonParser createNonBlockingByteArrayParser() {
        ObjectReader objectReader = versioned;
        Versioned versioned = objectReader._parserFactory.createNonBlockingByteArrayParser();
        return versioned._config.initialize((JsonParser)versioned, objectReader._schema);
    }

    public <T> T readValue(JsonParser jsonParser) {
        ObjectReader objectReader = this;
        objectReader._assertNotNull("p", jsonParser);
        return (T)this._bind(jsonParser, objectReader._valueToUpdate);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) {
        this._assertNotNull("p", jsonParser);
        return this.forType(clazz).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) {
        this._assertNotNull("p", jsonParser);
        return this.forType(typeReference).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) {
        this._assertNotNull("p", jsonParser);
        return this.forType((JavaType)resolvedType).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) {
        this._assertNotNull("p", jsonParser);
        return this.forType(javaType).readValue(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, Class<T> clazz) {
        this._assertNotNull("p", jsonParser);
        return this.forType(clazz).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, TypeReference<T> typeReference) {
        this._assertNotNull("p", jsonParser);
        return this.forType(typeReference).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) {
        this._assertNotNull("p", jsonParser);
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, JavaType javaType) {
        this._assertNotNull("p", jsonParser);
        return this.forType(javaType).readValues(jsonParser);
    }

    @Override
    public JsonNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    @Override
    public JsonNode missingNode() {
        return this._config.getNodeFactory().missingNode();
    }

    @Override
    public JsonNode nullNode() {
        return this._config.getNodeFactory().nullNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        ObjectReader objectReader = objectReader2;
        objectReader._assertNotNull("n", treeNode);
        ObjectReader objectReader2 = objectReader.withValueToUpdate(null);
        return new TreeTraversingParser((JsonNode)treeNode, objectReader2);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) {
        this._assertNotNull("p", jsonParser);
        return (T)this._bindAsTreeOrNull(jsonParser);
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) {
        throw new UnsupportedOperationException();
    }

    public <T> T readValue(InputStream inputStream) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return (T)this._detectBindAndClose(dataFormatReaders.findFormat(inputStream), false);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(inputStream), false));
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) {
        return this.forType(clazz).readValue(inputStream);
    }

    public <T> T readValue(Reader reader) {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(reader), false));
    }

    public <T> T readValue(Reader reader, Class<T> clazz) {
        return this.forType(clazz).readValue(reader);
    }

    public <T> T readValue(String string) {
        JsonProcessingException jsonProcessingException2;
        block5: {
            IOException iOException2;
            if (this._dataFormatReaders != null) {
                this._reportUndetectableSource(string);
            }
            try {
                try {
                    ObjectReader objectReader = this;
                    return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(string), false));
                }
                catch (IOException iOException2) {
                }
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block5;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException2);
        }
        throw jsonProcessingException2;
    }

    public <T> T readValue(String string, Class<T> clazz) {
        return this.forType(clazz).readValue(string);
    }

    public <T> T readValue(byte[] byArray) {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, 0, byArray.length);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(byArray), false));
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) {
        return this.forType(clazz).readValue(byArray);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3) {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, n2, n3);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(byArray, n2, n3), false));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) {
        return this.forType(clazz).readValue(byArray, n2, n3);
    }

    public <T> T readValue(File file) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return (T)this._detectBindAndClose(dataFormatReaders.findFormat(this._inputStream(file)), true);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(file), false));
    }

    public <T> T readValue(File file, Class<T> clazz) {
        return this.forType(clazz).readValue(file);
    }

    public <T> T readValue(URL uRL) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return (T)this._detectBindAndClose(dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(uRL), false));
    }

    public <T> T readValue(URL uRL, Class<T> clazz) {
        return this.forType(clazz).readValue(uRL);
    }

    public <T> T readValue(JsonNode jsonNode) {
        ObjectReader objectReader = this;
        objectReader._assertNotNull("content", jsonNode);
        if (objectReader._dataFormatReaders != null) {
            this._reportUndetectableSource(jsonNode);
        }
        ObjectReader objectReader2 = this;
        return (T)objectReader2._bindAndClose(objectReader2._considerFilter(objectReader2.treeAsTokens(jsonNode), false));
    }

    public <T> T readValue(JsonNode jsonNode, Class<T> clazz) {
        return this.forType(clazz).readValue(jsonNode);
    }

    public <T> T readValue(DataInput dataInput) {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        ObjectReader objectReader = this;
        return (T)objectReader._bindAndClose(objectReader._considerFilter(objectReader.createParser(dataInput), false));
    }

    public <T> T readValue(DataInput dataInput, Class<T> clazz) {
        return this.forType(clazz).readValue(dataInput);
    }

    public JsonNode readTree(InputStream inputStream) {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndCloseAsTree(inputStream);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndCloseAsTree(objectReader._considerFilter(objectReader.createParser(inputStream), false));
    }

    public JsonNode readTree(Reader reader) {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndCloseAsTree(objectReader._considerFilter(objectReader.createParser(reader), false));
    }

    public JsonNode readTree(String string) {
        JsonProcessingException jsonProcessingException2;
        block5: {
            IOException iOException2;
            if (this._dataFormatReaders != null) {
                this._reportUndetectableSource(string);
            }
            try {
                try {
                    ObjectReader objectReader = this;
                    return objectReader._bindAndCloseAsTree(objectReader._considerFilter(objectReader.createParser(string), false));
                }
                catch (IOException iOException2) {
                }
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block5;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException2);
        }
        throw jsonProcessingException2;
    }

    public JsonNode readTree(byte[] byArray) {
        ObjectReader objectReader = this;
        objectReader._assertNotNull("json", byArray);
        if (objectReader._dataFormatReaders != null) {
            this._reportUndetectableSource(byArray);
        }
        ObjectReader objectReader2 = this;
        return objectReader2._bindAndCloseAsTree(objectReader2._considerFilter(objectReader2.createParser(byArray), false));
    }

    public JsonNode readTree(byte[] byArray, int n2, int n3) {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(byArray);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndCloseAsTree(objectReader._considerFilter(objectReader.createParser(byArray, n2, n3), false));
    }

    public JsonNode readTree(DataInput dataInput) {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndCloseAsTree(objectReader._considerFilter(objectReader.createParser(dataInput), false));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser) {
        ObjectReader objectReader = serializable;
        ObjectReader objectReader2 = serializable;
        serializable._assertNotNull("p", jsonParser);
        Serializable serializable = objectReader2.createDeserializationContext(jsonParser);
        return objectReader._newIterator(jsonParser, (DeserializationContext)serializable, objectReader2._findRootDeserializer((DeserializationContext)serializable), false);
    }

    public <T> MappingIterator<T> readValues(InputStream inputStream) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return this._detectBindAndReadValues(dataFormatReaders.findFormat(inputStream), false);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndReadValues(objectReader._considerFilter(objectReader.createParser(inputStream), true));
    }

    public <T> MappingIterator<T> readValues(Reader closeable) {
        if (serializable._dataFormatReaders != null) {
            serializable._reportUndetectableSource(closeable);
        }
        ObjectReader objectReader = serializable;
        closeable = objectReader._considerFilter(objectReader.createParser((Reader)closeable), true);
        ObjectReader objectReader2 = serializable;
        Serializable serializable = objectReader2.createDeserializationContext((JsonParser)closeable);
        objectReader2._initForMultiRead((DeserializationContext)serializable, (JsonParser)closeable);
        ((JsonParser)closeable).nextToken();
        JsonDeserializer<Object> jsonDeserializer = objectReader._findRootDeserializer((DeserializationContext)serializable);
        return objectReader._newIterator((JsonParser)closeable, (DeserializationContext)serializable, jsonDeserializer, true);
    }

    public <T> MappingIterator<T> readValues(String object) {
        if (serializable._dataFormatReaders != null) {
            serializable._reportUndetectableSource(object);
        }
        ObjectReader objectReader = serializable;
        object = objectReader._considerFilter(objectReader.createParser((String)object), true);
        ObjectReader objectReader2 = serializable;
        Serializable serializable = objectReader2.createDeserializationContext((JsonParser)object);
        objectReader2._initForMultiRead((DeserializationContext)serializable, (JsonParser)object);
        ((JsonParser)object).nextToken();
        JsonDeserializer<Object> jsonDeserializer = objectReader._findRootDeserializer((DeserializationContext)serializable);
        return objectReader._newIterator((JsonParser)object, (DeserializationContext)serializable, jsonDeserializer, true);
    }

    public <T> MappingIterator<T> readValues(byte[] byArray, int n2, int n3) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return this._detectBindAndReadValues(dataFormatReaders.findFormat(byArray, n2, n3), false);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndReadValues(objectReader._considerFilter(objectReader.createParser(byArray, n2, n3), true));
    }

    public final <T> MappingIterator<T> readValues(byte[] byArray) {
        this._assertNotNull("src", byArray);
        return this.readValues(byArray, 0, byArray.length);
    }

    public <T> MappingIterator<T> readValues(File file) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return this._detectBindAndReadValues(dataFormatReaders.findFormat(this._inputStream(file)), false);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndReadValues(objectReader._considerFilter(objectReader.createParser(file), true));
    }

    public <T> MappingIterator<T> readValues(URL uRL) {
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            return this._detectBindAndReadValues(dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndReadValues(objectReader._considerFilter(objectReader.createParser(uRL), true));
    }

    public <T> MappingIterator<T> readValues(DataInput dataInput) {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        ObjectReader objectReader = this;
        return objectReader._bindAndReadValues(objectReader._considerFilter(objectReader.createParser(dataInput), true));
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) {
        JsonProcessingException jsonProcessingException2;
        block4: {
            IOException iOException2;
            ObjectReader objectReader = this;
            this._assertNotNull("n", treeNode);
            try {
                try {
                    return objectReader.readValue(objectReader.treeAsTokens(treeNode), clazz);
                }
                catch (IOException iOException2) {
                }
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block4;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException2);
        }
        throw jsonProcessingException2;
    }

    public <T> T treeToValue(TreeNode treeNode, JavaType javaType) {
        JsonProcessingException jsonProcessingException2;
        block4: {
            IOException iOException2;
            ObjectReader objectReader = this;
            this._assertNotNull("n", treeNode);
            try {
                try {
                    return objectReader.readValue(objectReader.treeAsTokens(treeNode), javaType);
                }
                catch (IOException iOException2) {
                }
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block4;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException2);
        }
        throw jsonProcessingException2;
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    public Object _bind(JsonParser jsonParser, Object object) {
        ObjectReader objectReader = serializable;
        DefaultDeserializationContext defaultDeserializationContext = objectReader.createDeserializationContext(jsonParser);
        Object object2 = objectReader._initForReading(defaultDeserializationContext, jsonParser);
        if (object2 == JsonToken.VALUE_NULL) {
            if (object == null) {
                object = serializable._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext);
            }
        } else if (object2 != JsonToken.END_ARRAY && object2 != JsonToken.END_OBJECT) {
            ObjectReader objectReader2 = serializable;
            object = objectReader2._valueType;
            object2 = objectReader2._findRootDeserializer(defaultDeserializationContext);
            Object object3 = objectReader2._valueToUpdate;
            object = defaultDeserializationContext.readRootValue(jsonParser, (JavaType)object, (JsonDeserializer<Object>)object2, object3);
        }
        jsonParser.clearCurrentToken();
        if (serializable._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            ObjectReader objectReader3 = serializable;
            Serializable serializable = objectReader3._valueType;
            objectReader3._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, (JavaType)serializable);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _bindAndClose(JsonParser var1_2) {
        block13: {
            try {
                v0 = this /* !! */ ;
                v1 = v0;
                var2_3 = v0.createDeserializationContext(var1_2);
            }
            catch (Throwable var0_1) {
                break block13;
            }
            {
                var3_4 /* !! */  = v1._initForReading(var2_3, var1_2);
            }
            {
                if (var3_4 /* !! */  != JsonToken.VALUE_NULL) ** GOTO lbl-1000
            }
            {
                var3_4 /* !! */  = this /* !! */ ._valueToUpdate;
                ** if (var3_4 /* !! */  != null) goto lbl16
            }
lbl-1000:
            // 1 sources

            {
                v2 = this /* !! */ ._findRootDeserializer(var2_3).getNullValue(var2_3);
lbl13:
                // 3 sources

                while (true) {
                    var3_4 /* !! */  = v2;
                    ** GOTO lbl26
                    break;
                }
            }
lbl16:
            // 1 sources

            ** GOTO lbl26
lbl-1000:
            // 1 sources

            {
                if (var3_4 /* !! */  == JsonToken.END_ARRAY || var3_4 /* !! */  == JsonToken.END_OBJECT) ** GOTO lbl24
            }
            {
                v3 = this /* !! */ ;
                var3_4 /* !! */  = v3._valueType;
                var4_5 = v3._findRootDeserializer(var2_3);
                var5_6 = v3._valueToUpdate;
                v2 = var2_3.readRootValue(var1_2, (JavaType)var3_4 /* !! */ , var4_5, var5_6);
                ** GOTO lbl13
lbl24:
                // 1 sources

                v2 = this /* !! */ ._valueToUpdate;
                ** continue;
lbl26:
                // 2 sources

                if (this /* !! */ ._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    v4 = this /* !! */ ;
                    this /* !! */  = v4._valueType;
                    v4._verifyNoTrailingTokens(var1_2, var2_3, (JavaType)this /* !! */ );
                }
                if (var1_2 == null) return var3_4 /* !! */ ;
                var1_2.close();
                return var3_4 /* !! */ ;
            }
        }
        if (var1_2 == null) throw var0_1;
        try {
            var1_2.close();
            throw var0_1;
        }
        catch (Throwable v5) {
            var0_1.addSuppressed(v5);
        }
        throw var0_1;
    }

    public final JsonNode _bindAndCloseAsTree(JsonParser jsonParser) {
        try {
            JsonNode jsonNode = ((ObjectReader)((Object)jsonNode))._bindAsTree(jsonParser);
            if (jsonParser != null) {
                jsonParser.close();
            }
            return jsonNode;
        }
        catch (Throwable throwable) {
            if (jsonParser != null) {
                try {
                    jsonParser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public final JsonNode _bindAsTree(JsonParser jsonParser) {
        Object object;
        Object object2 = serializable._valueToUpdate;
        if (object2 != null) {
            return (JsonNode)serializable._bind(jsonParser, object2);
        }
        ObjectReader objectReader = serializable;
        objectReader._config.initialize(jsonParser);
        object2 = objectReader._schema;
        if (object2 != null) {
            jsonParser.setSchema((FormatSchema)object2);
        }
        if ((object2 = jsonParser.currentToken()) == null && (object2 = jsonParser.nextToken()) == null) {
            return serializable._config.getNodeFactory().missingNode();
        }
        Object object3 = object2;
        object2 = serializable.createDeserializationContext(jsonParser);
        if (object3 == JsonToken.VALUE_NULL) {
            object = serializable._config.getNodeFactory().nullNode();
        } else {
            object = serializable._jsonNodeType();
            object = (JsonNode)((DefaultDeserializationContext)object2).readRootValue(jsonParser, (JavaType)object, serializable._findTreeDeserializer((DeserializationContext)object2), null);
        }
        jsonParser.clearCurrentToken();
        if (serializable._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            ObjectReader objectReader2 = serializable;
            Serializable serializable = objectReader2._jsonNodeType();
            objectReader2._verifyNoTrailingTokens(jsonParser, (DeserializationContext)object2, (JavaType)serializable);
        }
        return object;
    }

    public final JsonNode _bindAsTreeOrNull(JsonParser jsonParser) {
        Object object;
        Object object2 = serializable._valueToUpdate;
        if (object2 != null) {
            return (JsonNode)serializable._bind(jsonParser, object2);
        }
        ObjectReader objectReader = serializable;
        objectReader._config.initialize(jsonParser);
        object2 = objectReader._schema;
        if (object2 != null) {
            jsonParser.setSchema((FormatSchema)object2);
        }
        if ((object2 = jsonParser.currentToken()) == null && (object2 = jsonParser.nextToken()) == null) {
            return null;
        }
        Object object3 = object2;
        object2 = serializable.createDeserializationContext(jsonParser);
        if (object3 == JsonToken.VALUE_NULL) {
            object = serializable._config.getNodeFactory().nullNode();
        } else {
            object = serializable._jsonNodeType();
            object = (JsonNode)((DefaultDeserializationContext)object2).readRootValue(jsonParser, (JavaType)object, serializable._findTreeDeserializer((DeserializationContext)object2), null);
        }
        jsonParser.clearCurrentToken();
        if (serializable._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            ObjectReader objectReader2 = serializable;
            Serializable serializable = objectReader2._jsonNodeType();
            objectReader2._verifyNoTrailingTokens(jsonParser, (DeserializationContext)object2, (JavaType)serializable);
        }
        return object;
    }

    public <T> MappingIterator<T> _bindAndReadValues(JsonParser jsonParser) {
        ObjectReader objectReader = serializable;
        ObjectReader objectReader2 = serializable;
        ObjectReader objectReader3 = serializable;
        Serializable serializable = objectReader3.createDeserializationContext(jsonParser);
        objectReader3._initForMultiRead((DeserializationContext)serializable, jsonParser);
        jsonParser.nextToken();
        return objectReader._newIterator(jsonParser, (DeserializationContext)serializable, objectReader2._findRootDeserializer((DeserializationContext)serializable), true);
    }

    public JsonParser _considerFilter(JsonParser jsonParser, boolean bl) {
        if (object._filter != null && !FilteringParserDelegate.class.isInstance(jsonParser)) {
            FilteringParserDelegate filteringParserDelegate;
            FilteringParserDelegate filteringParserDelegate2 = filteringParserDelegate;
            Object object = TokenFilter.Inclusion.ONLY_INCLUDE_ALL;
            filteringParserDelegate = new FilteringParserDelegate(jsonParser, object._filter, (TokenFilter.Inclusion)((Object)object), bl);
            jsonParser = filteringParserDelegate2;
        }
        return jsonParser;
    }

    public final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType type) {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            if ((type = ClassUtil.rawClass(type)) == null && (this = ((ObjectReader)this)._valueToUpdate) != null) {
                type = this.getClass();
            }
            deserializationContext.reportTrailingTokens((Class<?>)type, jsonParser, jsonToken);
        }
    }

    public Object _detectBindAndClose(byte[] object, int n2, int n3) {
        DataFormatReaders.Match match = versioned._dataFormatReaders.findFormat((byte[])object, n2, n3);
        object = match;
        if (!match.hasMatch()) {
            ObjectReader objectReader = versioned;
            objectReader._reportUnkownFormat(objectReader._dataFormatReaders, (DataFormatReaders.Match)object);
        }
        Object object2 = object;
        Versioned versioned = ((DataFormatReaders.Match)object2).createParserWithMatch();
        return ((DataFormatReaders.Match)object2).getReader()._bindAndClose((JsonParser)versioned);
    }

    public Object _detectBindAndClose(DataFormatReaders.Match match, boolean bl) {
        if (!match.hasMatch()) {
            ObjectReader objectReader = versioned;
            objectReader._reportUnkownFormat(objectReader._dataFormatReaders, match);
        }
        Versioned versioned = match.createParserWithMatch();
        if (bl) {
            ((JsonParser)versioned).enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndClose((JsonParser)versioned);
    }

    public <T> MappingIterator<T> _detectBindAndReadValues(DataFormatReaders.Match match, boolean bl) {
        if (!match.hasMatch()) {
            ObjectReader objectReader = versioned;
            objectReader._reportUnkownFormat(objectReader._dataFormatReaders, match);
        }
        Versioned versioned = match.createParserWithMatch();
        if (bl) {
            ((JsonParser)versioned).enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndReadValues((JsonParser)versioned);
    }

    public JsonNode _detectBindAndCloseAsTree(InputStream object) {
        if (!((DataFormatReaders.Match)(object = versioned._dataFormatReaders.findFormat((InputStream)object))).hasMatch()) {
            ObjectReader objectReader = versioned;
            objectReader._reportUnkownFormat(objectReader._dataFormatReaders, (DataFormatReaders.Match)object);
        }
        Object object2 = object;
        Versioned versioned = ((DataFormatReaders.Match)object2).createParserWithMatch();
        ((JsonParser)versioned).enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return ((DataFormatReaders.Match)object2).getReader()._bindAndCloseAsTree((JsonParser)versioned);
    }

    public void _reportUnkownFormat(DataFormatReaders dataFormatReaders, DataFormatReaders.Match match) {
        throw new JsonParseException(null, "Cannot detect format from input, does not look like any of detectable formats " + dataFormatReaders.toString());
    }

    public void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._parserFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    public DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser) {
        ObjectReader objectReader = serializable;
        Serializable serializable = objectReader._config;
        InjectableValues injectableValues = objectReader._injectableValues;
        return serializable._context.createInstance((DeserializationConfig)serializable, jsonParser, injectableValues);
    }

    public DefaultDeserializationContext createDummyDeserializationContext() {
        return this._context.createDummyInstance(this._config);
    }

    public InputStream _inputStream(URL uRL) {
        return uRL.openStream();
    }

    public InputStream _inputStream(File file) {
        return new FileInputStream(file);
    }

    public void _reportUndetectableSource(Object object) {
        throw new JsonParseException(null, "Cannot use source of type " + object.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    public JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext) {
        JsonDeserializer<Object> jsonDeserializer;
        Object object = this._rootDeserializer;
        if (object != null) {
            return object;
        }
        object = this._valueType;
        if (object == null) {
            deserializationContext.reportBadDefinition((JavaType)null, "No value type configured for ObjectReader");
        }
        if ((jsonDeserializer = this._rootDeserializers.get(object)) != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer((JavaType)object);
        if (jsonDeserializer == null) {
            deserializationContext.reportBadDefinition((JavaType)object, "Cannot find a deserializer for type " + object);
        }
        this._rootDeserializers.put((JavaType)object, jsonDeserializer);
        return jsonDeserializer;
    }

    public JsonDeserializer<Object> _findTreeDeserializer(DeserializationContext deserializationContext) {
        ObjectReader objectReader = this;
        JavaType javaType = objectReader._jsonNodeType();
        JsonDeserializer<Object> jsonDeserializer = objectReader._rootDeserializers.get(javaType);
        if (jsonDeserializer == null) {
            jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
            if (jsonDeserializer == null) {
                deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
            }
            this._rootDeserializers.put(javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public JsonDeserializer<Object> _prefetchRootDeserializer(JavaType javaType) {
        block5: {
            JsonDeserializer<Object> jsonDeserializer;
            block4: {
                block3: {
                    if (javaType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) break block5;
                    jsonDeserializer = this._rootDeserializers.get(javaType);
                    if (jsonDeserializer != null) break block4;
                    try {
                        jsonDeserializer = this.createDummyDeserializationContext().findRootValueDeserializer(javaType);
                        if (jsonDeserializer == null) break block3;
                    }
                    catch (JacksonException jacksonException) {
                        break block4;
                    }
                    this._rootDeserializers.put(javaType, jsonDeserializer);
                }
                return jsonDeserializer;
            }
            return jsonDeserializer;
        }
        return null;
    }

    public final JavaType _jsonNodeType() {
        JavaType javaType = this._jsonNodeType;
        if (javaType == null) {
            this._jsonNodeType = javaType = this.getTypeFactory().constructType((Type)((Object)JsonNode.class));
        }
        return javaType;
    }

    public final void _assertNotNull(String string, Object object) {
        if (object != null) {
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        throw new IllegalArgumentException(String.format("argument \"%s\" is null", objectArray2));
    }
}

