/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonEncoding;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonProcessingException;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamWriteFeature;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.SegmentedStringWriter;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.core.type.TypeReference;
import com.privatefasterxml.jackson.core.util.Instantiatable;
import com.privatefasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.privatefasterxml.jackson.databind.DatabindException;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.ObjectMapper;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.RuntimeJsonMappingException;
import com.privatefasterxml.jackson.databind.SequenceWriter;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.privatefasterxml.jackson.databind.ser.FilterProvider;
import com.privatefasterxml.jackson.databind.ser.SerializerFactory;
import com.privatefasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    public ObjectWriter(ObjectMapper serializable, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = serializable._serializerProvider;
        this._serializerFactory = serializable._serializerFactory;
        this._generatorFactory = serializable._jsonFactory;
        if (prettyPrinter == null) {
            serializable = GeneratorSettings.empty;
        } else {
            GeneratorSettings generatorSettings;
            serializable = generatorSettings;
            generatorSettings = new GeneratorSettings(prettyPrinter, null, null, null);
        }
        this._generatorSettings = serializable;
        this._prefetch = javaType == null ? Prefetch.empty : (javaType.hasRawClass(Object.class) ? Prefetch.empty.forRootType(this, javaType) : Prefetch.empty.forRootType(this, javaType.withStaticTyping()));
    }

    public ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        ObjectWriter objectWriter = this;
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        objectWriter._generatorFactory = objectMapper._jsonFactory;
        objectWriter._generatorSettings = GeneratorSettings.empty;
        objectWriter._prefetch = Prefetch.empty;
    }

    public ObjectWriter(ObjectMapper serializable, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = serializable._serializerProvider;
        this._serializerFactory = serializable._serializerFactory;
        this._generatorFactory = serializable._jsonFactory;
        if (formatSchema == null) {
            serializable = GeneratorSettings.empty;
        } else {
            GeneratorSettings generatorSettings;
            serializable = generatorSettings;
            generatorSettings = new GeneratorSettings(null, formatSchema, null, null);
        }
        ObjectWriter objectWriter = this;
        objectWriter._generatorSettings = serializable;
        objectWriter._prefetch = Prefetch.empty;
    }

    public ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, GeneratorSettings generatorSettings, Prefetch prefetch) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = generatorSettings;
        this._prefetch = prefetch;
    }

    public ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    public ObjectWriter(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        ObjectWriter objectWriter2 = mapperFeature;
        ObjectWriter objectWriter3 = mapperFeature;
        ObjectWriter objectWriter4 = mapperFeature;
        ObjectWriter objectWriter5 = mapperFeature;
        ObjectWriter objectWriter6 = mapperFeature;
        ObjectWriter objectWriter7 = mapperFeature;
        MapperFeature mapperFeature = MapperFeature.SORT_PROPERTIES_ALPHABETICALLY;
        objectWriter7._config = (SerializationConfig)objectWriter._config.with(mapperFeature, jsonFactory.requiresPropertyOrdering());
        objectWriter6._serializerProvider = objectWriter._serializerProvider;
        objectWriter5._serializerFactory = objectWriter._serializerFactory;
        objectWriter4._generatorFactory = jsonFactory;
        objectWriter3._generatorSettings = objectWriter._generatorSettings;
        objectWriter2._prefetch = objectWriter._prefetch;
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object) {
        Closeable closeable = (Closeable)object;
        Closeable closeable2 = closeable;
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            closeable2 = null;
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable2, exception);
            return;
        }
        closeable.close();
        jsonGenerator.close();
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    public ObjectWriter _new(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        return new ObjectWriter(objectWriter, jsonFactory);
    }

    public ObjectWriter _new(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        if (serializationConfig == this._config) {
            return this;
        }
        return new ObjectWriter(objectWriter, serializationConfig);
    }

    public ObjectWriter _new(GeneratorSettings generatorSettings, Prefetch prefetch) {
        if (this._generatorSettings == generatorSettings && this._prefetch == prefetch) {
            return this;
        }
        return new ObjectWriter(this, this._config, generatorSettings, prefetch);
    }

    public SequenceWriter _newSequenceWriter(boolean bl, JsonGenerator object, boolean bl2) {
        ObjectWriter objectWriter = serializable;
        Serializable serializable = serializable._serializerProvider();
        JsonGenerator jsonGenerator = objectWriter._configureGenerator((JsonGenerator)object);
        object = objectWriter._prefetch;
        return new SequenceWriter((DefaultSerializerProvider)serializable, jsonGenerator, bl2, (Prefetch)object).init(bl);
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(serializationFeature));
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withFeatures(serializationFeatureArray));
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.without(serializationFeature));
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.without(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withoutFeatures(serializationFeatureArray));
    }

    public ObjectWriter with(DatatypeFeature datatypeFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.with(datatypeFeature));
    }

    public ObjectWriter withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withFeatures(datatypeFeatureArray));
    }

    public ObjectWriter without(DatatypeFeature datatypeFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.without(datatypeFeature));
    }

    public ObjectWriter withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withoutFeatures(datatypeFeatureArray));
    }

    public ObjectWriter with(JsonGenerator.Feature feature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(feature));
    }

    public ObjectWriter withFeatures(JsonGenerator.Feature ... featureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withFeatures(featureArray));
    }

    public ObjectWriter without(JsonGenerator.Feature feature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.without(feature));
    }

    public ObjectWriter withoutFeatures(JsonGenerator.Feature ... featureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withoutFeatures(featureArray));
    }

    public ObjectWriter with(StreamWriteFeature streamWriteFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter without(StreamWriteFeature streamWriteFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.without(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter with(FormatFeature formatFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(formatFeature));
    }

    public ObjectWriter withFeatures(FormatFeature ... formatFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withFeatures(formatFeatureArray));
    }

    public ObjectWriter without(FormatFeature formatFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.without(formatFeature));
    }

    public ObjectWriter withoutFeatures(FormatFeature ... formatFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectWriter forType(JavaType javaType) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings, this._prefetch.forRootType(this, javaType));
    }

    public ObjectWriter forType(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        return objectWriter.forType(objectWriter._config.constructType(clazz));
    }

    public ObjectWriter forType(TypeReference<?> typeReference) {
        ObjectWriter objectWriter = this;
        return objectWriter.forType(objectWriter._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectWriter withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectWriter withType(Class<?> clazz) {
        return this.forType(clazz);
    }

    @Deprecated
    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.forType(typeReference);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(dateFormat));
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        ObjectWriter objectWriter = this;
        return objectWriter.with(objectWriter._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        ObjectWriter objectWriter = serializable;
        Serializable serializable = objectWriter._generatorSettings.with(prettyPrinter);
        return objectWriter._new((GeneratorSettings)serializable, objectWriter._prefetch);
    }

    public ObjectWriter withRootName(String string) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withRootName(string));
    }

    public ObjectWriter withRootName(PropertyName propertyName) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withRootName(propertyName));
    }

    public ObjectWriter withoutRootName() {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectWriter with(FormatSchema formatSchema) {
        ObjectWriter objectWriter = serializable;
        objectWriter._verifySchemaType(formatSchema);
        Serializable serializable = objectWriter._generatorSettings.with(formatSchema);
        return objectWriter._new((GeneratorSettings)serializable, objectWriter._prefetch);
    }

    @Deprecated
    public ObjectWriter withSchema(FormatSchema formatSchema) {
        return this.with(formatSchema);
    }

    public ObjectWriter withView(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withView((Class)clazz));
    }

    public ObjectWriter with(Locale locale) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.with(locale));
    }

    public ObjectWriter with(TimeZone timeZone) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.with(timeZone));
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.with(base64Variant));
    }

    public ObjectWriter with(CharacterEscapes characterEscapes) {
        ObjectWriter objectWriter = serializable;
        Serializable serializable = objectWriter._generatorSettings.with(characterEscapes);
        return objectWriter._new((GeneratorSettings)serializable, objectWriter._prefetch);
    }

    public ObjectWriter with(JsonFactory jsonFactory) {
        if (jsonFactory != objectWriter2._generatorFactory) {
            ObjectWriter objectWriter = objectWriter2;
            ObjectWriter objectWriter2 = objectWriter._new(objectWriter, jsonFactory);
        }
        return objectWriter2;
    }

    public ObjectWriter with(ContextAttributes contextAttributes) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, objectWriter._config.with(contextAttributes));
    }

    public ObjectWriter withAttributes(Map<?, ?> map) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withAttributes(map));
    }

    public ObjectWriter withAttribute(Object object, Object object2) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withAttribute(object, object2));
    }

    public ObjectWriter withoutAttribute(Object object) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)objectWriter._config.withoutAttribute(object));
    }

    public ObjectWriter withRootValueSeparator(String string) {
        ObjectWriter objectWriter = serializable;
        Serializable serializable = objectWriter._generatorSettings.withRootValueSeparator(string);
        return objectWriter._new((GeneratorSettings)serializable, objectWriter._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString serializableString) {
        ObjectWriter objectWriter = serializable;
        Serializable serializable = objectWriter._generatorSettings.withRootValueSeparator(serializableString);
        return objectWriter._new((GeneratorSettings)serializable, objectWriter._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("out", outputStream);
        return objectWriter._configureGenerator(objectWriter._generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8));
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("out", outputStream);
        return objectWriter._configureGenerator(objectWriter._generatorFactory.createGenerator(outputStream, jsonEncoding));
    }

    public JsonGenerator createGenerator(Writer writer) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("w", writer);
        return objectWriter._configureGenerator(objectWriter._generatorFactory.createGenerator(writer));
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("outputFile", file);
        return objectWriter._configureGenerator(objectWriter._generatorFactory.createGenerator(file, jsonEncoding));
    }

    public JsonGenerator createGenerator(DataOutput dataOutput) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("out", dataOutput);
        return objectWriter._configureGenerator(objectWriter._generatorFactory.createGenerator(dataOutput));
    }

    public SequenceWriter writeValues(File file) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(false, objectWriter.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator jsonGenerator) {
        ObjectWriter objectWriter = this;
        this._assertNotNull("g", jsonGenerator);
        return objectWriter._newSequenceWriter(false, objectWriter._configureGenerator(jsonGenerator), false);
    }

    public SequenceWriter writeValues(Writer writer) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(false, objectWriter.createGenerator(writer), true);
    }

    public SequenceWriter writeValues(OutputStream outputStream) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(false, objectWriter.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput dataOutput) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(false, objectWriter.createGenerator(dataOutput), true);
    }

    public SequenceWriter writeValuesAsArray(File file) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(true, objectWriter.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator jsonGenerator) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("gen", jsonGenerator);
        return objectWriter._newSequenceWriter(true, jsonGenerator, false);
    }

    public SequenceWriter writeValuesAsArray(Writer writer) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(true, objectWriter.createGenerator(writer), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream outputStream) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(true, objectWriter.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput dataOutput) {
        ObjectWriter objectWriter = this;
        return objectWriter._newSequenceWriter(true, objectWriter.createGenerator(dataOutput), true);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._config.isEnabled(datatypeFeature);
    }

    @Deprecated
    public boolean isEnabled(JsonParser.Feature feature) {
        return this._generatorFactory.isEnabled(feature);
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this._generatorFactory.isEnabled(feature);
    }

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this._generatorFactory.isEnabled(streamWriteFeature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public JsonFactory getFactory() {
        return this._generatorFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        block7: {
            block6: {
                Exception exception2;
                Closeable closeable;
                block5: {
                    block4: {
                        ObjectWriter objectWriter = this;
                        this._assertNotNull("g", jsonGenerator);
                        objectWriter._configureGenerator(jsonGenerator);
                        if (!objectWriter._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) || !(object instanceof Closeable)) break block6;
                        ObjectWriter objectWriter2 = this;
                        closeable = (Closeable)object;
                        try {
                            objectWriter2._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
                            if (!objectWriter2._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        jsonGenerator.flush();
                    }
                    closeable.close();
                    break block7;
                }
                ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception2);
                return;
            }
            ObjectWriter objectWriter = this;
            objectWriter._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            if (objectWriter._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeValue(File file, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(writer), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(dataOutput), object);
    }

    public String writeValueAsString(Object object) {
        JsonProcessingException jsonProcessingException2;
        block3: {
            SegmentedStringWriter segmentedStringWriter;
            ObjectWriter objectWriter = this;
            SegmentedStringWriter segmentedStringWriter2 = segmentedStringWriter;
            try {
                objectWriter._writeValueAndClose(objectWriter.createGenerator(new SegmentedStringWriter(this._generatorFactory._getBufferRecycler())), object);
                return segmentedStringWriter2.getAndClear();
            }
            catch (IOException iOException) {
            }
            catch (JsonProcessingException jsonProcessingException2) {
                break block3;
            }
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        throw jsonProcessingException2;
    }

    /*
     * Exception decompiling
     */
    public byte[] writeValueAsBytes(Object var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [9, 8 : 55->62)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("type", javaType);
        objectWriter._assertNotNull("visitor", jsonFormatVisitorWrapper);
        objectWriter._serializerProvider().acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("type", clazz);
        objectWriter._assertNotNull("visitor", jsonFormatVisitorWrapper);
        objectWriter.acceptJsonFormatVisitor(objectWriter._config.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("type", clazz);
        return objectWriter._serializerProvider().hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        ObjectWriter objectWriter = this;
        objectWriter._assertNotNull("type", clazz);
        return objectWriter._serializerProvider().hasSerializerFor(clazz, atomicReference);
    }

    public DefaultSerializerProvider _serializerProvider() {
        ObjectWriter objectWriter = serializable;
        Serializable serializable = objectWriter._config;
        return serializable._serializerProvider.createInstance((SerializationConfig)serializable, objectWriter._serializerFactory);
    }

    public void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._generatorFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._generatorFactory.getFormatName());
        }
    }

    public final void _writeValueAndClose(JsonGenerator jsonGenerator, Object object) {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object);
            return;
        }
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            jsonGenerator.close();
            return;
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
    }

    public final JsonGenerator _configureGenerator(JsonGenerator jsonGenerator) {
        ObjectWriter objectWriter = this;
        objectWriter._config.initialize(jsonGenerator);
        objectWriter._generatorSettings.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public final void _assertNotNull(String string, Object object) {
        if (object != null) {
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        throw new IllegalArgumentException(String.format("argument \"%s\" is null", objectArray2));
    }

    public static final class GeneratorSettings
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final GeneratorSettings empty = new GeneratorSettings(null, null, null, null);
        public final PrettyPrinter prettyPrinter;
        public final FormatSchema schema;
        public final CharacterEscapes characterEscapes;
        public final SerializableString rootValueSeparator;

        public GeneratorSettings(PrettyPrinter prettyPrinter, FormatSchema formatSchema, CharacterEscapes characterEscapes, SerializableString serializableString) {
            this.prettyPrinter = prettyPrinter;
            this.schema = formatSchema;
            this.characterEscapes = characterEscapes;
            this.rootValueSeparator = serializableString;
        }

        private final String _rootValueSeparatorAsString() {
            SerializableString serializableString = ((GeneratorSettings)((Object)serializableString)).rootValueSeparator;
            return serializableString == null ? null : serializableString.getValue();
        }

        public GeneratorSettings with(PrettyPrinter prettyPrinter) {
            if (prettyPrinter == null) {
                prettyPrinter = NULL_PRETTY_PRINTER;
            }
            if (prettyPrinter != ((GeneratorSettings)object).prettyPrinter) {
                GeneratorSettings generatorSettings;
                GeneratorSettings generatorSettings2 = generatorSettings;
                GeneratorSettings generatorSettings3 = object;
                Object object = generatorSettings3.schema;
                CharacterEscapes characterEscapes = generatorSettings3.characterEscapes;
                SerializableString serializableString = generatorSettings3.rootValueSeparator;
                generatorSettings = new GeneratorSettings(prettyPrinter, (FormatSchema)object, characterEscapes, serializableString);
                object = generatorSettings2;
            }
            return object;
        }

        public GeneratorSettings with(FormatSchema formatSchema) {
            if (((GeneratorSettings)object).schema != formatSchema) {
                GeneratorSettings generatorSettings;
                GeneratorSettings generatorSettings2 = generatorSettings;
                GeneratorSettings generatorSettings3 = object;
                Object object = generatorSettings3.prettyPrinter;
                CharacterEscapes characterEscapes = generatorSettings3.characterEscapes;
                SerializableString serializableString = generatorSettings3.rootValueSeparator;
                generatorSettings = new GeneratorSettings((PrettyPrinter)object, formatSchema, characterEscapes, serializableString);
                object = generatorSettings2;
            }
            return object;
        }

        public GeneratorSettings with(CharacterEscapes characterEscapes) {
            if (((GeneratorSettings)object).characterEscapes != characterEscapes) {
                GeneratorSettings generatorSettings;
                GeneratorSettings generatorSettings2 = generatorSettings;
                GeneratorSettings generatorSettings3 = object;
                Object object = generatorSettings3.prettyPrinter;
                FormatSchema formatSchema = generatorSettings3.schema;
                SerializableString serializableString = generatorSettings3.rootValueSeparator;
                generatorSettings = new GeneratorSettings((PrettyPrinter)object, formatSchema, characterEscapes, serializableString);
                object = generatorSettings2;
            }
            return object;
        }

        public GeneratorSettings withRootValueSeparator(String object) {
            SerializedString serializedString;
            Object object2;
            if (object == null) {
                if (((GeneratorSettings)object2).rootValueSeparator == null) {
                    return object2;
                }
                GeneratorSettings generatorSettings = object2;
                object2 = generatorSettings.prettyPrinter;
                object = generatorSettings.schema;
                CharacterEscapes characterEscapes = generatorSettings.characterEscapes;
                return new GeneratorSettings((PrettyPrinter)object2, (FormatSchema)object, characterEscapes, null);
            }
            if (((String)object).equals(((GeneratorSettings)object2)._rootValueSeparatorAsString())) {
                return object2;
            }
            GeneratorSettings generatorSettings = object2;
            object2 = generatorSettings.prettyPrinter;
            FormatSchema formatSchema = generatorSettings.schema;
            CharacterEscapes characterEscapes = generatorSettings.characterEscapes;
            SerializedString serializedString2 = serializedString;
            serializedString = new SerializedString((String)object);
            return new GeneratorSettings((PrettyPrinter)object2, formatSchema, characterEscapes, serializedString2);
        }

        public GeneratorSettings withRootValueSeparator(SerializableString object) {
            Object object2;
            if (object == null) {
                if (((GeneratorSettings)object2).rootValueSeparator == null) {
                    return object2;
                }
                GeneratorSettings generatorSettings = object2;
                object2 = generatorSettings.prettyPrinter;
                object = generatorSettings.schema;
                CharacterEscapes characterEscapes = generatorSettings.characterEscapes;
                return new GeneratorSettings((PrettyPrinter)object2, (FormatSchema)object, characterEscapes, null);
            }
            if (object.equals(((GeneratorSettings)object2).rootValueSeparator)) {
                return object2;
            }
            GeneratorSettings generatorSettings = object2;
            object2 = generatorSettings.prettyPrinter;
            FormatSchema formatSchema = generatorSettings.schema;
            CharacterEscapes characterEscapes = generatorSettings.characterEscapes;
            return new GeneratorSettings((PrettyPrinter)object2, formatSchema, characterEscapes, (SerializableString)object);
        }

        public void initialize(JsonGenerator jsonGenerator) {
            Object object = ((GeneratorSettings)this).prettyPrinter;
            if (object != null) {
                if (object == NULL_PRETTY_PRINTER) {
                    jsonGenerator.setPrettyPrinter(null);
                } else {
                    if (object instanceof Instantiatable) {
                        object = (PrettyPrinter)((Instantiatable)object).createInstance();
                    }
                    jsonGenerator.setPrettyPrinter((PrettyPrinter)object);
                }
            }
            if ((object = ((GeneratorSettings)this).characterEscapes) != null) {
                jsonGenerator.setCharacterEscapes((CharacterEscapes)object);
            }
            if ((object = ((GeneratorSettings)this).schema) != null) {
                jsonGenerator.setSchema((FormatSchema)object);
            }
            if ((this = ((GeneratorSettings)this).rootValueSeparator) != null) {
                jsonGenerator.setRootValueSeparator((SerializableString)this);
            }
        }
    }

    public static final class Prefetch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType rootType;
        private final JsonSerializer<Object> valueSerializer;
        private final TypeSerializer typeSerializer;

        private Prefetch(JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
            this.rootType = javaType;
            this.valueSerializer = jsonSerializer;
            this.typeSerializer = typeSerializer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Prefetch forRootType(ObjectWriter jsonSerializer, JavaType javaType) {
            Object object;
            if (javaType == null) {
                if (((Prefetch)object).rootType == null) return object;
                if (((Prefetch)object).valueSerializer != null) return new Prefetch(null, null, null);
                return object;
            }
            if (javaType.equals(((Prefetch)object).rootType)) {
                return object;
            }
            if (javaType.isJavaLangObject()) {
                try {
                    object = ((ObjectWriter)((Object)jsonSerializer))._serializerProvider().findTypeSerializer(javaType);
                    return new Prefetch(null, null, (TypeSerializer)object);
                }
                catch (JsonMappingException jsonMappingException) {
                    throw new RuntimeJsonMappingException(jsonMappingException);
                }
            }
            if (((ObjectWriter)((Object)jsonSerializer)).isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                block11: {
                    try {
                        jsonSerializer = ((ObjectWriter)((Object)jsonSerializer))._serializerProvider().findTypedValueSerializer(javaType, true, null);
                        if (!(jsonSerializer instanceof TypeWrappedSerializer)) break block11;
                        JsonSerializer<Object> jsonSerializer2 = jsonSerializer;
                        jsonSerializer = null;
                        return new Prefetch(javaType, jsonSerializer, ((TypeWrappedSerializer)jsonSerializer2).typeSerializer());
                    }
                    catch (DatabindException databindException) {}
                }
                return new Prefetch(javaType, jsonSerializer, null);
            }
            object = ((Prefetch)object).typeSerializer;
            return new Prefetch(javaType, null, (TypeSerializer)object);
        }

        public final JsonSerializer<Object> getValueSerializer() {
            return this.valueSerializer;
        }

        public final TypeSerializer getTypeSerializer() {
            return this.typeSerializer;
        }

        public boolean hasSerializer() {
            return this.valueSerializer != null || this.typeSerializer != null;
        }

        public void serialize(JsonGenerator jsonGenerator, Object object, DefaultSerializerProvider object2) {
            Serializable serializable;
            JsonSerializer<Object> jsonSerializer = serializable.typeSerializer;
            if (jsonSerializer != null) {
                DefaultSerializerProvider defaultSerializerProvider = object2;
                Prefetch prefetch = serializable;
                serializable = prefetch.rootType;
                object2 = prefetch.valueSerializer;
                defaultSerializerProvider.serializePolymorphic(jsonGenerator, object, (JavaType)serializable, (JsonSerializer<Object>)object2, (TypeSerializer)((Object)jsonSerializer));
            } else {
                jsonSerializer = serializable.valueSerializer;
                if (jsonSerializer != null) {
                    serializable = serializable.rootType;
                    ((DefaultSerializerProvider)object2).serializeValue(jsonGenerator, object, (JavaType)serializable, jsonSerializer);
                } else {
                    serializable = serializable.rootType;
                    if (serializable != null) {
                        ((DefaultSerializerProvider)object2).serializeValue(jsonGenerator, object, (JavaType)serializable);
                    } else {
                        ((DefaultSerializerProvider)object2).serializeValue(jsonGenerator, object);
                    }
                }
            }
        }
    }
}

