/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.Nulls;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import java.io.Serializable;

public class PropertyMetadata
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final PropertyMetadata STD_REQUIRED = new PropertyMetadata(Boolean.TRUE, null, null, null, null, null, null);
    public static final PropertyMetadata STD_OPTIONAL = new PropertyMetadata(Boolean.FALSE, null, null, null, null, null, null);
    public static final PropertyMetadata STD_REQUIRED_OR_OPTIONAL = new PropertyMetadata(null, null, null, null, null, null, null);
    protected final Boolean _required;
    protected final String _description;
    protected final Integer _index;
    protected final String _defaultValue;
    protected final transient MergeInfo _mergeInfo;
    protected Nulls _valueNulls;
    protected Nulls _contentNulls;

    public PropertyMetadata(Boolean bl, String string, Integer n2, String string2, MergeInfo mergeInfo, Nulls nulls, Nulls nulls2) {
        this._required = bl;
        this._description = string;
        this._index = n2;
        if (string2 == null || string2.isEmpty()) {
            string2 = null;
        }
        PropertyMetadata propertyMetadata = this;
        propertyMetadata._defaultValue = string2;
        propertyMetadata._mergeInfo = mergeInfo;
        propertyMetadata._valueNulls = nulls;
        propertyMetadata._contentNulls = nulls2;
    }

    public static PropertyMetadata construct(Boolean bl, String string, Integer n2, String string2) {
        if (string == null && n2 == null && string2 == null) {
            if (bl == null) {
                return STD_REQUIRED_OR_OPTIONAL;
            }
            return bl != false ? STD_REQUIRED : STD_OPTIONAL;
        }
        return new PropertyMetadata(bl, string, n2, string2, null, null, null);
    }

    @Deprecated
    public static PropertyMetadata construct(boolean bl, String string, Integer n2, String string2) {
        if (string == null && n2 == null && string2 == null) {
            return bl ? STD_REQUIRED : STD_OPTIONAL;
        }
        return new PropertyMetadata(bl, string, n2, string2, null, null, null);
    }

    public Object readResolve() {
        if (((PropertyMetadata)serializable)._description == null && ((PropertyMetadata)serializable)._index == null && ((PropertyMetadata)serializable)._defaultValue == null && ((PropertyMetadata)serializable)._mergeInfo == null && ((PropertyMetadata)serializable)._valueNulls == null && ((PropertyMetadata)serializable)._contentNulls == null) {
            Serializable serializable = ((PropertyMetadata)serializable)._required;
            if (serializable == null) {
                return STD_REQUIRED_OR_OPTIONAL;
            }
            return ((Boolean)serializable).booleanValue() ? STD_REQUIRED : STD_OPTIONAL;
        }
        return serializable;
    }

    public PropertyMetadata withDescription(String string) {
        PropertyMetadata propertyMetadata = serializable;
        Serializable serializable = propertyMetadata._required;
        Integer n2 = propertyMetadata._index;
        String string2 = propertyMetadata._defaultValue;
        MergeInfo mergeInfo = propertyMetadata._mergeInfo;
        Nulls nulls = propertyMetadata._valueNulls;
        Nulls nulls2 = propertyMetadata._contentNulls;
        return new PropertyMetadata((Boolean)serializable, string, n2, string2, mergeInfo, nulls, nulls2);
    }

    public PropertyMetadata withMergeInfo(MergeInfo mergeInfo) {
        PropertyMetadata propertyMetadata = serializable;
        Serializable serializable = propertyMetadata._required;
        String string = propertyMetadata._description;
        Integer n2 = propertyMetadata._index;
        String string2 = propertyMetadata._defaultValue;
        Nulls nulls = propertyMetadata._valueNulls;
        Nulls nulls2 = propertyMetadata._contentNulls;
        return new PropertyMetadata((Boolean)serializable, string, n2, string2, mergeInfo, nulls, nulls2);
    }

    public PropertyMetadata withNulls(Nulls nulls, Nulls nulls2) {
        PropertyMetadata propertyMetadata = serializable;
        Serializable serializable = propertyMetadata._required;
        String string = propertyMetadata._description;
        Integer n2 = propertyMetadata._index;
        String string2 = propertyMetadata._defaultValue;
        MergeInfo mergeInfo = propertyMetadata._mergeInfo;
        return new PropertyMetadata((Boolean)serializable, string, n2, string2, mergeInfo, nulls, nulls2);
    }

    public PropertyMetadata withDefaultValue(String string) {
        if (string != null && !string.isEmpty()) {
            if (string.equals(serializable._defaultValue)) {
                return serializable;
            }
        } else {
            if (serializable._defaultValue == null) {
                return serializable;
            }
            string = null;
        }
        PropertyMetadata propertyMetadata = serializable;
        Serializable serializable = propertyMetadata._required;
        String string2 = propertyMetadata._description;
        Integer n2 = propertyMetadata._index;
        MergeInfo mergeInfo = propertyMetadata._mergeInfo;
        Nulls nulls = propertyMetadata._valueNulls;
        Nulls nulls2 = propertyMetadata._contentNulls;
        return new PropertyMetadata((Boolean)serializable, string2, n2, string, mergeInfo, nulls, nulls2);
    }

    public PropertyMetadata withIndex(Integer n2) {
        PropertyMetadata propertyMetadata = serializable;
        Serializable serializable = propertyMetadata._required;
        String string = propertyMetadata._description;
        String string2 = propertyMetadata._defaultValue;
        MergeInfo mergeInfo = propertyMetadata._mergeInfo;
        Nulls nulls = propertyMetadata._valueNulls;
        Nulls nulls2 = propertyMetadata._contentNulls;
        return new PropertyMetadata((Boolean)serializable, string, n2, string2, mergeInfo, nulls, nulls2);
    }

    public PropertyMetadata withRequired(Boolean bl) {
        if (bl == null ? ((PropertyMetadata)((Object)string))._required == null : bl.equals(((PropertyMetadata)((Object)string))._required)) {
            return string;
        }
        PropertyMetadata propertyMetadata = string;
        String string = propertyMetadata._description;
        Integer n2 = propertyMetadata._index;
        String string2 = propertyMetadata._defaultValue;
        MergeInfo mergeInfo = propertyMetadata._mergeInfo;
        Nulls nulls = propertyMetadata._valueNulls;
        Nulls nulls2 = propertyMetadata._contentNulls;
        return new PropertyMetadata(bl, string, n2, string2, mergeInfo, nulls, nulls2);
    }

    public String getDescription() {
        return this._description;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean hasDefaultValue() {
        return this._defaultValue != null;
    }

    public boolean isRequired() {
        Serializable serializable = ((PropertyMetadata)serializable)._required;
        return serializable != null && ((Boolean)serializable).booleanValue();
    }

    public Boolean getRequired() {
        return this._required;
    }

    public Integer getIndex() {
        return this._index;
    }

    public boolean hasIndex() {
        return this._index != null;
    }

    public MergeInfo getMergeInfo() {
        return this._mergeInfo;
    }

    public Nulls getValueNulls() {
        return this._valueNulls;
    }

    public Nulls getContentNulls() {
        return this._contentNulls;
    }

    public static final class MergeInfo {
        public final AnnotatedMember getter;
        public final boolean fromDefaults;

        public MergeInfo(AnnotatedMember annotatedMember, boolean bl) {
            this.getter = annotatedMember;
            this.fromDefaults = bl;
        }

        public static MergeInfo createForDefaults(AnnotatedMember annotatedMember) {
            return new MergeInfo(annotatedMember, true);
        }

        public static MergeInfo createForTypeOverride(AnnotatedMember annotatedMember) {
            return new MergeInfo(annotatedMember, false);
        }

        public static MergeInfo createForPropertyOverride(AnnotatedMember annotatedMember) {
            return new MergeInfo(annotatedMember, false);
        }
    }
}

