/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.core.util.InternCache;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;

public class PropertyName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String _USE_DEFAULT = "";
    private static final String _NO_NAME = "";
    public static final PropertyName USE_DEFAULT;
    public static final PropertyName NO_NAME;
    protected final String _simpleName;
    protected final String _namespace;
    protected SerializableString _encodedSimple;

    public PropertyName(String string) {
        this(string, null);
    }

    public PropertyName(String string, String string2) {
        this._simpleName = ClassUtil.nonNullString(string);
        this._namespace = string2;
    }

    public static PropertyName construct(String string) {
        if (string != null && !string.isEmpty()) {
            return new PropertyName(InternCache.instance.intern(string), null);
        }
        return USE_DEFAULT;
    }

    public static PropertyName construct(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null && string.isEmpty()) {
            return USE_DEFAULT;
        }
        return new PropertyName(InternCache.instance.intern(string), string2);
    }

    static {
        String string;
        USE_DEFAULT = new PropertyName("", null);
        String string2 = string;
        string = new String("");
        NO_NAME = new PropertyName(string2, null);
    }

    public Object readResolve() {
        String string;
        if (this._namespace == null && ((string = this._simpleName) == null || "".equals(string))) {
            return USE_DEFAULT;
        }
        return this;
    }

    public PropertyName internSimpleName() {
        if (this._simpleName.isEmpty()) {
            return this;
        }
        String string = InternCache.instance.intern(this._simpleName);
        if (string == this._simpleName) {
            return this;
        }
        return new PropertyName(string, this._namespace);
    }

    public PropertyName withSimpleName(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this._simpleName)) {
            return this;
        }
        return new PropertyName(string, this._namespace);
    }

    public PropertyName withNamespace(String string) {
        if (string == null ? this._namespace == null : string.equals(this._namespace)) {
            return this;
        }
        return new PropertyName(this._simpleName, string);
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public SerializableString simpleAsEncoded(MapperConfig<?> object) {
        Object object2 = this._encodedSimple;
        if (object2 == null) {
            if (object == null) {
                SerializedString serializedString;
                object = serializedString;
                serializedString = new SerializedString(this._simpleName);
                object2 = object;
            } else {
                object2 = object = ((MapperConfig)object).compileString(this._simpleName);
            }
            this._encodedSimple = object2;
        }
        return object2;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public boolean hasSimpleName() {
        return this._simpleName.isEmpty() ^ true;
    }

    public boolean hasSimpleName(String string) {
        return this._simpleName.equals(string);
    }

    public boolean hasNamespace() {
        return this._namespace != null;
    }

    public boolean isEmpty() {
        return this._namespace == null && this._simpleName.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == string2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != string2.getClass()) {
            return false;
        }
        object = (PropertyName)object;
        String string = ((PropertyName)((Object)string2))._simpleName;
        if (string == null ? ((PropertyName)object)._simpleName != null : !string.equals(((PropertyName)object)._simpleName)) {
            return false;
        }
        String string2 = ((PropertyName)((Object)string2))._namespace;
        if (string2 == null) {
            return ((PropertyName)object)._namespace == null;
        }
        return string2.equals(((PropertyName)object)._namespace);
    }

    public int hashCode() {
        String string = this._namespace;
        if (string == null) {
            return this._simpleName.hashCode();
        }
        return string.hashCode() ^ this._simpleName.hashCode();
    }

    public String toString() {
        if (this._namespace == null) {
            return this._simpleName;
        }
        return "{" + this._namespace + "}" + this._simpleName;
    }
}

