/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public class PropertyNamingStrategy
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Deprecated
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new PropertyNamingStrategy();
    @Deprecated
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy LOWER_DOT_CASE = new LowerDotCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES = SNAKE_CASE;
    @Deprecated
    public static final PropertyNamingStrategy PASCAL_CASE_TO_CAMEL_CASE = UPPER_CAMEL_CASE;

    public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
        return string;
    }

    public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
        return string;
    }

    @Deprecated
    public static class UpperCamelCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string != null && !string.isEmpty()) {
                char c2 = string.charAt(0);
                char c3 = Character.toUpperCase(c2);
                if (c2 == c3) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.setCharAt(0, c3);
                return stringBuilder.toString();
            }
            return string;
        }
    }

    @Deprecated
    public static class SnakeCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            StringBuilder stringBuilder;
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder(n2 * 2);
            int n3 = 0;
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (i2 <= 0 && c2 == '_') continue;
                if (Character.isUpperCase(c2)) {
                    if (!bl && n3 > 0 && stringBuilder2.charAt(n3 - 1) != '_') {
                        stringBuilder2.append('_');
                        ++n3;
                    }
                    c2 = Character.toLowerCase(c2);
                    bl = true;
                } else {
                    bl = false;
                }
                stringBuilder2.append(c2);
                ++n3;
            }
            if (n3 > 0) {
                string = stringBuilder2.toString();
            }
            return string;
        }
    }

    @Deprecated
    public static class LowerCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            return string.toLowerCase();
        }
    }

    @Deprecated
    public static class KebabCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            return PropertyNamingStrategyBase.translateLowerCaseWithSeparator(string, '-');
        }
    }

    @Deprecated
    public static class LowerDotCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            return PropertyNamingStrategyBase.translateLowerCaseWithSeparator(string, '.');
        }
    }

    @Deprecated
    public static class PascalCaseStrategy
    extends UpperCamelCaseStrategy {
    }

    @Deprecated
    public static class LowerCaseWithUnderscoresStrategy
    extends SnakeCaseStrategy {
    }

    @Deprecated
    public static abstract class PropertyNamingStrategyBase
    extends PropertyNamingStrategy {
        public static String translateLowerCaseWithSeparator(String string, char c2) {
            StringBuilder stringBuilder;
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            if (n2 == 0) {
                return string;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            int n3 = n2;
            stringBuilder = new StringBuilder(n3 + (n3 >> 1));
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                char c4 = Character.toLowerCase(c3);
                if (c4 == c3) {
                    if (n4 > 1) {
                        StringBuilder stringBuilder3 = stringBuilder2;
                        stringBuilder3.insert(stringBuilder3.length() - 1, c2);
                    }
                    n4 = 0;
                } else {
                    if (n4 == 0 && i2 > 0) {
                        stringBuilder2.append(c2);
                    }
                    ++n4;
                }
                stringBuilder2.append(c4);
            }
            return stringBuilder2.toString();
        }

        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);
    }
}

