/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.ObjectWriter;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.cfg.PackageVersion;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.privatefasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;

public class SequenceWriter
implements Versioned,
Closeable,
Flushable {
    protected final DefaultSerializerProvider _provider;
    protected final SerializationConfig _config;
    protected final JsonGenerator _generator;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final TypeSerializer _typeSerializer;
    protected final boolean _closeGenerator;
    protected final boolean _cfgFlush;
    protected final boolean _cfgCloseCloseable;
    protected PropertySerializerMap _dynamicSerializers;
    protected boolean _openArray;
    protected boolean _closed;

    public SequenceWriter(DefaultSerializerProvider serializable, JsonGenerator jsonGenerator, boolean bl, ObjectWriter.Prefetch prefetch) {
        SequenceWriter sequenceWriter = this;
        this._provider = serializable;
        this._generator = jsonGenerator;
        this._closeGenerator = bl;
        this._rootSerializer = prefetch.getValueSerializer();
        this._typeSerializer = prefetch.getTypeSerializer();
        serializable = ((SerializerProvider)((Object)serializable)).getConfig();
        this._config = serializable;
        this._cfgFlush = ((SerializationConfig)serializable).isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        sequenceWriter._cfgCloseCloseable = ((SerializationConfig)serializable).isEnabled(SerializationFeature.CLOSE_CLOSEABLE);
        sequenceWriter._dynamicSerializers = PropertySerializerMap.emptyForRootValues();
    }

    private final JsonSerializer<Object> _findAndAddDynamic(Class<?> object) {
        TypeSerializer typeSerializer = this._typeSerializer;
        object = typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer((Class<?>)object, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer((Class<?>)object, (JsonSerializer<Object>)new TypeWrappedSerializer(typeSerializer, this._provider.findValueSerializer((Class<?>)object, null)));
        this._dynamicSerializers = ((PropertySerializerMap.SerializerAndMapResult)object).map;
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(JavaType object) {
        TypeSerializer typeSerializer = this._typeSerializer;
        object = typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer((JavaType)object, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer((JavaType)object, (JsonSerializer<Object>)new TypeWrappedSerializer(typeSerializer, this._provider.findValueSerializer((JavaType)object, null)));
        this._dynamicSerializers = ((PropertySerializerMap.SerializerAndMapResult)object).map;
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }

    public SequenceWriter init(boolean bl) {
        if (bl) {
            this._generator.writeStartArray();
            this._openArray = true;
        }
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public SequenceWriter write(Object object) {
        if (object == null) {
            SequenceWriter sequenceWriter = this;
            sequenceWriter._provider.serializeValue(this._generator, null);
            return sequenceWriter;
        }
        if (this._cfgCloseCloseable && object instanceof Closeable) {
            return this._writeCloseableValue(object);
        }
        Object object2 = this._rootSerializer;
        if (object2 == null) {
            object2 = object.getClass();
            JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor((Class<?>)object2);
            object2 = jsonSerializer == null ? this._findAndAddDynamic((Class<?>)object2) : jsonSerializer;
        }
        SequenceWriter sequenceWriter = this;
        sequenceWriter._provider.serializeValue(this._generator, object, null, (JsonSerializer<Object>)object2);
        if (sequenceWriter._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter write(Object object, JavaType javaType) {
        if (object == null) {
            SequenceWriter sequenceWriter = this;
            sequenceWriter._provider.serializeValue(this._generator, null);
            return sequenceWriter;
        }
        if (this._cfgCloseCloseable && object instanceof Closeable) {
            return this._writeCloseableValue(object, javaType);
        }
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(javaType.getRawClass());
        if (jsonSerializer == null) {
            jsonSerializer = this._findAndAddDynamic(javaType);
        }
        SequenceWriter sequenceWriter = this;
        sequenceWriter._provider.serializeValue(this._generator, object, javaType, jsonSerializer);
        if (sequenceWriter._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter writeAll(Object[] objectArray) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(objectArray[i2]);
        }
        return this;
    }

    public <C extends Collection<?>> SequenceWriter writeAll(C object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.write(object.next());
        }
        return this;
    }

    public SequenceWriter writeAll(Iterable<?> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.write(object.next());
        }
        return this;
    }

    @Override
    public void flush() {
        if (!this._closed) {
            this._generator.flush();
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._closed = true;
            if (this._openArray) {
                this._openArray = false;
                this._generator.writeEndArray();
            }
            if (this._closeGenerator) {
                this._generator.close();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SequenceWriter _writeCloseableValue(Object object) {
        Throwable throwable2;
        Closeable closeable;
        block8: {
            JsonSerializer<Object> jsonSerializer;
            block7: {
                closeable = (Closeable)object;
                try {
                    jsonSerializer = this._rootSerializer;
                    if (jsonSerializer != null) break block7;
                }
                catch (Throwable throwable2) {
                    break block8;
                }
                {
                    jsonSerializer = object.getClass();
                    JsonSerializer<Object> jsonSerializer2 = this._dynamicSerializers.serializerFor((Class<?>)((Object)jsonSerializer));
                    jsonSerializer = jsonSerializer2 == null ? this._findAndAddDynamic((Class<?>)((Object)jsonSerializer)) : jsonSerializer2;
                }
            }
            SequenceWriter sequenceWriter = this;
            sequenceWriter._provider.serializeValue(this._generator, object, null, jsonSerializer);
            if (sequenceWriter._cfgFlush) {
                this._generator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
            return this;
        }
        if (closeable == null) throw throwable2;
        try {
            closeable.close();
            throw throwable2;
        }
        catch (IOException iOException) {}
        throw throwable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SequenceWriter _writeCloseableValue(Object object, JavaType javaType) {
        Throwable throwable2;
        Closeable closeable;
        block7: {
            JsonSerializer<Object> jsonSerializer;
            block6: {
                closeable = (Closeable)object;
                try {
                    jsonSerializer = this._dynamicSerializers.serializerFor(javaType.getRawClass());
                    if (jsonSerializer != null) break block6;
                }
                catch (Throwable throwable2) {
                    break block7;
                }
                jsonSerializer = this._findAndAddDynamic(javaType);
            }
            SequenceWriter sequenceWriter = this;
            sequenceWriter._provider.serializeValue(this._generator, object, javaType, jsonSerializer);
            if (sequenceWriter._cfgFlush) {
                this._generator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
            return this;
        }
        if (closeable == null) throw throwable2;
        try {
            closeable.close();
            throw throwable2;
        }
        catch (IOException iOException) {}
        throw throwable2;
    }
}

