/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.json.JsonWriteFeature;
import com.privatefasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.privatefasterxml.jackson.core.util.Instantiatable;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.cfg.BaseSettings;
import com.privatefasterxml.jackson.databind.cfg.ConfigOverrides;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfigBase;
import com.privatefasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.privatefasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.privatefasterxml.jackson.databind.ser.FilterProvider;
import com.privatefasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    private static final int SER_FEATURE_DEFAULTS = MapperConfig.collectFeatureDefaults(SerializationFeature.class);
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _serFeatures;
    protected final int _generatorFeatures;
    protected final int _generatorFeaturesToChange;
    protected final int _formatWriteFeatures;
    protected final int _formatWriteFeaturesToChange;

    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, DatatypeFeatures datatypeFeatures) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides, datatypeFeatures);
        this._serFeatures = SER_FEATURE_DEFAULTS;
        this._filterProvider = null;
        this._defaultPrettyPrinter = DEFAULT_PRETTY_PRINTER;
        this._generatorFeatures = 0;
        this._generatorFeaturesToChange = 0;
        this._formatWriteFeatures = 0;
        this._formatWriteFeaturesToChange = 0;
    }

    @Deprecated
    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        SerializationConfig serializationConfig = serializable;
        Serializable serializable = DatatypeFeatures.defaultFeatures();
        serializationConfig(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides, (DatatypeFeatures)serializable);
    }

    public SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(serializationConfig, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver) {
        super(serializationConfig, subtypeResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, long l2, int n2, int n3, int n4, int n5, int n6) {
        super(serializationConfig, l2);
        this._serFeatures = n2;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = n3;
        this._generatorFeaturesToChange = n4;
        this._formatWriteFeatures = n5;
        this._formatWriteFeaturesToChange = n6;
    }

    private SerializationConfig(SerializationConfig serializationConfig, BaseSettings baseSettings) {
        super(serializationConfig, baseSettings);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, FilterProvider filterProvider) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, Class<?> clazz) {
        super(serializationConfig, clazz);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, PropertyName propertyName) {
        super(serializationConfig, propertyName);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    public SerializationConfig(SerializationConfig serializationConfig, ContextAttributes contextAttributes) {
        super(serializationConfig, contextAttributes);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    public SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(serializationConfig, simpleMixInResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    public SerializationConfig(SerializationConfig serializationConfig, PrettyPrinter prettyPrinter) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = prettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    public SerializationConfig(SerializationConfig serializationConfig, DatatypeFeatures datatypeFeatures) {
        super(serializationConfig, datatypeFeatures);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig _withJsonWriteFeatures(FormatFeature ... object) {
        int n2;
        int n3 = object3._generatorFeatures;
        int n4 = object3._generatorFeaturesToChange;
        int n5 = object3._formatWriteFeatures;
        int n6 = object3._formatWriteFeaturesToChange;
        int n7 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n6;
            Object object2 = object[i2];
            n6 = object2.getMask();
            n2 = n5 | n6;
            n6 = n8 | n6;
            if (object2 instanceof JsonWriteFeature && (object2 = ((JsonWriteFeature)object2).mappedFeature()) != null) {
                int n9 = n4;
                int n10 = n3;
                n3 = ((JsonGenerator.Feature)((Object)object2)).getMask();
                n4 = n10 | n3;
                n3 = n9 | n3;
                int n11 = n4;
                n4 = n3;
                n3 = n11;
            }
            n5 = n2;
        }
        if (object3._formatWriteFeatures != n5 || object3._formatWriteFeaturesToChange != n6 || object3._generatorFeatures != n3 || object3._generatorFeaturesToChange != n4) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object3._mapperFeatures;
            n2 = object3._serFeatures;
            serializationConfig = new SerializationConfig((SerializationConfig)object3, l2, n2, n3, n4, n5, n6);
            Object object3 = object;
        }
        return object3;
    }

    private SerializationConfig _withoutJsonWriteFeatures(FormatFeature ... object) {
        int n2;
        int n3 = object3._generatorFeatures;
        int n4 = object3._generatorFeaturesToChange;
        int n5 = object3._formatWriteFeatures;
        int n6 = object3._formatWriteFeaturesToChange;
        int n7 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n6;
            Object object2 = object[i2];
            n6 = object2.getMask();
            n2 = n5 & ~n6;
            n6 = n8 | n6;
            if (object2 instanceof JsonWriteFeature && (object2 = ((JsonWriteFeature)object2).mappedFeature()) != null) {
                int n9 = n4;
                int n10 = n3;
                n3 = ((JsonGenerator.Feature)((Object)object2)).getMask();
                n4 = n10 & ~n3;
                n3 = n9 | n3;
                int n11 = n4;
                n4 = n3;
                n3 = n11;
            }
            n5 = n2;
        }
        if (object3._formatWriteFeatures != n5 || object3._formatWriteFeaturesToChange != n6 || object3._generatorFeatures != n3 || object3._generatorFeaturesToChange != n4) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object3._mapperFeatures;
            n2 = object3._serFeatures;
            serializationConfig = new SerializationConfig((SerializationConfig)object3, l2, n2, n3, n4, n5, n6);
            Object object3 = object;
        }
        return object3;
    }

    @Override
    public final SerializationConfig _withBase(BaseSettings baseSettings) {
        if (serializationConfig3._base != baseSettings) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            serializationConfig = new SerializationConfig(serializationConfig3, baseSettings);
            SerializationConfig serializationConfig3 = serializationConfig2;
        }
        return serializationConfig3;
    }

    @Override
    public final SerializationConfig _withMapperFeatures(long l2) {
        SerializationConfig serializationConfig = this;
        int n2 = serializationConfig._serFeatures;
        int n3 = serializationConfig._generatorFeatures;
        int n4 = serializationConfig._generatorFeaturesToChange;
        int n5 = serializationConfig._formatWriteFeatures;
        int n6 = serializationConfig._formatWriteFeaturesToChange;
        return new SerializationConfig(this, l2, n2, n3, n4, n5, n6);
    }

    @Override
    public final SerializationConfig _with(DatatypeFeatures datatypeFeatures) {
        return new SerializationConfig(this, datatypeFeatures);
    }

    @Override
    public SerializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new SerializationConfig(this, propertyName);
    }

    @Override
    public SerializationConfig with(SubtypeResolver subtypeResolver) {
        if (subtypeResolver != serializationConfig3._subtypeResolver) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            serializationConfig = new SerializationConfig(serializationConfig3, subtypeResolver);
            SerializationConfig serializationConfig3 = serializationConfig2;
        }
        return serializationConfig3;
    }

    @Override
    public SerializationConfig withView(Class<?> clazz) {
        if (serializationConfig3._view != clazz) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            serializationConfig = new SerializationConfig(serializationConfig3, clazz);
            SerializationConfig serializationConfig3 = serializationConfig2;
        }
        return serializationConfig3;
    }

    @Override
    public SerializationConfig with(ContextAttributes contextAttributes) {
        if (contextAttributes != serializationConfig3._attributes) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            serializationConfig = new SerializationConfig(serializationConfig3, contextAttributes);
            SerializationConfig serializationConfig3 = serializationConfig2;
        }
        return serializationConfig3;
    }

    @Override
    public SerializationConfig with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = (SerializationConfig)super.with(dateFormat);
        if (dateFormat == null) {
            return serializationConfig.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return serializationConfig.without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public SerializationConfig with(SerializationFeature serializationFeature) {
        int n2 = serializationConfig4._serFeatures | serializationFeature.getMask();
        if (n2 != serializationConfig4._serFeatures) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            SerializationConfig serializationConfig3 = serializationConfig4;
            long l2 = serializationConfig3._mapperFeatures;
            int n3 = serializationConfig3._generatorFeatures;
            int n4 = serializationConfig3._generatorFeaturesToChange;
            int n5 = serializationConfig3._formatWriteFeatures;
            int n6 = serializationConfig3._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig(serializationConfig4, l2, n2, n3, n4, n5, n6);
            SerializationConfig serializationConfig4 = serializationConfig2;
        }
        return serializationConfig4;
    }

    public SerializationConfig with(SerializationFeature serializationFeature, SerializationFeature ... object) {
        int n2 = object2._serFeatures | serializationFeature.getMask();
        int n3 = ((SerializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 |= object[i2].getMask();
        }
        if (n2 != object2._serFeatures) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._generatorFeatures;
            int n5 = object2._generatorFeaturesToChange;
            int n6 = object2._formatWriteFeatures;
            int n7 = object2._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig withFeatures(SerializationFeature ... object) {
        int n2 = object2._serFeatures;
        int n3 = ((SerializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 |= object[i2].getMask();
        }
        if (n2 != object2._serFeatures) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._generatorFeatures;
            int n5 = object2._generatorFeaturesToChange;
            int n6 = object2._formatWriteFeatures;
            int n7 = object2._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig without(SerializationFeature serializationFeature) {
        int n2 = serializationConfig4._serFeatures & ~serializationFeature.getMask();
        if (n2 != serializationConfig4._serFeatures) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            SerializationConfig serializationConfig3 = serializationConfig4;
            long l2 = serializationConfig3._mapperFeatures;
            int n3 = serializationConfig3._generatorFeatures;
            int n4 = serializationConfig3._generatorFeaturesToChange;
            int n5 = serializationConfig3._formatWriteFeatures;
            int n6 = serializationConfig3._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig(serializationConfig4, l2, n2, n3, n4, n5, n6);
            SerializationConfig serializationConfig4 = serializationConfig2;
        }
        return serializationConfig4;
    }

    public SerializationConfig without(SerializationFeature serializationFeature, SerializationFeature ... object) {
        int n2 = object2._serFeatures & ~serializationFeature.getMask();
        int n3 = ((SerializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 &= ~object[i2].getMask();
        }
        if (n2 != object2._serFeatures) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._generatorFeatures;
            int n5 = object2._generatorFeaturesToChange;
            int n6 = object2._formatWriteFeatures;
            int n7 = object2._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig withoutFeatures(SerializationFeature ... object) {
        int n2 = object2._serFeatures;
        int n3 = ((SerializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 &= ~object[i2].getMask();
        }
        if (n2 != object2._serFeatures) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._generatorFeatures;
            int n5 = object2._generatorFeaturesToChange;
            int n6 = object2._formatWriteFeatures;
            int n7 = object2._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig with(JsonGenerator.Feature feature) {
        SerializationConfig serializationConfig = serializationConfig5;
        int n2 = serializationConfig._generatorFeatures | feature.getMask();
        int n3 = serializationConfig._generatorFeaturesToChange | feature.getMask();
        if (serializationConfig._generatorFeatures != n2 || serializationConfig5._generatorFeaturesToChange != n3) {
            SerializationConfig serializationConfig2;
            SerializationConfig serializationConfig3 = serializationConfig2;
            SerializationConfig serializationConfig4 = serializationConfig5;
            long l2 = serializationConfig4._mapperFeatures;
            int n4 = serializationConfig4._serFeatures;
            int n5 = serializationConfig4._formatWriteFeatures;
            int n6 = serializationConfig4._formatWriteFeaturesToChange;
            serializationConfig2 = new SerializationConfig(serializationConfig5, l2, n4, n2, n3, n5, n6);
            SerializationConfig serializationConfig5 = serializationConfig3;
        }
        return serializationConfig5;
    }

    public SerializationConfig withFeatures(JsonGenerator.Feature ... object) {
        int n2 = object2._generatorFeatures;
        int n3 = object2._generatorFeaturesToChange;
        int n4 = ((JsonGenerator.Feature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 | n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._generatorFeatures != n2 || object2._generatorFeaturesToChange != n3) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._serFeatures;
            int n9 = object2._formatWriteFeatures;
            int n10 = object2._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n8, n2, n3, n9, n10);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig without(JsonGenerator.Feature feature) {
        SerializationConfig serializationConfig = serializationConfig5;
        int n2 = serializationConfig._generatorFeatures & ~feature.getMask();
        int n3 = serializationConfig._generatorFeaturesToChange | feature.getMask();
        if (serializationConfig._generatorFeatures != n2 || serializationConfig5._generatorFeaturesToChange != n3) {
            SerializationConfig serializationConfig2;
            SerializationConfig serializationConfig3 = serializationConfig2;
            SerializationConfig serializationConfig4 = serializationConfig5;
            long l2 = serializationConfig4._mapperFeatures;
            int n4 = serializationConfig4._serFeatures;
            int n5 = serializationConfig4._formatWriteFeatures;
            int n6 = serializationConfig4._formatWriteFeaturesToChange;
            serializationConfig2 = new SerializationConfig(serializationConfig5, l2, n4, n2, n3, n5, n6);
            SerializationConfig serializationConfig5 = serializationConfig3;
        }
        return serializationConfig5;
    }

    public SerializationConfig withoutFeatures(JsonGenerator.Feature ... object) {
        int n2 = object2._generatorFeatures;
        int n3 = object2._generatorFeaturesToChange;
        int n4 = ((JsonGenerator.Feature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 & ~n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._generatorFeatures != n2 || object2._generatorFeaturesToChange != n3) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._serFeatures;
            int n9 = object2._formatWriteFeatures;
            int n10 = object2._formatWriteFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n8, n2, n3, n9, n10);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig with(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonWriteFeature) {
            return serializationConfig5._withJsonWriteFeatures(formatFeature);
        }
        SerializationConfig serializationConfig = serializationConfig5;
        int n2 = serializationConfig._formatWriteFeatures | formatFeature.getMask();
        int n3 = serializationConfig._formatWriteFeaturesToChange | formatFeature.getMask();
        if (serializationConfig._formatWriteFeatures != n2 || serializationConfig5._formatWriteFeaturesToChange != n3) {
            SerializationConfig serializationConfig2;
            SerializationConfig serializationConfig3 = serializationConfig2;
            SerializationConfig serializationConfig4 = serializationConfig5;
            long l2 = serializationConfig4._mapperFeatures;
            int n4 = serializationConfig4._serFeatures;
            int n5 = serializationConfig4._generatorFeatures;
            int n6 = serializationConfig4._generatorFeaturesToChange;
            serializationConfig2 = new SerializationConfig(serializationConfig5, l2, n4, n5, n6, n2, n3);
            SerializationConfig serializationConfig5 = serializationConfig3;
        }
        return serializationConfig5;
    }

    public SerializationConfig withFeatures(FormatFeature ... object) {
        if (((FormatFeature[])object).length > 0 && object[0] instanceof JsonWriteFeature) {
            return object2._withJsonWriteFeatures((FormatFeature)object);
        }
        int n2 = object2._formatWriteFeatures;
        int n3 = object2._formatWriteFeaturesToChange;
        int n4 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 | n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._formatWriteFeatures != n2 || object2._formatWriteFeaturesToChange != n3) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._serFeatures;
            int n9 = object2._generatorFeatures;
            int n10 = object2._generatorFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n8, n9, n10, n2, n3);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig without(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonWriteFeature) {
            return serializationConfig5._withoutJsonWriteFeatures(formatFeature);
        }
        SerializationConfig serializationConfig = serializationConfig5;
        int n2 = serializationConfig._formatWriteFeatures & ~formatFeature.getMask();
        int n3 = serializationConfig._formatWriteFeaturesToChange | formatFeature.getMask();
        if (serializationConfig._formatWriteFeatures != n2 || serializationConfig5._formatWriteFeaturesToChange != n3) {
            SerializationConfig serializationConfig2;
            SerializationConfig serializationConfig3 = serializationConfig2;
            SerializationConfig serializationConfig4 = serializationConfig5;
            long l2 = serializationConfig4._mapperFeatures;
            int n4 = serializationConfig4._serFeatures;
            int n5 = serializationConfig4._generatorFeatures;
            int n6 = serializationConfig4._generatorFeaturesToChange;
            serializationConfig2 = new SerializationConfig(serializationConfig5, l2, n4, n5, n6, n2, n3);
            SerializationConfig serializationConfig5 = serializationConfig3;
        }
        return serializationConfig5;
    }

    public SerializationConfig withoutFeatures(FormatFeature ... object) {
        if (((FormatFeature[])object).length > 0 && object[0] instanceof JsonWriteFeature) {
            return object2._withoutJsonWriteFeatures((FormatFeature)object);
        }
        int n2 = object2._formatWriteFeatures;
        int n3 = object2._formatWriteFeaturesToChange;
        int n4 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 & ~n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._formatWriteFeatures != n2 || object2._formatWriteFeaturesToChange != n3) {
            SerializationConfig serializationConfig;
            object = serializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._serFeatures;
            int n9 = object2._generatorFeatures;
            int n10 = object2._generatorFeaturesToChange;
            serializationConfig = new SerializationConfig((SerializationConfig)object2, l2, n8, n9, n10, n2, n3);
            Object object2 = object;
        }
        return object2;
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        if (filterProvider != serializationConfig3._filterProvider) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            serializationConfig = new SerializationConfig(serializationConfig3, filterProvider);
            SerializationConfig serializationConfig3 = serializationConfig2;
        }
        return serializationConfig3;
    }

    @Deprecated
    public SerializationConfig withPropertyInclusion(JsonInclude.Value value) {
        SerializationConfig serializationConfig = this;
        serializationConfig._configOverrides.setDefaultInclusion(value);
        return serializationConfig;
    }

    public SerializationConfig withDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        if (serializationConfig3._defaultPrettyPrinter != prettyPrinter) {
            SerializationConfig serializationConfig;
            SerializationConfig serializationConfig2 = serializationConfig;
            serializationConfig = new SerializationConfig(serializationConfig3, prettyPrinter);
            SerializationConfig serializationConfig3 = serializationConfig2;
        }
        return serializationConfig3;
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        Object object = ((SerializationConfig)object)._defaultPrettyPrinter;
        if (object instanceof Instantiatable) {
            object = (PrettyPrinter)((Instantiatable)object).createInstance();
        }
        return object;
    }

    public void initialize(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter;
        if (SerializationFeature.INDENT_OUTPUT.enabledIn(this._serFeatures) && jsonGenerator.getPrettyPrinter() == null && (prettyPrinter = this.constructDefaultPrettyPrinter()) != null) {
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        }
        int n2 = SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._serFeatures);
        int n3 = this._generatorFeaturesToChange;
        if (n3 != 0 || n2 != 0) {
            int n4 = n2;
            n2 = this._generatorFeatures;
            if (n4 != 0) {
                int n5 = n3;
                int n6 = n2;
                n2 = JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.getMask();
                n3 = n6 | n2;
                n2 = n5 | n2;
                int n7 = n3;
                n3 = n2;
                n2 = n7;
            }
            jsonGenerator.overrideStdFeatures(n2, n3);
        }
        if ((n2 = this._formatWriteFeaturesToChange) != 0) {
            jsonGenerator.overrideFormatFeatures(this._formatWriteFeatures, n2);
        }
    }

    @Deprecated
    public JsonInclude.Include getSerializationInclusion() {
        if ((object = object.getDefaultPropertyInclusion().getValueInclusion()) == JsonInclude.Include.USE_DEFAULTS) {
            Object object = JsonInclude.Include.ALWAYS;
        }
        return object;
    }

    @Override
    public boolean useRootWrapping() {
        PropertyName propertyName = this._rootName;
        if (propertyName != null) {
            return propertyName.isEmpty() ^ true;
        }
        return this.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return (this._serFeatures & serializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature, JsonFactory jsonFactory) {
        int n2 = feature.getMask();
        if ((this._generatorFeaturesToChange & n2) != 0) {
            return (this._generatorFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int n2) {
        return (this._serFeatures & n2) == n2;
    }

    public final int getSerializationFeatures() {
        return this._serFeatures;
    }

    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._datatypeFeatures.isEnabled(datatypeFeature);
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter getDefaultPrettyPrinter() {
        return this._defaultPrettyPrinter;
    }

    public BeanDescription introspect(JavaType javaType) {
        return this.getClassIntrospector().forSerialization(this, javaType, this);
    }
}

