/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.privatefasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.FilterProvider;
import com.privatefasterxml.jackson.databind.ser.ResolvableSerializer;
import com.privatefasterxml.jackson.databind.ser.SerializerCache;
import com.privatefasterxml.jackson.databind.ser.SerializerFactory;
import com.privatefasterxml.jackson.databind.ser.impl.FailingSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.privatefasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.privatefasterxml.jackson.databind.ser.std.NullSerializer;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class SerializerProvider
extends DatabindContext {
    protected static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final Class<?> _serializationView;
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected transient ContextAttributes _attributes;
    protected JsonSerializer<Object> _unknownTypeSerializer;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _nullValueSerializer;
    protected JsonSerializer<Object> _nullKeySerializer;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;
    protected final boolean _stdNullValueSerializer;

    public SerializerProvider() {
        this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        this._nullValueSerializer = NullSerializer.instance;
        this._nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
        this._config = null;
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
        this._serializationView = null;
        this._attributes = null;
        this._stdNullValueSerializer = true;
    }

    public SerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory object) {
        JsonSerializer<Object> jsonSerializer;
        SerializerCache serializerCache;
        SerializerFactory serializerFactory = object;
        this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        this._nullValueSerializer = NullSerializer.instance;
        object = DEFAULT_NULL_KEY_SERIALIZER;
        this._nullKeySerializer = object;
        this._serializerFactory = serializerFactory;
        this._config = serializationConfig;
        this._serializerCache = serializerCache = serializerProvider._serializerCache;
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._nullValueSerializer = jsonSerializer = serializerProvider._nullValueSerializer;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        boolean bl = jsonSerializer == object;
        this._stdNullValueSerializer = bl;
        this._serializationView = serializationConfig.getActiveView();
        this._attributes = serializationConfig.getAttributes();
        this._knownSerializers = serializerCache.getReadOnlyLookupMap();
    }

    public SerializerProvider(SerializerProvider serializerProvider) {
        this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        this._nullValueSerializer = NullSerializer.instance;
        this._nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
        this._config = null;
        this._serializationView = null;
        this._serializerFactory = null;
        this._knownSerializers = null;
        this._serializerCache = new SerializerCache();
        this._unknownTypeSerializer = serializerProvider._unknownTypeSerializer;
        this._keySerializer = serializerProvider._keySerializer;
        this._nullValueSerializer = serializerProvider._nullValueSerializer;
        this._nullKeySerializer = serializerProvider._nullKeySerializer;
        this._stdNullValueSerializer = serializerProvider._stdNullValueSerializer;
    }

    public void setDefaultKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer != null) {
            this._keySerializer = jsonSerializer;
            return;
        }
        throw new IllegalArgumentException("Cannot pass null JsonSerializer");
    }

    public void setNullValueSerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer != null) {
            this._nullValueSerializer = jsonSerializer;
            return;
        }
        throw new IllegalArgumentException("Cannot pass null JsonSerializer");
    }

    public void setNullKeySerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer != null) {
            this._nullKeySerializer = jsonSerializer;
            return;
        }
        throw new IllegalArgumentException("Cannot pass null JsonSerializer");
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (javaType.hasRawClass(clazz)) {
            return javaType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(javaType, clazz, true);
    }

    @Override
    public final Class<?> getActiveView() {
        return this._serializationView;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._config.isEnabled(datatypeFeature);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._config.getDefaultPropertyFormat(clazz);
    }

    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz) {
        return this._config.getDefaultPropertyInclusion(clazz);
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public SerializerProvider setAttribute(Object object, Object object2) {
        SerializerProvider serializerProvider = this;
        serializerProvider._attributes = serializerProvider._attributes.withPerCallAttribute(object, object2);
        return serializerProvider;
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public final boolean hasSerializationFeatures(int n2) {
        return this._config.hasSerializationFeatures(n2);
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public JsonGenerator getGenerator() {
        return null;
    }

    public TokenBuffer bufferForValueConversion(ObjectCodec objectCodec) {
        return new TokenBuffer(objectCodec, false);
    }

    public final TokenBuffer bufferForValueConversion() {
        return this.bufferForValueConversion(null);
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public JsonSerializer<Object> findValueSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            return this.getUnknownTypeSerializer(clazz);
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findValueSerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer;
        if (javaType == null) {
            this.reportMappingProblem("Null passed for `valueType` of `findValueSerializer()`", new Object[0]);
        }
        if ((jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            return this.getUnknownTypeSerializer(javaType.getRawClass());
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findValueSerializer(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(clazz);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findValueSerializer(JavaType javaType) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            jsonSerializer = this.getUnknownTypeSerializer(javaType.getRawClass());
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            return this.getUnknownTypeSerializer(javaType.getRawClass());
        }
        return this.handlePrimaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            return this.getUnknownTypeSerializer(clazz);
        }
        return this.handlePrimaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findContentValueSerializer(JavaType javaType, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(javaType);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(javaType)) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(javaType)) == null) {
            return this.getUnknownTypeSerializer(javaType.getRawClass());
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findContentValueSerializer(Class<?> clazz, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(this._config.constructType(clazz))) == null && (jsonSerializer = this._createAndCacheUntypedSerializer(clazz)) == null) {
            return this.getUnknownTypeSerializer(clazz);
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> findTypedValueSerializer(Class<?> clazz, boolean bl, BeanProperty object) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(clazz);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        SerializerProvider serializerProvider = this;
        jsonSerializer = serializerProvider.findValueSerializer(clazz, (BeanProperty)object);
        SerializationConfig serializationConfig = this._config;
        Object object2 = serializerProvider._serializerFactory.createTypeSerializer(serializationConfig, serializationConfig.constructType(clazz));
        if (object2 != null) {
            TypeWrappedSerializer typeWrappedSerializer;
            object = ((TypeSerializer)object2).forProperty((BeanProperty)object);
            object2 = typeWrappedSerializer;
            typeWrappedSerializer = new TypeWrappedSerializer((TypeSerializer)object, jsonSerializer);
            jsonSerializer = object2;
        }
        if (bl) {
            this._serializerCache.addTypedSerializer(clazz, jsonSerializer);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findTypedValueSerializer(JavaType javaType, boolean bl, BeanProperty object) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        jsonSerializer = this._serializerCache.typedValueSerializer(javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        SerializerProvider serializerProvider = this;
        jsonSerializer = serializerProvider.findValueSerializer(javaType, (BeanProperty)object);
        Object object2 = serializerProvider._serializerFactory.createTypeSerializer(this._config, javaType);
        if (object2 != null) {
            TypeWrappedSerializer typeWrappedSerializer;
            object = ((TypeSerializer)object2).forProperty((BeanProperty)object);
            object2 = typeWrappedSerializer;
            typeWrappedSerializer = new TypeWrappedSerializer((TypeSerializer)object, jsonSerializer);
            jsonSerializer = object2;
        }
        if (bl) {
            this._serializerCache.addTypedSerializer(javaType, jsonSerializer);
        }
        return jsonSerializer;
    }

    public TypeSerializer findTypeSerializer(JavaType javaType) {
        return this._serializerFactory.createTypeSerializer(this._config, javaType);
    }

    public JsonSerializer<Object> findKeySerializer(JavaType javaType, BeanProperty beanProperty) {
        SerializerProvider serializerProvider = this;
        SerializerProvider serializerProvider2 = this;
        return serializerProvider._handleContextualResolvable(serializerProvider._serializerFactory.createKeySerializer(serializerProvider2, javaType, serializerProvider2._keySerializer), beanProperty);
    }

    public JsonSerializer<Object> findKeySerializer(Class<?> clazz, BeanProperty beanProperty) {
        SerializerProvider serializerProvider = this;
        return serializerProvider.findKeySerializer(serializerProvider._config.constructType(clazz), beanProperty);
    }

    public JsonSerializer<Object> getDefaultNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> findNullKeySerializer(JavaType javaType, BeanProperty beanProperty) {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty beanProperty) {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> clazz) {
        if (clazz == Object.class) {
            return this._unknownTypeSerializer;
        }
        return new UnknownSerializer(clazz);
    }

    public boolean isUnknownTypeSerializer(JsonSerializer<?> jsonSerializer) {
        if (jsonSerializer != this._unknownTypeSerializer && jsonSerializer != null) {
            return this.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS) && jsonSerializer.getClass() == UnknownSerializer.class;
        }
        return true;
    }

    public abstract JsonSerializer<Object> serializerInstance(Annotated var1, Object var2);

    public abstract Object includeFilterInstance(BeanPropertyDefinition var1, Class<?> var2);

    public abstract boolean includeFilterSuppressNulls(Object var1);

    public JsonSerializer<?> handlePrimaryContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer != null && jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    public JsonSerializer<?> handleSecondaryContextualization(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer != null && jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(this, beanProperty);
        }
        return jsonSerializer;
    }

    public final void defaultSerializeValue(Object object, JsonGenerator jsonGenerator) {
        if (object == null) {
            if (this._stdNullValueSerializer) {
                jsonGenerator.writeNull();
            } else {
                this._nullValueSerializer.serialize(null, jsonGenerator, this);
            }
        } else {
            this.findTypedValueSerializer(object.getClass(), true, null).serialize(object, jsonGenerator, this);
        }
    }

    public final void defaultSerializeField(String string, Object object, JsonGenerator jsonGenerator) {
        jsonGenerator.writeFieldName(string);
        if (object == null) {
            if (this._stdNullValueSerializer) {
                jsonGenerator.writeNull();
            } else {
                this._nullValueSerializer.serialize(null, jsonGenerator, this);
            }
        } else {
            this.findTypedValueSerializer(object.getClass(), true, null).serialize(object, jsonGenerator, this);
        }
    }

    public final void defaultSerializeDateValue(long l2, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(l2);
        } else {
            jsonGenerator.writeString(this._dateFormat().format(new Date(l2)));
        }
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(date.getTime());
        } else {
            jsonGenerator.writeString(this._dateFormat().format(date));
        }
    }

    public void defaultSerializeDateKey(long l2, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(l2));
        } else {
            jsonGenerator.writeFieldName(this._dateFormat().format(new Date(l2)));
        }
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator jsonGenerator) {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jsonGenerator.writeFieldName(String.valueOf(date.getTime()));
        } else {
            jsonGenerator.writeFieldName(this._dateFormat().format(date));
        }
    }

    public final void defaultSerializeNull(JsonGenerator jsonGenerator) {
        if (this._stdNullValueSerializer) {
            jsonGenerator.writeNull();
        } else {
            this._nullValueSerializer.serialize(null, jsonGenerator, this);
        }
    }

    public void reportMappingProblem(String string, Object ... objectArray) {
        throw this.mappingException(string, objectArray);
    }

    public <T> T reportBadTypeDefinition(BeanDescription beanDescription, String string, Object ... objectArray) {
        String string2 = "N/A";
        if (beanDescription != null) {
            string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        }
        SerializerProvider serializerProvider = string3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = ((DatabindContext)((Object)string3))._format(string, objectArray);
        String string3 = String.format("Invalid type definition for type %s: %s", objectArray3);
        throw InvalidDefinitionException.from(serializerProvider.getGenerator(), string3, beanDescription, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, String string, Object ... object) {
        string = object2._format(string, object);
        object = "N/A";
        if (beanPropertyDefinition != null) {
            object = object2._quotedString(beanPropertyDefinition.getName());
        }
        String string2 = "N/A";
        if (beanDescription != null) {
            string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        }
        Object[] objectArray = object2;
        Object[] objectArray2 = new Object[3];
        Object object2 = objectArray2;
        objectArray2[0] = object;
        objectArray2[1] = string2;
        objectArray2[2] = string;
        object2 = String.format("Invalid definition for property %s (of type %s): %s", object2);
        throw InvalidDefinitionException.from(objectArray.getGenerator(), (String)object2, beanDescription, beanPropertyDefinition);
    }

    @Override
    public <T> T reportBadDefinition(JavaType javaType, String string) {
        throw InvalidDefinitionException.from(this.getGenerator(), string, javaType);
    }

    public <T> T reportBadDefinition(JavaType javaType, String string, Throwable throwable) {
        throw InvalidDefinitionException.from(this.getGenerator(), string, javaType).withCause(throwable);
    }

    public <T> T reportBadDefinition(Class<?> clazz, String string, Throwable throwable) {
        throw InvalidDefinitionException.from(this.getGenerator(), string, this.constructType(clazz)).withCause(throwable);
    }

    public void reportMappingProblem(Throwable throwable, String string, Object ... objectArray) {
        SerializerProvider serializerProvider = string2;
        String string2 = serializerProvider._format(string, objectArray);
        throw JsonMappingException.from(serializerProvider.getGenerator(), string2, throwable);
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType javaType, String string, String string2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string;
        objectArray2[1] = ClassUtil.getTypeDescription(javaType);
        return InvalidTypeIdException.from(null, objectArray._colonConcat(String.format("Could not resolve type id '%s' as a subtype of %s", objectArray3), string2), javaType, string);
    }

    @Deprecated
    public JsonMappingException mappingException(String string, Object ... objectArray) {
        return JsonMappingException.from(this.getGenerator(), this._format(string, objectArray));
    }

    @Deprecated
    public JsonMappingException mappingException(Throwable throwable, String string, Object ... objectArray) {
        return JsonMappingException.from(this.getGenerator(), this._format(string, objectArray), throwable);
    }

    public void _reportIncompatibleRootType(Object object, JavaType javaType) {
        if (javaType.isPrimitive() && ClassUtil.wrapperType(javaType.getRawClass()).isAssignableFrom(object.getClass())) {
            return;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = javaType;
        objectArray2[1] = ClassUtil.classNameOf(object);
        objectArray.reportBadDefinition(javaType, String.format("Incompatible types: declared root type (%s) vs %s", objectArray3));
    }

    public JsonSerializer<Object> _findExplicitUntypedSerializer(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = this._knownSerializers.untypedValueSerializer(clazz);
        if (jsonSerializer == null && (jsonSerializer = this._serializerCache.untypedValueSerializer(clazz)) == null) {
            jsonSerializer = this._createAndCacheUntypedSerializer(clazz);
        }
        if (this.isUnknownTypeSerializer(jsonSerializer)) {
            return null;
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> _createAndCacheUntypedSerializer(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer;
        SerializerProvider serializerProvider = this;
        JavaType javaType = serializerProvider._config.constructType(clazz);
        try {
            jsonSerializer = serializerProvider._createUntypedSerializer(javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            jsonSerializer = null;
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(clazz, javaType, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> _createAndCacheUntypedSerializer(JavaType javaType) {
        JsonSerializer<Object> jsonSerializer;
        try {
            jsonSerializer = this._createUntypedSerializer(javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object var3_4 = null;
            Object[] objectArray = new Object[]{};
            this.reportMappingProblem(illegalArgumentException, ClassUtil.exceptionMessage(illegalArgumentException), objectArray);
            jsonSerializer = var3_4;
        }
        if (jsonSerializer != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(javaType, jsonSerializer, this);
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> _createUntypedSerializer(JavaType javaType) {
        return this._serializerFactory.createSerializer(this, javaType);
    }

    public JsonSerializer<Object> _handleContextualResolvable(JsonSerializer<?> jsonSerializer, BeanProperty beanProperty) {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return this.handleSecondaryContextualization(jsonSerializer, beanProperty);
    }

    public JsonSerializer<Object> _handleResolvable(JsonSerializer<?> jsonSerializer) {
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(this);
        }
        return jsonSerializer;
    }

    public final DateFormat _dateFormat() {
        DateFormat dateFormat = this._dateFormat;
        if (dateFormat != null) {
            return dateFormat;
        }
        this._dateFormat = (DateFormat)this._config.getDateFormat().clone();
        return this._dateFormat;
    }
}

