/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.StdDateFormat;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public final class BaseSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector _classIntrospector;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyNamingStrategy _propertyNamingStrategy;
    protected final AccessorNamingStrategy.Provider _accessorNaming;
    protected final TypeResolverBuilder<?> _typeResolverBuilder;
    protected final PolymorphicTypeValidator _typeValidator;
    protected final DateFormat _dateFormat;
    protected final HandlerInstantiator _handlerInstantiator;
    protected final Locale _locale;
    protected final TimeZone _timeZone;
    protected final Base64Variant _defaultBase64;

    public BaseSettings(ClassIntrospector classIntrospector, AnnotationIntrospector annotationIntrospector, PropertyNamingStrategy propertyNamingStrategy, TypeFactory typeFactory, TypeResolverBuilder<?> typeResolverBuilder, DateFormat dateFormat, HandlerInstantiator handlerInstantiator, Locale locale, TimeZone timeZone, Base64Variant base64Variant, PolymorphicTypeValidator polymorphicTypeValidator, AccessorNamingStrategy.Provider provider) {
        this._classIntrospector = classIntrospector;
        this._annotationIntrospector = annotationIntrospector;
        this._propertyNamingStrategy = propertyNamingStrategy;
        this._typeFactory = typeFactory;
        this._typeResolverBuilder = typeResolverBuilder;
        this._dateFormat = dateFormat;
        this._handlerInstantiator = handlerInstantiator;
        this._locale = locale;
        this._timeZone = timeZone;
        this._defaultBase64 = base64Variant;
        this._typeValidator = polymorphicTypeValidator;
        this._accessorNaming = provider;
    }

    @Deprecated
    public BaseSettings(ClassIntrospector classIntrospector, AnnotationIntrospector annotationIntrospector, PropertyNamingStrategy propertyNamingStrategy, TypeFactory typeFactory, TypeResolverBuilder<?> typeResolverBuilder, DateFormat dateFormat, HandlerInstantiator handlerInstantiator, Locale locale, TimeZone timeZone, Base64Variant base64Variant, PolymorphicTypeValidator polymorphicTypeValidator) {
        DefaultAccessorNamingStrategy.Provider provider;
        BaseSettings baseSettings = serializable;
        Serializable serializable = provider;
        provider = new DefaultAccessorNamingStrategy.Provider();
        baseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, (AccessorNamingStrategy.Provider)serializable);
    }

    private DateFormat _force(DateFormat dateFormat, TimeZone timeZone) {
        if (dateFormat instanceof StdDateFormat) {
            return ((StdDateFormat)dateFormat).withTimeZone(timeZone);
        }
        DateFormat dateFormat2 = (DateFormat)dateFormat.clone();
        dateFormat2.setTimeZone(timeZone);
        return dateFormat2;
    }

    public BaseSettings copy() {
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector.copy();
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withClassIntrospector(ClassIntrospector classIntrospector) {
        if (serializable._classIntrospector == classIntrospector) {
            return serializable;
        }
        BaseSettings baseSettings = serializable;
        Serializable serializable = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, (AnnotationIntrospector)serializable, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        if (((BaseSettings)((Object)classIntrospector))._annotationIntrospector == annotationIntrospector) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this.withAnnotationIntrospector(AnnotationIntrospectorPair.create(annotationIntrospector, this._annotationIntrospector));
    }

    public BaseSettings withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        BaseSettings baseSettings = this;
        return baseSettings.withAnnotationIntrospector(AnnotationIntrospectorPair.create(baseSettings._annotationIntrospector, annotationIntrospector));
    }

    public BaseSettings withPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        if (((BaseSettings)((Object)classIntrospector))._propertyNamingStrategy == propertyNamingStrategy) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withAccessorNaming(AccessorNamingStrategy.Provider provider) {
        if (((BaseSettings)((Object)classIntrospector))._accessorNaming == provider) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withTypeFactory(TypeFactory typeFactory) {
        if (((BaseSettings)((Object)classIntrospector))._typeFactory == typeFactory) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withTypeResolverBuilder(TypeResolverBuilder<?> typeResolverBuilder) {
        if (((BaseSettings)((Object)classIntrospector))._typeResolverBuilder == typeResolverBuilder) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withDateFormat(DateFormat dateFormat) {
        if (((BaseSettings)((Object)classIntrospector))._dateFormat == dateFormat) {
            return classIntrospector;
        }
        if (dateFormat != null && ((BaseSettings)((Object)classIntrospector)).hasExplicitTimeZone()) {
            BaseSettings baseSettings = classIntrospector;
            dateFormat = baseSettings._force(dateFormat, baseSettings._timeZone);
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings withHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        if (((BaseSettings)((Object)classIntrospector))._handlerInstantiator == handlerInstantiator) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings with(Locale locale) {
        if (((BaseSettings)((Object)classIntrospector))._locale == locale) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings with(TimeZone timeZone) {
        if (timeZone == ((BaseSettings)((Object)classIntrospector))._timeZone) {
            return classIntrospector;
        }
        DateFormat dateFormat = ((BaseSettings)((Object)classIntrospector))._dateFormat;
        Serializable serializable = timeZone == null ? DEFAULT_TIMEZONE : timeZone;
        dateFormat = ((BaseSettings)((Object)classIntrospector))._force(dateFormat, (TimeZone)serializable);
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        serializable = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, (AnnotationIntrospector)serializable, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings with(Base64Variant base64Variant) {
        if (base64Variant == ((BaseSettings)((Object)classIntrospector))._defaultBase64) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        PolymorphicTypeValidator polymorphicTypeValidator = baseSettings._typeValidator;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public BaseSettings with(PolymorphicTypeValidator polymorphicTypeValidator) {
        if (polymorphicTypeValidator == ((BaseSettings)((Object)classIntrospector))._typeValidator) {
            return classIntrospector;
        }
        BaseSettings baseSettings = classIntrospector;
        ClassIntrospector classIntrospector = baseSettings._classIntrospector;
        AnnotationIntrospector annotationIntrospector = baseSettings._annotationIntrospector;
        PropertyNamingStrategy propertyNamingStrategy = baseSettings._propertyNamingStrategy;
        TypeFactory typeFactory = baseSettings._typeFactory;
        TypeResolverBuilder<?> typeResolverBuilder = baseSettings._typeResolverBuilder;
        DateFormat dateFormat = baseSettings._dateFormat;
        HandlerInstantiator handlerInstantiator = baseSettings._handlerInstantiator;
        Locale locale = baseSettings._locale;
        TimeZone timeZone = baseSettings._timeZone;
        Base64Variant base64Variant = baseSettings._defaultBase64;
        AccessorNamingStrategy.Provider provider = baseSettings._accessorNaming;
        return new BaseSettings(classIntrospector, annotationIntrospector, propertyNamingStrategy, typeFactory, typeResolverBuilder, dateFormat, handlerInstantiator, locale, timeZone, base64Variant, polymorphicTypeValidator, provider);
    }

    public ClassIntrospector getClassIntrospector() {
        return this._classIntrospector;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._propertyNamingStrategy;
    }

    public AccessorNamingStrategy.Provider getAccessorNaming() {
        return this._accessorNaming;
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public TypeResolverBuilder<?> getTypeResolverBuilder() {
        return this._typeResolverBuilder;
    }

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        return this._typeValidator;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public HandlerInstantiator getHandlerInstantiator() {
        return this._handlerInstantiator;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public TimeZone getTimeZone() {
        Serializable serializable = serializable._timeZone;
        if (serializable == null) {
            serializable = DEFAULT_TIMEZONE;
        }
        return serializable;
    }

    public boolean hasExplicitTimeZone() {
        return this._timeZone != null;
    }

    public Base64Variant getBase64Variant() {
        return this._defaultBase64;
    }
}

