/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionConfig;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.privatefasterxml.jackson.databind.cfg.a;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CoercionConfigs
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TARGET_TYPE_COUNT = LogicalType.values().length;
    protected CoercionAction _defaultAction;
    protected final MutableCoercionConfig _defaultCoercions;
    protected MutableCoercionConfig[] _perTypeCoercions;
    protected Map<Class<?>, MutableCoercionConfig> _perClassCoercions;

    public CoercionConfigs() {
        MutableCoercionConfig mutableCoercionConfig;
        CoercionConfigs coercionConfigs = object;
        Object object = CoercionAction.TryConvert;
        MutableCoercionConfig mutableCoercionConfig2 = mutableCoercionConfig;
        mutableCoercionConfig = new MutableCoercionConfig();
        coercionConfigs((CoercionAction)((Object)object), mutableCoercionConfig2, null, null);
    }

    public CoercionConfigs(CoercionAction coercionAction, MutableCoercionConfig mutableCoercionConfig, MutableCoercionConfig[] mutableCoercionConfigArray, Map<Class<?>, MutableCoercionConfig> map) {
        this._defaultCoercions = mutableCoercionConfig;
        this._defaultAction = coercionAction;
        this._perTypeCoercions = mutableCoercionConfigArray;
        this._perClassCoercions = map;
    }

    private static MutableCoercionConfig _copy(MutableCoercionConfig mutableCoercionConfig) {
        if (mutableCoercionConfig == null) {
            return null;
        }
        return mutableCoercionConfig.copy();
    }

    public CoercionConfigs copy() {
        Object object;
        MutableCoercionConfig[] mutableCoercionConfigArray = this._perTypeCoercions;
        if (this._perTypeCoercions == null) {
            mutableCoercionConfigArray = null;
        } else {
            int n2 = mutableCoercionConfigArray.length;
            object = new MutableCoercionConfig[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                object[i2] = CoercionConfigs._copy(this._perTypeCoercions[i2]);
            }
            mutableCoercionConfigArray = object;
        }
        if (this._perClassCoercions == null) {
            object = null;
        } else {
            HashMap hashMap;
            object = hashMap;
            hashMap = new HashMap();
            for (Map.Entry<Class<?>, MutableCoercionConfig> entry : this._perClassCoercions.entrySet()) {
                ((HashMap)object).put(entry.getKey(), entry.getValue().copy());
            }
        }
        return new CoercionConfigs(this._defaultAction, this._defaultCoercions.copy(), mutableCoercionConfigArray, (Map<Class<?>, MutableCoercionConfig>)object);
    }

    public MutableCoercionConfig defaultCoercions() {
        return this._defaultCoercions;
    }

    public MutableCoercionConfig findOrCreateCoercion(LogicalType logicalType) {
        MutableCoercionConfig mutableCoercionConfig;
        if (this._perTypeCoercions == null) {
            this._perTypeCoercions = new MutableCoercionConfig[TARGET_TYPE_COUNT];
        }
        if ((mutableCoercionConfig = this._perTypeCoercions[logicalType.ordinal()]) == null) {
            MutableCoercionConfig mutableCoercionConfig2;
            mutableCoercionConfig = mutableCoercionConfig2;
            this._perTypeCoercions[logicalType.ordinal()] = new MutableCoercionConfig();
        }
        return mutableCoercionConfig;
    }

    public MutableCoercionConfig findOrCreateCoercion(Class<?> clazz) {
        Serializable serializable;
        if (this._perClassCoercions == null) {
            HashMap hashMap;
            serializable = hashMap;
            hashMap = new HashMap();
            this._perClassCoercions = serializable;
        }
        if ((serializable = this._perClassCoercions.get(clazz)) == null) {
            MutableCoercionConfig mutableCoercionConfig;
            serializable = mutableCoercionConfig;
            mutableCoercionConfig = new MutableCoercionConfig();
            this._perClassCoercions.put(clazz, (MutableCoercionConfig)serializable);
        }
        return serializable;
    }

    public CoercionAction findCoercion(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> object, CoercionInputShape coercionInputShape) {
        Map<Class<?>, MutableCoercionConfig> map = this._perClassCoercions;
        if (map != null && object != null && (object = map.get(object)) != null && (object = object.findAction(coercionInputShape)) != null) {
            return object;
        }
        object = this._perTypeCoercions;
        if (this._perTypeCoercions != null && logicalType != null && (object = object[logicalType.ordinal()]) != null && (object = object.findAction(coercionInputShape)) != null) {
            return object;
        }
        object = this._defaultCoercions.findAction(coercionInputShape);
        if (object != null) {
            return object;
        }
        int n2 = a.a[coercionInputShape.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3 && logicalType == LogicalType.Enum && deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                    return CoercionAction.Fail;
                }
            } else if (logicalType == LogicalType.Integer) {
                return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT) ? CoercionAction.TryConvert : CoercionAction.Fail;
            }
            boolean bl = this._isScalarType(logicalType);
            n2 = bl ? 1 : 0;
            if (bl && !deserializationConfig.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS) && (logicalType != LogicalType.Float || coercionInputShape != CoercionInputShape.Integer)) {
                return CoercionAction.Fail;
            }
            if (coercionInputShape == CoercionInputShape.EmptyString) {
                if (n2 == 0 && !deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                    if (logicalType == LogicalType.OtherScalar) {
                        return CoercionAction.TryConvert;
                    }
                    return CoercionAction.Fail;
                }
                return CoercionAction.AsNull;
            }
            return this._defaultAction;
        }
        return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT) ? CoercionAction.AsNull : CoercionAction.Fail;
    }

    public CoercionAction findCoercionFromBlankString(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> object, CoercionAction coercionAction) {
        Boolean bl = null;
        CoercionAction coercionAction2 = null;
        Map<Class<?>, MutableCoercionConfig> map = this._perClassCoercions;
        if (map != null && object != null && (object = map.get(object)) != null) {
            Object object2 = object;
            bl = ((CoercionConfig)object2).getAcceptBlankAsEmpty();
            coercionAction2 = ((CoercionConfig)object2).findAction(CoercionInputShape.EmptyString);
        }
        object = this._perTypeCoercions;
        if (this._perTypeCoercions != null && logicalType != null && (object = object[logicalType.ordinal()]) != null) {
            if (bl == null) {
                bl = ((CoercionConfig)object).getAcceptBlankAsEmpty();
            }
            if (coercionAction2 == null) {
                coercionAction2 = ((CoercionConfig)object).findAction(CoercionInputShape.EmptyString);
            }
        }
        if (bl == null) {
            bl = this._defaultCoercions.getAcceptBlankAsEmpty();
        }
        if (coercionAction2 == null) {
            coercionAction2 = this._defaultCoercions.findAction(CoercionInputShape.EmptyString);
        }
        if (Boolean.FALSE.equals(bl)) {
            return coercionAction;
        }
        if (coercionAction2 != null) {
            return coercionAction2;
        }
        if (this._isScalarType(logicalType)) {
            return CoercionAction.AsNull;
        }
        if (deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return CoercionAction.AsNull;
        }
        return coercionAction;
    }

    public boolean _isScalarType(LogicalType logicalType) {
        return logicalType == LogicalType.Float || logicalType == LogicalType.Integer || logicalType == LogicalType.Boolean || logicalType == LogicalType.DateTime;
    }
}

