/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextAttributes {
    public static ContextAttributes getEmpty() {
        return Impl.getEmpty();
    }

    public abstract ContextAttributes withSharedAttribute(Object var1, Object var2);

    public abstract ContextAttributes withSharedAttributes(Map<?, ?> var1);

    public abstract ContextAttributes withoutSharedAttribute(Object var1);

    public abstract Object getAttribute(Object var1);

    public abstract ContextAttributes withPerCallAttribute(Object var1, Object var2);

    public static class Impl
    extends ContextAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Impl EMPTY = new Impl(Collections.emptyMap());
        protected static final Object NULL_SURROGATE = new Object();
        protected final Map<?, ?> _shared;
        protected transient Map<Object, Object> _nonShared;

        public Impl(Map<?, ?> map) {
            this._shared = map;
            this._nonShared = null;
        }

        public Impl(Map<?, ?> map, Map<Object, Object> map2) {
            this._shared = map;
            this._nonShared = map2;
        }

        public static ContextAttributes getEmpty() {
            return EMPTY;
        }

        private Map<Object, Object> _copy(Map<?, ?> map) {
            return new HashMap<Object, Object>(map);
        }

        @Override
        public ContextAttributes withSharedAttribute(Object object, Object object2) {
            Object object3;
            if (object3 == EMPTY) {
                HashMap hashMap;
                object3 = hashMap;
                hashMap = new HashMap(8);
            } else {
                Impl impl = object3;
                object3 = impl._copy(impl._shared);
            }
            object3.put(object, object2);
            return new Impl((Map<?, ?>)object3);
        }

        @Override
        public ContextAttributes withSharedAttributes(Map<?, ?> map) {
            return new Impl(map);
        }

        @Override
        public ContextAttributes withoutSharedAttribute(Object object) {
            if (((Impl)((Object)map))._shared.isEmpty()) {
                return map;
            }
            if (((Impl)((Object)map))._shared.containsKey(object)) {
                if (((Impl)((Object)map))._shared.size() == 1) {
                    return EMPTY;
                }
                Impl impl = map;
                Map<Object, Object> map = impl._copy(impl._shared);
                map.remove(object);
                return new Impl(map);
            }
            return map;
        }

        @Override
        public Object getAttribute(Object object) {
            Map<Object, Object> map = this._nonShared;
            if (map != null && (map = map.get(object)) != null) {
                if (map == NULL_SURROGATE) {
                    return null;
                }
                return map;
            }
            return this._shared.get(object);
        }

        @Override
        public ContextAttributes withPerCallAttribute(Object object, Object map) {
            Map<Object, Object> map2;
            if (map == null) {
                if (this._shared.containsKey(object)) {
                    map = NULL_SURROGATE;
                } else {
                    map = this._nonShared;
                    if (map != null && map.containsKey(object)) {
                        Impl impl = this;
                        impl._nonShared.remove(object);
                        return impl;
                    }
                    return this;
                }
            }
            if ((map2 = this._nonShared) == null) {
                return this.nonSharedInstance(object, map);
            }
            map2.put(object, map);
            return this;
        }

        public ContextAttributes nonSharedInstance(Object object, Object object2) {
            HashMap<Object, Object> hashMap;
            HashMap<Object, Object> hashMap2 = hashMap;
            hashMap = new HashMap<Object, Object>();
            if (object2 == null) {
                object2 = NULL_SURROGATE;
            }
            hashMap2.put(object, object2);
            return new Impl(this._shared, hashMap2);
        }
    }
}

