/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.core.util.VersionUtil;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.c;
import java.io.Serializable;

public class DatatypeFeatures
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int FEATURE_INDEX_ENUM = 0;
    protected static final int FEATURE_INDEX_JSON_NODE = 1;
    private final int _enabledFor1;
    private final int _enabledFor2;
    private final int _explicitFor1;
    private final int _explicitFor2;

    public DatatypeFeatures(int n2, int n3, int n4, int n5) {
        this._enabledFor1 = n2;
        this._explicitFor1 = n3;
        this._enabledFor2 = n4;
        this._explicitFor2 = n5;
    }

    public static DatatypeFeatures defaultFeatures() {
        return c.a;
    }

    private DatatypeFeatures _with(int n2, int n3, int n4, int n5) {
        if (this._enabledFor1 == n2 && this._explicitFor1 == n3 && this._enabledFor2 == n4 && this._explicitFor2 == n5) {
            return this;
        }
        return new DatatypeFeatures(n2, n3, n4, n5);
    }

    private static final int _calcMask(DatatypeFeature ... datatypeFeatureArray) {
        int n2 = 0;
        int n3 = datatypeFeatureArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 |= datatypeFeatureArray[i2].getMask();
        }
        return n2;
    }

    public DatatypeFeatures with(DatatypeFeature datatypeFeature) {
        DatatypeFeature datatypeFeature2 = datatypeFeature;
        int n2 = datatypeFeature2.getMask();
        int n3 = datatypeFeature2.featureIndex();
        if (n3 != 0) {
            if (n3 != 1) {
                VersionUtil.throwInternal();
                return this;
            }
            DatatypeFeatures datatypeFeatures = this;
            n3 = datatypeFeatures._enabledFor1;
            int n4 = datatypeFeatures._explicitFor1;
            DatatypeFeatures datatypeFeatures2 = this;
            int n5 = datatypeFeatures2._enabledFor2 | n2;
            n2 = datatypeFeatures2._explicitFor2 | n2;
            return datatypeFeatures._with(n3, n4, n5, n2);
        }
        DatatypeFeatures datatypeFeatures = this;
        int n6 = datatypeFeatures._enabledFor1 | n2;
        n2 = datatypeFeatures._explicitFor1 | n2;
        n3 = datatypeFeatures._enabledFor2;
        int n7 = datatypeFeatures._explicitFor2;
        return datatypeFeatures._with(n6, n2, n3, n7);
    }

    public DatatypeFeatures withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        int n2 = DatatypeFeatures._calcMask(datatypeFeatureArray);
        if (n2 == 0) {
            return this;
        }
        int n3 = datatypeFeatureArray[0].featureIndex();
        if (n3 != 0) {
            if (n3 != 1) {
                VersionUtil.throwInternal();
                return this;
            }
            DatatypeFeatures datatypeFeatures = this;
            n3 = datatypeFeatures._enabledFor1;
            int n4 = datatypeFeatures._explicitFor1;
            int n5 = n3;
            DatatypeFeatures datatypeFeatures2 = this;
            int n6 = datatypeFeatures2._enabledFor2 | n2;
            n3 = datatypeFeatures2._explicitFor2 | n2;
            return datatypeFeatures._with(n5, n4, n6, n3);
        }
        DatatypeFeatures datatypeFeatures = this;
        int n7 = datatypeFeatures._enabledFor1 | n2;
        n3 = datatypeFeatures._explicitFor1 | n2;
        n2 = datatypeFeatures._enabledFor2;
        int n8 = datatypeFeatures._explicitFor2;
        return datatypeFeatures._with(n7, n3, n2, n8);
    }

    public DatatypeFeatures without(DatatypeFeature datatypeFeature) {
        DatatypeFeature datatypeFeature2 = datatypeFeature;
        int n2 = datatypeFeature2.getMask();
        int n3 = datatypeFeature2.featureIndex();
        if (n3 != 0) {
            if (n3 != 1) {
                VersionUtil.throwInternal();
                return this;
            }
            DatatypeFeatures datatypeFeatures = this;
            n3 = datatypeFeatures._enabledFor1;
            int n4 = datatypeFeatures._explicitFor1;
            DatatypeFeatures datatypeFeatures2 = this;
            int n5 = datatypeFeatures2._enabledFor2 & ~n2;
            n2 = datatypeFeatures2._explicitFor2 | n2;
            return datatypeFeatures._with(n3, n4, n5, n2);
        }
        DatatypeFeatures datatypeFeatures = this;
        int n6 = datatypeFeatures._enabledFor1 & ~n2;
        n2 = datatypeFeatures._explicitFor1 | n2;
        n3 = datatypeFeatures._enabledFor2;
        int n7 = datatypeFeatures._explicitFor2;
        return datatypeFeatures._with(n6, n2, n3, n7);
    }

    public DatatypeFeatures withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        int n2 = DatatypeFeatures._calcMask(datatypeFeatureArray);
        if (n2 == 0) {
            return this;
        }
        int n3 = datatypeFeatureArray[0].featureIndex();
        if (n3 != 0) {
            if (n3 != 1) {
                VersionUtil.throwInternal();
                return this;
            }
            DatatypeFeatures datatypeFeatures = this;
            n3 = datatypeFeatures._enabledFor1;
            int n4 = datatypeFeatures._explicitFor1;
            int n5 = n3;
            DatatypeFeatures datatypeFeatures2 = this;
            int n6 = datatypeFeatures2._enabledFor2 & ~n2;
            n3 = datatypeFeatures2._explicitFor2 | n2;
            return datatypeFeatures._with(n5, n4, n6, n3);
        }
        DatatypeFeatures datatypeFeatures = this;
        int n7 = datatypeFeatures._enabledFor1 & ~n2;
        n3 = datatypeFeatures._explicitFor1 | n2;
        n2 = datatypeFeatures._enabledFor2;
        int n8 = datatypeFeatures._explicitFor2;
        return datatypeFeatures._with(n7, n3, n2, n8);
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        int n2 = datatypeFeature.featureIndex();
        if (n2 != 0) {
            if (n2 != 1) {
                VersionUtil.throwInternal();
                return false;
            }
            return datatypeFeature.enabledIn(this._enabledFor2);
        }
        return datatypeFeature.enabledIn(this._enabledFor1);
    }

    public boolean isExplicitlySet(DatatypeFeature datatypeFeature) {
        int n2 = datatypeFeature.featureIndex();
        if (n2 != 0) {
            if (n2 != 1) {
                VersionUtil.throwInternal();
                return false;
            }
            return datatypeFeature.enabledIn(this._explicitFor2);
        }
        return datatypeFeature.enabledIn(this._explicitFor1);
    }

    public Boolean getExplicitState(DatatypeFeature datatypeFeature) {
        int n2 = datatypeFeature.featureIndex();
        if (n2 != 0) {
            if (n2 != 1) {
                VersionUtil.throwInternal();
                return null;
            }
            if (datatypeFeature.enabledIn(this._explicitFor2)) {
                return datatypeFeature.enabledIn(this._enabledFor2);
            }
            return null;
        }
        if (datatypeFeature.enabledIn(this._explicitFor1)) {
            return datatypeFeature.enabledIn(this._enabledFor1);
        }
        return null;
    }
}

