/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.databind.AbstractTypeResolver;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.privatefasterxml.jackson.databind.deser.Deserializers;
import com.privatefasterxml.jackson.databind.deser.KeyDeserializers;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiators;
import com.privatefasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.privatefasterxml.jackson.databind.util.ArrayBuilders;
import com.privatefasterxml.jackson.databind.util.ArrayIterator;
import java.io.Serializable;

public class DeserializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Deserializers[] NO_DESERIALIZERS;
    protected static final BeanDeserializerModifier[] NO_MODIFIERS;
    protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS;
    protected static final ValueInstantiators[] NO_VALUE_INSTANTIATORS;
    protected static final KeyDeserializers[] DEFAULT_KEY_DESERIALIZERS;
    protected final Deserializers[] _additionalDeserializers;
    protected final KeyDeserializers[] _additionalKeyDeserializers;
    protected final BeanDeserializerModifier[] _modifiers;
    protected final AbstractTypeResolver[] _abstractTypeResolvers;
    protected final ValueInstantiators[] _valueInstantiators;

    public DeserializerFactoryConfig() {
        this(null, null, null, null, null);
    }

    public DeserializerFactoryConfig(Deserializers[] deserializersArray, KeyDeserializers[] keyDeserializersArray, BeanDeserializerModifier[] beanDeserializerModifierArray, AbstractTypeResolver[] abstractTypeResolverArray, ValueInstantiators[] valueInstantiatorsArray) {
        if (deserializersArray == null) {
            deserializersArray = NO_DESERIALIZERS;
        }
        this._additionalDeserializers = deserializersArray;
        if (keyDeserializersArray == null) {
            keyDeserializersArray = DEFAULT_KEY_DESERIALIZERS;
        }
        this._additionalKeyDeserializers = keyDeserializersArray;
        if (beanDeserializerModifierArray == null) {
            beanDeserializerModifierArray = NO_MODIFIERS;
        }
        this._modifiers = beanDeserializerModifierArray;
        if (abstractTypeResolverArray == null) {
            abstractTypeResolverArray = NO_ABSTRACT_TYPE_RESOLVERS;
        }
        this._abstractTypeResolvers = abstractTypeResolverArray;
        if (valueInstantiatorsArray == null) {
            valueInstantiatorsArray = NO_VALUE_INSTANTIATORS;
        }
        this._valueInstantiators = valueInstantiatorsArray;
    }

    static {
        StdKeyDeserializers stdKeyDeserializers;
        NO_DESERIALIZERS = new Deserializers[0];
        NO_MODIFIERS = new BeanDeserializerModifier[0];
        NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
        NO_VALUE_INSTANTIATORS = new ValueInstantiators[0];
        KeyDeserializers[] keyDeserializersArray = new KeyDeserializers[1];
        StdKeyDeserializers stdKeyDeserializers2 = stdKeyDeserializers;
        stdKeyDeserializers = new StdKeyDeserializers();
        keyDeserializersArray[0] = stdKeyDeserializers2;
        DEFAULT_KEY_DESERIALIZERS = keyDeserializersArray;
    }

    public DeserializerFactoryConfig withAdditionalDeserializers(Deserializers objectArray) {
        if (objectArray != null) {
            objectArray = ArrayBuilders.insertInListNoDup(keyDeserializersArray2._additionalDeserializers, objectArray);
            Deserializers[] deserializersArray = objectArray;
            KeyDeserializers[] keyDeserializersArray = keyDeserializersArray2;
            KeyDeserializers[] keyDeserializersArray2 = keyDeserializersArray2._additionalKeyDeserializers;
            objectArray = keyDeserializersArray._modifiers;
            AbstractTypeResolver[] abstractTypeResolverArray = keyDeserializersArray2._abstractTypeResolvers;
            ValueInstantiators[] valueInstantiatorsArray = keyDeserializersArray._valueInstantiators;
            return new DeserializerFactoryConfig(deserializersArray, keyDeserializersArray2, (BeanDeserializerModifier[])objectArray, abstractTypeResolverArray, valueInstantiatorsArray);
        }
        throw new IllegalArgumentException("Cannot pass null Deserializers");
    }

    public DeserializerFactoryConfig withAdditionalKeyDeserializers(KeyDeserializers keyDeserializersArray) {
        if (keyDeserializersArray != null) {
            keyDeserializersArray = ArrayBuilders.insertInListNoDup(deserializersArray2._additionalKeyDeserializers, keyDeserializersArray);
            Deserializers[] deserializersArray = deserializersArray2;
            Deserializers[] deserializersArray2 = deserializersArray2._additionalDeserializers;
            BeanDeserializerModifier[] beanDeserializerModifierArray = deserializersArray._modifiers;
            AbstractTypeResolver[] abstractTypeResolverArray = deserializersArray2._abstractTypeResolvers;
            ValueInstantiators[] valueInstantiatorsArray = deserializersArray._valueInstantiators;
            return new DeserializerFactoryConfig(deserializersArray2, keyDeserializersArray, beanDeserializerModifierArray, abstractTypeResolverArray, valueInstantiatorsArray);
        }
        throw new IllegalArgumentException("Cannot pass null KeyDeserializers");
    }

    public DeserializerFactoryConfig withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifierArray) {
        if (beanDeserializerModifierArray != null) {
            beanDeserializerModifierArray = ArrayBuilders.insertInListNoDup(deserializersArray2._modifiers, beanDeserializerModifierArray);
            Deserializers[] deserializersArray = deserializersArray2;
            Deserializers[] deserializersArray2 = deserializersArray2._additionalDeserializers;
            KeyDeserializers[] keyDeserializersArray = deserializersArray._additionalKeyDeserializers;
            AbstractTypeResolver[] abstractTypeResolverArray = deserializersArray2._abstractTypeResolvers;
            ValueInstantiators[] valueInstantiatorsArray = deserializersArray._valueInstantiators;
            return new DeserializerFactoryConfig(deserializersArray2, keyDeserializersArray, beanDeserializerModifierArray, abstractTypeResolverArray, valueInstantiatorsArray);
        }
        throw new IllegalArgumentException("Cannot pass null modifier");
    }

    public DeserializerFactoryConfig withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolverArray) {
        if (abstractTypeResolverArray != null) {
            abstractTypeResolverArray = ArrayBuilders.insertInListNoDup(deserializersArray2._abstractTypeResolvers, abstractTypeResolverArray);
            Deserializers[] deserializersArray = deserializersArray2;
            Deserializers[] deserializersArray2 = deserializersArray2._additionalDeserializers;
            KeyDeserializers[] keyDeserializersArray = deserializersArray._additionalKeyDeserializers;
            BeanDeserializerModifier[] beanDeserializerModifierArray = deserializersArray2._modifiers;
            ValueInstantiators[] valueInstantiatorsArray = deserializersArray._valueInstantiators;
            return new DeserializerFactoryConfig(deserializersArray2, keyDeserializersArray, beanDeserializerModifierArray, abstractTypeResolverArray, valueInstantiatorsArray);
        }
        throw new IllegalArgumentException("Cannot pass null resolver");
    }

    public DeserializerFactoryConfig withValueInstantiators(ValueInstantiators valueInstantiatorsArray) {
        if (valueInstantiatorsArray != null) {
            valueInstantiatorsArray = ArrayBuilders.insertInListNoDup(deserializersArray2._valueInstantiators, valueInstantiatorsArray);
            Deserializers[] deserializersArray = deserializersArray2;
            Deserializers[] deserializersArray2 = deserializersArray2._additionalDeserializers;
            KeyDeserializers[] keyDeserializersArray = deserializersArray._additionalKeyDeserializers;
            BeanDeserializerModifier[] beanDeserializerModifierArray = deserializersArray2._modifiers;
            AbstractTypeResolver[] abstractTypeResolverArray = deserializersArray._abstractTypeResolvers;
            return new DeserializerFactoryConfig(deserializersArray2, keyDeserializersArray, beanDeserializerModifierArray, abstractTypeResolverArray, valueInstantiatorsArray);
        }
        throw new IllegalArgumentException("Cannot pass null resolver");
    }

    public boolean hasDeserializers() {
        return this._additionalDeserializers.length > 0;
    }

    public boolean hasKeyDeserializers() {
        return this._additionalKeyDeserializers.length > 0;
    }

    public boolean hasDeserializerModifiers() {
        return this._modifiers.length > 0;
    }

    public boolean hasAbstractTypeResolvers() {
        return this._abstractTypeResolvers.length > 0;
    }

    public boolean hasValueInstantiators() {
        return this._valueInstantiators.length > 0;
    }

    public Iterable<Deserializers> deserializers() {
        return new ArrayIterator<Deserializers>(this._additionalDeserializers);
    }

    public Iterable<KeyDeserializers> keyDeserializers() {
        return new ArrayIterator<KeyDeserializers>(this._additionalKeyDeserializers);
    }

    public Iterable<BeanDeserializerModifier> deserializerModifiers() {
        return new ArrayIterator<BeanDeserializerModifier>(this._modifiers);
    }

    public Iterable<AbstractTypeResolver> abstractTypeResolvers() {
        return new ArrayIterator<AbstractTypeResolver>(this._abstractTypeResolvers);
    }

    public Iterable<ValueInstantiators> valueInstantiators() {
        return new ArrayIterator<ValueInstantiators>(this._valueInstantiators);
    }
}

