/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.annotation.JsonAutoDetect;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.annotation.JsonSetter;
import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.annotation.PropertyAccessor;
import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.StreamWriteFeature;
import com.privatefasterxml.jackson.core.TokenStreamFactory;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.InjectableValues;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.Module;
import com.privatefasterxml.jackson.databind.ObjectMapper;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.cfg.ConstructorDetector;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.privatefasterxml.jackson.databind.cfg.MutableConfigOverride;
import com.privatefasterxml.jackson.databind.cfg.d;
import com.privatefasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.ser.FilterProvider;
import com.privatefasterxml.jackson.databind.ser.SerializerFactory;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.function.Consumer;

public abstract class MapperBuilder<M extends ObjectMapper, B extends MapperBuilder<M, B>> {
    protected final M _mapper;

    public MapperBuilder(M m2) {
        this._mapper = m2;
    }

    public static List<Module> findModules() {
        return MapperBuilder.findModules(null);
    }

    public static List<Module> findModules(ClassLoader object) {
        ArrayList<Module> arrayList;
        ArrayList<Module> arrayList2 = arrayList;
        arrayList = new ArrayList<Module>();
        object = MapperBuilder.secureGetServiceLoader(Module.class, (ClassLoader)object).iterator();
        while (object.hasNext()) {
            arrayList2.add((Module)object.next());
        }
        return arrayList2;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new d(clazz, classLoader));
    }

    public M build() {
        return this._mapper;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return ((ObjectMapper)this._mapper).isEnabled(mapperFeature);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return ((ObjectMapper)this._mapper).isEnabled(deserializationFeature);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return ((ObjectMapper)this._mapper).isEnabled(serializationFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return ((ObjectMapper)this._mapper).isEnabled(feature);
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return ((ObjectMapper)this._mapper).isEnabled(feature);
    }

    public TokenStreamFactory streamFactory() {
        return ((ObjectMapper)this._mapper).tokenStreamFactory();
    }

    public B enable(MapperFeature ... mapperFeatureArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).enable(mapperFeatureArray);
        return mapperBuilder._this();
    }

    public B disable(MapperFeature ... mapperFeatureArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).disable(mapperFeatureArray);
        return mapperBuilder._this();
    }

    public B configure(MapperFeature mapperFeature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(mapperFeature, bl);
        return mapperBuilder._this();
    }

    public B enable(SerializationFeature ... serializationFeatureArray) {
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            ((ObjectMapper)this._mapper).enable(serializationFeature);
        }
        return this._this();
    }

    public B disable(SerializationFeature ... serializationFeatureArray) {
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            ((ObjectMapper)this._mapper).disable(serializationFeature);
        }
        return this._this();
    }

    public B configure(SerializationFeature serializationFeature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(serializationFeature, bl);
        return mapperBuilder._this();
    }

    public B enable(DeserializationFeature ... deserializationFeatureArray) {
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            ((ObjectMapper)this._mapper).enable(deserializationFeature);
        }
        return this._this();
    }

    public B disable(DeserializationFeature ... deserializationFeatureArray) {
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            ((ObjectMapper)this._mapper).disable(deserializationFeature);
        }
        return this._this();
    }

    public B configure(DeserializationFeature deserializationFeature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(deserializationFeature, bl);
        return mapperBuilder._this();
    }

    public B enable(DatatypeFeature ... datatypeFeatureArray) {
        for (DatatypeFeature datatypeFeature : datatypeFeatureArray) {
            ((ObjectMapper)this._mapper).configure(datatypeFeature, true);
        }
        return this._this();
    }

    public B disable(DatatypeFeature ... datatypeFeatureArray) {
        for (DatatypeFeature datatypeFeature : datatypeFeatureArray) {
            ((ObjectMapper)this._mapper).configure(datatypeFeature, false);
        }
        return this._this();
    }

    public B configure(DatatypeFeature datatypeFeature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(datatypeFeature, bl);
        return mapperBuilder._this();
    }

    public B enable(JsonParser.Feature ... featureArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).enable(featureArray);
        return mapperBuilder._this();
    }

    public B disable(JsonParser.Feature ... featureArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).disable(featureArray);
        return mapperBuilder._this();
    }

    public B configure(JsonParser.Feature feature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(feature, bl);
        return mapperBuilder._this();
    }

    public B enable(JsonGenerator.Feature ... featureArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).enable(featureArray);
        return mapperBuilder._this();
    }

    public B disable(JsonGenerator.Feature ... featureArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).disable(featureArray);
        return mapperBuilder._this();
    }

    public B configure(JsonGenerator.Feature feature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(feature, bl);
        return mapperBuilder._this();
    }

    public B enable(StreamReadFeature ... streamReadFeatureArray) {
        for (StreamReadFeature streamReadFeature : streamReadFeatureArray) {
            ((ObjectMapper)this._mapper).enable(streamReadFeature.mappedFeature());
        }
        return this._this();
    }

    public B disable(StreamReadFeature ... streamReadFeatureArray) {
        for (StreamReadFeature streamReadFeature : streamReadFeatureArray) {
            ((ObjectMapper)this._mapper).disable(streamReadFeature.mappedFeature());
        }
        return this._this();
    }

    public B configure(StreamReadFeature streamReadFeature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(streamReadFeature.mappedFeature(), bl);
        return mapperBuilder._this();
    }

    public B enable(StreamWriteFeature ... streamWriteFeatureArray) {
        for (StreamWriteFeature streamWriteFeature : streamWriteFeatureArray) {
            ((ObjectMapper)this._mapper).enable(streamWriteFeature.mappedFeature());
        }
        return this._this();
    }

    public B disable(StreamWriteFeature ... streamWriteFeatureArray) {
        for (StreamWriteFeature streamWriteFeature : streamWriteFeatureArray) {
            ((ObjectMapper)this._mapper).disable(streamWriteFeature.mappedFeature());
        }
        return this._this();
    }

    public B configure(StreamWriteFeature streamWriteFeature, boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).configure(streamWriteFeature.mappedFeature(), bl);
        return mapperBuilder._this();
    }

    public B withConfigOverride(Class<?> clazz, Consumer<MutableConfigOverride> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).configOverride(clazz));
        return this._this();
    }

    public B withCoercionConfig(LogicalType logicalType, Consumer<MutableCoercionConfig> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).coercionConfigFor(logicalType));
        return this._this();
    }

    public B withCoercionConfig(Class<?> clazz, Consumer<MutableCoercionConfig> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).coercionConfigFor(clazz));
        return this._this();
    }

    public B withCoercionConfigDefaults(Consumer<MutableCoercionConfig> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).coercionConfigDefaults());
        return this._this();
    }

    public B addModule(Module module) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).registerModule(module);
        return mapperBuilder._this();
    }

    public B addModules(Module ... moduleArray) {
        int n2 = moduleArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addModule(moduleArray[i2]);
        }
        return this._this();
    }

    public B addModules(Iterable<? extends Module> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.addModule((Module)object.next());
        }
        return this._this();
    }

    public B findAndAddModules() {
        return this.addModules(MapperBuilder.findModules());
    }

    public B annotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setAnnotationIntrospector(annotationIntrospector);
        return mapperBuilder._this();
    }

    public B defaultAttributes(ContextAttributes contextAttributes) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultAttributes(contextAttributes);
        return mapperBuilder._this();
    }

    public B typeFactory(TypeFactory typeFactory) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setTypeFactory(typeFactory);
        return mapperBuilder._this();
    }

    public B subtypeResolver(SubtypeResolver subtypeResolver) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setSubtypeResolver(subtypeResolver);
        return mapperBuilder._this();
    }

    public B visibility(VisibilityChecker<?> visibilityChecker) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setVisibility(visibilityChecker);
        return mapperBuilder._this();
    }

    public B visibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setVisibility(propertyAccessor, visibility);
        return mapperBuilder._this();
    }

    public B handlerInstantiator(HandlerInstantiator handlerInstantiator) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setHandlerInstantiator(handlerInstantiator);
        return mapperBuilder._this();
    }

    public B propertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setPropertyNamingStrategy(propertyNamingStrategy);
        return mapperBuilder._this();
    }

    public B accessorNaming(AccessorNamingStrategy.Provider provider) {
        if (provider == null) {
            DefaultAccessorNamingStrategy.Provider provider2;
            provider = provider2;
            provider2 = new DefaultAccessorNamingStrategy.Provider();
        }
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setAccessorNaming(provider);
        return mapperBuilder._this();
    }

    public B serializerFactory(SerializerFactory serializerFactory) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setSerializerFactory(serializerFactory);
        return mapperBuilder._this();
    }

    public B filterProvider(FilterProvider filterProvider) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setFilterProvider(filterProvider);
        return mapperBuilder._this();
    }

    public B defaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultPrettyPrinter(prettyPrinter);
        return mapperBuilder._this();
    }

    public B injectableValues(InjectableValues injectableValues) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setInjectableValues(injectableValues);
        return mapperBuilder._this();
    }

    public B nodeFactory(JsonNodeFactory jsonNodeFactory) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setNodeFactory(jsonNodeFactory);
        return mapperBuilder._this();
    }

    public B constructorDetector(ConstructorDetector constructorDetector) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setConstructorDetector(constructorDetector);
        return mapperBuilder._this();
    }

    public B addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).addHandler(deserializationProblemHandler);
        return mapperBuilder._this();
    }

    public B clearProblemHandlers() {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).clearProblemHandlers();
        return mapperBuilder._this();
    }

    public B defaultSetterInfo(JsonSetter.Value value) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultSetterInfo(value);
        return mapperBuilder._this();
    }

    public B defaultMergeable(Boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultMergeable(bl);
        return mapperBuilder._this();
    }

    public B defaultLeniency(Boolean bl) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultLeniency(bl);
        return mapperBuilder._this();
    }

    public B defaultDateFormat(DateFormat dateFormat) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDateFormat(dateFormat);
        return mapperBuilder._this();
    }

    public B defaultTimeZone(TimeZone timeZone) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setTimeZone(timeZone);
        return mapperBuilder._this();
    }

    public B defaultLocale(Locale locale) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setLocale(locale);
        return mapperBuilder._this();
    }

    public B defaultBase64Variant(Base64Variant base64Variant) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setBase64Variant(base64Variant);
        return mapperBuilder._this();
    }

    public B serializationInclusion(JsonInclude.Include include) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setSerializationInclusion(include);
        return mapperBuilder._this();
    }

    public B defaultPropertyInclusion(JsonInclude.Value value) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultPropertyInclusion(value);
        return mapperBuilder._this();
    }

    public B addMixIn(Class<?> clazz, Class<?> clazz2) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).addMixIn(clazz, clazz2);
        return mapperBuilder._this();
    }

    public B removeMixIn(Class<?> clazz) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).addMixIn(clazz, null);
        return mapperBuilder._this();
    }

    public B registerSubtypes(Class<?> ... classArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).registerSubtypes(classArray);
        return mapperBuilder._this();
    }

    public B registerSubtypes(NamedType ... namedTypeArray) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).registerSubtypes(namedTypeArray);
        return mapperBuilder._this();
    }

    public B registerSubtypes(Collection<Class<?>> collection) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).registerSubtypes(collection);
        return mapperBuilder._this();
    }

    public B polymorphicTypeValidator(PolymorphicTypeValidator polymorphicTypeValidator) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setPolymorphicTypeValidator(polymorphicTypeValidator);
        return mapperBuilder._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).activateDefaultTyping(polymorphicTypeValidator);
        return mapperBuilder._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper.DefaultTyping defaultTyping) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).activateDefaultTyping(polymorphicTypeValidator, defaultTyping);
        return mapperBuilder._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper.DefaultTyping defaultTyping, JsonTypeInfo.As as) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).activateDefaultTyping(polymorphicTypeValidator, defaultTyping, as);
        return mapperBuilder._this();
    }

    public B activateDefaultTypingAsProperty(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper.DefaultTyping defaultTyping, String string) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).activateDefaultTypingAsProperty(polymorphicTypeValidator, defaultTyping, string);
        return mapperBuilder._this();
    }

    public B deactivateDefaultTyping() {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).deactivateDefaultTyping();
        return mapperBuilder._this();
    }

    public B setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        MapperBuilder mapperBuilder = this;
        ((ObjectMapper)mapperBuilder._mapper).setDefaultTyping(typeResolverBuilder);
        return mapperBuilder._this();
    }

    public final B _this() {
        return (B)this;
    }
}

