/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.annotation.JsonIncludeProperties;
import com.privatefasterxml.jackson.annotation.JsonSetter;
import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.core.type.TypeReference;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.cfg.BaseSettings;
import com.privatefasterxml.jackson.databind.cfg.ConfigFeature;
import com.privatefasterxml.jackson.databind.cfg.ConfigOverride;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.jsontype.DefaultBaseTypeLimitingValidator;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class MapperConfig<T extends MapperConfig<T>>
implements ClassIntrospector.MixInResolver,
Serializable {
    private static final long serialVersionUID = 2L;
    protected static final JsonInclude.Value EMPTY_INCLUDE = JsonInclude.Value.empty();
    protected static final JsonFormat.Value EMPTY_FORMAT = JsonFormat.Value.empty();
    protected final long _mapperFeatures;
    protected final BaseSettings _base;

    public MapperConfig(BaseSettings baseSettings, long l2) {
        this._base = baseSettings;
        this._mapperFeatures = l2;
    }

    public MapperConfig(MapperConfig<T> mapperConfig, long l2) {
        this._base = mapperConfig._base;
        this._mapperFeatures = l2;
    }

    public MapperConfig(MapperConfig<T> mapperConfig, BaseSettings baseSettings) {
        this._base = baseSettings;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    public MapperConfig(MapperConfig<T> mapperConfig) {
        this._base = mapperConfig._base;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> clazz) {
        int n2 = 0;
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n3 = enumArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            ConfigFeature configFeature = (ConfigFeature)((Object)enumArray[i2]);
            if (!configFeature.enabledByDefault()) continue;
            n2 |= configFeature.getMask();
        }
        return n2;
    }

    public abstract T with(MapperFeature ... var1);

    public abstract T without(MapperFeature ... var1);

    public abstract T with(MapperFeature var1, boolean var2);

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return mapperFeature.enabledIn(this._mapperFeatures);
    }

    @Deprecated
    public final boolean hasMapperFeatures(int n2) {
        long l2 = n2;
        return (this._mapperFeatures & l2) == l2;
    }

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public final boolean shouldSortPropertiesAlphabetically() {
        return this.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
    }

    public abstract boolean useRootWrapping();

    public SerializableString compileString(String string) {
        return new SerializedString(string);
    }

    public ClassIntrospector getClassIntrospector() {
        return this._base.getClassIntrospector();
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return this._base.getAnnotationIntrospector();
        }
        return NopAnnotationIntrospector.instance;
    }

    public final PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._base.getPropertyNamingStrategy();
    }

    public final AccessorNamingStrategy.Provider getAccessorNaming() {
        return this._base.getAccessorNaming();
    }

    public final HandlerInstantiator getHandlerInstantiator() {
        return this._base.getHandlerInstantiator();
    }

    public final TypeResolverBuilder<?> getDefaultTyper(JavaType javaType) {
        return this._base.getTypeResolverBuilder();
    }

    public abstract SubtypeResolver getSubtypeResolver();

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        PolymorphicTypeValidator polymorphicTypeValidator = this._base.getPolymorphicTypeValidator();
        if (polymorphicTypeValidator == LaissezFaireSubTypeValidator.instance && this.isEnabled(MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES)) {
            DefaultBaseTypeLimitingValidator defaultBaseTypeLimitingValidator;
            polymorphicTypeValidator = defaultBaseTypeLimitingValidator;
            defaultBaseTypeLimitingValidator = new DefaultBaseTypeLimitingValidator();
        }
        return polymorphicTypeValidator;
    }

    public final TypeFactory getTypeFactory() {
        return this._base.getTypeFactory();
    }

    public final JavaType constructType(Class<?> clazz) {
        return this.getTypeFactory().constructType(clazz);
    }

    public final JavaType constructType(TypeReference<?> typeReference) {
        return this.getTypeFactory().constructType(typeReference.getType());
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this.getTypeFactory().constructSpecializedType(javaType, clazz, true);
    }

    public BeanDescription introspectClassAnnotations(Class<?> clazz) {
        MapperConfig mapperConfig = this;
        return mapperConfig.introspectClassAnnotations(mapperConfig.constructType(clazz));
    }

    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    public BeanDescription introspectDirectClassAnnotations(Class<?> clazz) {
        MapperConfig mapperConfig = this;
        return mapperConfig.introspectDirectClassAnnotations(mapperConfig.constructType(clazz));
    }

    public final BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    public abstract ConfigOverride findConfigOverride(Class<?> var1);

    public abstract ConfigOverride getConfigOverride(Class<?> var1);

    public abstract JsonInclude.Value getDefaultPropertyInclusion();

    public abstract JsonInclude.Value getDefaultPropertyInclusion(Class<?> var1);

    /*
     * WARNING - void declaration
     */
    public JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz, JsonInclude.Value value) {
        void var2_3;
        void var1_2;
        JsonInclude.Value value2 = this.getConfigOverride((Class<?>)var1_2).getInclude();
        if (value2 != null) {
            return value2;
        }
        return var2_3;
    }

    public abstract JsonInclude.Value getDefaultInclusion(Class<?> var1, Class<?> var2);

    public JsonInclude.Value getDefaultInclusion(Class<?> serializable, Class<?> clazz, JsonInclude.Value value) {
        MapperConfig mapperConfig = serializable2;
        Serializable serializable2 = serializable2.getConfigOverride((Class<?>)serializable).getInclude();
        serializable = mapperConfig.getConfigOverride(clazz).getIncludeAsProperty();
        return JsonInclude.Value.mergeAll(new JsonInclude.Value[]{value, serializable2, serializable});
    }

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> var1);

    public abstract JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> var1, AnnotatedClass var2);

    public abstract JsonIncludeProperties.Value getDefaultPropertyInclusions(Class<?> var1, AnnotatedClass var2);

    public abstract VisibilityChecker<?> getDefaultVisibilityChecker();

    public abstract VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> var1, AnnotatedClass var2);

    public abstract JsonSetter.Value getDefaultSetterInfo();

    public abstract Boolean getDefaultMergeable();

    public abstract Boolean getDefaultMergeable(Class<?> var1);

    public final DateFormat getDateFormat() {
        return this._base.getDateFormat();
    }

    public final Locale getLocale() {
        return this._base.getLocale();
    }

    public final TimeZone getTimeZone() {
        return this._base.getTimeZone();
    }

    public boolean hasExplicitTimeZone() {
        return this._base.hasExplicitTimeZone();
    }

    public abstract Class<?> getActiveView();

    public Base64Variant getBase64Variant() {
        return this._base.getBase64Variant();
    }

    public abstract ContextAttributes getAttributes();

    public abstract PropertyName findRootName(JavaType var1);

    public abstract PropertyName findRootName(Class<?> var1);

    public TypeResolverBuilder<?> typeResolverBuilderInstance(Annotated object, Class<? extends TypeResolverBuilder<?>> clazz) {
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.typeResolverBuilderInstance(this, (Annotated)object, clazz)) != null) {
            return object;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }

    public TypeIdResolver typeIdResolverInstance(Annotated object, Class<? extends TypeIdResolver> clazz) {
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.typeIdResolverInstance(this, (Annotated)object, clazz)) != null) {
            return object;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }
}

