/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.annotation.JsonAutoDetect;
import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.annotation.JsonIncludeProperties;
import com.privatefasterxml.jackson.annotation.JsonSetter;
import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.cfg.BaseSettings;
import com.privatefasterxml.jackson.databind.cfg.ConfigFeature;
import com.privatefasterxml.jackson.databind.cfg.ConfigOverride;
import com.privatefasterxml.jackson.databind.cfg.ConfigOverrides;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.ClassIntrospector;
import com.privatefasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    protected static final ConfigOverride EMPTY_OVERRIDE = ConfigOverride.empty();
    private static final long DEFAULT_MAPPER_FEATURES = MapperFeature.collectLongDefaults();
    private static final long AUTO_DETECT_MASK = MapperFeature.AUTO_DETECT_FIELDS.getLongMask() | MapperFeature.AUTO_DETECT_GETTERS.getLongMask() | MapperFeature.AUTO_DETECT_IS_GETTERS.getLongMask() | MapperFeature.AUTO_DETECT_SETTERS.getLongMask() | MapperFeature.AUTO_DETECT_CREATORS.getLongMask();
    protected final SimpleMixInResolver _mixIns;
    protected final SubtypeResolver _subtypeResolver;
    protected final PropertyName _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;
    protected final RootNameLookup _rootNames;
    protected final ConfigOverrides _configOverrides;
    protected final DatatypeFeatures _datatypeFeatures;

    public MapperConfigBase(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, DatatypeFeatures datatypeFeatures) {
        MapperConfigBase mapperConfigBase = this;
        super(baseSettings, DEFAULT_MAPPER_FEATURES);
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = subtypeResolver;
        mapperConfigBase._rootNames = rootNameLookup;
        mapperConfigBase._rootName = null;
        mapperConfigBase._view = null;
        mapperConfigBase._attributes = ContextAttributes.getEmpty();
        this._configOverrides = configOverrides;
        this._datatypeFeatures = datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        MapperConfigBase<CFG, T> mapperConfigBase2 = mapperConfigBase;
        super(mapperConfigBase2, mapperConfigBase2._base.copy());
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = subtypeResolver;
        this._rootNames = rootNameLookup;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, BaseSettings baseSettings) {
        super(mapperConfigBase, baseSettings);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, long l2) {
        super(mapperConfigBase, l2);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, SubtypeResolver subtypeResolver) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, PropertyName propertyName) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = propertyName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, Class<?> clazz) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = clazz;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, SimpleMixInResolver simpleMixInResolver) {
        super(mapperConfigBase);
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, ContextAttributes contextAttributes) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = contextAttributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    public MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, DatatypeFeatures datatypeFeatures) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = datatypeFeatures;
    }

    public abstract T _withBase(BaseSettings var1);

    public abstract T _withMapperFeatures(long var1);

    public abstract T _with(DatatypeFeatures var1);

    public DatatypeFeatures _datatypeFeatures() {
        return this._datatypeFeatures;
    }

    @Override
    public final T with(MapperFeature ... mapperFeatureArray) {
        long l2 = this._mapperFeatures;
        int n2 = mapperFeatureArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 |= mapperFeatureArray[i2].getLongMask();
        }
        if (l2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(l2);
    }

    @Override
    public final T without(MapperFeature ... mapperFeatureArray) {
        long l2 = this._mapperFeatures;
        int n2 = mapperFeatureArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 &= mapperFeatureArray[i2].getLongMask() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(l2);
    }

    @Override
    public final T with(MapperFeature mapperFeature, boolean bl) {
        long l2 = bl ? this._mapperFeatures | mapperFeature.getLongMask() : this._mapperFeatures & (mapperFeature.getLongMask() ^ 0xFFFFFFFFFFFFFFFFL);
        if (l2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(l2);
    }

    public final T with(DatatypeFeature datatypeFeature) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._with(mapperConfigBase._datatypeFeatures().with(datatypeFeature));
    }

    public final T withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._with(mapperConfigBase._datatypeFeatures().withFeatures(datatypeFeatureArray));
    }

    public final T without(DatatypeFeature datatypeFeature) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._with(mapperConfigBase._datatypeFeatures().without(datatypeFeature));
    }

    public final T withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._with(mapperConfigBase._datatypeFeatures().withoutFeatures(datatypeFeatureArray));
    }

    public final T with(DatatypeFeature object, boolean bl) {
        DatatypeFeatures datatypeFeatures = this._datatypeFeatures();
        object = bl ? datatypeFeatures.with((DatatypeFeature)object) : datatypeFeatures.without((DatatypeFeature)object);
        return this._with((DatatypeFeatures)object);
    }

    public final T with(AnnotationIntrospector annotationIntrospector) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withAnnotationIntrospector(annotationIntrospector));
    }

    public final T withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withAppendedAnnotationIntrospector(annotationIntrospector));
    }

    public final T withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withInsertedAnnotationIntrospector(annotationIntrospector));
    }

    public final T with(ClassIntrospector classIntrospector) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withClassIntrospector(classIntrospector));
    }

    public abstract T with(ContextAttributes var1);

    public T withAttributes(Map<?, ?> map) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase.with(mapperConfigBase.getAttributes().withSharedAttributes(map));
    }

    public T withAttribute(Object object, Object object2) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase.with(mapperConfigBase.getAttributes().withSharedAttribute(object, object2));
    }

    public T withoutAttribute(Object object) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase.with(mapperConfigBase.getAttributes().withoutSharedAttribute(object));
    }

    public final T with(TypeFactory typeFactory) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withTypeFactory(typeFactory));
    }

    public final T with(TypeResolverBuilder<?> typeResolverBuilder) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withTypeResolverBuilder(typeResolverBuilder));
    }

    public final T with(PropertyNamingStrategy propertyNamingStrategy) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    public final T with(AccessorNamingStrategy.Provider provider) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withAccessorNaming(provider));
    }

    public final T with(HandlerInstantiator handlerInstantiator) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withHandlerInstantiator(handlerInstantiator));
    }

    public final T with(Base64Variant base64Variant) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.with(base64Variant));
    }

    public T with(DateFormat dateFormat) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.withDateFormat(dateFormat));
    }

    public final T with(Locale locale) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.with(locale));
    }

    public final T with(TimeZone timeZone) {
        MapperConfigBase mapperConfigBase = this;
        return mapperConfigBase._withBase(mapperConfigBase._base.with(timeZone));
    }

    public abstract T withRootName(PropertyName var1);

    public T withRootName(String string) {
        if (string == null) {
            return this.withRootName((PropertyName)null);
        }
        return this.withRootName(PropertyName.construct(string));
    }

    public abstract T with(SubtypeResolver var1);

    public abstract T withView(Class<?> var1);

    @Override
    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    @Deprecated
    public final String getRootName() {
        Serializable serializable = ((MapperConfigBase)serializable)._rootName;
        return serializable == null ? null : ((PropertyName)serializable).getSimpleName();
    }

    public final PropertyName getFullRootName() {
        return this._rootName;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final ConfigOverride getConfigOverride(Class<?> clazz) {
        Object object = ((MapperConfigBase)object)._configOverrides.findOverride(clazz);
        if (object == null) {
            object = EMPTY_OVERRIDE;
        }
        return object;
    }

    @Override
    public final ConfigOverride findConfigOverride(Class<?> clazz) {
        return this._configOverrides.findOverride(clazz);
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion() {
        return this._configOverrides.getDefaultInclusion();
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> serializable) {
        MapperConfigBase mapperConfigBase = serializable2;
        Serializable serializable2 = mapperConfigBase.getConfigOverride((Class<?>)serializable).getInclude();
        serializable = mapperConfigBase.getDefaultPropertyInclusion();
        if (serializable == null) {
            return serializable2;
        }
        return ((JsonInclude.Value)serializable).withOverrides((JsonInclude.Value)serializable2);
    }

    @Override
    public final JsonInclude.Value getDefaultInclusion(Class<?> serializable, Class<?> clazz) {
        MapperConfigBase mapperConfigBase = serializable2;
        Serializable serializable2 = serializable2.getConfigOverride(clazz).getIncludeAsProperty();
        if ((serializable = mapperConfigBase.getDefaultPropertyInclusion((Class<?>)serializable)) == null) {
            return serializable2;
        }
        return ((JsonInclude.Value)serializable).withOverrides((JsonInclude.Value)serializable2);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._configOverrides.findFormatDefaults(clazz);
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> clazz) {
        Object object = ((MapperConfigBase)object)._configOverrides.findOverride(clazz);
        if (object != null && (object = ((ConfigOverride)object).getIgnorals()) != null) {
            return object;
        }
        return null;
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> clazz, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = this.getAnnotationIntrospector();
        return JsonIgnoreProperties.Value.merge(annotationIntrospector == null ? null : annotationIntrospector.findPropertyIgnoralByName(this, annotatedClass), this.getDefaultPropertyIgnorals(clazz));
    }

    @Override
    public final JsonIncludeProperties.Value getDefaultPropertyInclusions(Class<?> serializable, AnnotatedClass annotatedClass) {
        serializable = this.getAnnotationIntrospector();
        return serializable == null ? null : ((AnnotationIntrospector)serializable).findPropertyInclusionByName(this, annotatedClass);
    }

    @Override
    public final VisibilityChecker<?> getDefaultVisibilityChecker() {
        MapperConfigBase mapperConfigBase = this;
        VisibilityChecker<?> visibilityChecker = mapperConfigBase._configOverrides.getDefaultVisibility();
        long l2 = AUTO_DETECT_MASK;
        if ((mapperConfigBase._mapperFeatures & l2) != l2) {
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
                visibilityChecker = visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_GETTERS)) {
                visibilityChecker = visibilityChecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_IS_GETTERS)) {
                visibilityChecker = visibilityChecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_SETTERS)) {
                visibilityChecker = visibilityChecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_CREATORS)) {
                visibilityChecker = visibilityChecker.withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
            }
        }
        return visibilityChecker;
    }

    @Override
    public final VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> clazz, AnnotatedClass annotatedClass) {
        VisibilityChecker<VisibilityChecker.Std> visibilityChecker = ClassUtil.isJDKClass(clazz) ? VisibilityChecker.Std.allPublicInstance() : ((MapperConfigBase)this).getDefaultVisibilityChecker();
        AnnotationIntrospector annotationIntrospector = ((MapperConfig)this).getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            visibilityChecker = annotationIntrospector.findAutoDetectVisibility(annotatedClass, visibilityChecker);
        }
        if ((this = ((MapperConfigBase)this)._configOverrides.findOverride(clazz)) != null) {
            visibilityChecker = visibilityChecker.withOverrides(((ConfigOverride)this).getVisibility());
        }
        return visibilityChecker;
    }

    @Override
    public final JsonSetter.Value getDefaultSetterInfo() {
        return this._configOverrides.getDefaultSetterInfo();
    }

    @Override
    public Boolean getDefaultMergeable() {
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public Boolean getDefaultMergeable(Class<?> object) {
        if ((object = this._configOverrides.findOverride((Class<?>)object)) != null && (object = ((ConfigOverride)object).getMergeable()) != null) {
            return object;
        }
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public PropertyName findRootName(JavaType javaType) {
        PropertyName propertyName = this._rootName;
        if (propertyName != null) {
            return propertyName;
        }
        return this._rootNames.findRootName(javaType, this);
    }

    @Override
    public PropertyName findRootName(Class<?> clazz) {
        PropertyName propertyName = this._rootName;
        if (propertyName != null) {
            return propertyName;
        }
        return this._rootNames.findRootName(clazz, this);
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixIns.findMixInClassFor(clazz);
    }

    @Override
    public ClassIntrospector.MixInResolver copy() {
        throw new UnsupportedOperationException();
    }

    public final int mixInCount() {
        return this._mixIns.localSize();
    }
}

