/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.cfg;

import com.privatefasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.privatefasterxml.jackson.databind.ser.Serializers;
import com.privatefasterxml.jackson.databind.util.ArrayBuilders;
import com.privatefasterxml.jackson.databind.util.ArrayIterator;
import java.io.Serializable;

public final class SerializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
    protected static final BeanSerializerModifier[] NO_MODIFIERS = new BeanSerializerModifier[0];
    protected final Serializers[] _additionalSerializers;
    protected final Serializers[] _additionalKeySerializers;
    protected final BeanSerializerModifier[] _modifiers;

    public SerializerFactoryConfig() {
        this(null, null, null);
    }

    public SerializerFactoryConfig(Serializers[] serializersArray, Serializers[] serializersArray2, BeanSerializerModifier[] beanSerializerModifierArray) {
        if (serializersArray == null) {
            serializersArray = NO_SERIALIZERS;
        }
        this._additionalSerializers = serializersArray;
        if (serializersArray2 == null) {
            serializersArray2 = NO_SERIALIZERS;
        }
        this._additionalKeySerializers = serializersArray2;
        if (beanSerializerModifierArray == null) {
            beanSerializerModifierArray = NO_MODIFIERS;
        }
        this._modifiers = beanSerializerModifierArray;
    }

    public SerializerFactoryConfig withAdditionalSerializers(Serializers serializersArray) {
        if (serializersArray != null) {
            serializersArray = ArrayBuilders.insertInListNoDup(serializersArray2._additionalSerializers, serializersArray);
            Serializers[] serializersArray2 = serializersArray2._additionalKeySerializers;
            return new SerializerFactoryConfig(serializersArray, serializersArray2, serializersArray2._modifiers);
        }
        throw new IllegalArgumentException("Cannot pass null Serializers");
    }

    public SerializerFactoryConfig withAdditionalKeySerializers(Serializers serializersArray) {
        if (serializersArray != null) {
            serializersArray = ArrayBuilders.insertInListNoDup(serializersArray2._additionalKeySerializers, serializersArray);
            Serializers[] serializersArray2 = serializersArray2._additionalSerializers;
            BeanSerializerModifier[] beanSerializerModifierArray = serializersArray2._modifiers;
            return new SerializerFactoryConfig(serializersArray2, serializersArray, beanSerializerModifierArray);
        }
        throw new IllegalArgumentException("Cannot pass null Serializers");
    }

    public SerializerFactoryConfig withSerializerModifier(BeanSerializerModifier beanSerializerModifierArray) {
        if (beanSerializerModifierArray != null) {
            beanSerializerModifierArray = ArrayBuilders.insertInListNoDup(serializersArray._modifiers, beanSerializerModifierArray);
            Serializers[] serializersArray = serializersArray._additionalSerializers;
            return new SerializerFactoryConfig(serializersArray, serializersArray._additionalKeySerializers, beanSerializerModifierArray);
        }
        throw new IllegalArgumentException("Cannot pass null modifier");
    }

    public boolean hasSerializers() {
        return this._additionalSerializers.length > 0;
    }

    public boolean hasKeySerializers() {
        return this._additionalKeySerializers.length > 0;
    }

    public boolean hasSerializerModifiers() {
        return this._modifiers.length > 0;
    }

    public Iterable<Serializers> serializers() {
        return new ArrayIterator<Serializers>(this._additionalSerializers);
    }

    public Iterable<Serializers> keySerializers() {
        return new ArrayIterator<Serializers>(this._additionalKeySerializers);
    }

    public Iterable<BeanSerializerModifier> serializerModifiers() {
        return new ArrayIterator<BeanSerializerModifier>(this._modifiers);
    }
}

