/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerators;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.privatefasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Map;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected transient Map<String, SettableBeanProperty> _properties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder object, BeanDescription object2, Map<String, SettableBeanProperty> map, Map<String, SettableBeanProperty> map2) {
        this._baseType = object2 = ((BeanDescription)object2).getType();
        this._objectIdReader = ((BeanDeserializerBuilder)object).getObjectIdReader();
        this._backRefProperties = map;
        this._properties = map2;
        object = ((JavaType)object2).getRawClass();
        this._acceptString = ((Class)object).isAssignableFrom(String.class);
        boolean bl = object == Boolean.TYPE || ((Class)object).isAssignableFrom(Boolean.class);
        this._acceptBoolean = bl;
        bl = object == Integer.TYPE || ((Class)object).isAssignableFrom(Integer.class);
        this._acceptInt = bl;
        boolean bl2 = object == Double.TYPE || ((Class)object).isAssignableFrom(Double.class);
        this._acceptDouble = bl2;
    }

    @Deprecated
    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map) {
        this(beanDeserializerBuilder, beanDescription, map, null);
    }

    public AbstractDeserializer(BeanDescription clazz) {
        clazz = ((BeanDescription)((Object)clazz)).getType();
        AbstractDeserializer abstractDeserializer = this;
        abstractDeserializer._baseType = clazz;
        abstractDeserializer._objectIdReader = null;
        abstractDeserializer._backRefProperties = null;
        clazz = ((JavaType)((Object)clazz)).getRawClass();
        this._acceptString = clazz.isAssignableFrom(String.class);
        boolean bl = clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class);
        this._acceptBoolean = bl;
        bl = clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class);
        this._acceptInt = bl;
        boolean bl2 = clazz == Double.TYPE || clazz.isAssignableFrom(Double.class);
        this._acceptDouble = bl2;
    }

    public AbstractDeserializer(AbstractDeserializer abstractDeserializer, ObjectIdReader objectIdReader, Map<String, SettableBeanProperty> map) {
        this._baseType = abstractDeserializer._baseType;
        this._backRefProperties = abstractDeserializer._backRefProperties;
        this._acceptString = abstractDeserializer._acceptString;
        this._acceptBoolean = abstractDeserializer._acceptBoolean;
        this._acceptInt = abstractDeserializer._acceptInt;
        this._acceptDouble = abstractDeserializer._acceptDouble;
        this._objectIdReader = objectIdReader;
        this._properties = map;
    }

    public static AbstractDeserializer constructForNonPOJO(BeanDescription beanDescription) {
        return new AbstractDeserializer(beanDescription);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty object2) {
        ObjectIdInfo objectIdInfo;
        Map<String, SettableBeanProperty> map = ((DeserializationContext)object).getAnnotationIntrospector();
        if (object2 != null && map != null && (object2 = object2.getMember()) != null && (objectIdInfo = ((AnnotationIntrospector)((Object)map)).findObjectIdInfo((Annotated)object2)) != null) {
            AnnotationIntrospector annotationIntrospector = map;
            map = null;
            ObjectIdResolver objectIdResolver = ((DatabindContext)object).objectIdResolverInstance((Annotated)object2, objectIdInfo);
            Object object3 = (objectIdInfo = annotationIntrospector.findObjectReferenceInfo((Annotated)object2, objectIdInfo)).getGeneratorType();
            if (object3 == ObjectIdGenerators.PropertyGenerator.class) {
                PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator;
                object2 = objectIdInfo.getPropertyName();
                map = this._properties;
                map = map == null ? null : (SettableBeanProperty)map.get(((PropertyName)object2).getSimpleName());
                if (map == null) {
                    Object[] objectArray = new Object[2];
                    object3 = objectArray;
                    object3[0] = ClassUtil.nameOf(this.handledType());
                    objectArray[1] = ClassUtil.name((PropertyName)object2);
                    ((DeserializationContext)object).reportBadDefinition(this._baseType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", object3));
                }
                object2 = ((SettableBeanProperty)((Object)map)).getType();
                object3 = propertyBasedObjectIdGenerator;
                propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
            } else {
                Object object4 = object2;
                DeserializationContext deserializationContext = object;
                objectIdResolver = ((DatabindContext)object).objectIdResolverInstance((Annotated)object2, objectIdInfo);
                object2 = deserializationContext.constructType((Class<?>)object3);
                object2 = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object2, ObjectIdGenerator.class)[0];
                object3 = ((DatabindContext)object).objectIdGeneratorInstance((Annotated)object4, objectIdInfo);
            }
            object = ((DeserializationContext)object).findRootValueDeserializer((JavaType)object2);
            object = ObjectIdReader.construct((JavaType)object2, objectIdInfo.getPropertyName(), object3, object, (SettableBeanProperty)((Object)map), objectIdResolver);
            return new AbstractDeserializer(this, (ObjectIdReader)object, null);
        }
        if (this._properties == null) {
            return this;
        }
        return new AbstractDeserializer(this, this._objectIdReader, null);
    }

    @Override
    public Class<?> handledType() {
        return this._baseType.getRawClass();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        Map<String, SettableBeanProperty> map = ((AbstractDeserializer)((Object)map))._backRefProperties;
        return map == null ? null : (SettableBeanProperty)map.get(string);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        JsonToken jsonToken;
        if (((AbstractDeserializer)this)._objectIdReader != null && (jsonToken = jsonParser.currentToken()) != null) {
            if (jsonToken.isScalarValue()) {
                return ((AbstractDeserializer)this)._deserializeFromObjectId(jsonParser, deserializationContext);
            }
            if (jsonToken == JsonToken.START_OBJECT) {
                jsonToken = jsonParser.nextToken();
            }
            if (jsonToken == JsonToken.FIELD_NAME && ((AbstractDeserializer)this)._objectIdReader.maySerializeAsObject() && ((AbstractDeserializer)this)._objectIdReader.isValidReferencePropertyName(jsonParser.currentName(), jsonParser)) {
                return ((AbstractDeserializer)this)._deserializeFromObjectId(jsonParser, deserializationContext);
            }
        }
        if ((this = ((AbstractDeserializer)this)._deserializeIfNatural(jsonParser, deserializationContext)) != null) {
            return this;
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext serializable) {
        ValueInstantiator.Base base;
        DeserializationContext deserializationContext = serializable;
        serializable = base;
        base = new ValueInstantiator.Base(objectArray._baseType);
        Object[] objectArray = new Object[]{};
        return deserializationContext.handleMissingInstantiator(objectArray._baseType.getRawClass(), (ValueInstantiator)((Object)serializable), jsonParser, "abstract types either need to be mapped to concrete types, have custom deserializer, or contain additional type information", objectArray);
    }

    public Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.currentTokenId()) {
            default: {
                break;
            }
            case 10: {
                if (!this._acceptBoolean) break;
                return Boolean.FALSE;
            }
            case 9: {
                if (!this._acceptBoolean) break;
                return Boolean.TRUE;
            }
            case 8: {
                if (!this._acceptDouble) break;
                return jsonParser.getDoubleValue();
            }
            case 7: {
                if (!this._acceptInt) break;
                return jsonParser.getIntValue();
            }
            case 6: {
                if (!this._acceptString) break;
                return jsonParser.getText();
            }
        }
        return null;
    }

    public Object _deserializeFromObjectId(JsonParser jsonParser, DeserializationContext object) {
        DeserializationContext deserializationContext = object;
        AbstractDeserializer abstractDeserializer = object2;
        Object object2 = abstractDeserializer._objectIdReader.readObjectReference(jsonParser, (DeserializationContext)object);
        ObjectIdReader objectIdReader = abstractDeserializer._objectIdReader;
        object = objectIdReader.generator;
        Object object3 = ((ReadableObjectId)(object = deserializationContext.findObjectId(object2, (ObjectIdGenerator<?>)object, objectIdReader.resolver))).resolve();
        if (object3 != null) {
            return object3;
        }
        JsonParser jsonParser2 = jsonParser;
        object2 = "Could not resolve Object Id [" + object2 + "] -- unresolved forward-reference?";
        throw new UnresolvedForwardReference(jsonParser2, (String)object2, jsonParser2.getCurrentLocation(), (ReadableObjectId)object);
    }
}

