/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.annotation.JacksonInject;
import com.privatefasterxml.jackson.annotation.JsonCreator;
import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonIncludeProperties;
import com.privatefasterxml.jackson.annotation.JsonSetter;
import com.privatefasterxml.jackson.annotation.Nulls;
import com.privatefasterxml.jackson.databind.AbstractTypeResolver;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.ConstructorDetector;
import com.privatefasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfigBase;
import com.privatefasterxml.jackson.databind.deser.AbstractDeserializer;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.privatefasterxml.jackson.databind.deser.CreatorProperty;
import com.privatefasterxml.jackson.databind.deser.DeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.Deserializers;
import com.privatefasterxml.jackson.databind.deser.KeyDeserializers;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiators;
import com.privatefasterxml.jackson.databind.deser.a;
import com.privatefasterxml.jackson.databind.deser.impl.CreatorCandidate;
import com.privatefasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.privatefasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.privatefasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.DateDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.MapDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.privatefasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StringDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.privatefasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.privatefasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.privatefasterxml.jackson.databind.introspect.VisibilityChecker;
import com.privatefasterxml.jackson.databind.jdk14.JDK14Util;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.type.ArrayType;
import com.privatefasterxml.jackson.databind.type.CollectionLikeType;
import com.privatefasterxml.jackson.databind.type.CollectionType;
import com.privatefasterxml.jackson.databind.type.MapLikeType;
import com.privatefasterxml.jackson.databind.type.MapType;
import com.privatefasterxml.jackson.databind.type.ReferenceType;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.EnumResolver;
import com.privatefasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_SEQUENCE = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    private static final Class<?> CLASS_SERIALIZABLE = Serializable.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    protected final DeserializerFactoryConfig _factoryConfig;

    public BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasAbstractTypeResolvers()) {
            Iterator<AbstractTypeResolver> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.abstractTypeResolvers().iterator();
            while (iterator.hasNext()) {
                JavaType javaType2 = ((AbstractTypeResolver)iterator.next()).findTypeMapping(deserializationConfig, javaType);
                if (javaType2 == null || javaType2.hasRawClass(clazz)) continue;
                return javaType2;
            }
        }
        return null;
    }

    private boolean _checkIfCreatorPropertyBased(AnnotationIntrospector annotationIntrospector, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition beanPropertyDefinition) {
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed() || annotationIntrospector.findInjectableValue(annotatedWithParams.getParameter(0)) != null) {
            return true;
        }
        return beanPropertyDefinition != null && (this = beanPropertyDefinition.getName()) != null && !((String)this).isEmpty() && beanPropertyDefinition.couldSerialize();
    }

    private void _checkImplicitlyNamedConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector2, CreatorCollector object, List<AnnotatedWithParams> object2) {
        BasicBeanDescription basicBeanDescription;
        AnnotatedWithParams annotatedWithParams;
        void v0 = annotatedWithParams;
        annotatedWithParams = null;
        SettableBeanProperty[] settableBeanPropertyArray = null;
        block0: for (AnnotatedWithParams annotatedWithParams2 : v0) {
            if (!visibilityChecker.isCreatorVisible(annotatedWithParams2)) continue;
            int n2 = annotatedWithParams2.getParameterCount();
            SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotatedParameter annotatedParameter = annotatedWithParams2.getParameter(i2);
                PropertyName propertyName = super._findParamName(annotatedParameter, annotationIntrospector2);
                if (propertyName == null || propertyName.isEmpty()) continue block0;
                int n3 = annotatedParameter.getIndex();
                settableBeanPropertyArray2[i2] = ((BasicDeserializerFactory)((Object)basicBeanDescription)).constructCreatorProperty(deserializationContext, beanDescription, propertyName, n3, annotatedParameter, null);
            }
            if (annotatedWithParams != null) {
                annotatedWithParams = null;
                break;
            }
            settableBeanPropertyArray = settableBeanPropertyArray2;
            annotatedWithParams = annotatedWithParams2;
        }
        if (annotatedWithParams != null) {
            PropertyName propertyName;
            ((CreatorCollector)((Object)propertyName)).addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
            basicBeanDescription = (BasicBeanDescription)beanDescription;
            for (void var4_8 : settableBeanPropertyArray) {
                propertyName = var4_8.getFullName();
                if (basicBeanDescription.hasProperty(propertyName)) continue;
                basicBeanDescription.addProperty(SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), var4_8.getMember(), propertyName));
            }
        }
    }

    private PropertyName _findParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        if (annotationIntrospector != null) {
            Object object = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (object != null && !((PropertyName)object).isEmpty()) {
                return object;
            }
            object = annotationIntrospector.findImplicitPropertyName(annotatedParameter);
            if (object != null && !((String)object).isEmpty()) {
                return PropertyName.construct((String)object);
            }
        }
        return null;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType serializable) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = ((JavaType)serializable).getRawClass();
        BeanDescription beanDescription = deserializationConfig.introspect((JavaType)serializable);
        KeyDeserializer object2 = this.findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (object2 != null) {
            return object2;
        }
        JsonDeserializer<?> jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, (JavaType)serializable, jsonDeserializer);
        }
        JsonDeserializer<Object> jsonDeserializer2 = this.findDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, (JavaType)serializable, jsonDeserializer2);
        }
        serializable = this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueAccessor());
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
            if (annotatedMethod.getParameterCount() == 1 && annotatedMethod.getRawReturnType().isAssignableFrom(clazz)) {
                if (annotatedMethod.getRawParameterType(0) != String.class) continue;
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)serializable, annotatedMethod);
            }
            throw new IllegalArgumentException(com.applitools.android.common.a.a(clazz, new StringBuilder("Unsuitable method (").append(annotatedMethod).append(") decorated with @JsonCreator (for Enum type "), ")"));
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)serializable);
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) {
        JavaType javaType2;
        while (true) {
            Class<?> clazz;
            if ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) == null) {
                return javaType;
            }
            Class<?> clazz2 = javaType.getRawClass();
            if (clazz2 == (clazz = javaType2.getRawClass()) || !clazz2.isAssignableFrom(clazz)) break;
            javaType = javaType2;
        }
        throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass object2 = beanDescription.getClassInfo();
        Object[] objectArray = deserializationContext.getAnnotationIntrospector().findValueInstantiator(object2);
        if (objectArray != null) {
            valueInstantiator = ((BasicDeserializerFactory)this)._valueInstantiatorInstance(deserializationConfig, object2, objectArray);
        }
        if (valueInstantiator == null && (valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(deserializationConfig, beanDescription.getBeanClass())) == null) {
            valueInstantiator = ((BasicDeserializerFactory)this)._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (((BasicDeserializerFactory)this)._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : ((BasicDeserializerFactory)this)._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = valueInstantiators.getClass().getName();
                deserializationContext.reportBadTypeDefinition(beanDescription, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", objectArray);
            }
        }
        if (valueInstantiator != null) {
            valueInstantiator = valueInstantiator.createContextual(deserializationContext, beanDescription);
        }
        return valueInstantiator;
    }

    public ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription object) {
        CreatorCollectionState creatorCollectionState;
        CreatorCollector creatorCollector;
        DeserializationContext deserializationContext2 = deserializationContext;
        Object object2 = deserializationContext2.getConfig();
        BeanDescription beanDescription = object;
        Object object3 = beanDescription.getBeanClass();
        object3 = ((MapperConfigBase)object2).getDefaultVisibilityChecker((Class<?>)object3, beanDescription.getClassInfo());
        ConstructorDetector constructorDetector = ((DeserializationConfig)object2).getConstructorDetector();
        CreatorCollector creatorCollector2 = creatorCollector;
        creatorCollector = new CreatorCollector((BeanDescription)object, (MapperConfig<?>)object2);
        object2 = ((BasicDeserializerFactory)((Object)list))._findCreatorsFromProperties(deserializationContext2, (BeanDescription)object);
        CreatorCollectionState creatorCollectionState2 = creatorCollectionState;
        creatorCollectionState = new CreatorCollectionState(deserializationContext, (BeanDescription)object, (VisibilityChecker<?>)object3, creatorCollector2, (Map<AnnotatedWithParams, BeanPropertyDefinition[]>)object2);
        ((BasicDeserializerFactory)((Object)list))._addExplicitFactoryCreators(deserializationContext, creatorCollectionState2, constructorDetector.requireCtorAnnotation() ^ true);
        if (((BeanDescription)object).getType().isConcrete()) {
            if (((BeanDescription)object).getType().isRecordType()) {
                ArrayList arrayList;
                object2 = arrayList;
                arrayList = new ArrayList();
                object3 = JDK14Util.findRecordConstructor(deserializationContext, (BeanDescription)object, (List<String>)object2);
                if (object3 != null) {
                    ((BasicDeserializerFactory)((Object)list))._addRecordConstructor(deserializationContext, creatorCollectionState2, (AnnotatedConstructor)object3, (List<String>)object2);
                    return creatorCollectionState2.creators.constructValueInstantiator(deserializationContext);
                }
            }
            if (!((BeanDescription)object).isNonStaticInnerClass()) {
                ((BasicDeserializerFactory)((Object)list))._addExplicitConstructorCreators(deserializationContext, creatorCollectionState2, constructorDetector.shouldIntrospectorImplicitConstructors(((BeanDescription)object).getBeanClass()));
                if (creatorCollectionState2.hasImplicitConstructorCandidates() && !creatorCollectionState2.hasExplicitConstructors()) {
                    object = creatorCollectionState2.implicitConstructorCandidates();
                    ((BasicDeserializerFactory)((Object)list))._addImplicitConstructorCreators(deserializationContext, creatorCollectionState2, (List<CreatorCandidate>)object);
                }
            }
        }
        if (creatorCollectionState2.hasImplicitFactoryCandidates() && !creatorCollectionState2.hasExplicitFactories() && !creatorCollectionState2.hasExplicitConstructors()) {
            BasicDeserializerFactory basicDeserializerFactory = list;
            List<CreatorCandidate> list = creatorCollectionState2.implicitFactoryCandidates();
            basicDeserializerFactory._addImplicitFactoryCreators(deserializationContext, creatorCollectionState2, list);
        }
        return creatorCollectionState2.creators.constructValueInstantiator(deserializationContext);
    }

    public Map<AnnotatedWithParams, BeanPropertyDefinition[]> _findCreatorsFromProperties(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        Object object = Collections.emptyMap();
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            Iterator<AnnotatedParameter> iterator = beanPropertyDefinition.getConstructorParameters();
            while (iterator.hasNext()) {
                AnnotatedParameter annotatedParameter = iterator.next();
                AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
                BeanPropertyDefinition[] beanPropertyDefinitionArray = (BeanPropertyDefinition[])object.get(annotatedWithParams);
                int n2 = annotatedParameter.getIndex();
                if (beanPropertyDefinitionArray == null) {
                    if (object.isEmpty()) {
                        LinkedHashMap linkedHashMap;
                        object = linkedHashMap;
                        linkedHashMap = new LinkedHashMap();
                    }
                    AnnotatedWithParams annotatedWithParams2 = annotatedWithParams;
                    beanPropertyDefinitionArray = new BeanPropertyDefinition[annotatedWithParams2.getParameterCount()];
                    object.put(annotatedWithParams2, beanPropertyDefinitionArray);
                } else if (beanPropertyDefinitionArray[n2] != null) {
                    Object[] objectArray = new Object[4];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = n2;
                    objectArray2[1] = annotatedWithParams;
                    objectArray[2] = beanPropertyDefinitionArray[n2];
                    objectArray[3] = beanPropertyDefinition;
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Conflict: parameter #%d of %s bound to more than one property; %s vs %s", objectArray2);
                }
                beanPropertyDefinitionArray[n2] = beanPropertyDefinition;
            }
        }
        return object;
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof ValueInstantiator) {
            return (ValueInstantiator)object2;
        }
        if (object2 instanceof Class) {
            Serializable serializable = (Class)object2;
            if (ClassUtil.isBogusClass(serializable)) {
                return null;
            }
            if (ValueInstantiator.class.isAssignableFrom((Class<?>)serializable)) {
                object2 = deserializationConfig.getHandlerInstantiator();
                if (object2 != null && (object = ((HandlerInstantiator)object2).valueInstantiatorInstance(deserializationConfig, (Annotated)object, (Class<?>)serializable)) != null) {
                    return object;
                }
                return (ValueInstantiator)ClassUtil.createInstance(serializable, deserializationConfig.canOverrideAccessModifiers());
            }
            throw new IllegalStateException(com.applitools.android.common.a.a((Class)serializable, new StringBuilder("AnnotationIntrospector returned Class "), "; expected Class<ValueInstantiator>"));
        }
        throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object2.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
    }

    public void _addRecordConstructor(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, AnnotatedConstructor annotatedConstructor, List<String> list) {
        int n2 = annotatedConstructor.getParameterCount();
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            AnnotationIntrospector annotationIntrospector2 = annotationIntrospector;
            AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(i2);
            JacksonInject.Value value = annotationIntrospector2.findInjectableValue(annotatedParameter);
            PropertyName propertyName = annotationIntrospector2.findNameForDeserialization(annotatedParameter);
            if (propertyName == null || propertyName.isEmpty()) {
                propertyName = PropertyName.construct(list.get(i2));
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, creatorCollectionState.beanDesc, propertyName, i2, annotatedParameter, value);
        }
        creatorCollectionState.creators.addPropertyCreator(annotatedConstructor, false, settableBeanPropertyArray);
    }

    public void _addExplicitConstructorCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, boolean bl) {
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollectionState creatorCollectionState2 = creatorCollectionState;
        CreatorCollector creatorCollector = creatorCollectionState2.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState2.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState2.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState2.creatorParams;
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || this._hasCreatorAnnotation(deserializationContext, annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        for (AnnotatedConstructor annotatedConstructor2 : beanDescription.getConstructors()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedConstructor2);
            if (JsonCreator.Mode.DISABLED == mode) continue;
            if (mode == null) {
                if (!bl || !visibilityChecker.isCreatorVisible(annotatedConstructor2)) continue;
                creatorCollectionState.addImplicitConstructorCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                continue;
            }
            int n2 = a.a[mode.ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    CreatorCandidate creatorCandidate = CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2));
                    ConstructorDetector constructorDetector = deserializationContext.getConfig().getConstructorDetector();
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate, constructorDetector);
                } else {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                }
            } else {
                CreatorCandidate creatorCandidate = CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, null);
                this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
            }
            creatorCollectionState.increaseExplicitConstructorCount();
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void _addImplicitConstructorCreators(DeserializationContext deserializationContext, CreatorCollectionState object, List<CreatorCandidate> object2) {
        List<CreatorCandidate> list = object2;
        CreatorCollectionState creatorCollectionState = object;
        object = deserializationContext.getConfig();
        object2 = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        Object object3 = object;
        object = null;
        boolean bl = ((DeserializationConfig)object3).getConstructorDetector().singleArgCreatorDefaultsToProperties();
        for (Object[] objectArray : list) {
            Object object4;
            int n2 = objectArray.paramCount();
            AnnotatedWithParams annotatedWithParams = objectArray.creator();
            if (n2 == 1) {
                SettableBeanProperty[] settableBeanPropertyArray = objectArray.propertyDef(0);
                if (!bl && !this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, (BeanPropertyDefinition)settableBeanPropertyArray)) {
                    boolean bl2 = visibilityChecker.isCreatorVisible(annotatedWithParams);
                    this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, bl2);
                    if (settableBeanPropertyArray == null) continue;
                    ((POJOPropertyBuilder)settableBeanPropertyArray).removeConstructors();
                    continue;
                }
                CreatorCandidate creatorCandidate = objectArray;
                settableBeanPropertyArray = new SettableBeanProperty[1];
                JacksonInject.Value value = creatorCandidate.injection(0);
                object4 = creatorCandidate.paramName(0);
                if (object4 == null && (object4 = objectArray.findImplicitParamName(0)) == null && value == null) continue;
                objectArray = objectArray.parameter(0);
                settableBeanPropertyArray[0] = this.constructCreatorProperty(deserializationContext, (BeanDescription)object2, (PropertyName)object4, 0, (AnnotatedParameter)objectArray, value);
                creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                continue;
            }
            int n3 = -1;
            object4 = new SettableBeanProperty[n2];
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(i2);
                BeanPropertyDefinition beanPropertyDefinition = objectArray.propertyDef(i2);
                JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter);
                PropertyName propertyName = beanPropertyDefinition == null ? null : beanPropertyDefinition.getFullName();
                if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
                    ++n4;
                    object4[i2] = this.constructCreatorProperty(deserializationContext, (BeanDescription)object2, propertyName, i2, annotatedParameter, value);
                    continue;
                }
                if (value != null) {
                    ++n5;
                    object4[i2] = this.constructCreatorProperty(deserializationContext, (BeanDescription)object2, propertyName, i2, annotatedParameter, value);
                    continue;
                }
                if (annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter) != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, (BeanDescription)object2, annotatedParameter);
                    continue;
                }
                if (n3 >= 0) continue;
                n3 = i2;
            }
            if (n4 > 0 || n5 > 0) {
                if (n4 + n5 == n2) {
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, (SettableBeanProperty[])object4);
                    continue;
                }
                if (n4 == 0 && n5 + 1 == n2) {
                    creatorCollector.addDelegatingCreator(annotatedWithParams, false, (SettableBeanProperty[])object4, 0);
                    continue;
                }
                if ((objectArray = objectArray.findImplicitParamName(n3)) == null || objectArray.isEmpty()) {
                    Object[] objectArray2 = new Object[2];
                    objectArray = objectArray2;
                    objectArray2[0] = n3;
                    objectArray2[1] = annotatedWithParams;
                    deserializationContext.reportBadTypeDefinition((BeanDescription)object2, "Argument #%d of constructor %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", objectArray);
                }
            }
            if (creatorCollector.hasDefaultCreator()) continue;
            if (object == null) {
                LinkedList linkedList;
                object = linkedList;
                linkedList = new LinkedList();
            }
            object.add(annotatedWithParams);
        }
        if (object != null && !creatorCollector.hasDelegatingCreator() && !creatorCollector.hasPropertyBasedCreator()) {
            this._checkImplicitlyNamedConstructors(deserializationContext, (BeanDescription)object2, visibilityChecker, annotationIntrospector, creatorCollector, (List<AnnotatedWithParams>)object);
        }
    }

    public void _addExplicitFactoryCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, boolean bl) {
        CreatorCollectionState creatorCollectionState2 = creatorCollectionState;
        BeanDescription beanDescription = creatorCollectionState2.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState2.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState2.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState2.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState2.creatorParams;
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedMethod);
            int n2 = annotatedMethod.getParameterCount();
            if (mode == null) {
                if (!bl || n2 != 1 || !visibilityChecker.isCreatorVisible(annotatedMethod)) continue;
                creatorCollectionState.addImplicitFactoryCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                continue;
            }
            if (mode == JsonCreator.Mode.DISABLED) continue;
            if (n2 == 0) {
                creatorCollector.setDefaultCreator(annotatedMethod);
                continue;
            }
            int n3 = a.a[mode.ordinal()];
            if (n3 != 1) {
                if (n3 != 2) {
                    ConstructorDetector constructorDetector = ConstructorDetector.DEFAULT;
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)), constructorDetector);
                } else {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)));
                }
            } else {
                CreatorCandidate creatorCandidate = CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null);
                this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
            }
            creatorCollectionState.increaseExplicitFactoryCount();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _addImplicitFactoryCreators(DeserializationContext deserializationContext, CreatorCollectionState object, List<CreatorCandidate> object2) {
        Object object3 = object2;
        Object object4 = object;
        object = ((CreatorCollectionState)object4).beanDesc;
        object2 = ((CreatorCollectionState)object4).creators;
        AnnotationIntrospector annotationIntrospector = ((CreatorCollectionState)object4).annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = ((CreatorCollectionState)object4).vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = ((CreatorCollectionState)object4).creatorParams;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            void var8_12;
            CreatorCandidate creatorCandidate = (CreatorCandidate)iterator.next();
            int n2 = creatorCandidate.paramCount();
            AnnotatedWithParams annotatedWithParams = creatorCandidate.creator();
            Object[] objectArray = map.get(annotatedWithParams);
            if (n2 != 1) continue;
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            if (!this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, beanPropertyDefinition)) {
                n2 = visibilityChecker.isCreatorVisible(annotatedWithParams) ? 1 : 0;
                this._handleSingleArgumentCreator((CreatorCollector)object2, annotatedWithParams, false, n2 != 0);
                if (beanPropertyDefinition == null) continue;
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
                continue;
            }
            Object var8_11 = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
            int n3 = 0;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(i2);
                BeanPropertyDefinition beanPropertyDefinition2 = objectArray == null ? null : objectArray[i2];
                JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter);
                PropertyName propertyName = beanPropertyDefinition2 == null ? null : beanPropertyDefinition2.getFullName();
                if (beanPropertyDefinition2 != null && beanPropertyDefinition2.isExplicitlyNamed()) {
                    ++n3;
                    settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, (BeanDescription)object, propertyName, i2, annotatedParameter, value);
                    continue;
                }
                if (value != null) {
                    ++n4;
                    settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, (BeanDescription)object, propertyName, i2, annotatedParameter, value);
                    continue;
                }
                if (annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter) != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, (BeanDescription)object, annotatedParameter);
                    continue;
                }
                if (var8_12 != null) continue;
                AnnotatedParameter annotatedParameter2 = annotatedParameter;
            }
            if (n3 <= 0 && n4 <= 0) continue;
            if (n3 + n4 == n2) {
                ((CreatorCollector)object2).addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                continue;
            }
            if (n3 == 0 && n4 + 1 == n2) {
                ((CreatorCollector)object2).addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                continue;
            }
            String string = "Argument #%d of factory method %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator";
            objectArray = new Object[2];
            int n5 = 0;
            Integer n6 = var8_12 == null ? -1 : var8_12.getIndex();
            objectArray[n5] = n6;
            objectArray[1] = annotatedWithParams;
            deserializationContext.reportBadTypeDefinition((BeanDescription)object, string, objectArray);
        }
    }

    public void _addExplicitDelegatingCreator(DeserializationContext objectArray, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        int n2 = -1;
        int n3 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            CreatorCandidate creatorCandidate2 = creatorCandidate;
            Object[] objectArray2 = creatorCandidate2.parameter(i2);
            JacksonInject.Value value = creatorCandidate2.injection(i2);
            if (value != null) {
                settableBeanPropertyArray[i2] = ((BasicDeserializerFactory)((Object)beanPropertyDefinition)).constructCreatorProperty((DeserializationContext)objectArray, beanDescription, null, i2, (AnnotatedParameter)objectArray2, value);
                continue;
            }
            if (n2 < 0) {
                n2 = i2;
                continue;
            }
            Object[] objectArray3 = new Object[3];
            objectArray2 = objectArray3;
            objectArray2[0] = n2;
            objectArray3[1] = i2;
            objectArray3[2] = creatorCandidate;
            objectArray.reportBadTypeDefinition(beanDescription, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", objectArray2);
        }
        if (n2 < 0) {
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = creatorCandidate;
            objectArray4.reportBadTypeDefinition(beanDescription, "No argument left as delegating for Creator %s: exactly one required", objectArray);
        }
        if (n3 == 1) {
            ((BasicDeserializerFactory)((Object)beanPropertyDefinition))._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            if (beanPropertyDefinition != null) {
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
            }
            return;
        }
        creatorCollector.addDelegatingCreator(creatorCandidate.creator(), true, settableBeanPropertyArray, n2);
    }

    public void _addExplicitPropertyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        int n2 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            CreatorCandidate creatorCandidate2 = creatorCandidate;
            JacksonInject.Value value = creatorCandidate2.injection(i2);
            AnnotatedParameter annotatedParameter = creatorCandidate2.parameter(i2);
            PropertyName propertyName = creatorCandidate2.paramName(i2);
            if (propertyName == null) {
                if (deserializationContext.getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedParameter) != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                }
                propertyName = creatorCandidate.findImplicitParamName(i2);
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, i2, propertyName, value);
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, i2, annotatedParameter, value);
        }
        creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
    }

    @Deprecated
    public void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        BasicDeserializerFactory basicDeserializerFactory = serializable;
        DeserializationContext deserializationContext2 = deserializationContext;
        Serializable serializable = deserializationContext2.getConfig().getConstructorDetector();
        basicDeserializerFactory._addExplicitAnyCreator(deserializationContext2, beanDescription, creatorCollector, creatorCandidate, (ConstructorDetector)serializable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector settableBeanPropertyArray, CreatorCandidate creatorCandidate, ConstructorDetector constructorDetector) {
        boolean bl;
        Object[] objectArray;
        PropertyName propertyName;
        JacksonInject.Value value;
        AnnotatedParameter annotatedParameter;
        block10: {
            block9: {
                if (1 != creatorCandidate.paramCount()) {
                    int n2;
                    if (!constructorDetector.singleArgCreatorDefaultsToProperties() && (n2 = creatorCandidate.findOnlyParamWithoutInjection()) >= 0 && (constructorDetector.singleArgCreatorDefaultsToDelegating() || creatorCandidate.paramName(n2) == null)) {
                        objectArray._addExplicitDelegatingCreator(deserializationContext, beanDescription, (CreatorCollector)settableBeanPropertyArray, creatorCandidate);
                        return;
                    }
                    objectArray._addExplicitPropertyCreator(deserializationContext, beanDescription, (CreatorCollector)settableBeanPropertyArray, creatorCandidate);
                    return;
                }
                CreatorCandidate creatorCandidate2 = creatorCandidate;
                annotatedParameter = creatorCandidate2.parameter(0);
                value = creatorCandidate2.injection(0);
                propertyName = null;
                int n3 = a.b[constructorDetector.singleArgMode().ordinal()];
                if (n3 == 1) break block9;
                if (n3 != 2) {
                    if (n3 == 3) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = creatorCandidate.creator();
                        deserializationContext.reportBadTypeDefinition(beanDescription, "Single-argument constructor (%s) is annotated but no 'mode' defined; `CreatorDetector`configured with `SingleArgConstructor.REQUIRE_MODE`", objectArray);
                        return;
                    }
                    CreatorCandidate creatorCandidate3 = creatorCandidate;
                    BeanPropertyDefinition beanPropertyDefinition = creatorCandidate3.propertyDef(0);
                    propertyName = creatorCandidate3.explicitParamName(0);
                    bl = propertyName != null || value != null;
                    if (!bl && beanPropertyDefinition != null) {
                        boolean bl2;
                        boolean bl3;
                        propertyName = creatorCandidate.paramName(0);
                        bl = propertyName != null && beanPropertyDefinition.couldSerialize() ? (bl3 = true) : (bl2 = false);
                    }
                    break block10;
                } else {
                    bl = true;
                    propertyName = creatorCandidate.paramName(0);
                    if (propertyName == null) {
                        objectArray._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, 0, propertyName, value);
                    }
                }
                break block10;
            }
            bl = false;
        }
        if (bl) {
            SettableBeanProperty[] settableBeanPropertyArray2 = settableBeanPropertyArray;
            SettableBeanProperty[] settableBeanPropertyArray3 = new SettableBeanProperty[1];
            settableBeanPropertyArray = settableBeanPropertyArray3;
            settableBeanPropertyArray3[0] = objectArray.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, annotatedParameter, value);
            settableBeanPropertyArray2.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
            return;
        }
        objectArray._handleSingleArgumentCreator((CreatorCollector)settableBeanPropertyArray, creatorCandidate.creator(), true, true);
        objectArray = creatorCandidate.propertyDef(0);
        if (objectArray != null) {
            ((POJOPropertyBuilder)objectArray).removeConstructors();
        }
    }

    public boolean _handleSingleArgumentCreator(CreatorCollector creatorCollector, AnnotatedWithParams annotatedWithParams, boolean bl, boolean bl2) {
        Serializable serializable = annotatedWithParams.getRawParameterType(0);
        if (serializable != String.class && serializable != CLASS_CHAR_SEQUENCE) {
            if (serializable != Integer.TYPE && serializable != Integer.class) {
                if (serializable != Long.TYPE && serializable != Long.class) {
                    if (serializable != Double.TYPE && serializable != Double.class) {
                        if (serializable != Boolean.TYPE && serializable != Boolean.class) {
                            if (serializable == BigInteger.class && (bl || bl2)) {
                                creatorCollector.addBigIntegerCreator(annotatedWithParams, bl);
                            }
                            if (serializable == BigDecimal.class && (bl || bl2)) {
                                creatorCollector.addBigDecimalCreator(annotatedWithParams, bl);
                            }
                            if (bl) {
                                creatorCollector.addDelegatingCreator(annotatedWithParams, bl, null, 0);
                                return true;
                            }
                            return false;
                        }
                        if (bl || bl2) {
                            creatorCollector.addBooleanCreator(annotatedWithParams, bl);
                        }
                        return true;
                    }
                    if (bl || bl2) {
                        creatorCollector.addDoubleCreator(annotatedWithParams, bl);
                    }
                    return true;
                }
                if (bl || bl2) {
                    creatorCollector.addLongCreator(annotatedWithParams, bl);
                }
                return true;
            }
            if (bl || bl2) {
                creatorCollector.addIntCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (bl || bl2) {
            creatorCollector.addStringCreator(annotatedWithParams, bl);
        }
        return true;
    }

    public void _validateNamedPropertyParameter(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCandidate creatorCandidate, int n2, PropertyName propertyName, JacksonInject.Value value) {
        if (propertyName == null && value == null) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            objectArray[1] = creatorCandidate;
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name (and is not Injectable): can not use as property-based Creator", objectArray2);
        }
    }

    public void _reportUnwrappedCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedParameter annotatedParameter) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = annotatedParameter.getIndex();
        deserializationContext.reportBadTypeDefinition(beanDescription, "Cannot define Creator parameter %d as `@JsonUnwrapped`: combination not yet supported", objectArray2);
    }

    public SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription jsonDeserializer, PropertyName object, int n2, AnnotatedParameter annotatedParameter, JacksonInject.Value value) {
        BeanProperty.Std std;
        Object object2;
        Object object3;
        DeserializationContext deserializationContext2 = deserializationContext;
        DeserializationConfig deserializationConfig = deserializationContext2.getConfig();
        Object object4 = deserializationContext2.getAnnotationIntrospector();
        if (object4 == null) {
            object4 = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            object3 = null;
        } else {
            AnnotationIntrospector annotationIntrospector = object4;
            Boolean bl = ((AnnotationIntrospector)object4).hasRequiredMarker(annotatedParameter);
            Serializable serializable = object4;
            Serializable serializable2 = object4;
            object4 = ((AnnotationIntrospector)object4).findPropertyDescription(annotatedParameter);
            object3 = ((AnnotationIntrospector)serializable2).findPropertyIndex(annotatedParameter);
            object2 = ((AnnotationIntrospector)serializable).findPropertyDefaultValue(annotatedParameter);
            object4 = PropertyMetadata.construct(bl, (String)object4, (Integer)object3, (String)object2);
            object3 = annotationIntrospector.findWrapperName(annotatedParameter);
        }
        object2 = ((BasicDeserializerFactory)serializable).resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter, annotatedParameter.getType());
        BeanProperty.Std std2 = std;
        std = new BeanProperty.Std((PropertyName)object, (JavaType)object2, (PropertyName)object3, annotatedParameter, (PropertyMetadata)object4);
        object3 = (TypeDeserializer)((JavaType)object2).getTypeHandler();
        if (object3 == null) {
            object3 = ((BasicDeserializerFactory)serializable).findTypeDeserializer(deserializationConfig, (JavaType)object2);
        }
        BasicDeserializerFactory basicDeserializerFactory = serializable;
        PropertyName propertyName = object;
        BeanDescription beanDescription = jsonDeserializer;
        Serializable serializable = ((BasicDeserializerFactory)serializable)._getSetterInfo(deserializationContext, std2, (PropertyMetadata)object4);
        jsonDeserializer = std2.getWrapperName();
        object = beanDescription.getClassAnnotations();
        serializable = CreatorProperty.construct(propertyName, (JavaType)object2, (PropertyName)((Object)jsonDeserializer), (TypeDeserializer)object3, (Annotations)object, annotatedParameter, n2, value, (PropertyMetadata)serializable);
        jsonDeserializer = basicDeserializerFactory.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer)((JavaType)object2).getValueHandler();
        }
        if (jsonDeserializer != null) {
            serializable = ((CreatorProperty)serializable).withValueDeserializer(deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)((Object)serializable), (JavaType)object2));
        }
        return serializable;
    }

    public PropertyMetadata _getSetterInfo(DeserializationContext serializable, BeanProperty object, PropertyMetadata propertyMetadata) {
        DeserializationContext deserializationContext = serializable;
        Serializable serializable2 = deserializationContext.getAnnotationIntrospector();
        serializable = deserializationContext.getConfig();
        Object object2 = null;
        Nulls nulls = null;
        AnnotatedMember annotatedMember = object.getMember();
        if (annotatedMember != null) {
            if (serializable2 != null && (serializable2 = ((AnnotationIntrospector)serializable2).findSetterInfo(annotatedMember)) != null) {
                Serializable serializable3 = serializable2;
                object2 = ((JsonSetter.Value)serializable3).nonDefaultValueNulls();
                nulls = ((JsonSetter.Value)serializable3).nonDefaultContentNulls();
            }
            if ((serializable2 = ((MapperConfigBase)serializable).getConfigOverride(object.getType().getRawClass()).getSetterInfo()) != null) {
                if (object2 == null) {
                    object = ((JsonSetter.Value)serializable2).nonDefaultValueNulls();
                    object2 = object;
                }
                if (nulls == null) {
                    nulls = ((JsonSetter.Value)serializable2).nonDefaultContentNulls();
                }
            }
        }
        serializable2 = ((MapperConfigBase)serializable).getDefaultSetterInfo();
        if (object2 == null) {
            object2 = ((JsonSetter.Value)serializable2).nonDefaultValueNulls();
        }
        if (nulls == null) {
            nulls = ((JsonSetter.Value)serializable2).nonDefaultContentNulls();
        }
        if (object2 != null || nulls != null) {
            propertyMetadata = propertyMetadata.withNulls((Nulls)((Object)object2), nulls);
        }
        return propertyMetadata;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext serializable, ArrayType arrayType, BeanDescription beanDescription) {
        JsonDeserializer jsonDeserializer;
        serializable = serializable.getConfig();
        Type type = arrayType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)type.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)type.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findTypeDeserializer((DeserializationConfig)serializable, (JavaType)type);
        }
        if ((jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator))._findCustomArrayDeserializer(arrayType, (DeserializationConfig)serializable, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            ObjectArrayDeserializer objectArrayDeserializer;
            if (jsonDeserializer2 == null) {
                JavaType javaType = type;
                type = javaType.getRawClass();
                if (javaType.isPrimitive()) {
                    return PrimitiveArrayDeserializers.forType(type);
                }
                if (type == String.class) {
                    return StringArrayDeserializer.instance;
                }
            }
            jsonDeserializer = objectArrayDeserializer;
            objectArrayDeserializer = new ObjectArrayDeserializer((JavaType)arrayType, jsonDeserializer2, typeDeserializer);
        }
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyArrayDeserializer((DeserializationConfig)serializable, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext jsonDeserializer, CollectionType type, BeanDescription beanDescription) {
        Object object;
        JavaType javaType = ((CollectionLikeType)type).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)((Object)jsonDeserializer)).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((object = ((BasicDeserializerFactory)((Object)iterator))._findCustomCollectionDeserializer((CollectionType)type, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            Class<?> clazz = ((JavaType)type).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom(clazz)) {
                EnumSetDeserializer enumSetDeserializer;
                object = enumSetDeserializer;
                enumSetDeserializer = new EnumSetDeserializer(javaType, null);
            }
        }
        if (object == null) {
            if (((JavaType)type).isInterface() || ((JavaType)type).isAbstract()) {
                CollectionType collectionType = ((BasicDeserializerFactory)((Object)iterator))._mapAbstractCollectionType((JavaType)type, deserializationConfig);
                if (collectionType == null) {
                    if (((JavaType)type).getTypeHandler() == null) throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Collection type " + type);
                    object = AbstractDeserializer.constructForNonPOJO(beanDescription);
                } else {
                    beanDescription = deserializationConfig.introspectForCreation(collectionType);
                    type = collectionType;
                }
            }
            if (object == null) {
                object = ((BasicDeserializerFactory)((Object)iterator)).findValueInstantiator((DeserializationContext)((Object)jsonDeserializer), beanDescription);
                if (!((ValueInstantiator)object).canCreateUsingDefault()) {
                    if (((JavaType)type).hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer((JavaType)type, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object);
                    }
                    if ((jsonDeserializer = JavaUtilCollectionsDeserializers.findForCollection(jsonDeserializer, (JavaType)type)) != null) {
                        return jsonDeserializer;
                    }
                }
                if (javaType.hasRawClass(String.class)) {
                    StringCollectionDeserializer stringCollectionDeserializer;
                    jsonDeserializer = stringCollectionDeserializer;
                    stringCollectionDeserializer = new StringCollectionDeserializer((JavaType)type, jsonDeserializer2, (ValueInstantiator)object);
                    object = jsonDeserializer;
                } else {
                    CollectionDeserializer collectionDeserializer;
                    jsonDeserializer = collectionDeserializer;
                    collectionDeserializer = new CollectionDeserializer((JavaType)type, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object);
                    object = jsonDeserializer;
                }
            }
        }
        if (!((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) return object;
        Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
        while (iterator.hasNext()) {
            object = ((BeanDeserializerModifier)iterator.next()).modifyCollectionDeserializer(deserializationConfig, (CollectionType)type, beanDescription, (JsonDeserializer<?>)object);
        }
        return object;
    }

    public CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Serializable serializable = ContainerDefaultMappings.findCollectionFallback(javaType);
        if (serializable != null) {
            return (CollectionType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, (Class<?>)serializable, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext jsonDeserializer, CollectionLikeType collectionLikeType, BeanDescription beanDescription) {
        DeserializationContext deserializationContext = jsonDeserializer;
        jsonDeserializer = collectionLikeType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findTypeDeserializer(deserializationConfig, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator))._findCustomCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) != null && ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyCollectionLikeDeserializer(deserializationConfig, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext object, MapType object2, BeanDescription beanDescription) {
        MapType mapType = object2;
        DeserializationConfig deserializationConfig = ((DeserializationContext)object).getConfig();
        Object object3 = mapType.getKeyType();
        Object object4 = mapType.getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)((JavaType)object4).getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)((JavaType)object3).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)object4).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findTypeDeserializer(deserializationConfig, (JavaType)object4);
        }
        if ((object4 = ((BasicDeserializerFactory)((Object)iterator))._findCustomMapDeserializer((MapType)object2, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer)) == null) {
            Class<?> clazz = ((JavaType)object2).getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz)) {
                object4 = clazz == EnumMap.class ? null : ((BasicDeserializerFactory)((Object)iterator)).findValueInstantiator((DeserializationContext)object, beanDescription);
                if (((JavaType)object3).isEnumImplType()) {
                    EnumMapDeserializer enumMapDeserializer;
                    object3 = enumMapDeserializer;
                    enumMapDeserializer = new EnumMapDeserializer((JavaType)object2, (ValueInstantiator)object4, null, jsonDeserializer, typeDeserializer, null);
                    object4 = object3;
                } else {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
            }
            if (object4 == null) {
                if (!((JavaType)object2).isInterface() && !((JavaType)object2).isAbstract()) {
                    object3 = JavaUtilCollectionsDeserializers.findForMap((DeserializationContext)object, (JavaType)object2);
                    if (object3 != null) {
                        return object3;
                    }
                    object4 = object3;
                } else {
                    object3 = ((BasicDeserializerFactory)((Object)iterator))._mapAbstractMapType((JavaType)object2, deserializationConfig);
                    if (object3 != null) {
                        ((JavaType)object3).getRawClass();
                        beanDescription = deserializationConfig.introspectForCreation((JavaType)object3);
                        object2 = object3;
                    } else {
                        if (((JavaType)object2).getTypeHandler() == null) {
                            throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Map type " + object2);
                        }
                        object4 = AbstractDeserializer.constructForNonPOJO(beanDescription);
                    }
                }
                if (object4 == null) {
                    MapDeserializer mapDeserializer;
                    object = ((BasicDeserializerFactory)((Object)iterator)).findValueInstantiator((DeserializationContext)object, beanDescription);
                    object4 = mapDeserializer;
                    mapDeserializer = new MapDeserializer((JavaType)object2, (ValueInstantiator)object, keyDeserializer, jsonDeserializer, typeDeserializer);
                    object = deserializationConfig.getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    object = object == null ? null : ((JsonIgnoreProperties.Value)object).findIgnoredForDeserialization();
                    ((MapDeserializer)object4).setIgnorableProperties((Set<String>)object);
                    object = deserializationConfig.getDefaultPropertyInclusions(Map.class, beanDescription.getClassInfo());
                    object = object == null ? null : ((JsonIncludeProperties.Value)object).getIncluded();
                    ((MapDeserializer)object4).setIncludableProperties((Set<String>)object);
                }
            }
        }
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                object4 = ((BeanDeserializerModifier)iterator.next()).modifyMapDeserializer(deserializationConfig, (MapType)object2, beanDescription, (JsonDeserializer<?>)object4);
            }
        }
        return object4;
    }

    public MapType _mapAbstractMapType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Serializable serializable = ContainerDefaultMappings.findMapFallback(javaType);
        if (serializable != null) {
            return (MapType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, (Class<?>)serializable, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext jsonDeserializer, MapLikeType mapLikeType, BeanDescription beanDescription) {
        DeserializationContext deserializationContext = jsonDeserializer;
        MapLikeType mapLikeType2 = mapLikeType;
        jsonDeserializer = mapLikeType2.getKeyType();
        JavaType javaType = mapLikeType2.getContentType();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Serializable serializable = jsonDeserializer;
        jsonDeserializer = (JsonDeserializer)javaType.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)((JavaType)serializable).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator))._findCustomMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer)) != null && ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyMapLikeDeserializer(deserializationConfig, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext objectArray, JavaType javaType, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = objectArray.getConfig();
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator))._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer == null) {
            if (clazz == Enum.class) {
                return AbstractDeserializer.constructForNonPOJO(beanDescription);
            }
            ValueInstantiator valueInstantiator = ((BasicDeserializerFactory)((Object)iterator))._constructDefaultValueInstantiator((DeserializationContext)objectArray, beanDescription);
            SettableBeanProperty[] settableBeanPropertyArray = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(objectArray.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!((BasicDeserializerFactory)((Object)iterator))._hasCreatorAnnotation((DeserializationContext)objectArray, annotatedMethod)) continue;
                if (annotatedMethod.getParameterCount() == 0) {
                    jsonDeserializer = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                if (!annotatedMethod.getRawReturnType().isAssignableFrom(clazz)) {
                    Serializable serializable = objectArray;
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = annotatedMethod.toString();
                    ((DeserializationContext)serializable).reportBadDefinition(javaType, String.format("Invalid `@JsonCreator` annotated Enum factory method [%s]: needs to return compatible type", objectArray));
                }
                jsonDeserializer = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, settableBeanPropertyArray);
                break;
            }
            if (jsonDeserializer == null) {
                EnumDeserializer enumDeserializer;
                jsonDeserializer = enumDeserializer;
                objectArray = ((BasicDeserializerFactory)((Object)iterator)).constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueAccessor());
                enumDeserializer = new EnumDeserializer((EnumResolver)objectArray, (Boolean)deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
            }
        }
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig jsonDeserializer, JavaType javaType, BeanDescription beanDescription) {
        void var3_4;
        JsonDeserializer<?> jsonDeserializer2;
        void var2_3;
        Class<?> clazz = var2_3.getRawClass();
        jsonDeserializer2 = this._findCustomTreeNodeDeserializer(clazz, (DeserializationConfig)((Object)jsonDeserializer2), (BeanDescription)var3_4);
        if (jsonDeserializer2 != null) {
            return jsonDeserializer2;
        }
        return JsonNodeDeserializer.getDeserializer(clazz);
    }

    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext deserializationContext, ReferenceType referenceType, BeanDescription beanDescription) {
        Object object;
        JsonDeserializer<?> jsonDeserializer = referenceType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((BasicDeserializerFactory)object).findTypeDeserializer(deserializationConfig, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = ((BasicDeserializerFactory)object)._findCustomReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null && referenceType.isTypeOrSubTypeOf(AtomicReference.class)) {
            object = referenceType.getRawClass() == AtomicReference.class ? null : ((BasicDeserializerFactory)object).findValueInstantiator(deserializationContext, beanDescription);
            return new AtomicReferenceDeserializer(referenceType, (ValueInstantiator)object, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && ((BasicDeserializerFactory)object)._factoryConfig.hasDeserializerModifiers()) {
            object = ((BasicDeserializerFactory)object)._factoryConfig.deserializerModifiers().iterator();
            while (object.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)object.next()).modifyReferenceDeserializer(deserializationConfig, referenceType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        void var0_3;
        DeserializationConfig deserializationConfig2 = deserializationConfig;
        Object object = deserializationConfig2.introspectClassAnnotations(javaType.getRawClass()).getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig2.getAnnotationIntrospector().findTypeResolver(deserializationConfig, (AnnotatedClass)object, javaType);
        if (typeResolverBuilder == null && (typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType)) == null) {
            return null;
        }
        object = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedClass)object);
        if (typeResolverBuilder.getDefaultImpl() == null && javaType.isAbstract() && (this = ((BasicDeserializerFactory)this).mapAbstractType(deserializationConfig, javaType)) != null && !((JavaType)this).hasRawClass(javaType.getRawClass())) {
            typeResolverBuilder = typeResolverBuilder.withDefaultImpl(((JavaType)this).getRawClass());
        }
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage((Throwable)var0_3), javaType).withCause((Throwable)var0_3);
    }

    public JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = null;
        KeyDeserializer keyDeserializer = null;
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasKeyDeserializers()) {
            beanDescription = deserializationConfig.introspectClassAnnotations(javaType);
            Iterator<KeyDeserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.keyDeserializers().iterator();
            while (iterator.hasNext() && (keyDeserializer = iterator.next().findKeyDeserializer(javaType, deserializationConfig, beanDescription)) == null) {
            }
        }
        if (keyDeserializer == null) {
            if (beanDescription == null) {
                beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
            }
            if ((keyDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo())) == null) {
                keyDeserializer = javaType.isEnumType() ? super._createEnumKeyDeserializer(deserializationContext, javaType) : StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
            }
        }
        if (keyDeserializer != null && ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                keyDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyKeyDeserializer(deserializationConfig, javaType, keyDeserializer);
            }
        }
        return keyDeserializer;
    }

    @Override
    public boolean hasExplicitDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        String string = clazz.getName();
        if (string.startsWith("java.")) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return NumberDeserializers.find(clazz, string) != null;
            }
            if (!JdkDeserializers.hasDeserializerFor(clazz) && clazz != CLASS_STRING && clazz != Boolean.class && clazz != EnumMap.class && clazz != AtomicReference.class) {
                return DateDeserializers.hasDeserializerFor(clazz);
            }
            return true;
        }
        if (string.startsWith("com.privatefasterxml.")) {
            return JsonNode.class.isAssignableFrom(clazz) || clazz == TokenBuffer.class;
        }
        return OptionalHandlerFactory.instance.hasDeserializerFor(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) {
        void var0_3;
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig.getAnnotationIntrospector().findPropertyTypeResolver(deserializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType);
        }
        DeserializationConfig deserializationConfig2 = deserializationConfig;
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig2, javaType, deserializationConfig2.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType));
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage((Throwable)var0_3), javaType).withCause((Throwable)var0_3);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) {
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig.getAnnotationIntrospector().findPropertyContentTypeResolver(deserializationConfig, annotatedMember, javaType);
        javaType = javaType.getContentType();
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType);
        }
        DeserializationConfig deserializationConfig2 = deserializationConfig;
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig2, javaType, deserializationConfig2.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType));
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext object, JavaType object2, BeanDescription object3) {
        JsonDeserializer<Object> jsonDeserializer;
        Serializable serializable = object2.getRawClass();
        if (serializable != CLASS_OBJECT && serializable != CLASS_SERIALIZABLE) {
            if (serializable != CLASS_STRING && serializable != CLASS_CHAR_SEQUENCE) {
                Object object4 = CLASS_ITERABLE;
                if (serializable == object4) {
                    serializable = ((DeserializationContext)object).getTypeFactory();
                    object2 = ((TypeFactory)serializable).findTypeParameters((JavaType)object2, (Class<?>)object4);
                    object2 = object2 != null && ((JavaType[])object2).length == 1 ? object2[0] : TypeFactory.unknownType();
                    return ((BasicDeserializerFactory)((Object)jsonDeserializer)).createCollectionDeserializer((DeserializationContext)object, ((TypeFactory)serializable).constructCollectionType(Collection.class, (JavaType)object2), (BeanDescription)object3);
                }
                if (serializable == CLASS_MAP_ENTRY) {
                    object3 = object2.containedTypeOrUnknown(0);
                    serializable = object2.containedTypeOrUnknown(1);
                    object4 = (TypeDeserializer)((JavaType)serializable).getTypeHandler();
                    if (object4 == null) {
                        object4 = ((BasicDeserializerFactory)((Object)jsonDeserializer)).findTypeDeserializer(((DeserializationContext)object).getConfig(), (JavaType)serializable);
                    }
                    jsonDeserializer = (JsonDeserializer)((JavaType)serializable).getValueHandler();
                    object = (KeyDeserializer)((JavaType)object3).getValueHandler();
                    return new MapEntryDeserializer((JavaType)object2, (KeyDeserializer)object, jsonDeserializer, (TypeDeserializer)object4);
                }
                Serializable serializable2 = serializable;
                object4 = ((Class)serializable2).getName();
                if (((Class)serializable2).isPrimitive() || ((String)object4).startsWith("java.")) {
                    JsonDeserializer<?> jsonDeserializer2 = NumberDeserializers.find(serializable, (String)object4);
                    if (jsonDeserializer2 == null) {
                        jsonDeserializer2 = DateDeserializers.find(serializable, (String)object4);
                    }
                    if (jsonDeserializer2 != null) {
                        return jsonDeserializer2;
                    }
                }
                if (serializable == TokenBuffer.class) {
                    return new TokenBufferDeserializer();
                }
                if ((jsonDeserializer = ((BasicDeserializerFactory)((Object)jsonDeserializer)).findOptionalStdDeserializer((DeserializationContext)object, (JavaType)object2, (BeanDescription)object3)) != null) {
                    return jsonDeserializer;
                }
                return JdkDeserializers.find((DeserializationContext)object, serializable, (String)object4);
            }
            return StringDeserializer.instance;
        }
        object = ((DeserializationContext)object).getConfig();
        if (((BasicDeserializerFactory)((Object)jsonDeserializer))._factoryConfig.hasAbstractTypeResolvers()) {
            BasicDeserializerFactory basicDeserializerFactory = jsonDeserializer;
            jsonDeserializer = basicDeserializerFactory._findRemappedType((DeserializationConfig)object, List.class);
            object = basicDeserializerFactory._findRemappedType((DeserializationConfig)object, Map.class);
        } else {
            object = null;
            jsonDeserializer = object;
        }
        return new UntypedObjectDeserializer((JavaType)((Object)jsonDeserializer), (JavaType)object);
    }

    public JavaType _findRemappedType(DeserializationConfig deserializationConfig, Class<?> clazz) {
        if ((serializable = ((BasicDeserializerFactory)serializable).mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz))) == null || ((JavaType)serializable).hasRawClass(clazz)) {
            Serializable serializable = null;
        }
        return serializable;
    }

    public JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer = ((Deserializers)iterator.next()).findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer2 = ((Deserializers)iterator.next()).findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<Object> jsonDeserializer = ((Deserializers)iterator.next()).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer2 = ((Deserializers)iterator.next()).findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer2 = ((Deserializers)iterator.next()).findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer2 = ((Deserializers)iterator.next()).findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer = ((Deserializers)iterator.next()).findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer2 = ((Deserializers)iterator.next()).findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        Iterator<Deserializers> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializers().iterator();
        while (iterator.hasNext()) {
            JsonDeserializer<?> jsonDeserializer2 = ((Deserializers)iterator.next()).findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    public JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    public KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    public JsonDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findContentDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    public JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (javaType.isMapLikeType() && javaType.getKeyType() != null && (jsonDeserializer = deserializationContext.keyDeserializerInstance(annotatedMember, annotationIntrospector.findKeyDeserializer(annotatedMember))) != null) {
            javaType = ((MapLikeType)javaType).withKeyValueHandler(jsonDeserializer);
            ((MapLikeType)javaType).getKeyType();
        }
        if (javaType.hasContentType()) {
            jsonDeserializer = deserializationContext.deserializerInstance(annotatedMember, annotationIntrospector.findContentDeserializer(annotatedMember));
            if (jsonDeserializer != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
            if ((jsonDeserializer = ((BasicDeserializerFactory)this).findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(jsonDeserializer);
            }
        }
        if ((this = ((BasicDeserializerFactory)this).findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(this);
        }
        return annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
    }

    public EnumResolver constructEnumResolver(Class<?> clazz, DeserializationConfig deserializationConfig, AnnotatedMember annotatedMember) {
        if (annotatedMember != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(annotatedMember.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUsingMethod(deserializationConfig, clazz, annotatedMember);
        }
        return EnumResolver.constructFor(deserializationConfig, clazz);
    }

    public boolean _hasCreatorAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector();
        if (object != null) {
            return (object = ((AnnotationIntrospector)object).findCreatorAnnotation(deserializationContext.getConfig(), annotated)) != null && object != JsonCreator.Mode.DISABLED;
        }
        return false;
    }

    @Deprecated
    public JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        Serializable serializable = deserializationContext.getAnnotationIntrospector();
        if (serializable == null) {
            return javaType;
        }
        return ((AnnotationIntrospector)serializable).refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
    }

    @Deprecated
    public JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) {
        return this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
    }

    @Deprecated
    public AnnotatedMethod _findJsonValueFor(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        return deserializationConfig.introspect(javaType).findJsonValueMethod();
    }

    public static class CreatorCollectionState {
        public final DeserializationContext context;
        public final BeanDescription beanDesc;
        public final VisibilityChecker<?> vchecker;
        public final CreatorCollector creators;
        public final Map<AnnotatedWithParams, BeanPropertyDefinition[]> creatorParams;
        private List<CreatorCandidate> _implicitFactoryCandidates;
        private int _explicitFactoryCount;
        private List<CreatorCandidate> _implicitConstructorCandidates;
        private int _explicitConstructorCount;

        public CreatorCollectionState(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) {
            this.context = deserializationContext;
            this.beanDesc = beanDescription;
            this.vchecker = visibilityChecker;
            this.creators = creatorCollector;
            this.creatorParams = map;
        }

        public AnnotationIntrospector annotationIntrospector() {
            return this.context.getAnnotationIntrospector();
        }

        public void addImplicitFactoryCandidate(CreatorCandidate creatorCandidate) {
            if (this._implicitFactoryCandidates == null) {
                LinkedList<CreatorCandidate> linkedList;
                LinkedList<CreatorCandidate> linkedList2 = linkedList;
                linkedList = new LinkedList<CreatorCandidate>();
                this._implicitFactoryCandidates = linkedList2;
            }
            this._implicitFactoryCandidates.add(creatorCandidate);
        }

        public void increaseExplicitFactoryCount() {
            ++this._explicitFactoryCount;
        }

        public boolean hasExplicitFactories() {
            return this._explicitFactoryCount > 0;
        }

        public boolean hasImplicitFactoryCandidates() {
            return this._implicitFactoryCandidates != null;
        }

        public List<CreatorCandidate> implicitFactoryCandidates() {
            return this._implicitFactoryCandidates;
        }

        public void addImplicitConstructorCandidate(CreatorCandidate creatorCandidate) {
            if (this._implicitConstructorCandidates == null) {
                LinkedList<CreatorCandidate> linkedList;
                LinkedList<CreatorCandidate> linkedList2 = linkedList;
                linkedList = new LinkedList<CreatorCandidate>();
                this._implicitConstructorCandidates = linkedList2;
            }
            this._implicitConstructorCandidates.add(creatorCandidate);
        }

        public void increaseExplicitConstructorCount() {
            ++this._explicitConstructorCount;
        }

        public boolean hasExplicitConstructors() {
            return this._explicitConstructorCount > 0;
        }

        public boolean hasImplicitConstructorCandidates() {
            return this._implicitConstructorCandidates != null;
        }

        public List<CreatorCandidate> implicitConstructorCandidates() {
            return this._implicitConstructorCandidates;
        }
    }

    public static class ContainerDefaultMappings {
        static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
        static final HashMap<String, Class<? extends Map>> _mapFallbacks;

        public static Class<?> findCollectionFallback(JavaType javaType) {
            return _collectionFallbacks.get(javaType.getRawClass().getName());
        }

        public static Class<?> findMapFallback(JavaType javaType) {
            return _mapFallbacks.get(javaType.getRawClass().getName());
        }

        static {
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put(Collection.class.getName(), ArrayList.class);
            hashMap.put(List.class.getName(), ArrayList.class);
            hashMap.put(Set.class.getName(), HashSet.class);
            hashMap.put(SortedSet.class.getName(), TreeSet.class);
            hashMap.put(Queue.class.getName(), LinkedList.class);
            hashMap.put(AbstractList.class.getName(), ArrayList.class);
            hashMap.put(AbstractSet.class.getName(), HashSet.class);
            hashMap.put(Deque.class.getName(), LinkedList.class);
            hashMap.put(NavigableSet.class.getName(), TreeSet.class);
            _collectionFallbacks = hashMap;
            HashMap<String, Class> hashMap2 = new HashMap<String, Class>();
            hashMap2.put(Map.class.getName(), LinkedHashMap.class);
            hashMap2.put(AbstractMap.class.getName(), LinkedHashMap.class);
            hashMap2.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
            hashMap2.put(SortedMap.class.getName(), TreeMap.class);
            hashMap2.put(NavigableMap.class.getName(), TreeMap.class);
            hashMap2.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
            _mapFallbacks = hashMap2;
        }
    }
}

