/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerators;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.core.JacksonException;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.CreatorProperty;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.privatefasterxml.jackson.databind.deser.SettableAnyProperty;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.privatefasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.privatefasterxml.jackson.databind.deser.impl.InnerClassProperty;
import com.privatefasterxml.jackson.databind.deser.impl.ManagedReferenceProperty;
import com.privatefasterxml.jackson.databind.deser.impl.MergingSettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReferenceProperty;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.privatefasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.privatefasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.privatefasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.privatefasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.privatefasterxml.jackson.databind.deser.impl.ValueInjector;
import com.privatefasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.exc.IgnoredPropertyException;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.ClassKey;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import com.privatefasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.privatefasterxml.jackson.databind.util.NameTransformer;
import com.privatefasterxml.jackson.databind.util.NativeImageUtil;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BeanDeserializerBase
extends StdDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer,
ValueInstantiator.Gettable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PropertyName TEMP_PROPERTY_NAME = new PropertyName("#temporary-name");
    protected final JavaType _beanType;
    protected final JsonFormat.Shape _serializationShape;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected JsonDeserializer<Object> _arrayDelegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected boolean _nonStandardCreation;
    protected boolean _vanillaProcessing;
    protected final BeanPropertyMap _beanProperties;
    protected final ValueInjector[] _injectables;
    protected SettableAnyProperty _anySetter;
    protected final Set<String> _ignorableProps;
    protected final Set<String> _includableProps;
    protected final boolean _ignoreAllUnknown;
    protected final boolean _needViewProcesing;
    protected final Map<String, SettableBeanProperty> _backRefs;
    protected transient HashMap<ClassKey, JsonDeserializer<Object>> _subDeserializers;
    protected UnwrappedPropertyHandler _unwrappedPropertyHandler;
    protected ExternalTypeHandler _externalTypeIdHandler;
    protected final ObjectIdReader _objectIdReader;

    public BeanDeserializerBase(BeanDeserializerBuilder object, BeanDescription beanDescription, BeanPropertyMap object2, Map<String, SettableBeanProperty> object3, Set<String> set, boolean bl, Set<String> set2, boolean bl2) {
        BeanPropertyMap beanPropertyMap = object2;
        BeanDeserializerBase beanDeserializerBase = this;
        super(beanDescription.getType());
        this._beanType = beanDescription.getType();
        object2 = ((BeanDeserializerBuilder)object).getValueInstantiator();
        beanDeserializerBase._valueInstantiator = object2;
        beanDeserializerBase._delegateDeserializer = null;
        beanDeserializerBase._arrayDelegateDeserializer = null;
        beanDeserializerBase._propertyBasedCreator = null;
        this._beanProperties = beanPropertyMap;
        this._backRefs = object3;
        this._ignorableProps = set;
        this._ignoreAllUnknown = bl;
        this._includableProps = set2;
        this._anySetter = ((BeanDeserializerBuilder)object).getAnySetter();
        object3 = ((BeanDeserializerBuilder)object).getInjectables();
        object3 = object3 != null && !object3.isEmpty() ? object3.toArray(new ValueInjector[object3.size()]) : null;
        this._injectables = object3;
        object = ((BeanDeserializerBuilder)object).getObjectIdReader();
        this._objectIdReader = object;
        boolean bl3 = this._unwrappedPropertyHandler != null || ((ValueInstantiator)object2).canCreateUsingDelegate() || ((ValueInstantiator)object2).canCreateFromObjectWith() || !((ValueInstantiator)object2).canCreateUsingDefault();
        this._nonStandardCreation = bl3;
        this._serializationShape = beanDescription.findExpectedFormat(null).getShape();
        this._needViewProcesing = bl2;
        boolean bl4 = !this._nonStandardCreation && object3 == null && !bl2 && object == null;
        this._vanillaProcessing = bl4;
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase) {
        this(beanDeserializerBase, beanDeserializerBase._ignoreAllUnknown);
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, boolean bl) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._beanProperties = beanDeserializerBase._beanProperties;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = bl;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        boolean bl = nameTransformer != null || beanDeserializerBase._ignoreAllUnknown;
        this._ignoreAllUnknown = bl;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        UnwrappedPropertyHandler unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        if (nameTransformer != null) {
            if (unwrappedPropertyHandler != null) {
                unwrappedPropertyHandler = unwrappedPropertyHandler.renameAll(nameTransformer);
            }
            this._beanProperties = beanDeserializerBase._beanProperties.renameAll(nameTransformer);
        } else {
            this._beanProperties = beanDeserializerBase._beanProperties;
        }
        BeanDeserializerBase beanDeserializerBase2 = this;
        this._unwrappedPropertyHandler = unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        beanDeserializerBase2._serializationShape = beanDeserializerBase._serializationShape;
        beanDeserializerBase2._vanillaProcessing = false;
    }

    public BeanDeserializerBase(BeanDeserializerBase serializable, ObjectIdReader objectIdReader) {
        BeanDeserializerBase beanDeserializerBase = serializable;
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._objectIdReader = objectIdReader;
        if (objectIdReader == null) {
            BeanDeserializerBase beanDeserializerBase2 = serializable;
            this._beanProperties = beanDeserializerBase2._beanProperties;
            this._vanillaProcessing = beanDeserializerBase2._vanillaProcessing;
        } else {
            ObjectIdValueProperty objectIdValueProperty;
            BeanDeserializerBase beanDeserializerBase3 = serializable;
            serializable = objectIdValueProperty;
            objectIdValueProperty = new ObjectIdValueProperty(objectIdReader, PropertyMetadata.STD_REQUIRED);
            this._beanProperties = beanDeserializerBase3._beanProperties.withProperty((SettableBeanProperty)serializable);
            this._vanillaProcessing = false;
        }
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, Set<String> set, Set<String> set2) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = set;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = set2;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._beanProperties = beanDeserializerBase._beanProperties.withoutProperties(set, set2);
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, BeanPropertyMap beanPropertyMap) {
        super(beanDeserializerBase._beanType);
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._arrayDelegateDeserializer = beanDeserializerBase._arrayDelegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._beanProperties = beanPropertyMap;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._includableProps = beanDeserializerBase._includableProps;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
    }

    @Deprecated
    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, Set<String> set) {
        BeanDeserializerBase beanDeserializerBase2 = set2;
        Set<String> set2 = beanDeserializerBase._includableProps;
        beanDeserializerBase2(beanDeserializerBase, set, set2);
    }

    private JsonDeserializer<Object> _findDelegateDeserializer(DeserializationContext object, JavaType javaType, AnnotatedWithParams object2) {
        BeanProperty.Std std;
        BeanProperty.Std std2 = std;
        Object object3 = PropertyMetadata.STD_OPTIONAL;
        std = new BeanProperty.Std(TEMP_PROPERTY_NAME, javaType, null, (AnnotatedMember)object2, (PropertyMetadata)object3);
        object2 = (TypeDeserializer)javaType.getTypeHandler();
        if (object2 == null) {
            object2 = ((DeserializationContext)object).getConfig().findTypeDeserializer(javaType);
        }
        JsonDeserializer jsonDeserializer = (object3 = (JsonDeserializer)javaType.getValueHandler()) == null ? jsonDeserializer.findDeserializer((DeserializationContext)object, javaType, std2) : ((DeserializationContext)object).handleSecondaryContextualization((JsonDeserializer<?>)object3, std2, javaType);
        if (object2 != null) {
            object = ((TypeDeserializer)object2).forProperty(std2);
            return new TypeWrappedDeserializer((TypeDeserializer)object, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    private Throwable throwOrReturnThrowable(Throwable throwable, DeserializationContext deserializationContext) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl) {
            ClassUtil.throwIfRTE(throwable);
        }
        return throwable;
    }

    @Override
    public abstract JsonDeserializer<Object> unwrappingDeserializer(NameTransformer var1);

    public abstract BeanDeserializerBase withObjectIdReader(ObjectIdReader var1);

    public abstract BeanDeserializerBase withByNameInclusion(Set<String> var1, Set<String> var2);

    public abstract BeanDeserializerBase withIgnoreAllUnknown(boolean var1);

    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        throw new UnsupportedOperationException("Class " + this.getClass().getName() + " does not override `withBeanProperties()`, needs to");
    }

    public abstract BeanDeserializerBase asArrayDeserializer();

    @Deprecated
    public BeanDeserializerBase withIgnorableProperties(Set<String> set) {
        return this.withByNameInclusion(set, this._includableProps);
    }

    @Override
    public void resolve(DeserializationContext object) {
        Object object2;
        Object object32;
        SettableBeanProperty[] settableBeanPropertyArray;
        ExternalTypeHandler.Builder builder = null;
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            settableBeanPropertyArray = this._valueInstantiator.getFromObjectArguments(((DeserializationContext)object).getConfig());
            if (this._ignorableProps != null || this._includableProps != null) {
                int n2 = settableBeanPropertyArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!IgnorePropertiesUtil.shouldIgnore(settableBeanPropertyArray[i2].getName(), this._ignorableProps, this._includableProps)) continue;
                    settableBeanPropertyArray[i2].markAsIgnorable();
                }
            }
        } else {
            settableBeanPropertyArray = null;
        }
        UnwrappedPropertyHandler unwrappedPropertyHandler = null;
        for (Object object32 : this._beanProperties) {
            if (((SettableBeanProperty)object32).hasValueDeserializer()) continue;
            object2 = this.findConvertingDeserializer((DeserializationContext)object, (SettableBeanProperty)object32);
            if (object2 == null) {
                object2 = ((DeserializationContext)object).findNonContextualValueDeserializer(((SettableBeanProperty)object32).getType());
            }
            object2 = ((SettableBeanProperty)object32).withValueDeserializer((JsonDeserializer<?>)object2);
            this._replaceProperty(this._beanProperties, settableBeanPropertyArray, (SettableBeanProperty)object32, (SettableBeanProperty)object2);
        }
        for (Object object32 : this._beanProperties) {
            JsonDeserializer<Object> jsonDeserializer;
            SettableBeanProperty settableBeanProperty = object32;
            object2 = settableBeanProperty.getValueDeserializer();
            JsonDeserializer<Object> jsonDeserializer2 = settableBeanProperty.getType();
            object2 = ((SettableBeanProperty)object32).withValueDeserializer(((DeserializationContext)object).handlePrimaryContextualization((JsonDeserializer<?>)object2, (BeanProperty)object32, (JavaType)((Object)jsonDeserializer2)));
            if (!((object2 = this._resolveManagedReferenceProperty((DeserializationContext)object, (SettableBeanProperty)object2)) instanceof ManagedReferenceProperty)) {
                object2 = this._resolvedObjectIdProperty((DeserializationContext)object, (SettableBeanProperty)object2);
            }
            if ((jsonDeserializer2 = this._findPropertyUnwrapper((DeserializationContext)object, (SettableBeanProperty)object2)) != null && (jsonDeserializer2 = (jsonDeserializer = ((SettableBeanProperty)object2).getValueDeserializer()).unwrappingDeserializer((NameTransformer)((Object)jsonDeserializer2))) != jsonDeserializer && jsonDeserializer2 != null) {
                object32 = ((SettableBeanProperty)object2).withValueDeserializer(jsonDeserializer2);
                if (unwrappedPropertyHandler == null) {
                    UnwrappedPropertyHandler unwrappedPropertyHandler2;
                    unwrappedPropertyHandler = unwrappedPropertyHandler2;
                    unwrappedPropertyHandler2 = new UnwrappedPropertyHandler();
                }
                unwrappedPropertyHandler.addProperty((SettableBeanProperty)object32);
                this._beanProperties.remove((SettableBeanProperty)object32);
                continue;
            }
            jsonDeserializer2 = ((ConcreteBeanPropertyBase)object2).getMetadata();
            object2 = this._resolveMergeAndNullSettings((DeserializationContext)object, (SettableBeanProperty)object2, (PropertyMetadata)((Object)jsonDeserializer2));
            if ((object2 = this._resolveInnerClassValuedProperty((DeserializationContext)object, (SettableBeanProperty)object2)) != object32) {
                this._replaceProperty(this._beanProperties, settableBeanPropertyArray, (SettableBeanProperty)object32, (SettableBeanProperty)object2);
            }
            if (!((SettableBeanProperty)object2).hasValueTypeDeserializer() || ((TypeDeserializer)(object32 = ((SettableBeanProperty)object2).getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            if (builder == null) {
                builder = ExternalTypeHandler.builder(this._beanType);
            }
            builder.addExternal((SettableBeanProperty)object2, (TypeDeserializer)object32);
            this._beanProperties.remove((SettableBeanProperty)object2);
        }
        Object object4 = this._anySetter;
        if (object4 != null && !((SettableAnyProperty)object4).hasValueDeserializer()) {
            SettableAnyProperty settableAnyProperty = this._anySetter;
            object4 = settableAnyProperty.getType();
            object32 = this._anySetter.getProperty();
            this._anySetter = settableAnyProperty.withValueDeserializer(this.findDeserializer((DeserializationContext)object, (JavaType)object4, (BeanProperty)object32));
        }
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            object4 = this._valueInstantiator.getDelegateType(((DeserializationContext)object).getConfig());
            if (object4 == null) {
                object32 = this._beanType;
                Object[] objectArray = new Object[2];
                object2 = objectArray;
                objectArray[0] = ClassUtil.getTypeDescription((JavaType)object32);
                objectArray[1] = ClassUtil.classNameOf(this._valueInstantiator);
                ((DeserializationContext)object).reportBadDefinition((JavaType)object32, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", (Object[])object2));
            }
            object32 = this._valueInstantiator.getDelegateCreator();
            this._delegateDeserializer = this._findDelegateDeserializer((DeserializationContext)object, (JavaType)object4, (AnnotatedWithParams)object32);
        }
        if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
            object4 = this._valueInstantiator.getArrayDelegateType(((DeserializationContext)object).getConfig());
            if (object4 == null) {
                object32 = this._beanType;
                Object[] objectArray = new Object[2];
                object2 = objectArray;
                objectArray[0] = ClassUtil.getTypeDescription((JavaType)object32);
                objectArray[1] = ClassUtil.classNameOf(this._valueInstantiator);
                ((DeserializationContext)object).reportBadDefinition((JavaType)object32, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", (Object[])object2));
            }
            object32 = this._valueInstantiator.getArrayDelegateCreator();
            this._arrayDelegateDeserializer = this._findDelegateDeserializer((DeserializationContext)object, (JavaType)object4, (AnnotatedWithParams)object32);
        }
        if (settableBeanPropertyArray != null) {
            DeserializationContext deserializationContext = object;
            object = this._valueInstantiator;
            object4 = this._beanProperties;
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, (ValueInstantiator)object, settableBeanPropertyArray, (BeanPropertyMap)object4);
        }
        if (builder != null) {
            this._externalTypeIdHandler = builder.build(this._beanProperties);
            this._nonStandardCreation = true;
        }
        this._unwrappedPropertyHandler = unwrappedPropertyHandler;
        if (unwrappedPropertyHandler != null) {
            this._nonStandardCreation = true;
        }
        boolean bl = this._vanillaProcessing && !this._nonStandardCreation;
        this._vanillaProcessing = bl;
    }

    public void _replaceProperty(BeanPropertyMap beanPropertyMap, SettableBeanProperty[] settableBeanPropertyArray, SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        beanPropertyMap.replace(settableBeanProperty, settableBeanProperty2);
        if (settableBeanPropertyArray != null) {
            int n2 = settableBeanPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (settableBeanPropertyArray[i2] != settableBeanProperty) continue;
                settableBeanPropertyArray[i2] = settableBeanProperty2;
                return;
            }
        }
    }

    public JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext serializable, SettableBeanProperty object) {
        Object object2 = serializable.getAnnotationIntrospector();
        if (object2 != null && (object2 = ((AnnotationIntrospector)object2).findDeserializationConverter(((SettableBeanProperty)object).getMember())) != null) {
            DeserializationContext deserializationContext = serializable;
            object2 = deserializationContext.converterInstance(((SettableBeanProperty)object).getMember(), object2);
            serializable = object2.getInputType(serializable.getTypeFactory());
            object = deserializationContext.findNonContextualValueDeserializer((JavaType)serializable);
            return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)object2, (JavaType)serializable, (JsonDeserializer<?>)object);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext serializable, BeanProperty object) {
        Object object2;
        Object object3 = this._objectIdReader;
        Serializable serializable2 = ((DeserializationContext)serializable).getAnnotationIntrospector();
        AnnotatedMember annotatedMember = StdDeserializer._neitherNull(object, serializable2) ? object.getMember() : null;
        if (annotatedMember != null && (object2 = serializable2.findObjectIdInfo(annotatedMember)) != null) {
            ObjectIdGenerator objectIdGenerator;
            SettableBeanProperty settableBeanProperty;
            object3 = serializable2.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object2);
            object2 = ((ObjectIdInfo)object3).getGeneratorType();
            ObjectIdResolver objectIdResolver = ((DatabindContext)((Object)serializable)).objectIdResolverInstance(annotatedMember, (ObjectIdInfo)object3);
            if (object2 == ObjectIdGenerators.PropertyGenerator.class) {
                PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator;
                object2 = ((ObjectIdInfo)object3).getPropertyName();
                settableBeanProperty = this.findProperty((PropertyName)object2);
                if (settableBeanProperty == null) {
                    Serializable serializable3 = serializable;
                    Object[] objectArray = new Object[2];
                    serializable = objectArray;
                    serializable[0] = ClassUtil.nameOf(this.handledType());
                    objectArray[1] = ClassUtil.name((PropertyName)object2);
                    return (JsonDeserializer)((DeserializationContext)serializable3).reportBadDefinition(this._beanType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", (Object[])serializable));
                }
                object2 = settableBeanProperty.getType();
                objectIdGenerator = propertyBasedObjectIdGenerator;
                propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(((ObjectIdInfo)object3).getScope());
            } else {
                Serializable serializable4 = serializable;
                object2 = ((DeserializationContext)serializable4).constructType((Class<?>)object2);
                object2 = ((DeserializationContext)serializable4).getTypeFactory().findTypeParameters((JavaType)object2, ObjectIdGenerator.class)[0];
                settableBeanProperty = null;
                objectIdGenerator = ((DatabindContext)((Object)serializable)).objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object3);
            }
            JsonDeserializer<Object> jsonDeserializer = object3;
            object3 = ((DeserializationContext)serializable).findRootValueDeserializer((JavaType)object2);
            object3 = ObjectIdReader.construct((JavaType)object2, ((ObjectIdInfo)((Object)jsonDeserializer)).getPropertyName(), objectIdGenerator, object3, settableBeanProperty, objectIdResolver);
        }
        object3 = object3 != null && object3 != this._objectIdReader ? this.withObjectIdReader((ObjectIdReader)object3) : this;
        if (annotatedMember != null) {
            object3 = this._handleByNameInclusion((DeserializationContext)serializable, (AnnotationIntrospector)serializable2, (BeanDeserializerBase)object3, annotatedMember);
        }
        BeanDeserializerBase beanDeserializerBase = this;
        serializable2 = beanDeserializerBase.handledType();
        serializable = beanDeserializerBase.findFormatOverrides((DeserializationContext)serializable, (BeanProperty)object, (Class<?>)serializable2);
        object = null;
        if (serializable != null) {
            if (((JsonFormat.Value)serializable).hasShape()) {
                object = ((JsonFormat.Value)serializable).getShape();
            }
            if ((serializable = ((JsonFormat.Value)serializable).getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) != null && (serializable = ((BeanPropertyMap)(serializable2 = this._beanProperties)).withCaseInsensitivity((Boolean)serializable)) != serializable2) {
                object3 = ((BeanDeserializerBase)object3).withBeanProperties((BeanPropertyMap)serializable);
            }
        }
        if (object == null) {
            object = this._serializationShape;
        }
        if (object == JsonFormat.Shape.ARRAY) {
            object3 = ((BeanDeserializerBase)object3).asArrayDeserializer();
        }
        return object3;
    }

    public BeanDeserializerBase _handleByNameInclusion(DeserializationContext object, AnnotationIntrospector annotationIntrospector, BeanDeserializerBase beanDeserializerBase, AnnotatedMember annotatedMember) {
        Object object2 = annotationIntrospector.findPropertyIgnoralByName((MapperConfig<?>)(object = ((DeserializationContext)object).getConfig()), annotatedMember);
        if (((JsonIgnoreProperties.Value)object2).getIgnoreUnknown() && !((BeanDeserializerBase)((Object)hashSet))._ignoreAllUnknown) {
            beanDeserializerBase = beanDeserializerBase.withIgnoreAllUnknown(true);
        }
        HashSet<String> hashSet = ((JsonIgnoreProperties.Value)object2).findIgnoredForDeserialization();
        object2 = beanDeserializerBase._ignorableProps;
        if (hashSet.isEmpty()) {
            hashSet = object2;
        } else if (object2 != null && !object2.isEmpty()) {
            HashSet<String> hashSet2;
            HashSet<String> hashSet3 = hashSet2;
            new HashSet<String>((Collection<String>)object2).addAll((Collection<String>)hashSet);
            hashSet = hashSet3;
        }
        Set<String> set = object2;
        object2 = beanDeserializerBase._includableProps;
        object = IgnorePropertiesUtil.combineNamesToInclude(object2, annotationIntrospector.findPropertyInclusionByName((MapperConfig<?>)object, annotatedMember).getIncluded());
        if (hashSet != set || object != object2) {
            beanDeserializerBase = beanDeserializerBase.withByNameInclusion(hashSet, (Set<String>)object);
        }
        return beanDeserializerBase;
    }

    public SettableBeanProperty _resolveManagedReferenceProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Object[] objectArray;
        String string = settableBeanProperty.getManagedReferenceName();
        if (string == null) {
            return settableBeanProperty;
        }
        SettableBeanProperty settableBeanProperty2 = settableBeanProperty.getValueDeserializer().findBackReference(string);
        if (settableBeanProperty2 == null) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = ClassUtil.name(string);
            objectArray2[1] = ClassUtil.getTypeDescription(settableBeanProperty.getType());
            return (SettableBeanProperty)deserializationContext.reportBadDefinition(objectArray._beanType, String.format("Cannot handle managed/back reference %s: no back reference property found from type %s", objectArray));
        }
        JavaType javaType = objectArray._beanType;
        JavaType javaType2 = settableBeanProperty2.getType();
        boolean bl = settableBeanProperty.getType().isContainerType();
        if (!javaType2.getRawClass().isAssignableFrom(javaType.getRawClass())) {
            Object[] objectArray3 = new Object[3];
            objectArray = objectArray3;
            objectArray[0] = ClassUtil.name(string);
            objectArray[1] = ClassUtil.getTypeDescription(javaType2);
            objectArray3[2] = javaType.getRawClass().getName();
            deserializationContext.reportBadDefinition(objectArray._beanType, String.format("Cannot handle managed/back reference %s: back reference type (%s) not compatible with managed type (%s)", objectArray));
        }
        return new ManagedReferenceProperty(settableBeanProperty, string, settableBeanProperty2, bl);
    }

    public SettableBeanProperty _resolvedObjectIdProperty(DeserializationContext jsonDeserializer, SettableBeanProperty settableBeanProperty) {
        SettableBeanProperty settableBeanProperty2 = settableBeanProperty;
        ObjectIdInfo objectIdInfo = settableBeanProperty2.getObjectIdInfo();
        jsonDeserializer = settableBeanProperty2.getValueDeserializer();
        jsonDeserializer = jsonDeserializer == null ? null : jsonDeserializer.getObjectIdReader();
        if (objectIdInfo == null && jsonDeserializer == null) {
            return settableBeanProperty;
        }
        return new ObjectIdReferenceProperty(settableBeanProperty, objectIdInfo);
    }

    public NameTransformer _findPropertyUnwrapper(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Object object = settableBeanProperty.getMember();
        if (object != null && (object = deserializationContext.getAnnotationIntrospector().findUnwrappingNameTransformer((AnnotatedMember)object)) != null) {
            if (settableBeanProperty instanceof CreatorProperty) {
                JavaType javaType = objectArray2.getValueType();
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = settableBeanProperty.getName();
                deserializationContext.reportBadDefinition(javaType, String.format("Cannot define Creator property \"%s\" as `@JsonUnwrapped`: combination not yet supported", objectArray2));
            }
            return object;
        }
        return null;
    }

    public SettableBeanProperty _resolveInnerClassValuedProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Class<?> clazz;
        JsonDeserializer<Object> jsonDeserializer = settableBeanProperty.getValueDeserializer();
        if (jsonDeserializer instanceof BeanDeserializerBase && !((BeanDeserializerBase)jsonDeserializer).getValueInstantiator().canCreateUsingDefault() && (clazz = ClassUtil.getOuterClass(jsonDeserializer = settableBeanProperty.getType().getRawClass())) != null && clazz == this._beanType.getRawClass()) {
            for (Constructor<?> constructor : ((Class)((Object)jsonDeserializer)).getConstructors()) {
                if (constructor.getParameterCount() != 1 || !clazz.equals(constructor.getParameterTypes()[0])) continue;
                if (deserializationContext.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(constructor, deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return new InnerClassProperty(settableBeanProperty, constructor);
            }
        }
        return settableBeanProperty;
    }

    /*
     * WARNING - void declaration
     */
    public SettableBeanProperty _resolveMergeAndNullSettings(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty, PropertyMetadata propertyMetadata) {
        NullValueProvider nullValueProvider;
        void var1_2;
        SettableBeanProperty settableBeanProperty2;
        void var3_4;
        Object object = var3_4.getMergeInfo();
        if (object != null) {
            JsonDeserializer<Object> jsonDeserializer = settableBeanProperty2.getValueDeserializer();
            Boolean bl = jsonDeserializer.supportsUpdate(var1_2.getConfig());
            if (bl == null) {
                if (((PropertyMetadata.MergeInfo)object).fromDefaults) {
                    return settableBeanProperty2;
                }
            } else if (!bl.booleanValue()) {
                if (!((PropertyMetadata.MergeInfo)object).fromDefaults) {
                    var1_2.handleBadMerge(jsonDeserializer);
                }
                return settableBeanProperty2;
            }
            object = ((PropertyMetadata.MergeInfo)object).getter;
            ((AnnotatedMember)object).fixAccess(var1_2.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            if (!(settableBeanProperty2 instanceof SetterlessProperty)) {
                settableBeanProperty2 = MergingSettableBeanProperty.construct(settableBeanProperty2, (AnnotatedMember)object);
            }
        }
        if ((nullValueProvider = this.findValueNullProvider((DeserializationContext)var1_2, settableBeanProperty2, (PropertyMetadata)var3_4)) != null) {
            settableBeanProperty2 = settableBeanProperty2.withNullProvider(nullValueProvider);
        }
        return settableBeanProperty2;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        try {
            return this._valueInstantiator.createUsingDefault(deserializationContext);
        }
        catch (IOException iOException) {
            return ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    public boolean isCaseInsensitive() {
        return this._beanProperties.isCaseInsensitive();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public Class<?> handledType() {
        return this._beanType.getRawClass();
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public boolean hasProperty(String string) {
        return this._beanProperties.find(string) != null;
    }

    public boolean hasViews() {
        return this._needViewProcesing;
    }

    public int getPropertyCount() {
        return this._beanProperties.size();
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        ArrayList arrayList;
        BeanDeserializerBase beanDeserializerBase = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        Iterator<SettableBeanProperty> iterator = beanDeserializerBase._beanProperties.iterator();
        while (iterator.hasNext()) {
            ((ArrayList)serializable).add(iterator.next().getName());
        }
        return serializable;
    }

    @Deprecated
    public final Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._beanType;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    public Iterator<SettableBeanProperty> properties() {
        Serializable serializable = ((BeanDeserializerBase)serializable)._beanProperties;
        if (serializable != null) {
            return ((BeanPropertyMap)serializable).iterator();
        }
        throw new IllegalStateException("Can only call after BeanDeserializer has been resolved");
    }

    public Iterator<SettableBeanProperty> creatorProperties() {
        PropertyBasedCreator propertyBasedCreator = ((BeanDeserializerBase)((Object)propertyBasedCreator))._propertyBasedCreator;
        if (propertyBasedCreator == null) {
            return Collections.emptyList().iterator();
        }
        return propertyBasedCreator.properties().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this.findProperty(propertyName.getSimpleName());
    }

    public SettableBeanProperty findProperty(String string) {
        Serializable serializable = ((BeanDeserializerBase)this)._beanProperties;
        serializable = serializable == null ? null : serializable.find(string);
        if (serializable == null && (this = ((BeanDeserializerBase)this)._propertyBasedCreator) != null) {
            serializable = ((PropertyBasedCreator)this).findCreatorProperty(string);
        }
        return serializable;
    }

    public SettableBeanProperty findProperty(int n2) {
        Serializable serializable = ((BeanDeserializerBase)this)._beanProperties;
        serializable = serializable == null ? null : serializable.find(n2);
        if (serializable == null && (this = ((BeanDeserializerBase)this)._propertyBasedCreator) != null) {
            serializable = ((PropertyBasedCreator)this).findCreatorProperty(n2);
        }
        return serializable;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        Map<String, SettableBeanProperty> map = ((BeanDeserializerBase)((Object)map))._backRefs;
        if (map == null) {
            return null;
        }
        return (SettableBeanProperty)map.get(string);
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public void replaceProperty(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        this._beanProperties.replace(settableBeanProperty, settableBeanProperty2);
    }

    public abstract Object deserializeFromObject(JsonParser var1, DeserializationContext var2);

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        if (this._objectIdReader != null) {
            Object object;
            if (jsonParser.canReadObjectId() && (object = jsonParser.getObjectId()) != null) {
                return this._handleTypedObjectId(jsonParser, deserializationContext, typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext), object);
            }
            object = jsonParser.currentToken();
            if (object != null) {
                if (((JsonToken)((Object)object)).isScalarValue()) {
                    return this.deserializeFromObjectId(jsonParser, deserializationContext);
                }
                if (object == JsonToken.START_OBJECT) {
                    object = jsonParser.nextToken();
                }
                if (object == JsonToken.FIELD_NAME && this._objectIdReader.maySerializeAsObject() && this._objectIdReader.isValidReferencePropertyName(jsonParser.currentName(), jsonParser)) {
                    return this.deserializeFromObjectId(jsonParser, deserializationContext);
                }
            }
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    public Object _handleTypedObjectId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, Object object2) {
        JsonDeserializer<Object> jsonDeserializer = ((BeanDeserializerBase)serializable)._objectIdReader.getDeserializer();
        if (jsonDeserializer.handledType() != object2.getClass()) {
            object2 = ((BeanDeserializerBase)serializable)._convertObjectId(jsonParser, deserializationContext, object2, jsonDeserializer);
        }
        BeanDeserializerBase beanDeserializerBase = serializable;
        ObjectIdReader objectIdReader = ((BeanDeserializerBase)serializable)._objectIdReader;
        Serializable serializable = objectIdReader.generator;
        deserializationContext.findObjectId(object2, (ObjectIdGenerator<?>)serializable, objectIdReader.resolver).bindItem(object);
        serializable = beanDeserializerBase._objectIdReader.idProperty;
        if (serializable != null) {
            return ((SettableBeanProperty)serializable).setAndReturn(object, object2);
        }
        return object;
    }

    public Object _convertObjectId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, JsonDeserializer<Object> jsonDeserializer) {
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        if (object instanceof String) {
            tokenBuffer.writeString((String)object);
        } else if (object instanceof Long) {
            tokenBuffer.writeNumber((Long)object);
        } else if (object instanceof Integer) {
            tokenBuffer.writeNumber((Integer)object);
        } else {
            tokenBuffer.writeObject(object);
        }
        JsonParser jsonParser2 = tokenBuffer.asParser();
        jsonParser2.nextToken();
        return jsonDeserializer.deserialize(jsonParser2, deserializationContext);
    }

    public Object deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this.deserializeFromObject(jsonParser, deserializationContext);
    }

    public Object deserializeFromObjectId(JsonParser jsonParser, DeserializationContext object) {
        DeserializationContext deserializationContext = object;
        BeanDeserializerBase beanDeserializerBase = string;
        object = beanDeserializerBase._objectIdReader.readObjectReference(jsonParser, (DeserializationContext)object);
        ObjectIdReader objectIdReader = beanDeserializerBase._objectIdReader;
        Object object2 = objectIdReader.generator;
        Object object3 = ((ReadableObjectId)(object2 = deserializationContext.findObjectId(object, (ObjectIdGenerator<?>)object2, objectIdReader.resolver))).resolve();
        if (object3 != null) {
            return object3;
        }
        JsonParser jsonParser2 = jsonParser;
        String string = "Could not resolve Object Id [" + object + "] (for " + ((BeanDeserializerBase)((Object)string))._beanType + ").";
        throw new UnresolvedForwardReference(jsonParser2, string, jsonParser2.getCurrentLocation(), (ReadableObjectId)object2);
    }

    public Object deserializeFromObjectUsingNonDefault(JsonParser object, DeserializationContext objectArray) {
        Object[] objectArray2;
        Object object2 = objectArray2._delegateDeserializer();
        if (object2 != null) {
            object = objectArray2._valueInstantiator.createUsingDelegate((DeserializationContext)objectArray, ((JsonDeserializer)object2).deserialize((JsonParser)object, (DeserializationContext)objectArray));
            if (objectArray2._injectables != null) {
                objectArray2.injectValues((DeserializationContext)objectArray, object);
            }
            return object;
        }
        if (objectArray2._propertyBasedCreator != null) {
            return objectArray2._deserializeUsingPropertyBased((JsonParser)object, (DeserializationContext)objectArray);
        }
        object2 = objectArray2._beanType.getRawClass();
        if (ClassUtil.isNonStaticInnerClass(object2)) {
            objectArray2 = new Object[]{};
            return objectArray.handleMissingInstantiator((Class<?>)object2, null, (JsonParser)object, "non-static inner classes like this can only by instantiated using default, no-argument constructor", objectArray2);
        }
        if (NativeImageUtil.needsReflectionConfiguration(object2)) {
            objectArray2 = new Object[]{};
            return objectArray.handleMissingInstantiator((Class<?>)object2, null, (JsonParser)object, "cannot deserialize from Object value (no delegate- or property-based Creator): this appears to be a native image, in which case you may need to configure reflection for the class that is to be deserialized", objectArray2);
        }
        Object[] objectArray3 = objectArray;
        objectArray2 = objectArray2.getValueInstantiator();
        objectArray = new Object[]{};
        return objectArray3.handleMissingInstantiator((Class<?>)object2, (ValueInstantiator)objectArray2, (JsonParser)object, "cannot deserialize from Object value (no delegate- or property-based Creator)", objectArray);
    }

    public abstract Object _deserializeUsingPropertyBased(JsonParser var1, DeserializationContext var2);

    public Object deserializeFromNumber(JsonParser object, DeserializationContext object2) {
        if (objectArray._objectIdReader != null) {
            return objectArray.deserializeFromObjectId((JsonParser)object, (DeserializationContext)object2);
        }
        JsonDeserializer<Object> jsonDeserializer = objectArray._delegateDeserializer();
        JsonParser.NumberType numberType = ((JsonParser)object).getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            if (jsonDeserializer != null && !objectArray._valueInstantiator.canCreateFromInt()) {
                BeanDeserializerBase beanDeserializerBase = objectArray;
                object = beanDeserializerBase._valueInstantiator.createUsingDelegate((DeserializationContext)object2, jsonDeserializer.deserialize((JsonParser)object, (DeserializationContext)object2));
                if (beanDeserializerBase._injectables != null) {
                    objectArray.injectValues((DeserializationContext)object2, object);
                }
                return object;
            }
            return objectArray._valueInstantiator.createFromInt((DeserializationContext)object2, ((JsonParser)object).getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            if (jsonDeserializer != null && !objectArray._valueInstantiator.canCreateFromInt()) {
                BeanDeserializerBase beanDeserializerBase = objectArray;
                object = beanDeserializerBase._valueInstantiator.createUsingDelegate((DeserializationContext)object2, jsonDeserializer.deserialize((JsonParser)object, (DeserializationContext)object2));
                if (beanDeserializerBase._injectables != null) {
                    objectArray.injectValues((DeserializationContext)object2, object);
                }
                return object;
            }
            return objectArray._valueInstantiator.createFromLong((DeserializationContext)object2, ((JsonParser)object).getLongValue());
        }
        if (numberType == JsonParser.NumberType.BIG_INTEGER) {
            if (jsonDeserializer != null && !objectArray._valueInstantiator.canCreateFromBigInteger()) {
                Serializable serializable = objectArray;
                object = serializable._valueInstantiator.createUsingDelegate((DeserializationContext)object2, jsonDeserializer.deserialize((JsonParser)object, (DeserializationContext)object2));
                if (serializable._injectables != null) {
                    objectArray.injectValues((DeserializationContext)object2, object);
                }
                return object;
            }
            return objectArray._valueInstantiator.createFromBigInteger((DeserializationContext)object2, ((JsonParser)object).getBigIntegerValue());
        }
        DeserializationContext deserializationContext = object2;
        BeanDeserializerBase beanDeserializerBase = objectArray;
        Object[] objectArray = beanDeserializerBase.handledType();
        object2 = beanDeserializerBase.getValueInstantiator();
        Serializable serializable = objectArray;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = ((JsonParser)object).getNumberValue();
        return deserializationContext.handleMissingInstantiator((Class<?>)serializable, (ValueInstantiator)object2, (JsonParser)object, "no suitable creator method found to deserialize from Number value (%s)", objectArray);
    }

    public Object deserializeFromString(JsonParser object, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId((JsonParser)object, deserializationContext);
        }
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer();
        if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromString()) {
            BeanDeserializerBase beanDeserializerBase = this;
            object = beanDeserializerBase._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
            if (beanDeserializerBase._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        return this._deserializeFromString((JsonParser)object, deserializationContext);
    }

    public Object deserializeFromDouble(JsonParser object, DeserializationContext object2) {
        Object object3 = ((JsonParser)object).getNumberType();
        if (object3 != JsonParser.NumberType.DOUBLE && object3 != JsonParser.NumberType.FLOAT) {
            if (object3 == JsonParser.NumberType.BIG_DECIMAL) {
                object3 = objectArray._delegateDeserializer();
                if (object3 != null && !objectArray._valueInstantiator.canCreateFromBigDecimal()) {
                    Serializable serializable = objectArray;
                    object = serializable._valueInstantiator.createUsingDelegate((DeserializationContext)object2, ((JsonDeserializer)object3).deserialize((JsonParser)object, (DeserializationContext)object2));
                    if (serializable._injectables != null) {
                        objectArray.injectValues((DeserializationContext)object2, object);
                    }
                    return object;
                }
                return objectArray._valueInstantiator.createFromBigDecimal((DeserializationContext)object2, ((JsonParser)object).getDecimalValue());
            }
            DeserializationContext deserializationContext = object2;
            BeanDeserializerBase beanDeserializerBase = objectArray;
            Object[] objectArray = beanDeserializerBase.handledType();
            object2 = beanDeserializerBase.getValueInstantiator();
            Serializable serializable = objectArray;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ((JsonParser)object).getNumberValue();
            return deserializationContext.handleMissingInstantiator((Class<?>)serializable, (ValueInstantiator)object2, (JsonParser)object, "no suitable creator method found to deserialize from Number value (%s)", objectArray);
        }
        object3 = objectArray._delegateDeserializer();
        if (object3 != null && !objectArray._valueInstantiator.canCreateFromDouble()) {
            BeanDeserializerBase beanDeserializerBase = objectArray;
            object = beanDeserializerBase._valueInstantiator.createUsingDelegate((DeserializationContext)object2, ((JsonDeserializer)object3).deserialize((JsonParser)object, (DeserializationContext)object2));
            if (beanDeserializerBase._injectables != null) {
                objectArray.injectValues((DeserializationContext)object2, object);
            }
            return object;
        }
        return objectArray._valueInstantiator.createFromDouble((DeserializationContext)object2, ((JsonParser)object).getDoubleValue());
    }

    public Object deserializeFromBoolean(JsonParser object, DeserializationContext deserializationContext) {
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer();
        if (jsonDeserializer != null && !this._valueInstantiator.canCreateFromBoolean()) {
            BeanDeserializerBase beanDeserializerBase = this;
            object = beanDeserializerBase._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize((JsonParser)object, deserializationContext));
            if (beanDeserializerBase._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        boolean bl = ((JsonParser)object).currentToken() == JsonToken.VALUE_TRUE;
        return this._valueInstantiator.createFromBoolean(deserializationContext, bl);
    }

    @Deprecated
    public Object deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._deserializeFromArray(jsonParser, deserializationContext);
    }

    public Object deserializeFromEmbedded(JsonParser object, DeserializationContext deserializationContext) {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId((JsonParser)object, deserializationContext);
        }
        Object object2 = this._delegateDeserializer();
        if (object2 != null && !this._valueInstantiator.canCreateFromString()) {
            BeanDeserializerBase beanDeserializerBase = this;
            object = beanDeserializerBase._valueInstantiator.createUsingDelegate(deserializationContext, ((JsonDeserializer)object2).deserialize((JsonParser)object, deserializationContext));
            if (beanDeserializerBase._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        object2 = ((JsonParser)object).getEmbeddedObject();
        if (object2 != null && !this._beanType.isTypeOrSuperTypeOf(object2.getClass())) {
            object2 = deserializationContext.handleWeirdNativeValue(this._beanType, object2, (JsonParser)object);
        }
        return object2;
    }

    public final JsonDeserializer<Object> _delegateDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer;
        if (jsonDeserializer == null) {
            jsonDeserializer = this._arrayDelegateDeserializer;
        }
        return jsonDeserializer;
    }

    public void injectValues(DeserializationContext deserializationContext, Object object) {
        ValueInjector[] valueInjectorArray = valueInjectorArray._injectables;
        int n2 = valueInjectorArray._injectables.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            valueInjectorArray[i2].inject(deserializationContext, object);
        }
    }

    public Object handleUnknownProperties(DeserializationContext deserializationContext, Object object, TokenBuffer closeable) {
        TokenBuffer tokenBuffer = closeable;
        tokenBuffer.writeEndObject();
        closeable = tokenBuffer.asParser();
        while (((JsonParser)closeable).nextToken() != JsonToken.END_OBJECT) {
            Closeable closeable2 = closeable;
            String string = ((JsonParser)closeable2).currentName();
            ((JsonParser)closeable2).nextToken();
            this.handleUnknownProperty((JsonParser)closeable, deserializationContext, object, string);
        }
        return object;
    }

    public void handleUnknownVanilla(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        BeanDeserializerBase beanDeserializerBase = this;
        Object object2 = beanDeserializerBase._ignorableProps;
        if (IgnorePropertiesUtil.shouldIgnore(string, object2, beanDeserializerBase._includableProps)) {
            this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
        } else {
            object2 = this._anySetter;
            if (object2 != null) {
                try {
                    ((SettableAnyProperty)object2).deserializeAndSet(jsonParser, deserializationContext, object, string);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, string, deserializationContext);
                }
            } else {
                this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
            }
        }
    }

    @Override
    public void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (this._ignoreAllUnknown) {
            jsonParser.skipChildren();
            return;
        }
        BeanDeserializerBase beanDeserializerBase = this;
        Set<String> set = beanDeserializerBase._ignorableProps;
        if (IgnorePropertiesUtil.shouldIgnore(string, set, beanDeserializerBase._includableProps)) {
            this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
        }
        super.handleUnknownProperty(jsonParser, deserializationContext, object, string);
    }

    public void handleIgnoredProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES)) {
            jsonParser.skipChildren();
            return;
        }
        throw IgnoredPropertyException.from(jsonParser, object, string, this.getKnownPropertyNames());
    }

    public Object handlePolymorphic(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) {
        JsonDeserializer<Object> jsonDeserializer = ((BeanDeserializerBase)((Object)jsonParser2))._findSubclassDeserializer(deserializationContext, object, tokenBuffer);
        if (jsonDeserializer != null) {
            if (tokenBuffer != null) {
                TokenBuffer tokenBuffer2 = tokenBuffer;
                tokenBuffer2.writeEndObject();
                JsonParser jsonParser2 = tokenBuffer2.asParser();
                jsonParser2.nextToken();
                object = jsonDeserializer.deserialize(jsonParser2, deserializationContext, object);
            }
            if (jsonParser != null) {
                object = jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
            }
            return object;
        }
        if (tokenBuffer != null) {
            object = ((BeanDeserializerBase)((Object)jsonParser2)).handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        if (jsonParser != null) {
            object = ((JsonDeserializer)((Object)jsonParser2)).deserialize(jsonParser, deserializationContext, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonDeserializer<Object> _findSubclassDeserializer(DeserializationContext var1_1, Object var2_2, TokenBuffer var3_3) {
        v0 = this;
        synchronized (v0) {
            var3_3 = v0._subDeserializers;
            var3_3 = var3_3 == null ? null : (JsonDeserializer)var3_3.get(new ClassKey(var2_2.getClass()));
            {
                // ** MonitorExit[this] (shouldn't be in output)
                if (var3_3 != null) {
                    return var3_3;
                }
                v2 = var1_1;
                var1_1 = v2.findRootValueDeserializer(v2.constructType(var2_2.getClass()));
                if (var1_1 == null) return var1_1;
                v3 = this;
            }
            synchronized (v3) {
                block10: {
                    try {
                        if (v3._subDeserializers != null) break block10;
                        v4 = this;
                    }
                    catch (Throwable v5) {
                        ** GOTO lbl32
                    }
                    var3_3 = v6;
                    v6 = new HashMap<K, V>();
                    v4._subDeserializers = var3_3;
                }
                v7 = this;
                v7._subDeserializers.put(new ClassKey(var2_2.getClass()), var1_1);
                {
                    // ** MonitorExit[v7] (shouldn't be in output)
                    return var1_1;
lbl32:
                    // 1 sources

                    // ** MonitorExit[this] (shouldn't be in output)
                }
                throw v5;
            }
        }
    }

    public void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, string);
    }

    public Object wrapInstantiationProblem(Throwable throwable, DeserializationContext deserializationContext) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        Throwable throwable2 = throwable;
        ClassUtil.throwIfError(throwable2);
        if (!(throwable2 instanceof IOException)) {
            if (deserializationContext != null) {
                if (!deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
                    ClassUtil.throwIfRTE(throwable);
                }
                return deserializationContext.handleInstantiationProblem(this._beanType.getRawClass(), null, throwable);
            }
            throw new IllegalArgumentException(throwable.getMessage(), throwable);
        }
        throw (IOException)throwable;
    }
}

