/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DatabindException;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.privatefasterxml.jackson.databind.deser.AbstractDeserializer;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializer;
import com.privatefasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import com.privatefasterxml.jackson.databind.deser.SettableAnyProperty;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.privatefasterxml.jackson.databind.deser.impl.ValueInjector;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.IgnorePropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeserializerBuilder {
    protected final DeserializationConfig _config;
    protected final DeserializationContext _context;
    protected final BeanDescription _beanDesc;
    protected final Map<String, SettableBeanProperty> _properties;
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected HashSet<String> _includableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDescription, DeserializationContext deserializationContext) {
        this._properties = new LinkedHashMap<String, SettableBeanProperty>();
        this._beanDesc = beanDescription;
        this._context = deserializationContext;
        this._config = deserializationContext.getConfig();
    }

    public BeanDeserializerBuilder(BeanDeserializerBuilder beanDeserializerBuilder) {
        LinkedHashMap<String, SettableBeanProperty> linkedHashMap;
        LinkedHashMap<String, SettableBeanProperty> linkedHashMap2;
        LinkedHashMap<String, SettableBeanProperty> linkedHashMap3 = linkedHashMap2 = linkedHashMap;
        linkedHashMap3();
        this._properties = linkedHashMap3;
        this._beanDesc = beanDeserializerBuilder._beanDesc;
        this._context = beanDeserializerBuilder._context;
        this._config = beanDeserializerBuilder._config;
        linkedHashMap.putAll(beanDeserializerBuilder._properties);
        this._injectables = BeanDeserializerBuilder._copy(beanDeserializerBuilder._injectables);
        this._backRefProperties = BeanDeserializerBuilder._copy(beanDeserializerBuilder._backRefProperties);
        this._ignorableProps = beanDeserializerBuilder._ignorableProps;
        this._includableProps = beanDeserializerBuilder._includableProps;
        this._valueInstantiator = beanDeserializerBuilder._valueInstantiator;
        this._objectIdReader = beanDeserializerBuilder._objectIdReader;
        this._anySetter = beanDeserializerBuilder._anySetter;
        this._ignoreAllUnknown = beanDeserializerBuilder._ignoreAllUnknown;
        this._buildMethod = beanDeserializerBuilder._buildMethod;
        this._builderConfig = beanDeserializerBuilder._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> hashMap) {
        if (hashMap == null) {
            hashMap = null;
        } else {
            HashMap<String, SettableBeanProperty> hashMap2;
            HashMap<String, SettableBeanProperty> hashMap3 = hashMap2;
            hashMap2 = new HashMap<String, SettableBeanProperty>(hashMap);
            hashMap = hashMap3;
        }
        return hashMap;
    }

    private static <T> List<T> _copy(List<T> list) {
        if (list == null) {
            list = null;
        } else {
            ArrayList<T> arrayList;
            ArrayList<T> arrayList2 = arrayList;
            arrayList = new ArrayList<T>(list);
            list = arrayList2;
        }
        return list;
    }

    public void addOrReplaceProperty(SettableBeanProperty settableBeanProperty, boolean bl) {
        this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
    }

    public void addProperty(SettableBeanProperty settableBeanProperty) {
        SettableBeanProperty settableBeanProperty2 = this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
        if (settableBeanProperty2 != null && settableBeanProperty2 != settableBeanProperty) {
            throw new IllegalArgumentException("Duplicate property '" + settableBeanProperty.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String string, SettableBeanProperty settableBeanProperty) {
        if (this._backRefProperties == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap(4);
            this._backRefProperties = hashMap2;
        }
        if (this._config.canOverrideAccessModifiers()) {
            try {
                settableBeanProperty.fixAccess(this._config);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
        this._backRefProperties.put(string, settableBeanProperty);
    }

    public void addInjectable(PropertyName propertyName, JavaType javaType, Annotations object, AnnotatedMember annotatedMember, Object object2) {
        if (this._injectables == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            this._injectables = object;
        }
        if (this._config.canOverrideAccessModifiers()) {
            try {
                annotatedMember.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
        this._injectables.add(new ValueInjector(propertyName, javaType, annotatedMember, object2));
    }

    public void addIgnorable(String string) {
        if (this._ignorableProps == null) {
            HashSet hashSet;
            HashSet hashSet2 = hashSet;
            hashSet = new HashSet();
            this._ignorableProps = hashSet2;
        }
        this._ignorableProps.add(string);
    }

    public void addIncludable(String string) {
        if (this._includableProps == null) {
            HashSet hashSet;
            HashSet hashSet2 = hashSet;
            hashSet = new HashSet();
            this._includableProps = hashSet2;
        }
        this._includableProps.add(string);
    }

    public void addCreatorProperty(SettableBeanProperty settableBeanProperty) {
        this.addProperty(settableBeanProperty);
    }

    public void setAnySetter(SettableAnyProperty settableAnyProperty) {
        if (this._anySetter != null && settableAnyProperty != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = settableAnyProperty;
    }

    public void setIgnoreUnknownProperties(boolean bl) {
        this._ignoreAllUnknown = bl;
    }

    public void setValueInstantiator(ValueInstantiator valueInstantiator) {
        this._valueInstantiator = valueInstantiator;
    }

    public void setObjectIdReader(ObjectIdReader objectIdReader) {
        this._objectIdReader = objectIdReader;
    }

    public void setPOJOBuilder(AnnotatedMethod annotatedMethod, JsonPOJOBuilder.Value value) {
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        beanDeserializerBuilder._buildMethod = annotatedMethod;
        beanDeserializerBuilder._builderConfig = value;
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this._properties.get(propertyName.getSimpleName());
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public SettableBeanProperty removeProperty(PropertyName propertyName) {
        return this._properties.remove(propertyName.getSimpleName());
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder.Value getBuilderConfig() {
        return this._builderConfig;
    }

    public boolean hasIgnorable(String string) {
        BeanDeserializerBuilder beanDeserializerBuilder = hashSet;
        HashSet<String> hashSet = beanDeserializerBuilder._ignorableProps;
        return IgnorePropertiesUtil.shouldIgnore(string, (Collection<String>)hashSet, beanDeserializerBuilder._includableProps);
    }

    public JsonDeserializer<?> build() {
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        Object object = beanDeserializerBuilder._properties.values();
        beanDeserializerBuilder._fixAccess((Collection<SettableBeanProperty>)object);
        BeanDeserializerBuilder beanDeserializerBuilder2 = this;
        Object object2 = beanDeserializerBuilder2._collectAliases((Collection<SettableBeanProperty>)object);
        object2 = BeanPropertyMap.construct(beanDeserializerBuilder._config, object, object2, beanDeserializerBuilder2._findCaseInsensitivity());
        ((BeanPropertyMap)object2).assignIndexes();
        boolean bl = beanDeserializerBuilder._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION) ^ true;
        if (!bl) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!((SettableBeanProperty)object.next()).hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty;
            object = objectIdValueProperty;
            objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            object2 = ((BeanPropertyMap)object2).withProperty((SettableBeanProperty)object);
        }
        BeanDeserializerBuilder beanDeserializerBuilder3 = this;
        object = beanDeserializerBuilder3._beanDesc;
        HashMap<String, SettableBeanProperty> hashMap = beanDeserializerBuilder3._backRefProperties;
        HashSet<String> hashSet = beanDeserializerBuilder3._ignorableProps;
        boolean bl2 = beanDeserializerBuilder3._ignoreAllUnknown;
        HashSet<String> hashSet2 = beanDeserializerBuilder3._includableProps;
        return new BeanDeserializer(this, (BeanDescription)object, (BeanPropertyMap)object2, (Map<String, SettableBeanProperty>)hashMap, hashSet, bl2, (Set<String>)hashSet2, bl);
    }

    public AbstractDeserializer buildAbstract() {
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        BeanDescription beanDescription = beanDeserializerBuilder._beanDesc;
        HashMap<String, SettableBeanProperty> hashMap = beanDeserializerBuilder._backRefProperties;
        Map<String, SettableBeanProperty> map = beanDeserializerBuilder._properties;
        return new AbstractDeserializer(this, beanDescription, hashMap, map);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType javaType, String clazz) {
        Object object = this._buildMethod;
        if (object == null) {
            if (!((String)((Object)clazz)).isEmpty()) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                objectArray[0] = ClassUtil.getTypeDescription(this._beanDesc.getType());
                objectArray[1] = clazz;
                this._context.reportBadDefinition(this._beanDesc.getType(), String.format("Builder class %s does not have build method (name: '%s')", object));
            }
        } else {
            clazz = object.getRawReturnType();
            if (clazz != (object = javaType.getRawClass()) && !clazz.isAssignableFrom((Class<?>)object) && !object.isAssignableFrom(clazz)) {
                Object[] objectArray = new Object[3];
                object = objectArray;
                object[0] = this._buildMethod.getFullName();
                object[1] = ClassUtil.getClassDescription(clazz);
                objectArray[2] = ClassUtil.getTypeDescription(javaType);
                this._context.reportBadDefinition(this._beanDesc.getType(), String.format("Build method `%s` has wrong return type (%s), not compatible with POJO type (%s)", object));
            }
        }
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        clazz = beanDeserializerBuilder._properties.values();
        beanDeserializerBuilder._fixAccess((Collection<SettableBeanProperty>)((Object)clazz));
        BeanDeserializerBuilder beanDeserializerBuilder2 = this;
        object = beanDeserializerBuilder2._collectAliases((Collection<SettableBeanProperty>)((Object)clazz));
        object = BeanPropertyMap.construct(beanDeserializerBuilder._config, clazz, (Map<String, List<PropertyName>>)object, beanDeserializerBuilder2._findCaseInsensitivity());
        object.assignIndexes();
        boolean bl = beanDeserializerBuilder._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION) ^ true;
        if (!bl) {
            clazz = clazz.iterator();
            while (clazz.hasNext()) {
                if (!((SettableBeanProperty)clazz.next()).hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty;
            clazz = objectIdValueProperty;
            objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            object = object.withProperty((SettableBeanProperty)((Object)clazz));
        }
        return this.createBuilderBasedDeserializer(javaType, (BeanPropertyMap)object, bl);
    }

    public JsonDeserializer<?> createBuilderBasedDeserializer(JavaType javaType, BeanPropertyMap beanPropertyMap, boolean bl) {
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        BeanDescription beanDescription = beanDeserializerBuilder._beanDesc;
        HashMap<String, SettableBeanProperty> hashMap = beanDeserializerBuilder._backRefProperties;
        HashSet<String> hashSet = beanDeserializerBuilder._ignorableProps;
        boolean bl2 = beanDeserializerBuilder._ignoreAllUnknown;
        HashSet<String> hashSet2 = beanDeserializerBuilder._includableProps;
        return new BuilderBasedDeserializer(this, beanDescription, javaType, beanPropertyMap, hashMap, hashSet, bl2, hashSet2, bl);
    }

    public void _fixAccess(Collection<SettableBeanProperty> object) {
        if (this._config.canOverrideAccessModifiers()) {
            object = object.iterator();
            while (object.hasNext()) {
                try {
                    ((SettableBeanProperty)object.next()).fixAccess(this._config);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this._handleBadAccess(illegalArgumentException);
                }
            }
        }
        if ((object = this._anySetter) != null) {
            try {
                ((SettableAnyProperty)object).fixAccess(this._config);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
        if ((object = this._buildMethod) != null) {
            try {
                ((AnnotatedMember)object).fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
    }

    public Map<String, List<PropertyName>> _collectAliases(Collection<SettableBeanProperty> object) {
        BeanDeserializerBuilder beanDeserializerBuilder = object2;
        Object object2 = null;
        AnnotationIntrospector annotationIntrospector = beanDeserializerBuilder._config.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            object = object.iterator();
            while (object.hasNext()) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
                List<PropertyName> list = annotationIntrospector.findPropertyAliases(settableBeanProperty.getMember());
                if (list == null || list.isEmpty()) continue;
                if (object2 == null) {
                    HashMap hashMap;
                    object2 = hashMap;
                    hashMap = new HashMap();
                }
                object2.put(settableBeanProperty.getName(), list);
            }
        }
        if (object2 == null) {
            return Collections.emptyMap();
        }
        return object2;
    }

    public boolean _findCaseInsensitivity() {
        Boolean bl = this._beanDesc.findExpectedFormat(null).getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        return bl == null ? this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES) : bl.booleanValue();
    }

    public void _handleBadAccess(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException illegalArgumentException2;
        DeserializationContext deserializationContext;
        try {
            deserializationContext = ((BeanDeserializerBuilder)((Object)beanDescription))._context;
            illegalArgumentException2 = illegalArgumentException;
            BeanDescription beanDescription = ((BeanDeserializerBuilder)((Object)beanDescription))._beanDesc;
        }
        catch (DatabindException databindException) {
            if (databindException.getCause() == null) {
                databindException.initCause(illegalArgumentException);
            }
            throw databindException;
        }
        String string = illegalArgumentException2.getMessage();
        deserializationContext.reportBadTypeDefinition(beanDescription, string, new Object[0]);
    }
}

