/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonIncludeProperties;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerators;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.databind.AbstractTypeResolver;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.PropertyNamingStrategy;
import com.privatefasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.privatefasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.deser.BasicDeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializer;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.privatefasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.privatefasterxml.jackson.databind.deser.CreatorProperty;
import com.privatefasterxml.jackson.databind.deser.DeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.SettableAnyProperty;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.ErrorThrowingDeserializer;
import com.privatefasterxml.jackson.databind.deser.impl.FieldProperty;
import com.privatefasterxml.jackson.databind.deser.impl.MethodProperty;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.privatefasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.privatefasterxml.jackson.databind.deser.impl.UnsupportedTypeDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.ThrowableDeserializer;
import com.privatefasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.BeanUtil;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.privatefasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] INIT_CAUSE_PARAMS;
    public static final BeanDeserializerFactory instance;

    public BeanDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        super(deserializerFactoryConfig);
    }

    private boolean _isSetterlessType(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    static {
        DeserializerFactoryConfig deserializerFactoryConfig;
        INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
        DeserializerFactoryConfig deserializerFactoryConfig2 = deserializerFactoryConfig;
        deserializerFactoryConfig = new DeserializerFactoryConfig();
        instance = new BeanDeserializerFactory(deserializerFactoryConfig2);
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactoryConfig deserializerFactoryConfig) {
        if (this._factoryConfig == deserializerFactoryConfig) {
            return this;
        }
        ClassUtil.verifyMustOverride(BeanDeserializerFactory.class, this, "withConfig");
        return new BeanDeserializerFactory(deserializerFactoryConfig);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        JsonDeserializer<?> jsonDeserializer = deserializationContext.getConfig();
        JsonDeserializer<Object> jsonDeserializer2 = ((BasicDeserializerFactory)((Object)iterator))._findCustomBeanDeserializer(javaType, (DeserializationConfig)((Object)jsonDeserializer), beanDescription);
        if (jsonDeserializer2 != null) {
            if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
                Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
                while (iterator.hasNext()) {
                    jsonDeserializer2 = ((BeanDeserializerModifier)iterator.next()).modifyDeserializer(deserializationContext.getConfig(), beanDescription, jsonDeserializer2);
                }
            }
            return jsonDeserializer2;
        }
        if (javaType.isThrowable()) {
            return ((BeanDeserializerFactory)((Object)iterator)).buildThrowableDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (javaType.isAbstract() && !javaType.isPrimitive() && !javaType.isEnumType() && (jsonDeserializer2 = ((BeanDeserializerFactory)((Object)iterator)).materializeAbstractType(deserializationContext, javaType, beanDescription)) != null) {
            return ((BeanDeserializerFactory)((Object)iterator)).buildBeanDeserializer(deserializationContext, (JavaType)((Object)jsonDeserializer2), ((DeserializationConfig)((Object)jsonDeserializer)).introspect((JavaType)((Object)jsonDeserializer2)));
        }
        jsonDeserializer = ((BeanDeserializerFactory)((Object)iterator)).findStdDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        if (!((BeanDeserializerFactory)((Object)iterator)).isPotentialBeanType(javaType.getRawClass())) {
            return null;
        }
        Iterator<BeanDeserializerModifier> iterator = iterator;
        ((BeanDeserializerFactory)((Object)iterator))._validateSubType(deserializationContext, javaType, beanDescription);
        jsonDeserializer = ((BeanDeserializerFactory)((Object)iterator))._findUnsupportedTypeDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return ((BeanDeserializerFactory)((Object)iterator)).buildBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    @Override
    public JsonDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription, Class<?> type) {
        type = deserializationContext.isEnabled(MapperFeature.INFER_BUILDER_TYPE_BINDINGS) ? deserializationContext.getTypeFactory().constructParametricType((Class<?>)type, javaType.getBindings()) : deserializationContext.constructType((Class<?>)type);
        DeserializationContext deserializationContext2 = deserializationContext;
        return this.buildBuilderBasedDeserializer(deserializationContext2, javaType, deserializationContext2.getConfig().introspectForBuilder((JavaType)type, beanDescription));
    }

    public JsonDeserializer<?> findStdDeserializer(DeserializationContext deserializationContext, JavaType jsonDeserializer, BeanDescription beanDescription) {
        if ((jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findDefaultDeserializer(deserializationContext, (JavaType)((Object)jsonDeserializer), beanDescription)) != null && ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyDeserializer(deserializationContext.getConfig(), beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    public JsonDeserializer<Object> _findUnsupportedTypeDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        String string = BeanUtil.checkUnsupportedType(javaType);
        if (string != null && deserializationContext.getConfig().findMixInClassFor(javaType.getRawClass()) == null) {
            return new UnsupportedTypeDeserializer(javaType, string);
        }
        return null;
    }

    public JavaType materializeAbstractType(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        Iterator<AbstractTypeResolver> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.abstractTypeResolvers().iterator();
        while (iterator.hasNext()) {
            javaType = ((AbstractTypeResolver)iterator.next()).resolveAbstractType(deserializationContext.getConfig(), beanDescription);
            if (javaType == null) continue;
            return javaType;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationContext jsonDeserializer, JavaType javaType, BeanDescription beanDescription) {
        BeanDeserializerBuilder beanDeserializerBuilder;
        DeserializationContext deserializationContext;
        BeanDeserializerFactory beanDeserializerFactory;
        DeserializationContext deserializationContext2;
        BeanDeserializerFactory beanDeserializerFactory2;
        DeserializationContext deserializationContext3;
        BeanDeserializerFactory beanDeserializerFactory3;
        DeserializationContext deserializationContext4;
        BeanDeserializerFactory beanDeserializerFactory4;
        DeserializationContext deserializationContext5;
        BeanDeserializerFactory beanDeserializerFactory5;
        try {
            beanDeserializerFactory5 = iterator;
            deserializationContext5 = jsonDeserializer;
            beanDeserializerFactory4 = iterator;
            deserializationContext4 = jsonDeserializer;
            beanDeserializerFactory3 = iterator;
            deserializationContext3 = jsonDeserializer;
            beanDeserializerFactory2 = iterator;
            deserializationContext2 = jsonDeserializer;
            beanDeserializerFactory = iterator;
            deserializationContext = jsonDeserializer;
            DeserializationContext deserializationContext6 = jsonDeserializer;
            jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator)).findValueInstantiator((DeserializationContext)((Object)jsonDeserializer), beanDescription);
            beanDeserializerBuilder = ((BeanDeserializerFactory)((Object)iterator)).constructBeanDeserializerBuilder(deserializationContext6, beanDescription);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidDefinitionException.from(((DeserializationContext)((Object)jsonDeserializer)).getParser(), ClassUtil.exceptionMessage(illegalArgumentException), beanDescription, null).withCause(illegalArgumentException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new ErrorThrowingDeserializer(noClassDefFoundError);
        }
        beanDeserializerBuilder.setValueInstantiator((ValueInstantiator)((Object)jsonDeserializer));
        beanDeserializerFactory.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        beanDeserializerFactory2.addObjectIdReader(deserializationContext2, beanDescription, beanDeserializerBuilder);
        beanDeserializerFactory3.addBackReferenceProperties(deserializationContext3, beanDescription, beanDeserializerBuilder);
        beanDeserializerFactory4.addInjectables(deserializationContext4, beanDescription, beanDeserializerBuilder);
        DeserializationConfig deserializationConfig = deserializationContext5.getConfig();
        if (beanDeserializerFactory5._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                beanDeserializerBuilder = iterator.next().updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        jsonDeserializer = javaType.isAbstract() && !((ValueInstantiator)((Object)jsonDeserializer)).canInstantiate() ? beanDeserializerBuilder.buildAbstract() : beanDeserializerBuilder.build();
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    public JsonDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext jsonDeserializer, JavaType javaType, BeanDescription beanDescription) {
        BeanDeserializerBuilder beanDeserializerBuilder;
        DeserializationConfig deserializationConfig;
        Object object;
        BeanDeserializerFactory beanDeserializerFactory;
        BeanDeserializerFactory beanDeserializerFactory2;
        BeanDeserializerFactory beanDeserializerFactory3;
        BeanDeserializerFactory beanDeserializerFactory4;
        BeanDescription beanDescription2;
        try {
            beanDescription2 = beanDescription;
            BeanDeserializerFactory beanDeserializerFactory5 = iterator;
            beanDeserializerFactory4 = beanDeserializerFactory5;
            beanDeserializerFactory3 = beanDeserializerFactory5;
            beanDeserializerFactory2 = beanDeserializerFactory5;
            beanDeserializerFactory = beanDeserializerFactory5;
            object = ((BasicDeserializerFactory)((Object)iterator)).findValueInstantiator((DeserializationContext)((Object)jsonDeserializer), beanDescription);
            deserializationConfig = ((DeserializationContext)((Object)jsonDeserializer)).getConfig();
            beanDeserializerBuilder = beanDeserializerFactory5.constructBeanDeserializerBuilder((DeserializationContext)((Object)jsonDeserializer), beanDescription);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidDefinitionException.from(((DeserializationContext)((Object)jsonDeserializer)).getParser(), ClassUtil.exceptionMessage(illegalArgumentException), beanDescription, null);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new ErrorThrowingDeserializer(noClassDefFoundError);
        }
        beanDeserializerBuilder.setValueInstantiator((ValueInstantiator)object);
        beanDeserializerFactory3.addBeanProps((DeserializationContext)((Object)jsonDeserializer), beanDescription, beanDeserializerBuilder);
        beanDeserializerFactory2.addObjectIdReader((DeserializationContext)((Object)jsonDeserializer), beanDescription, beanDeserializerBuilder);
        beanDeserializerFactory.addBackReferenceProperties((DeserializationContext)((Object)jsonDeserializer), beanDescription, beanDeserializerBuilder);
        beanDeserializerFactory4.addInjectables((DeserializationContext)((Object)jsonDeserializer), beanDescription, beanDeserializerBuilder);
        jsonDeserializer = beanDescription2.findPOJOBuilderConfig();
        object = jsonDeserializer == null ? "build" : ((JsonPOJOBuilder.Value)((Object)jsonDeserializer)).buildMethodName;
        AnnotatedMethod annotatedMethod = beanDescription.findMethod((String)object, null);
        if (annotatedMethod != null && deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        beanDeserializerBuilder.setPOJOBuilder(annotatedMethod, (JsonPOJOBuilder.Value)((Object)jsonDeserializer));
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            jsonDeserializer = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (jsonDeserializer.hasNext()) {
                beanDeserializerBuilder = ((BeanDeserializerModifier)jsonDeserializer.next()).updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        jsonDeserializer = beanDeserializerBuilder.buildBuilderBased(javaType, (String)object);
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void addObjectIdReader(DeserializationContext deserializationContext, BeanDescription object, BeanDeserializerBuilder beanDeserializerBuilder) {
        void var4_11;
        SettableBeanProperty settableBeanProperty;
        void var3_6;
        void var1_4;
        JavaType javaType;
        ObjectIdInfo objectIdInfo = ((BeanDescription)((Object)javaType)).getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        ObjectIdResolver objectIdResolver = var1_4.objectIdResolverInstance(((BeanDescription)((Object)javaType)).getClassInfo(), objectIdInfo);
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator;
            PropertyName propertyName = objectIdInfo.getPropertyName();
            settableBeanProperty = var3_6.findProperty(propertyName);
            if (settableBeanProperty == null) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = ClassUtil.getTypeDescription(((BeanDescription)((Object)javaType)).getType());
                objectArray[1] = ClassUtil.name(propertyName);
                throw new IllegalArgumentException(String.format("Invalid Object Id definition for %s: cannot find property with name %s", objectArray2));
            }
            javaType = settableBeanProperty.getType();
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator2 = propertyBasedObjectIdGenerator;
            propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
        } else {
            void v2 = javaType;
            void v3 = var1_4;
            javaType = v3.constructType(clazz);
            javaType = v3.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
            settableBeanProperty = null;
            ObjectIdGenerator<?> objectIdGenerator = var1_4.objectIdGeneratorInstance(v2.getClassInfo(), objectIdInfo);
        }
        JsonDeserializer<Object> jsonDeserializer = var1_4.findRootValueDeserializer(javaType);
        var3_6.setObjectIdReader(ObjectIdReader.construct(javaType, objectIdInfo.getPropertyName(), var4_11, jsonDeserializer, settableBeanProperty, objectIdResolver));
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationContext deserializationContext, JavaType serializable, BeanDescription beanDescription) {
        DeserializationContext deserializationContext2 = deserializationContext;
        serializable = deserializationContext2.getConfig();
        JsonDeserializer<?> jsonDeserializer = ((BeanDeserializerFactory)((Object)iterator)).constructBeanDeserializerBuilder(deserializationContext2, beanDescription);
        ((BeanDeserializerBuilder)((Object)jsonDeserializer)).setValueInstantiator(((BasicDeserializerFactory)((Object)iterator)).findValueInstantiator(deserializationContext, beanDescription));
        ((BeanDeserializerFactory)((Object)iterator)).addBeanProps(deserializationContext, beanDescription, (BeanDeserializerBuilder)((Object)jsonDeserializer));
        Object object = ((BeanDeserializerBuilder)((Object)jsonDeserializer)).getProperties();
        while (object.hasNext()) {
            if (!"setCause".equals(object.next().getMember().getName())) continue;
            object.remove();
            break;
        }
        if ((object = beanDescription.findMethod("initCause", INIT_CAUSE_PARAMS)) != null) {
            PropertyName propertyName;
            Object object2 = "cause";
            PropertyNamingStrategy propertyNamingStrategy = ((MapperConfig)serializable).getPropertyNamingStrategy();
            if (propertyNamingStrategy != null) {
                object2 = propertyNamingStrategy.nameForSetterMethod((MapperConfig<?>)serializable, (AnnotatedMethod)object, "cause");
            }
            Iterator<BeanDeserializerModifier> iterator = object;
            Iterator<BeanDeserializerModifier> iterator2 = object;
            object = propertyName;
            propertyName = new PropertyName((String)object2);
            object = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), iterator2, (PropertyName)object);
            object2 = ((AnnotatedMethod)((Object)iterator)).getParameterType(0);
            if ((object = ((BeanDeserializerFactory)((Object)iterator)).constructSettableProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)object, (JavaType)object2)) != null) {
                ((BeanDeserializerBuilder)((Object)jsonDeserializer)).addOrReplaceProperty((SettableBeanProperty)object, true);
            }
        }
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            object = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (object.hasNext()) {
                jsonDeserializer = object.next().updateBuilder((DeserializationConfig)serializable, beanDescription, (BeanDeserializerBuilder)((Object)jsonDeserializer));
            }
        }
        if ((jsonDeserializer = ((BeanDeserializerBuilder)((Object)jsonDeserializer)).build()) instanceof BeanDeserializer) {
            jsonDeserializer = ThrowableDeserializer.construct(deserializationContext, (BeanDeserializer)jsonDeserializer);
        }
        if (((BasicDeserializerFactory)((Object)iterator))._factoryConfig.hasDeserializerModifiers()) {
            Iterator<BeanDeserializerModifier> iterator = ((BasicDeserializerFactory)((Object)iterator))._factoryConfig.deserializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonDeserializer = ((BeanDeserializerModifier)iterator.next()).modifyDeserializer((DeserializationConfig)serializable, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    public BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        return new BeanDeserializerBuilder(beanDescription, deserializationContext);
    }

    public void addBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        Object object;
        SettableBeanProperty[] settableBeanPropertyArray = beanDescription.getType().isAbstract() ^ true ? beanDeserializerBuilder.getValueInstantiator().getFromObjectArguments(deserializationContext.getConfig()) : null;
        boolean bl = settableBeanPropertyArray != null;
        BeanDescription beanDescription2 = beanDescription;
        Object object2 = beanDescription2.getBeanClass();
        object2 = deserializationContext.getConfig().getDefaultPropertyIgnorals((Class<?>)object2, beanDescription2.getClassInfo());
        if (object2 != null) {
            beanDeserializerBuilder.setIgnoreUnknownProperties(((JsonIgnoreProperties.Value)object2).getIgnoreUnknown());
            object2 = ((JsonIgnoreProperties.Value)object2).findIgnoredForDeserialization();
            object = object2.iterator();
            while (object.hasNext()) {
                beanDeserializerBuilder.addIgnorable((String)object.next());
            }
        } else {
            object2 = Collections.emptySet();
        }
        BeanDescription beanDescription3 = beanDescription;
        object = beanDescription3.getBeanClass();
        object = deserializationContext.getConfig().getDefaultPropertyInclusions((Class<?>)object, beanDescription3.getClassInfo());
        Class<?>[] classArray = null;
        if (object != null && (classArray = ((JsonIncludeProperties.Value)object).getIncluded()) != null) {
            object = classArray.iterator();
            while (object.hasNext()) {
                beanDeserializerBuilder.addIncludable((String)object.next());
            }
        }
        if ((object = beanDescription.findAnySetterAccessor()) != null) {
            beanDeserializerBuilder.setAnySetter(this.constructAnySetter(deserializationContext, beanDescription, (AnnotatedMember)object));
        } else {
            object = beanDescription.getIgnoredPropertyNames();
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    beanDeserializerBuilder.addIgnorable((String)object.next());
                }
            }
        }
        boolean bl2 = deserializationContext.isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS) && deserializationContext.isEnabled(MapperFeature.AUTO_DETECT_GETTERS);
        BeanDeserializerFactory beanDeserializerFactory = this;
        Object object3 = beanDescription.findProperties();
        object2 = beanDeserializerFactory.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, (List<BeanPropertyDefinition>)object3, (Set<String>)object2, (Set<String>)classArray);
        if (beanDeserializerFactory._factoryConfig.hasDeserializerModifiers()) {
            classArray = this._factoryConfig.deserializerModifiers().iterator();
            while (classArray.hasNext()) {
                object2 = ((BeanDeserializerModifier)classArray.next()).updateProperties(deserializationContext.getConfig(), beanDescription, (List<BeanPropertyDefinition>)object2);
            }
        }
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object4;
            classArray = (BeanPropertyDefinition)object2.next();
            object3 = null;
            if (classArray.hasSetter()) {
                object3 = classArray.getSetter().getParameterType(0);
                object3 = this.constructSettableProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)classArray, (JavaType)object3);
            } else if (classArray.hasField()) {
                object3 = classArray.getField().getType();
                object3 = this.constructSettableProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)classArray, (JavaType)object3);
            } else {
                object4 = classArray.getGetter();
                if (object4 != null && !(bl2 && this._isSetterlessType(((AnnotatedMethod)object4).getRawType()) ? beanDeserializerBuilder.hasIgnorable(classArray.getName()) : classArray.hasConstructorParameter() || classArray.getMetadata().getMergeInfo() == null)) {
                    object3 = this.constructSetterlessProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)classArray);
                }
            }
            if (bl && classArray.hasConstructorParameter()) {
                object4 = classArray.getName();
                Object[] objectArray = null;
                int n2 = settableBeanPropertyArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
                    if (!((String)object4).equals(settableBeanProperty.getName()) || !(settableBeanProperty instanceof CreatorProperty)) continue;
                    objectArray = (CreatorProperty)settableBeanProperty;
                    break;
                }
                if (objectArray == null) {
                    ArrayList arrayList;
                    object3 = arrayList;
                    arrayList = new ArrayList();
                    int n3 = settableBeanPropertyArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        ((ArrayList)object3).add(settableBeanPropertyArray[n2].getName());
                    }
                    Object[] objectArray2 = new Object[2];
                    objectArray = objectArray2;
                    objectArray2[0] = ClassUtil.name((String)object4);
                    objectArray2[1] = object3;
                    deserializationContext.reportBadPropertyDefinition(beanDescription, (BeanPropertyDefinition)classArray, "Could not find creator property with name %s (known Creator properties: %s)", objectArray);
                    continue;
                }
                if (object3 != null) {
                    objectArray.setFallbackSetter((SettableBeanProperty)object3);
                }
                if ((classArray = classArray.findViews()) == null) {
                    classArray = beanDescription.findDefaultViews();
                }
                objectArray.setViews(classArray);
                beanDeserializerBuilder.addCreatorProperty((SettableBeanProperty)objectArray);
                continue;
            }
            if (object3 == null) continue;
            if ((classArray = classArray.findViews()) == null) {
                classArray = beanDescription.findDefaultViews();
            }
            ((SettableBeanProperty)object3).setViews(classArray);
            beanDeserializerBuilder.addProperty((SettableBeanProperty)object3);
        }
    }

    @Deprecated
    public List<BeanPropertyDefinition> filterBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder, List<BeanPropertyDefinition> list, Set<String> set) {
        return this.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, list, set, null);
    }

    public List<BeanPropertyDefinition> filterBeanProps(DeserializationContext deserializationContext, BeanDescription object, BeanDeserializerBuilder beanDeserializerBuilder, List<BeanPropertyDefinition> object2, Set<String> set, Set<String> set2) {
        HashMap hashMap;
        ArrayList arrayList;
        List<BeanPropertyDefinition> list = object2;
        object = arrayList;
        arrayList = new ArrayList(Math.max(4, object2.size()));
        object2 = hashMap;
        hashMap = new HashMap();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            Class<?> clazz;
            String string = beanPropertyDefinition.getName();
            if (IgnorePropertiesUtil.shouldIgnore(string, set, set2)) continue;
            if (!beanPropertyDefinition.hasConstructorParameter() && (clazz = beanPropertyDefinition.getRawPrimaryType()) != null && this.isIgnorableType(deserializationContext.getConfig(), beanPropertyDefinition, clazz, (Map<Class<?>, Boolean>)object2)) {
                beanDeserializerBuilder.addIgnorable(string);
                continue;
            }
            ((ArrayList)object).add(beanPropertyDefinition);
        }
        return object;
    }

    public void addBackReferenceProperties(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        List<BeanPropertyDefinition> list = beanDescription.findBackReferences();
        if (list != null) {
            for (BeanPropertyDefinition beanPropertyDefinition : list) {
                String string = beanPropertyDefinition.findReferenceName();
                JavaType javaType = beanPropertyDefinition.getPrimaryType();
                beanDeserializerBuilder.addBackReferenceProperty(string, this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, javaType));
            }
        }
    }

    @Deprecated
    public void addReferenceProperties(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        this.addBackReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
    }

    public void addInjectables(DeserializationContext serializable, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        Map<Object, AnnotatedMember> map = beanDescription.findInjectables();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                serializable = (AnnotatedMember)entry.getValue();
                PropertyName propertyName = PropertyName.construct(((Annotated)((Object)serializable)).getName());
                JavaType javaType = ((Annotated)((Object)serializable)).getType();
                Annotations annotations = beanDescription.getClassAnnotations();
                Object k2 = entry.getKey();
                beanDeserializerBuilder.addInjectable(propertyName, javaType, annotations, (AnnotatedMember)serializable, k2);
            }
        }
    }

    public SettableAnyProperty constructAnySetter(DeserializationContext serializable, BeanDescription object, AnnotatedMember annotatedMember) {
        Object object2;
        block13: {
            BeanProperty.Std std;
            Serializable serializable2;
            block14: {
                Object object3;
                Object object4;
                boolean bl;
                block12: {
                    BeanProperty.Std std2;
                    block11: {
                        BeanProperty.Std std3;
                        AnnotatedMember annotatedMember2 = annotatedMember;
                        bl = annotatedMember2 instanceof AnnotatedField;
                        if (!(annotatedMember2 instanceof AnnotatedMethod)) break block11;
                        AnnotatedMember annotatedMember3 = annotatedMember;
                        AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedMember3;
                        object = annotatedMethod.getParameterType(0);
                        serializable2 = ((BasicDeserializerFactory)object2).resolveMemberAndTypeAnnotations((DeserializationContext)serializable, annotatedMember3, annotatedMethod.getParameterType(1));
                        object4 = std3;
                        object3 = PropertyMetadata.STD_OPTIONAL;
                        std3 = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), (JavaType)serializable2, null, annotatedMember, (PropertyMetadata)object3);
                        break block12;
                    }
                    if (!bl) break block13;
                    serializable2 = ((AnnotatedField)annotatedMember).getType();
                    if (!((JavaType)serializable2).isMapLikeType()) break block14;
                    object = ((BasicDeserializerFactory)object2).resolveMemberAndTypeAnnotations((DeserializationContext)serializable, annotatedMember, (JavaType)serializable2);
                    serializable2 = ((JavaType)object).getKeyType();
                    object4 = ((JavaType)object).getContentType();
                    object3 = std2;
                    Object object5 = object;
                    object = PropertyMetadata.STD_OPTIONAL;
                    std2 = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), (JavaType)object5, null, annotatedMember, (PropertyMetadata)object);
                    JavaType javaType = serializable2;
                    serializable2 = object4;
                    object4 = object3;
                    object = javaType;
                }
                object3 = ((BasicDeserializerFactory)object2).findKeyDeserializerFromAnnotation((DeserializationContext)serializable, annotatedMember);
                if (object3 == null) {
                    object3 = (KeyDeserializer)((JavaType)object).getValueHandler();
                }
                if (object3 == null) {
                    object3 = ((DeserializationContext)serializable).findKeyDeserializer((JavaType)object, (BeanProperty)object4);
                } else if (object3 instanceof ContextualKeyDeserializer) {
                    object3 = ((ContextualKeyDeserializer)object3).createContextual((DeserializationContext)serializable, (BeanProperty)object4);
                }
                object2 = ((BasicDeserializerFactory)object2).findContentDeserializerFromAnnotation((DeserializationContext)serializable, annotatedMember);
                if (object2 == null) {
                    object2 = (JsonDeserializer)((JavaType)serializable2).getValueHandler();
                }
                if (object2 != null) {
                    object2 = ((DeserializationContext)serializable).handlePrimaryContextualization((JsonDeserializer<?>)object2, (BeanProperty)object4, (JavaType)serializable2);
                }
                object = (TypeDeserializer)((JavaType)serializable2).getTypeHandler();
                if (bl) {
                    return SettableAnyProperty.constructForMapField((DeserializationContext)serializable, (BeanProperty)object4, annotatedMember, (JavaType)serializable2, (KeyDeserializer)object3, (JsonDeserializer<Object>)object2, (TypeDeserializer)object);
                }
                return SettableAnyProperty.constructForMethod((DeserializationContext)serializable, (BeanProperty)object4, annotatedMember, (JavaType)serializable2, (KeyDeserializer)object3, (JsonDeserializer<Object>)object2, (TypeDeserializer)object);
            }
            if (!((JavaType)serializable2).hasRawClass(JsonNode.class) && !((JavaType)serializable2).hasRawClass(ObjectNode.class)) {
                Object[] objectArray = new Object[1];
                object2 = objectArray;
                objectArray[0] = ClassUtil.getTypeDescription((JavaType)serializable2);
                return (SettableAnyProperty)((DeserializationContext)serializable).reportBadDefinition(((BeanDescription)object).getType(), String.format("Unsupported type for any-setter: %s -- only support `Map`s, `JsonNode` and `ObjectNode` ", (Object[])object2));
            }
            DeserializationContext deserializationContext = serializable;
            object2 = ((BasicDeserializerFactory)object2).resolveMemberAndTypeAnnotations((DeserializationContext)serializable, annotatedMember, (JavaType)serializable2);
            serializable = deserializationContext.constructType(JsonNode.class);
            object = std;
            Object object6 = object2;
            object2 = PropertyMetadata.STD_OPTIONAL;
            std = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), (JavaType)object6, null, annotatedMember, (PropertyMetadata)object2);
            object2 = deserializationContext.findRootValueDeserializer((JavaType)serializable);
            return SettableAnyProperty.constructForJsonNodeField(deserializationContext, (BeanProperty)object, annotatedMember, (JavaType)serializable, (JsonDeserializer<Object>)object2);
        }
        Object[] objectArray = new Object[1];
        object2 = objectArray;
        objectArray[0] = ClassUtil.nameOf(annotatedMember.getClass());
        return (SettableAnyProperty)((DeserializationContext)serializable).reportBadDefinition(((BeanDescription)object).getType(), String.format("Unrecognized mutator type for any-setter: %s", (Object[])object2));
    }

    public SettableBeanProperty constructSettableProperty(DeserializationContext deserializationContext, BeanDescription object, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType) {
        SettableBeanProperty settableBeanProperty;
        Object object2;
        AnnotatedMember annotatedMember = beanPropertyDefinition.getNonConstructorMutator();
        if (annotatedMember == null) {
            object2 = new Object[]{};
            deserializationContext.reportBadPropertyDefinition((BeanDescription)object, beanPropertyDefinition, "No non-constructor mutator available", object2);
        }
        javaType = ((BasicDeserializerFactory)object3).resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
        object2 = (TypeDeserializer)javaType.getTypeHandler();
        if (annotatedMember instanceof AnnotatedMethod) {
            MethodProperty methodProperty;
            settableBeanProperty = methodProperty;
            object = ((BeanDescription)object).getClassAnnotations();
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedMember;
            methodProperty = new MethodProperty(beanPropertyDefinition, javaType, (TypeDeserializer)object2, (Annotations)object, annotatedMethod);
        } else {
            FieldProperty fieldProperty;
            settableBeanProperty = fieldProperty;
            object = ((BeanDescription)object).getClassAnnotations();
            AnnotatedField annotatedField = (AnnotatedField)annotatedMember;
            fieldProperty = new FieldProperty(beanPropertyDefinition, javaType, (TypeDeserializer)object2, (Annotations)object, annotatedField);
        }
        Object object3 = ((BasicDeserializerFactory)object3).findDeserializerFromAnnotation(deserializationContext, annotatedMember);
        if (object3 == null) {
            object3 = (JsonDeserializer)javaType.getValueHandler();
        }
        if (object3 != null) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.handlePrimaryContextualization((JsonDeserializer<?>)object3, settableBeanProperty, javaType));
        }
        if ((object3 = beanPropertyDefinition.findReferenceType()) != null && ((AnnotationIntrospector.ReferenceProperty)object3).isManagedReference()) {
            settableBeanProperty.setManagedReferenceName(((AnnotationIntrospector.ReferenceProperty)object3).getName());
        }
        if ((object3 = beanPropertyDefinition.findObjectIdInfo()) != null) {
            settableBeanProperty.setObjectIdInfo((ObjectIdInfo)object3);
        }
        return settableBeanProperty;
    }

    public SettableBeanProperty constructSetterlessProperty(DeserializationContext deserializationContext, BeanDescription object, BeanPropertyDefinition beanPropertyDefinition) {
        SetterlessProperty setterlessProperty;
        BeanDeserializerFactory beanDeserializerFactory = object2;
        BeanDeserializerFactory beanDeserializerFactory2 = object2;
        Object object2 = beanPropertyDefinition.getGetter();
        JavaType javaType = beanDeserializerFactory2.resolveMemberAndTypeAnnotations(deserializationContext, (AnnotatedMember)object2, ((AnnotatedMethod)object2).getType());
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        SettableBeanProperty settableBeanProperty = setterlessProperty;
        object = ((BeanDescription)object).getClassAnnotations();
        setterlessProperty = new SetterlessProperty(beanPropertyDefinition, javaType, typeDeserializer, (Annotations)object, (AnnotatedMethod)object2);
        if ((object2 = beanDeserializerFactory.findDeserializerFromAnnotation(deserializationContext, (Annotated)object2)) == null) {
            object2 = (JsonDeserializer)javaType.getValueHandler();
        }
        if (object2 != null) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.handlePrimaryContextualization((JsonDeserializer<?>)object2, settableBeanProperty, javaType));
        }
        return settableBeanProperty;
    }

    public boolean isPotentialBeanType(Class<?> clazz) {
        Object object = ClassUtil.canBeABeanType(clazz);
        if (object == null) {
            if (!ClassUtil.isProxyType(clazz)) {
                object = ClassUtil.isLocalType(clazz, true);
                if (object == null) {
                    return true;
                }
                throw new IllegalArgumentException("Cannot deserialize Class " + clazz.getName() + " (of type " + (String)object + ") as a Bean");
            }
            throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Cannot deserialize Proxy class "), " as a Bean"));
        }
        throw new IllegalArgumentException("Cannot deserialize Class " + clazz.getName() + " (of type " + (String)object + ") as a Bean");
    }

    public boolean isIgnorableType(DeserializationConfig deserializationConfig, BeanPropertyDefinition beanPropertyDefinition, Class<?> clazz, Map<Class<?>, Boolean> map) {
        block5: {
            Object object;
            block4: {
                object = map.get(clazz);
                if (object != null) {
                    return (Boolean)object;
                }
                if (clazz == String.class || clazz.isPrimitive()) break block4;
                object = deserializationConfig.getConfigOverride(clazz).getIsIgnoredType();
                if (object != null) break block5;
                DeserializationConfig deserializationConfig2 = deserializationConfig;
                object = deserializationConfig2.introspectClassAnnotations(clazz);
                object = deserializationConfig2.getAnnotationIntrospector().isIgnorableType(((BeanDescription)object).getClassInfo());
                if (object != null) break block5;
            }
            object = Boolean.FALSE;
        }
        map.put(clazz, (Boolean)object);
        return (Boolean)object;
    }

    public void _validateSubType(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        SubTypeValidator.instance().validateSubType(deserializationContext, javaType, beanDescription);
    }
}

