/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.annotation.JacksonInject;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;

public class CreatorProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedParameter _annotated;
    protected final JacksonInject.Value _injectableValue;
    protected SettableBeanProperty _fallbackSetter;
    protected final int _creatorIndex;
    protected boolean _ignorable;

    public CreatorProperty(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, JacksonInject.Value value, PropertyMetadata propertyMetadata) {
        super(propertyName, javaType, propertyName2, typeDeserializer, annotations, propertyMetadata);
        this._annotated = annotatedParameter;
        this._creatorIndex = n2;
        this._injectableValue = value;
        this._fallbackSetter = null;
    }

    @Deprecated
    public CreatorProperty(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, Object object, PropertyMetadata propertyMetadata) {
        object = object == null ? null : JacksonInject.Value.construct(object, null);
        this(propertyName, javaType, propertyName2, typeDeserializer, annotations, annotatedParameter, n2, (JacksonInject.Value)object, propertyMetadata);
    }

    public static CreatorProperty construct(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, JacksonInject.Value value, PropertyMetadata propertyMetadata) {
        return new CreatorProperty(propertyName, javaType, propertyName2, typeDeserializer, annotations, annotatedParameter, n2, value, propertyMetadata);
    }

    public CreatorProperty(CreatorProperty creatorProperty, PropertyName propertyName) {
        super(creatorProperty, propertyName);
        this._annotated = creatorProperty._annotated;
        this._injectableValue = creatorProperty._injectableValue;
        this._fallbackSetter = creatorProperty._fallbackSetter;
        this._creatorIndex = creatorProperty._creatorIndex;
        this._ignorable = creatorProperty._ignorable;
    }

    public CreatorProperty(CreatorProperty creatorProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(creatorProperty, jsonDeserializer, nullValueProvider);
        this._annotated = creatorProperty._annotated;
        this._injectableValue = creatorProperty._injectableValue;
        this._fallbackSetter = creatorProperty._fallbackSetter;
        this._creatorIndex = creatorProperty._creatorIndex;
        this._ignorable = creatorProperty._ignorable;
    }

    private final void _verifySetter() {
        if (this._fallbackSetter == null) {
            this._reportMissingSetter(null, null);
        }
    }

    private void _reportMissingSetter(JsonParser jsonParser, DeserializationContext deserializationContext) {
        String string = "No fallback setter/field defined for creator property " + ClassUtil.name(this.getName());
        if (deserializationContext != null) {
            deserializationContext.reportBadDefinition(this.getType(), string);
            return;
        }
        throw InvalidDefinitionException.from(jsonParser, string, this.getType());
    }

    @Override
    public SettableBeanProperty withName(PropertyName propertyName) {
        return new CreatorProperty(this, propertyName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        NullValueProvider nullValueProvider = this._valueDeserializer;
        if (nullValueProvider == jsonDeserializer) {
            return this;
        }
        if (nullValueProvider == (nullValueProvider = this._nullProvider)) {
            nullValueProvider = jsonDeserializer;
        }
        return new CreatorProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        return new CreatorProperty(this, this._valueDeserializer, nullValueProvider);
    }

    @Override
    public void fixAccess(DeserializationConfig deserializationConfig) {
        SettableBeanProperty settableBeanProperty = ((CreatorProperty)settableBeanProperty)._fallbackSetter;
        if (settableBeanProperty != null) {
            settableBeanProperty.fixAccess(deserializationConfig);
        }
    }

    public void setFallbackSetter(SettableBeanProperty settableBeanProperty) {
        this._fallbackSetter = settableBeanProperty;
    }

    @Override
    public void markAsIgnorable() {
        this._ignorable = true;
    }

    @Override
    public boolean isIgnorable() {
        return this._ignorable;
    }

    @Deprecated
    public Object findInjectableValue(DeserializationContext deserializationContext, Object object) {
        if (this._injectableValue == null) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = ClassUtil.name(this.getName());
            objectArray[1] = ClassUtil.classNameOf(this);
            deserializationContext.reportBadDefinition(ClassUtil.classOf(object), String.format("Property %s (type %s) has no injectable value id configured", objectArray2));
        }
        return deserializationContext.findInjectableValue(this._injectableValue.getId(), this, object);
    }

    @Deprecated
    public void inject(DeserializationContext deserializationContext, Object object) {
        CreatorProperty creatorProperty = this;
        creatorProperty.set(object, creatorProperty.findInjectableValue(deserializationContext, object));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Serializable serializable = ((CreatorProperty)serializable)._annotated;
        if (serializable == null) {
            return null;
        }
        return ((AnnotatedMember)serializable).getAnnotation(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public int getCreatorIndex() {
        return this._creatorIndex;
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        CreatorProperty creatorProperty = this;
        creatorProperty._verifySetter();
        creatorProperty._fallbackSetter.set(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        CreatorProperty creatorProperty = this;
        creatorProperty._verifySetter();
        return creatorProperty._fallbackSetter.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public void set(Object object, Object object2) {
        CreatorProperty creatorProperty = this;
        creatorProperty._verifySetter();
        creatorProperty._fallbackSetter.set(object, object2);
    }

    @Override
    public Object setAndReturn(Object object, Object object2) {
        CreatorProperty creatorProperty = this;
        creatorProperty._verifySetter();
        return creatorProperty._fallbackSetter.setAndReturn(object, object2);
    }

    @Override
    public PropertyMetadata getMetadata() {
        CreatorProperty creatorProperty = serializable;
        Serializable serializable = super.getMetadata();
        SettableBeanProperty settableBeanProperty = creatorProperty._fallbackSetter;
        if (settableBeanProperty != null) {
            return ((PropertyMetadata)serializable).withMergeInfo(settableBeanProperty.getMetadata().getMergeInfo());
        }
        return serializable;
    }

    @Override
    public Object getInjectableValueId() {
        Serializable serializable = ((CreatorProperty)serializable)._injectableValue;
        return serializable == null ? null : ((JacksonInject.Value)serializable).getId();
    }

    @Override
    public boolean isInjectionOnly() {
        Serializable serializable = ((CreatorProperty)serializable)._injectableValue;
        return serializable != null && !((JacksonInject.Value)serializable).willUseInput(true);
    }

    @Override
    public String toString() {
        return "[creator property, name " + ClassUtil.name(this.getName()) + "; inject id '" + this.getInjectableValueId() + "']";
    }
}

