/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.format.InputAccessor;
import com.privatefasterxml.jackson.core.format.MatchStrength;
import com.privatefasterxml.jackson.core.io.MergedStream;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;

public class DataFormatReaders {
    public static final int DEFAULT_MAX_INPUT_LOOKAHEAD = 64;
    protected final ObjectReader[] _readers;
    protected final MatchStrength _optimalMatch;
    protected final MatchStrength _minimalMatch;
    protected final int _maxInputLookahead;

    public DataFormatReaders(ObjectReader ... objectReaderArray) {
        DataFormatReaders dataFormatReaders = object;
        Object object = MatchStrength.WEAK_MATCH;
        dataFormatReaders(objectReaderArray, MatchStrength.SOLID_MATCH, (MatchStrength)((Object)object), 64);
    }

    public DataFormatReaders(Collection<ObjectReader> collection) {
        Collection<ObjectReader> collection2 = collection;
        this(collection2.toArray(new ObjectReader[collection2.size()]));
    }

    private DataFormatReaders(ObjectReader[] objectReaderArray, MatchStrength matchStrength, MatchStrength matchStrength2, int n2) {
        this._readers = objectReaderArray;
        this._optimalMatch = matchStrength;
        this._minimalMatch = matchStrength2;
        this._maxInputLookahead = n2;
    }

    private Match _findFormat(AccessorForReader accessorForReader) {
        ObjectReader objectReader = null;
        Enum enum_ = null;
        ObjectReader[] objectReaderArray = this._readers;
        int n2 = this._readers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectReader objectReader2 = objectReaderArray[i2];
            accessorForReader.reset();
            MatchStrength matchStrength = objectReader2.getFactory().hasFormat(accessorForReader);
            if (matchStrength == null || matchStrength.ordinal() < this._minimalMatch.ordinal() || objectReader != null && enum_.ordinal() >= matchStrength.ordinal()) continue;
            if (matchStrength.ordinal() >= this._optimalMatch.ordinal()) {
                enum_ = matchStrength;
                objectReader = objectReader2;
                break;
            }
            enum_ = matchStrength;
            objectReader = objectReader2;
        }
        return accessorForReader.createMatcher(objectReader, (MatchStrength)enum_);
    }

    public DataFormatReaders withOptimalMatch(MatchStrength matchStrength) {
        if (matchStrength == objectReaderArray._optimalMatch) {
            return objectReaderArray;
        }
        ObjectReader[] objectReaderArray = objectReaderArray._readers;
        MatchStrength matchStrength2 = objectReaderArray._minimalMatch;
        int n2 = objectReaderArray._maxInputLookahead;
        return new DataFormatReaders(objectReaderArray, matchStrength, matchStrength2, n2);
    }

    public DataFormatReaders withMinimalMatch(MatchStrength matchStrength) {
        if (matchStrength == objectReaderArray._minimalMatch) {
            return objectReaderArray;
        }
        ObjectReader[] objectReaderArray = objectReaderArray._readers;
        MatchStrength matchStrength2 = objectReaderArray._optimalMatch;
        int n2 = objectReaderArray._maxInputLookahead;
        return new DataFormatReaders(objectReaderArray, matchStrength2, matchStrength, n2);
    }

    public DataFormatReaders with(ObjectReader[] objectReaderArray) {
        DataFormatReaders dataFormatReaders = object;
        Object object = dataFormatReaders._optimalMatch;
        MatchStrength matchStrength = dataFormatReaders._minimalMatch;
        int n2 = dataFormatReaders._maxInputLookahead;
        return new DataFormatReaders(objectReaderArray, (MatchStrength)((Object)object), matchStrength, n2);
    }

    public DataFormatReaders withMaxInputLookahead(int n2) {
        if (n2 == objectReaderArray._maxInputLookahead) {
            return objectReaderArray;
        }
        ObjectReader[] objectReaderArray = objectReaderArray._readers;
        MatchStrength matchStrength = objectReaderArray._optimalMatch;
        MatchStrength matchStrength2 = objectReaderArray._minimalMatch;
        return new DataFormatReaders(objectReaderArray, matchStrength, matchStrength2, n2);
    }

    public DataFormatReaders with(DeserializationConfig object) {
        int n2 = object2._readers.length;
        ObjectReader[] objectReaderArray = new ObjectReader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectReaderArray[i2] = object2._readers[i2].with((DeserializationConfig)object);
        }
        DataFormatReaders dataFormatReaders = object2;
        Object object2 = dataFormatReaders._optimalMatch;
        object = dataFormatReaders._minimalMatch;
        n2 = dataFormatReaders._maxInputLookahead;
        return new DataFormatReaders(objectReaderArray, (MatchStrength)((Object)object2), (MatchStrength)((Object)object), n2);
    }

    public DataFormatReaders withType(JavaType object) {
        int n2 = object2._readers.length;
        ObjectReader[] objectReaderArray = new ObjectReader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectReaderArray[i2] = object2._readers[i2].forType((JavaType)object);
        }
        DataFormatReaders dataFormatReaders = object2;
        Object object2 = dataFormatReaders._optimalMatch;
        object = dataFormatReaders._minimalMatch;
        n2 = dataFormatReaders._maxInputLookahead;
        return new DataFormatReaders(objectReaderArray, (MatchStrength)((Object)object2), (MatchStrength)((Object)object), n2);
    }

    public Match findFormat(InputStream inputStream) {
        return this._findFormat(new AccessorForReader(inputStream, new byte[this._maxInputLookahead]));
    }

    public Match findFormat(byte[] byArray) {
        return this._findFormat(new AccessorForReader(byArray));
    }

    public Match findFormat(byte[] byArray, int n2, int n3) {
        return this._findFormat(new AccessorForReader(byArray, n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("[");
        ObjectReader[] objectReaderArray = this._readers;
        int n2 = this._readers.length;
        if (n2 > 0) {
            stringBuilder2.append(objectReaderArray[0].getFactory().getFormatName());
            for (int i2 = 1; i2 < n2; ++i2) {
                stringBuilder2.append(", ");
                stringBuilder2.append(this._readers[i2].getFactory().getFormatName());
            }
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(']');
        return stringBuilder3.toString();
    }

    public static class AccessorForReader
    extends InputAccessor.Std {
        public AccessorForReader(InputStream inputStream, byte[] byArray) {
            super(inputStream, byArray);
        }

        public AccessorForReader(byte[] byArray) {
            super(byArray);
        }

        public AccessorForReader(byte[] byArray, int n2, int n3) {
            super(byArray, n2, n3);
        }

        public Match createMatcher(ObjectReader objectReader, MatchStrength matchStrength) {
            AccessorForReader accessorForReader = this;
            InputStream inputStream = accessorForReader._in;
            byte[] byArray = accessorForReader._buffer;
            int n2 = accessorForReader._bufferedStart;
            int n3 = this._bufferedEnd - n2;
            return new Match(inputStream, byArray, n2, n3, objectReader, matchStrength);
        }
    }

    public static class Match {
        protected final InputStream _originalStream;
        protected final byte[] _bufferedData;
        protected final int _bufferedStart;
        protected final int _bufferedLength;
        protected final ObjectReader _match;
        protected final MatchStrength _matchStrength;

        public Match(InputStream inputStream, byte[] byArray, int n2, int n3, ObjectReader objectReader, MatchStrength matchStrength) {
            this._originalStream = inputStream;
            this._bufferedData = byArray;
            this._bufferedStart = n2;
            this._bufferedLength = n3;
            this._match = objectReader;
            this._matchStrength = matchStrength;
        }

        public boolean hasMatch() {
            return this._match != null;
        }

        public MatchStrength getMatchStrength() {
            Object object = object._matchStrength;
            if (object == null) {
                object = MatchStrength.INCONCLUSIVE;
            }
            return object;
        }

        public ObjectReader getReader() {
            return this._match;
        }

        public String getMatchedFormatName() {
            return this._match.getFactory().getFormatName();
        }

        public JsonParser createParserWithMatch() {
            Versioned versioned = ((Match)object)._match;
            if (versioned == null) {
                return null;
            }
            versioned = ((ObjectReader)versioned).getFactory();
            if (((Match)object)._originalStream == null) {
                Match match = object;
                Object object = match._bufferedData;
                int n2 = match._bufferedStart;
                int n3 = match._bufferedLength;
                return ((JsonFactory)versioned).createParser((byte[])object, n2, n3);
            }
            return ((JsonFactory)versioned).createParser(((Match)object).getDataStream());
        }

        public InputStream getDataStream() {
            Object object;
            if (((Match)object)._originalStream == null) {
                Match match = object;
                object = match._bufferedData;
                int n2 = match._bufferedStart;
                int n3 = match._bufferedLength;
                return new ByteArrayInputStream((byte[])object, n2, n3);
            }
            Match match = object;
            object = match._originalStream;
            byte[] byArray = match._bufferedData;
            int n4 = match._bufferedStart;
            int n5 = match._bufferedLength;
            return new MergedStream(null, (InputStream)object, byArray, n4, n5);
        }
    }
}

