/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.InjectableValues;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.deser.DeserializerCache;
import com.privatefasterxml.jackson.databind.deser.DeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.privatefasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.privatefasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultDeserializationContext
extends DeserializationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;
    private List<ObjectIdResolver> _objectIdResolvers;

    public DefaultDeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        super(deserializerFactory, deserializerCache);
    }

    public DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        super(defaultDeserializationContext, deserializationConfig, jsonParser, injectableValues);
    }

    public DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig) {
        super((DeserializationContext)defaultDeserializationContext, deserializationConfig);
    }

    public DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializerFactory deserializerFactory) {
        super((DeserializationContext)defaultDeserializationContext, deserializerFactory);
    }

    public DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext) {
        super(defaultDeserializationContext);
    }

    public DefaultDeserializationContext copy() {
        throw new IllegalStateException("DefaultDeserializationContext sub-class not overriding copy()");
    }

    @Override
    public ReadableObjectId findObjectId(Object object, ObjectIdGenerator<?> linkedHashMap, ObjectIdResolver object2) {
        if (object == null) {
            return null;
        }
        object = ((ObjectIdGenerator)((Object)linkedHashMap)).key(object);
        linkedHashMap = this._objectIds;
        if (linkedHashMap == null) {
            LinkedHashMap linkedHashMap2;
            linkedHashMap = linkedHashMap2;
            linkedHashMap2 = new LinkedHashMap();
            this._objectIds = linkedHashMap;
        } else if ((linkedHashMap = (ReadableObjectId)linkedHashMap.get(object)) != null) {
            return linkedHashMap;
        }
        linkedHashMap = null;
        Object object3 = this._objectIdResolvers;
        if (object3 == null) {
            ArrayList arrayList;
            object3 = arrayList;
            arrayList = new ArrayList(8);
            this._objectIdResolvers = object3;
        } else {
            object3 = object3.iterator();
            while (object3.hasNext()) {
                ObjectIdResolver objectIdResolver = (ObjectIdResolver)object3.next();
                if (!objectIdResolver.canUseFor((ObjectIdResolver)object2)) continue;
                linkedHashMap = objectIdResolver;
                break;
            }
        }
        if (linkedHashMap == null) {
            linkedHashMap = object2.newForDeserialization(this);
            this._objectIdResolvers.add((ObjectIdResolver)((Object)linkedHashMap));
        }
        object2 = this.createReadableObjectId((ObjectIdGenerator.IdKey)object);
        ((ReadableObjectId)object2).setResolver((ObjectIdResolver)((Object)linkedHashMap));
        ((AbstractMap)this._objectIds).put((ObjectIdGenerator.IdKey)object, (ReadableObjectId)object2);
        return object2;
    }

    public ReadableObjectId createReadableObjectId(ObjectIdGenerator.IdKey idKey) {
        return new ReadableObjectId(idKey);
    }

    @Override
    public void checkUnresolvedObjectId() {
        if (this._objectIds == null) {
            return;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS)) {
            return;
        }
        UnresolvedForwardReference unresolvedForwardReference = null;
        Iterator<Map.Entry<ObjectIdGenerator.IdKey, ReadableObjectId>> iterator = this._objectIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next().getValue();
            if (!((ReadableObjectId)object).hasReferringProperties() || this.tryToResolveUnresolvedObjectId((ReadableObjectId)object)) continue;
            if (unresolvedForwardReference == null) {
                unresolvedForwardReference = new UnresolvedForwardReference(this.getParser(), "Unresolved forward references for: ").withStackTrace();
            }
            ReadableObjectId readableObjectId = object;
            object = readableObjectId.getKey().key;
            Iterator<ReadableObjectId.Referring> iterator2 = readableObjectId.referringProperties();
            while (iterator2.hasNext()) {
                ReadableObjectId.Referring referring = iterator2.next();
                Class<?> clazz = referring.getBeanType();
                unresolvedForwardReference.addUnresolvedId(object, clazz, referring.getLocation());
            }
        }
        if (unresolvedForwardReference == null) {
            return;
        }
        throw unresolvedForwardReference;
    }

    public boolean tryToResolveUnresolvedObjectId(ReadableObjectId readableObjectId) {
        return readableObjectId.tryToResolveUnresolved(this);
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated jsonDeserializer, Object object) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        block6: {
                            if (object == null) {
                                return null;
                            }
                            if (!(object instanceof JsonDeserializer)) break block6;
                            jsonDeserializer = (JsonDeserializer)object;
                            break block7;
                        }
                        if (!(object instanceof Class)) break block8;
                        if ((object = (Class)object) == JsonDeserializer.None.class || ClassUtil.isBogusClass(object)) break block9;
                        if (!JsonDeserializer.class.isAssignableFrom((Class<?>)object)) break block10;
                        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
                        jsonDeserializer = handlerInstantiator == null ? null : handlerInstantiator.deserializerInstance(this._config, (Annotated)((Object)jsonDeserializer), (Class<?>)object);
                        if (jsonDeserializer == null) {
                            jsonDeserializer = (JsonDeserializer)ClassUtil.createInstance(object, this._config.canOverrideAccessModifiers());
                        }
                    }
                    if (jsonDeserializer instanceof ResolvableDeserializer) {
                        ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(this);
                    }
                    return jsonDeserializer;
                }
                throw new IllegalStateException(a.a((Class)object, new StringBuilder("AnnotationIntrospector returned Class "), "; expected Class<JsonDeserializer>"));
            }
            return null;
        }
        throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + object.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated object, Object object2) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        block6: {
                            if (object2 == null) {
                                return null;
                            }
                            if (!(object2 instanceof KeyDeserializer)) break block6;
                            object = (KeyDeserializer)object2;
                            break block7;
                        }
                        if (!(object2 instanceof Class)) break block8;
                        if ((object2 = (Class)object2) == KeyDeserializer.None.class || ClassUtil.isBogusClass(object2)) break block9;
                        if (!KeyDeserializer.class.isAssignableFrom((Class<?>)object2)) break block10;
                        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
                        object = handlerInstantiator == null ? null : handlerInstantiator.keyDeserializerInstance(this._config, (Annotated)object, (Class<?>)object2);
                        if (object == null) {
                            object = (KeyDeserializer)ClassUtil.createInstance(object2, this._config.canOverrideAccessModifiers());
                        }
                    }
                    if (object instanceof ResolvableDeserializer) {
                        ((ResolvableDeserializer)object).resolve(this);
                    }
                    return object;
                }
                throw new IllegalStateException(a.a((Class)object2, new StringBuilder("AnnotationIntrospector returned Class "), "; expected Class<KeyDeserializer>"));
            }
            return null;
        }
        throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object2.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);

    public abstract DefaultDeserializationContext createDummyInstance(DeserializationConfig var1);

    public Object readRootValue(JsonParser jsonParser, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object) {
        if (this._config.useRootWrapping()) {
            return this._unwrapAndDeserialize(jsonParser, javaType, jsonDeserializer, object);
        }
        if (object == null) {
            return jsonDeserializer.deserialize(jsonParser, this);
        }
        return jsonDeserializer.deserialize(jsonParser, this, object);
    }

    public Object _unwrapAndDeserialize(JsonParser jsonParser, JavaType javaType, JsonDeserializer<Object> object, Object object2) {
        Object[] objectArray;
        String string = objectArray7._config.findRootName(javaType).getSimpleName();
        Object object3 = JsonToken.START_OBJECT;
        if (jsonParser.currentToken() != object3) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = ClassUtil.name(string);
            objectArray2[1] = jsonParser.currentToken();
            objectArray7.reportWrongTokenException(javaType, (JsonToken)((Object)object3), "Current token not START_OBJECT (needed to unwrap root name %s), but %s", objectArray);
        }
        object3 = JsonToken.FIELD_NAME;
        if (jsonParser.nextToken() != object3) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = ClassUtil.name(string);
            objectArray3[1] = jsonParser.currentToken();
            objectArray7.reportWrongTokenException(javaType, (JsonToken)((Object)object3), "Current token not FIELD_NAME (to contain expected root name %s), but %s", objectArray);
        }
        if (!string.equals(object3 = jsonParser.currentName())) {
            Object[] objectArray4 = new Object[3];
            objectArray = objectArray4;
            objectArray[0] = ClassUtil.name((String)object3);
            objectArray[1] = ClassUtil.name(string);
            objectArray4[2] = ClassUtil.getTypeDescription(javaType);
            objectArray7.reportPropertyInputMismatch(javaType, (String)object3, "Root name (%s) does not match expected (%s) for type %s", objectArray);
        }
        jsonParser.nextToken();
        object = object2 == null ? ((JsonDeserializer)object).deserialize(jsonParser, (DeserializationContext)objectArray7) : ((JsonDeserializer)object).deserialize(jsonParser, (DeserializationContext)objectArray7, (Object)object2);
        object2 = JsonToken.END_OBJECT;
        if (jsonParser.nextToken() != object2) {
            Object[] objectArray5 = objectArray7;
            Object[] objectArray6 = new Object[2];
            Object[] objectArray7 = objectArray6;
            objectArray7[0] = ClassUtil.name(string);
            objectArray6[1] = jsonParser.currentToken();
            objectArray5.reportWrongTokenException(javaType, (JsonToken)((Object)object2), "Current token not END_OBJECT (to match wrapper object with root name %s), but %s", objectArray7);
        }
        return object;
    }

    public static final class Impl
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;

        public Impl(DeserializerFactory deserializerFactory) {
            super(deserializerFactory, null);
        }

        private Impl(Impl impl, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            super(impl, deserializationConfig, jsonParser, injectableValues);
        }

        private Impl(Impl impl) {
            super(impl);
        }

        private Impl(Impl impl, DeserializerFactory deserializerFactory) {
            super((DefaultDeserializationContext)impl, deserializerFactory);
        }

        private Impl(Impl impl, DeserializationConfig deserializationConfig) {
            super((DefaultDeserializationContext)impl, deserializationConfig);
        }

        @Override
        public DefaultDeserializationContext copy() {
            ClassUtil.verifyMustOverride(Impl.class, this, "copy");
            return new Impl(this);
        }

        @Override
        public DefaultDeserializationContext createInstance(DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            return new Impl(this, deserializationConfig, jsonParser, injectableValues);
        }

        @Override
        public DefaultDeserializationContext createDummyInstance(DeserializationConfig deserializationConfig) {
            return new Impl(this, deserializationConfig);
        }

        @Override
        public DefaultDeserializationContext with(DeserializerFactory deserializerFactory) {
            return new Impl(this, deserializerFactory);
        }
    }
}

