/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.deser.DeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.type.ArrayType;
import com.privatefasterxml.jackson.databind.type.CollectionLikeType;
import com.privatefasterxml.jackson.databind.type.CollectionType;
import com.privatefasterxml.jackson.databind.type.MapLikeType;
import com.privatefasterxml.jackson.databind.type.MapType;
import com.privatefasterxml.jackson.databind.type.ReferenceType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import com.privatefasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;
import java.util.HashMap;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers;
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers;

    public DeserializerCache() {
        this(2000);
    }

    public DeserializerCache(int n2) {
        LRUMap lRUMap;
        HashMap hashMap;
        DeserializerCache deserializerCache = serializable;
        Serializable serializable = hashMap;
        hashMap = new HashMap(8);
        v2._incompleteDeserializers = serializable;
        int n3 = Math.min(64, n2 >> 2);
        LRUMap lRUMap2 = lRUMap;
        lRUMap = new LRUMap(n3, n2);
        deserializerCache._cachedDeserializers = lRUMap2;
    }

    /*
     * WARNING - void declaration
     */
    private JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        void var2_3;
        Object object;
        JavaType javaType2;
        void var1_2;
        AnnotationIntrospector annotationIntrospector = var1_2.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType2;
        }
        if (((JavaType)javaType2).isMapLikeType() && (object = ((JavaType)javaType2).getKeyType()) != null && ((JavaType)object).getValueHandler() == null && (object = annotationIntrospector.findKeyDeserializer((Annotated)var2_3)) != null && (object = var1_2.keyDeserializerInstance((Annotated)var2_3, object)) != null) {
            javaType2 = ((MapLikeType)javaType2).withKeyValueHandler(object);
        }
        if ((object = ((JavaType)javaType2).getContentType()) != null && ((JavaType)object).getValueHandler() == null && (object = annotationIntrospector.findContentDeserializer((Annotated)var2_3)) != null) {
            JsonDeserializer<Object> jsonDeserializer = null;
            if (object instanceof JsonDeserializer) {
                jsonDeserializer = (JsonDeserializer<Object>)object;
            } else {
                Class<?> clazz = this._verifyAsClass(object, "findContentDeserializer", JsonDeserializer.None.class);
                if (clazz != null) {
                    jsonDeserializer = var1_2.deserializerInstance((Annotated)var2_3, clazz);
                }
            }
            if (jsonDeserializer != null) {
                javaType2 = ((JavaType)javaType2).withContentValueHandler(jsonDeserializer);
            }
        }
        return annotationIntrospector.refineDeserializationType(var1_2.getConfig(), (Annotated)var2_3, javaType2);
    }

    private boolean _hasCustomHandlers(JavaType javaType) {
        if (javaType.isContainerType()) {
            Serializable serializable = javaType.getContentType();
            if (serializable != null && (((JavaType)serializable).getValueHandler() != null || ((JavaType)serializable).getTypeHandler() != null)) {
                return true;
            }
            if (javaType.isMapLikeType() && javaType.getKeyType().getValueHandler() != null) {
                return true;
            }
        }
        return false;
    }

    private Class<?> _verifyAsClass(Object object, String string, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (object instanceof Class) {
            Serializable serializable = (Class)object;
            if (serializable != clazz && !ClassUtil.isBogusClass(serializable)) {
                return serializable;
            }
            return null;
        }
        throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
    }

    public Object writeReplace() {
        DeserializerCache deserializerCache = this;
        deserializerCache._incompleteDeserializers.clear();
        return deserializerCache;
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null && (jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType)) == null) {
            jsonDeserializer = this._handleUnknownValueDeserializer(deserializationContext, javaType);
        }
        return jsonDeserializer;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext deserializationContext, DeserializerFactory object, JavaType javaType) {
        if ((object = ((DeserializerFactory)object).createKeyDeserializer(deserializationContext, javaType)) == null) {
            return this._handleUnknownKeyDeserializer(deserializationContext, javaType);
        }
        if (object instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)object).resolve(deserializationContext);
        }
        return object;
    }

    public boolean hasValueDeserializerFor(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null) {
            jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType);
        }
        return jsonDeserializer != null;
    }

    public JsonDeserializer<Object> _findCachedDeserializer(JavaType javaType) {
        if (javaType != null) {
            if (this._hasCustomHandlers(javaType)) {
                return null;
            }
            return this._cachedDeserializers.get(javaType);
        }
        throw new IllegalArgumentException("Null JavaType passed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext jsonDeserializer, DeserializerFactory deserializerFactory, JavaType javaType) {
        DeserializerCache deserializerCache = this;
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = deserializerCache._incompleteDeserializers;
        synchronized (hashMap) {
            Throwable throwable2;
            block13: {
                block12: {
                    int n2;
                    block11: {
                        JsonDeserializer<Object> jsonDeserializer2;
                        try {
                            JsonDeserializer<Object> jsonDeserializer3 = deserializerCache._findCachedDeserializer(javaType);
                            if (jsonDeserializer3 != null) {
                                return jsonDeserializer3;
                            }
                            n2 = this._incompleteDeserializers.size();
                            if (n2 <= 0 || (jsonDeserializer2 = this._incompleteDeserializers.get(javaType)) == null) break block11;
                        }
                        catch (Throwable throwable2) {}
                        return jsonDeserializer2;
                    }
                    try {
                        jsonDeserializer = this._createAndCache2((DeserializationContext)((Object)jsonDeserializer), deserializerFactory, javaType);
                        if (n2 != 0) break block12;
                    }
                    catch (Throwable throwable3) {
                        if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                            this._incompleteDeserializers.clear();
                        }
                        throw throwable3;
                    }
                    if (this._incompleteDeserializers.size() <= 0) break block12;
                    this._incompleteDeserializers.clear();
                    break block13;
                }
                return jsonDeserializer;
            }
            throw throwable2;
        }
    }

    public JsonDeserializer<Object> _createAndCache2(DeserializationContext deserializationContext, DeserializerFactory object, JavaType javaType) {
        try {
            object = this._createDeserializer(deserializationContext, (DeserializerFactory)object, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            deserializationContext.reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            object = null;
        }
        if (object == null) {
            return null;
        }
        boolean bl = !this._hasCustomHandlers(javaType) && ((JsonDeserializer)object).isCachable();
        if (object instanceof ResolvableDeserializer) {
            this._incompleteDeserializers.put(javaType, (JsonDeserializer<Object>)object);
            ((ResolvableDeserializer)object).resolve(deserializationContext);
            this._incompleteDeserializers.remove(javaType);
        }
        if (bl) {
            this._cachedDeserializers.put(javaType, (JsonDeserializer<Object>)object);
        }
        return object;
    }

    public JsonDeserializer<Object> _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType type) {
        BeanDescription beanDescription;
        Converter<Object, Object> converter;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (((JavaType)type).isAbstract() || ((JavaType)type).isMapLikeType() || ((JavaType)type).isCollectionLikeType()) {
            type = deserializerFactory.mapAbstractType(deserializationConfig, (JavaType)type);
        }
        if ((converter = ((DeserializerCache)((Object)jsonDeserializer)).findDeserializerFromAnnotation(deserializationContext, (beanDescription = deserializationConfig.introspect((JavaType)type)).getClassInfo())) != null) {
            return converter;
        }
        converter = ((DeserializerCache)((Object)jsonDeserializer)).modifyTypeByAnnotation(deserializationContext, beanDescription.getClassInfo(), (JavaType)type);
        if (converter != type) {
            beanDescription = deserializationConfig.introspect((JavaType)((Object)converter));
            type = converter;
        }
        if ((converter = beanDescription.findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, (JavaType)type, beanDescription, (Class<?>)((Object)converter));
        }
        converter = beanDescription.findDeserializationConverter();
        if (converter == null) {
            return ((DeserializerCache)((Object)jsonDeserializer))._createDeserializer2(deserializationContext, deserializerFactory, (JavaType)type, beanDescription);
        }
        JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
        if (!javaType.hasRawClass(((JavaType)type).getRawClass())) {
            beanDescription = deserializationConfig.introspect(javaType);
        }
        JsonDeserializer<?> jsonDeserializer = ((DeserializerCache)((Object)jsonDeserializer))._createDeserializer2(deserializationContext, deserializerFactory, javaType, beanDescription);
        return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
    }

    public JsonDeserializer<?> _createDeserializer2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType, BeanDescription beanDescription) {
        Serializable serializable = deserializationContext.getConfig();
        if (javaType.isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (javaType.isContainerType()) {
            if (javaType.isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType, beanDescription);
            }
            if (javaType.isMapLikeType() && beanDescription.findExpectedFormat(null).getShape() != JsonFormat.Shape.OBJECT) {
                serializable = (MapLikeType)javaType;
                if (serializable instanceof MapType) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)serializable, beanDescription);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, (MapLikeType)serializable, beanDescription);
            }
            if (javaType.isCollectionLikeType() && beanDescription.findExpectedFormat(null).getShape() != JsonFormat.Shape.OBJECT) {
                serializable = (CollectionLikeType)javaType;
                if (serializable instanceof CollectionType) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)serializable, beanDescription);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, (CollectionLikeType)serializable, beanDescription);
            }
        }
        if (javaType.isReferenceType()) {
            return deserializerFactory.createReferenceDeserializer(deserializationContext, (ReferenceType)javaType, beanDescription);
        }
        if (JsonNode.class.isAssignableFrom(javaType.getRawClass())) {
            return deserializerFactory.createTreeDeserializer((DeserializationConfig)serializable, javaType, beanDescription);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    public JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializer(annotated);
        if (object == null) {
            return null;
        }
        DeserializationContext deserializationContext2 = deserializationContext;
        return this.findConvertingDeserializer(deserializationContext2, annotated, deserializationContext2.deserializerInstance(annotated, object));
    }

    public JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext serializable, Annotated annotated, JsonDeserializer<Object> jsonDeserializer) {
        if ((this = ((DeserializerCache)this).findConverter((DeserializationContext)serializable, annotated)) == null) {
            return jsonDeserializer;
        }
        serializable = this.getInputType(serializable.getTypeFactory());
        return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)this, (JavaType)serializable, jsonDeserializer);
    }

    public Converter<Object, Object> findConverter(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.converterInstance(annotated, object);
    }

    public JsonDeserializer<Object> _handleUnknownValueDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        if (!ClassUtil.isConcrete(javaType.getRawClass())) {
            return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a Value deserializer for abstract type " + javaType);
        }
        return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a Value deserializer for type " + javaType);
    }

    public KeyDeserializer _handleUnknownKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        return (KeyDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a (Map) Key deserializer for type " + javaType);
    }
}

