/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.e;
import com.privatefasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.privatefasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class SettableAnyProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _setter;
    protected final boolean _setterIsField;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final KeyDeserializer _keyDeserializer;

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this._property = beanProperty;
        this._setter = annotatedMember;
        this._type = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._keyDeserializer = keyDeserializer;
        this._setterIsField = annotatedMember instanceof AnnotatedField;
    }

    public static SettableAnyProperty constructForMethod(DeserializationContext deserializationContext, BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        return new MethodAnyProperty(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
    }

    public static SettableAnyProperty constructForMapField(DeserializationContext object, BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        Class<Object> clazz = annotatedMember.getRawType();
        if (clazz == Map.class) {
            clazz = LinkedHashMap.class;
        }
        object = JDKValueInstantiators.findStdValueInstantiator(((DeserializationContext)object).getConfig(), clazz);
        return new MapFieldAnyProperty(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer, (ValueInstantiator)object);
    }

    public static SettableAnyProperty constructForJsonNodeField(DeserializationContext serializable, BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        serializable = serializable.getNodeFactory();
        return new JsonNodeFieldAnyProperty(beanProperty, annotatedMember, javaType, jsonDeserializer, (JsonNodeFactory)serializable);
    }

    private String getClassName() {
        return ClassUtil.nameOf(this._setter.getDeclaringClass());
    }

    public abstract SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> var1);

    public void fixAccess(DeserializationConfig deserializationConfig) {
        this._setter.fixAccess(deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public Object readResolve() {
        AnnotatedMember annotatedMember = this._setter;
        if (annotatedMember != null && annotatedMember.getAnnotated() != null) {
            return this;
        }
        throw new IllegalArgumentException("Missing method/field (broken JDK (de)serialization?)");
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public String getPropertyName() {
        return this._property.getName();
    }

    public void deserializeAndSet(JsonParser object, DeserializationContext object2, Object object3, String string) {
        UnresolvedForwardReference unresolvedForwardReference2;
        block7: {
            Object object4;
            block6: {
                block5: {
                    object4 = this._keyDeserializer;
                    if (object4 != null) break block5;
                    object4 = string;
                    break block6;
                }
                object4 = ((KeyDeserializer)object4).deserializeKey(string, (DeserializationContext)object2);
            }
            SettableAnyProperty settableAnyProperty = this;
            SettableAnyProperty settableAnyProperty2 = settableAnyProperty;
            object2 = settableAnyProperty.deserialize((JsonParser)object, (DeserializationContext)object2);
            try {
                settableAnyProperty2.set(object3, object4, object2);
            }
            catch (UnresolvedForwardReference unresolvedForwardReference2) {
                e e2;
                if (this._valueDeserializer.getObjectIdReader() == null) break block7;
                object = e2;
                SettableAnyProperty settableAnyProperty3 = this;
                e2 = new e(settableAnyProperty3, unresolvedForwardReference2, settableAnyProperty3._type.getRawClass(), object3, string);
                unresolvedForwardReference2.getRoid().appendReferring((ReadableObjectId.Referring)object);
            }
            return;
        }
        throw JsonMappingException.from((JsonParser)object, "Unresolved forward reference but no identity info.", (Throwable)unresolvedForwardReference2);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return this._valueDeserializer.getNullValue(deserializationContext);
        }
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(Object object, Object object2, Object object3) {
        try {
            this._set(object, object2, object3);
            return;
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2, object3);
            return;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public abstract void _set(Object var1, Object var2, Object var3);

    public void _throwAsIOE(Exception exception, Object object, Object object2) {
        Object object3;
        if (exception instanceof IllegalArgumentException) {
            String string = ClassUtil.classNameOf(object2);
            object = new StringBuilder("Problem deserializing \"any-property\" '").append(object);
            ((StringBuilder)object).append("' of class " + ((SettableAnyProperty)object3).getClassName() + " (expected type: ").append(((SettableAnyProperty)object3)._type);
            ((StringBuilder)object).append("; actual type: ").append(string).append(")");
            object3 = ClassUtil.exceptionMessage(exception);
            if (object3 != null) {
                ((StringBuilder)object).append(", problem: ").append((String)object3);
            } else {
                ((StringBuilder)object).append(" (no error message provided)");
            }
            throw new JsonMappingException(null, ((StringBuilder)object).toString(), (Throwable)exception);
        }
        Exception exception2 = exception;
        ClassUtil.throwIfIOE(exception2);
        ClassUtil.throwIfRTE(exception2);
        object3 = ClassUtil.getRootCause(exception2);
        throw new JsonMappingException(null, ClassUtil.exceptionMessage((Throwable)object3), (Throwable)object3);
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }

    public static class MethodAnyProperty
    extends SettableAnyProperty
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public MethodAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
            super(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
        }

        @Override
        public void _set(Object object, Object object2, Object object3) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object2;
            objectArray[1] = object3;
            ((AnnotatedMethod)objectArray2._setter).callOnWith(object, objectArray2);
        }

        @Override
        public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
            MethodAnyProperty methodAnyProperty = beanProperty;
            BeanProperty beanProperty = methodAnyProperty._property;
            AnnotatedMember annotatedMember = methodAnyProperty._setter;
            JavaType javaType = methodAnyProperty._type;
            KeyDeserializer keyDeserializer = methodAnyProperty._keyDeserializer;
            TypeDeserializer typeDeserializer = methodAnyProperty._valueTypeDeserializer;
            return new MethodAnyProperty(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
        }
    }

    public static class MapFieldAnyProperty
    extends SettableAnyProperty
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final ValueInstantiator _valueInstantiator;

        public MapFieldAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator) {
            super(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer);
            this._valueInstantiator = valueInstantiator;
        }

        @Override
        public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
            MapFieldAnyProperty mapFieldAnyProperty = beanProperty;
            BeanProperty beanProperty = mapFieldAnyProperty._property;
            AnnotatedMember annotatedMember = mapFieldAnyProperty._setter;
            JavaType javaType = mapFieldAnyProperty._type;
            KeyDeserializer keyDeserializer = mapFieldAnyProperty._keyDeserializer;
            TypeDeserializer typeDeserializer = mapFieldAnyProperty._valueTypeDeserializer;
            ValueInstantiator valueInstantiator = mapFieldAnyProperty._valueInstantiator;
            return new MapFieldAnyProperty(beanProperty, annotatedMember, javaType, keyDeserializer, jsonDeserializer, typeDeserializer, valueInstantiator);
        }

        @Override
        public void _set(Object object, Object object2, Object object3) {
            AnnotatedField annotatedField = (AnnotatedField)this._setter;
            Map<Object, Object> map = (Map<Object, Object>)annotatedField.getValue(object);
            if (map == null) {
                map = this._createAndSetMap(null, annotatedField, object, object2);
            }
            map.put(object2, object3);
        }

        public Map<Object, Object> _createAndSetMap(DeserializationContext objectArray, AnnotatedField annotatedField, Object object, Object object2) {
            object2 = ((MapFieldAnyProperty)((Object)map))._valueInstantiator;
            if (object2 != null) {
                Map map = (Map)((ValueInstantiator)object2).createUsingDefault((DeserializationContext)objectArray);
                annotatedField.setValue(object, map);
                return map;
            }
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = ClassUtil.nameOf(((SettableAnyProperty)((Object)map))._type.getRawClass());
            objectArray3[1] = ((SettableAnyProperty)((Object)map))._property.getName();
            throw JsonMappingException.from((DeserializationContext)objectArray2, String.format("Cannot create an instance of %s for use as \"any-setter\" '%s'", objectArray));
        }
    }

    public static class JsonNodeFieldAnyProperty
    extends SettableAnyProperty
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final JsonNodeFactory _nodeFactory;

        public JsonNodeFieldAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, JsonNodeFactory jsonNodeFactory) {
            super(beanProperty, annotatedMember, javaType, null, jsonDeserializer, null);
            this._nodeFactory = jsonNodeFactory;
        }

        @Override
        public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
            this.setProperty(object, string, (JsonNode)this.deserialize(jsonParser, deserializationContext));
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
        }

        @Override
        public void _set(Object object, Object object2, Object object3) {
            JsonNodeFieldAnyProperty jsonNodeFieldAnyProperty = string;
            String string = (String)object2;
            object2 = (JsonNode)object3;
            jsonNodeFieldAnyProperty.setProperty(object, string, (JsonNode)object2);
        }

        public void setProperty(Object objectArray, String string, JsonNode jsonNode) {
            Object object;
            block4: {
                block3: {
                    Serializable serializable;
                    block2: {
                        AnnotatedField annotatedField = (AnnotatedField)((SettableAnyProperty)serializable)._setter;
                        object = annotatedField.getValue(objectArray);
                        if (object != null) break block2;
                        serializable = ((JsonNodeFieldAnyProperty)serializable)._nodeFactory.objectNode();
                        annotatedField.setValue(objectArray, serializable);
                        break block3;
                    }
                    if (!(object instanceof ObjectNode)) break block4;
                    serializable = (ObjectNode)object;
                }
                ((ObjectNode)serializable).set(string, jsonNode);
                return;
            }
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = ((SettableAnyProperty)serializable).getPropertyName();
            objectArray2[1] = ClassUtil.nameOf(object.getClass());
            throw JsonMappingException.from(null, String.format("Value \"any-setter\" '%s' not `ObjectNode` but %s", objectArray));
        }

        @Override
        public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
            return this;
        }
    }
}

