/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.impl.FailingDeserializer;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.ViewMatcher;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;

public abstract class SettableBeanProperty
extends ConcreteBeanPropertyBase
implements Serializable {
    protected static final JsonDeserializer<Object> MISSING_VALUE_DESERIALIZER = new FailingDeserializer("No _valueDeserializer assigned");
    protected final PropertyName _propName;
    protected final JavaType _type;
    protected final PropertyName _wrapperName;
    protected final transient Annotations _contextAnnotations;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final NullValueProvider _nullProvider;
    protected String _managedReferenceName;
    protected ObjectIdInfo _objectIdInfo;
    protected ViewMatcher _viewMatcher;
    protected int _propertyIndex;

    public SettableBeanProperty(BeanPropertyDefinition object, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations) {
        SettableBeanProperty settableBeanProperty = serializable;
        BeanPropertyDefinition beanPropertyDefinition = object;
        Serializable serializable = beanPropertyDefinition.getFullName();
        object = beanPropertyDefinition.getWrapperName();
        PropertyMetadata propertyMetadata = beanPropertyDefinition.getMetadata();
        settableBeanProperty((PropertyName)serializable, javaType, (PropertyName)object, typeDeserializer, annotations, propertyMetadata);
    }

    public SettableBeanProperty(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, PropertyMetadata propertyMetadata) {
        super(propertyMetadata);
        ((SettableBeanProperty)((Object)jsonDeserializer))._propertyIndex = -1;
        ((SettableBeanProperty)((Object)jsonDeserializer))._propName = propertyName == null ? PropertyName.NO_NAME : propertyName.internSimpleName();
        SettableBeanProperty settableBeanProperty = jsonDeserializer;
        settableBeanProperty._type = javaType;
        settableBeanProperty._wrapperName = propertyName2;
        settableBeanProperty._contextAnnotations = annotations;
        settableBeanProperty._viewMatcher = null;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty((BeanProperty)((Object)jsonDeserializer));
        }
        SettableBeanProperty settableBeanProperty2 = jsonDeserializer;
        settableBeanProperty2._valueTypeDeserializer = typeDeserializer;
        JsonDeserializer<Object> jsonDeserializer = MISSING_VALUE_DESERIALIZER;
        settableBeanProperty2._valueDeserializer = jsonDeserializer;
        settableBeanProperty2._nullProvider = jsonDeserializer;
    }

    public SettableBeanProperty(PropertyName propertyName, JavaType javaType, PropertyMetadata propertyMetadata, JsonDeserializer<Object> jsonDeserializer) {
        super(propertyMetadata);
        this._propertyIndex = -1;
        this._propName = propertyName == null ? PropertyName.NO_NAME : propertyName.internSimpleName();
        SettableBeanProperty settableBeanProperty = this;
        settableBeanProperty._type = javaType;
        settableBeanProperty._wrapperName = null;
        settableBeanProperty._contextAnnotations = null;
        settableBeanProperty._viewMatcher = null;
        settableBeanProperty._valueTypeDeserializer = null;
        settableBeanProperty._valueDeserializer = jsonDeserializer;
        settableBeanProperty._nullProvider = jsonDeserializer;
    }

    public SettableBeanProperty(SettableBeanProperty settableBeanProperty) {
        super(settableBeanProperty);
        this._propertyIndex = -1;
        this._propName = settableBeanProperty._propName;
        this._type = settableBeanProperty._type;
        this._wrapperName = settableBeanProperty._wrapperName;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueDeserializer = settableBeanProperty._valueDeserializer;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._viewMatcher = settableBeanProperty._viewMatcher;
        this._nullProvider = settableBeanProperty._nullProvider;
    }

    public SettableBeanProperty(SettableBeanProperty settableBeanProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider jsonDeserializer2) {
        super(settableBeanProperty);
        this._propertyIndex = -1;
        this._propName = settableBeanProperty._propName;
        this._type = settableBeanProperty._type;
        this._wrapperName = settableBeanProperty._wrapperName;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._valueDeserializer = jsonDeserializer == null ? MISSING_VALUE_DESERIALIZER : jsonDeserializer;
        this._viewMatcher = settableBeanProperty._viewMatcher;
        if (jsonDeserializer2 == MISSING_VALUE_DESERIALIZER) {
            jsonDeserializer2 = this._valueDeserializer;
        }
        this._nullProvider = jsonDeserializer2;
    }

    public SettableBeanProperty(SettableBeanProperty settableBeanProperty, PropertyName propertyName) {
        super(settableBeanProperty);
        this._propertyIndex = -1;
        this._propName = propertyName;
        this._type = settableBeanProperty._type;
        this._wrapperName = settableBeanProperty._wrapperName;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueDeserializer = settableBeanProperty._valueDeserializer;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._viewMatcher = settableBeanProperty._viewMatcher;
        this._nullProvider = settableBeanProperty._nullProvider;
    }

    public abstract SettableBeanProperty withValueDeserializer(JsonDeserializer<?> var1);

    public abstract SettableBeanProperty withName(PropertyName var1);

    public SettableBeanProperty withSimpleName(String string) {
        PropertyName propertyName = settableBeanProperty._propName;
        if (propertyName == null) {
            PropertyName propertyName2;
            propertyName = propertyName2;
            propertyName2 = new PropertyName(string);
        } else {
            propertyName = propertyName.withSimpleName(string);
        }
        if (propertyName != settableBeanProperty._propName) {
            SettableBeanProperty settableBeanProperty = settableBeanProperty.withName(propertyName);
        }
        return settableBeanProperty;
    }

    public abstract SettableBeanProperty withNullProvider(NullValueProvider var1);

    public void setManagedReferenceName(String string) {
        this._managedReferenceName = string;
    }

    public void setObjectIdInfo(ObjectIdInfo objectIdInfo) {
        this._objectIdInfo = objectIdInfo;
    }

    public void setViews(Class<?>[] classArray) {
        this._viewMatcher = classArray == null ? null : ViewMatcher.construct(classArray);
    }

    public void assignIndex(int n2) {
        if (this._propertyIndex == -1) {
            this._propertyIndex = n2;
            return;
        }
        throw new IllegalStateException("Property '" + this.getName() + "' already had index (" + this._propertyIndex + "), trying to assign " + n2);
    }

    public void fixAccess(DeserializationConfig deserializationConfig) {
    }

    public void markAsIgnorable() {
    }

    public boolean isIgnorable() {
        return false;
    }

    @Override
    public final String getName() {
        return this._propName.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._propName;
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    @Override
    public PropertyName getWrapperName() {
        return this._wrapperName;
    }

    @Override
    public abstract AnnotatedMember getMember();

    @Override
    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
        return this._contextAnnotations.get(clazz);
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        if (this.isRequired()) {
            jsonObjectFormatVisitor.property(this);
        } else {
            jsonObjectFormatVisitor.optionalProperty(this);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.getMember().getDeclaringClass();
    }

    public String getManagedReferenceName() {
        return this._managedReferenceName;
    }

    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    public boolean hasValueDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = ((SettableBeanProperty)((Object)jsonDeserializer))._valueDeserializer;
        return jsonDeserializer != null && jsonDeserializer != MISSING_VALUE_DESERIALIZER;
    }

    public boolean hasValueTypeDeserializer() {
        return this._valueTypeDeserializer != null;
    }

    public JsonDeserializer<Object> getValueDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = ((SettableBeanProperty)((Object)jsonDeserializer))._valueDeserializer;
        if (jsonDeserializer == MISSING_VALUE_DESERIALIZER) {
            return null;
        }
        return jsonDeserializer;
    }

    public TypeDeserializer getValueTypeDeserializer() {
        return this._valueTypeDeserializer;
    }

    public NullValueProvider getNullValueProvider() {
        return this._nullProvider;
    }

    public boolean visibleInView(Class<?> clazz) {
        Serializable serializable = ((SettableBeanProperty)serializable)._viewMatcher;
        return serializable == null || ((ViewMatcher)serializable).isVisibleForView(clazz);
    }

    public boolean hasViews() {
        return this._viewMatcher != null;
    }

    public int getPropertyIndex() {
        return this._propertyIndex;
    }

    public int getCreatorIndex() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getName();
        objectArray[1] = this.getClass().getName();
        throw new IllegalStateException(String.format("Internal error: no creator index for property '%s' (of type %s)", objectArray2));
    }

    public Object getInjectableValueId() {
        return null;
    }

    public boolean isInjectionOnly() {
        return false;
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3);

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3);

    public abstract void set(Object var1, Object var2);

    public abstract Object setAndReturn(Object var1, Object var2);

    public final Object deserialize(JsonParser object, DeserializationContext deserializationContext) {
        if (((JsonParser)object).hasToken(JsonToken.VALUE_NULL)) {
            return this._nullProvider.getNullValue(deserializationContext);
        }
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType((JsonParser)object, deserializationContext, typeDeserializer);
        }
        if ((object = this._valueDeserializer.deserialize((JsonParser)object, deserializationContext)) == null) {
            object = this._nullProvider.getNullValue(deserializationContext);
        }
        return object;
    }

    public final Object deserializeWith(JsonParser object, DeserializationContext deserializationContext, Object object2) {
        if (((JsonParser)object).hasToken(JsonToken.VALUE_NULL)) {
            if (NullsConstantProvider.isSkipper(this._nullProvider)) {
                return object2;
            }
            return this._nullProvider.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            DeserializationContext deserializationContext2 = deserializationContext;
            return deserializationContext2.findContextualValueDeserializer(deserializationContext2.getTypeFactory().constructType(object2.getClass()), this).deserialize((JsonParser)object, deserializationContext, object2);
        }
        if ((object = this._valueDeserializer.deserialize((JsonParser)object, deserializationContext, object2)) == null) {
            if (NullsConstantProvider.isSkipper(this._nullProvider)) {
                return object2;
            }
            object = this._nullProvider.getNullValue(deserializationContext);
        }
        return object;
    }

    public void _throwAsIOE(JsonParser jsonParser, Exception exception, Object object) {
        if (exception instanceof IllegalArgumentException) {
            Serializable serializable = new StringBuilder("Problem deserializing property '").append(((SettableBeanProperty)serializable).getName()).append("' (expected type: ").append(((SettableBeanProperty)serializable).getType()).append("; actual type: ").append(ClassUtil.classNameOf(object)).append(")");
            object = ClassUtil.exceptionMessage(exception);
            if (object != null) {
                ((StringBuilder)serializable).append(", problem: ").append((String)object);
            } else {
                ((StringBuilder)serializable).append(" (no error message provided)");
            }
            throw JsonMappingException.from(jsonParser, ((StringBuilder)serializable).toString(), (Throwable)exception);
        }
        ((SettableBeanProperty)serializable)._throwAsIOE(jsonParser, exception);
    }

    public IOException _throwAsIOE(JsonParser jsonParser, Exception exception) {
        Exception exception2 = exception;
        ClassUtil.throwIfIOE(exception2);
        ClassUtil.throwIfRTE(exception2);
        Serializable serializable = ClassUtil.getRootCause(exception2);
        throw JsonMappingException.from(jsonParser, ClassUtil.exceptionMessage((Throwable)serializable), (Throwable)serializable);
    }

    @Deprecated
    public IOException _throwAsIOE(Exception exception) {
        return this._throwAsIOE(null, exception);
    }

    public void _throwAsIOE(Exception exception, Object object) {
        this._throwAsIOE(null, exception, object);
    }

    public String toString() {
        return "[property '" + this.getName() + "']";
    }

    public static abstract class Delegating
    extends SettableBeanProperty {
        protected final SettableBeanProperty delegate;

        public Delegating(SettableBeanProperty settableBeanProperty) {
            super(settableBeanProperty);
            this.delegate = settableBeanProperty;
        }

        public abstract SettableBeanProperty withDelegate(SettableBeanProperty var1);

        public SettableBeanProperty _with(SettableBeanProperty settableBeanProperty) {
            if (settableBeanProperty == this.delegate) {
                return this;
            }
            return this.withDelegate(settableBeanProperty);
        }

        @Override
        public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
            Delegating delegating = this;
            return delegating._with(delegating.delegate.withValueDeserializer(jsonDeserializer));
        }

        @Override
        public SettableBeanProperty withName(PropertyName propertyName) {
            Delegating delegating = this;
            return delegating._with(delegating.delegate.withName(propertyName));
        }

        @Override
        public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
            Delegating delegating = this;
            return delegating._with(delegating.delegate.withNullProvider(nullValueProvider));
        }

        @Override
        public void assignIndex(int n2) {
            this.delegate.assignIndex(n2);
        }

        @Override
        public void fixAccess(DeserializationConfig deserializationConfig) {
            this.delegate.fixAccess(deserializationConfig);
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.delegate.getDeclaringClass();
        }

        @Override
        public String getManagedReferenceName() {
            return this.delegate.getManagedReferenceName();
        }

        @Override
        public ObjectIdInfo getObjectIdInfo() {
            return this.delegate.getObjectIdInfo();
        }

        @Override
        public boolean hasValueDeserializer() {
            return this.delegate.hasValueDeserializer();
        }

        @Override
        public boolean hasValueTypeDeserializer() {
            return this.delegate.hasValueTypeDeserializer();
        }

        @Override
        public JsonDeserializer<Object> getValueDeserializer() {
            return this.delegate.getValueDeserializer();
        }

        @Override
        public TypeDeserializer getValueTypeDeserializer() {
            return this.delegate.getValueTypeDeserializer();
        }

        @Override
        public boolean visibleInView(Class<?> clazz) {
            return this.delegate.visibleInView(clazz);
        }

        @Override
        public boolean hasViews() {
            return this.delegate.hasViews();
        }

        @Override
        public int getPropertyIndex() {
            return this.delegate.getPropertyIndex();
        }

        @Override
        public int getCreatorIndex() {
            return this.delegate.getCreatorIndex();
        }

        @Override
        public Object getInjectableValueId() {
            return this.delegate.getInjectableValueId();
        }

        @Override
        public boolean isInjectionOnly() {
            return this.delegate.isInjectionOnly();
        }

        @Override
        public AnnotatedMember getMember() {
            return this.delegate.getMember();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return this.delegate.getAnnotation(clazz);
        }

        public SettableBeanProperty getDelegate() {
            return this.delegate;
        }

        @Override
        public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
            this.delegate.deserializeAndSet(jsonParser, deserializationContext, object);
        }

        @Override
        public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
            return this.delegate.deserializeSetAndReturn(jsonParser, deserializationContext, object);
        }

        @Override
        public void set(Object object, Object object2) {
            this.delegate.set(object, object2);
        }

        @Override
        public Object setAndReturn(Object object, Object object2) {
            return this.delegate.setAndReturn(object, object2);
        }
    }
}

