/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ValueInstantiator {
    public ValueInstantiator createContextual(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        return this;
    }

    public Class<?> getValueClass() {
        return Object.class;
    }

    public String getValueTypeDesc() {
        if ((this = ((ValueInstantiator)this).getValueClass()) == null) {
            return "UNKNOWN";
        }
        return ((Class)this).getName();
    }

    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateUsingArrayDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    public boolean canCreateFromString() {
        return false;
    }

    public boolean canCreateFromInt() {
        return false;
    }

    public boolean canCreateFromLong() {
        return false;
    }

    public boolean canCreateFromBigInteger() {
        return false;
    }

    public boolean canCreateFromDouble() {
        return false;
    }

    public boolean canCreateFromBigDecimal() {
        return false;
    }

    public boolean canCreateFromBoolean() {
        return false;
    }

    public boolean canCreateUsingDefault() {
        return this.getDefaultCreator() != null;
    }

    public boolean canCreateUsingDelegate() {
        return false;
    }

    public boolean canCreateUsingArrayDelegate() {
        return false;
    }

    public boolean canCreateFromObjectWith() {
        return false;
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        return null;
    }

    public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
        return null;
    }

    public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
        return null;
    }

    public Object createUsingDefault(DeserializationContext deserializationContext) {
        Class<?> clazz = objectArray2.getValueClass();
        Object[] objectArray = objectArray2;
        Object[] objectArray2 = new Object[]{};
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no default no-arguments constructor found", objectArray2);
    }

    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = new Object[]{};
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray2, null, "no creator with arguments specified", objectArray3);
    }

    public Object createFromObjectWith(DeserializationContext deserializationContext, SettableBeanProperty[] settableBeanPropertyArray, PropertyValueBuffer propertyValueBuffer) {
        return this.createFromObjectWith(deserializationContext, propertyValueBuffer.getParameters(settableBeanPropertyArray));
    }

    public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) {
        Class<?> clazz = objectArray2.getValueClass();
        Object[] objectArray = objectArray2;
        Object[] objectArray2 = new Object[]{};
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no delegate creator specified", objectArray2);
    }

    public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) {
        Class<?> clazz = objectArray2.getValueClass();
        Object[] objectArray = objectArray2;
        Object[] objectArray2 = new Object[]{};
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no array delegate creator specified", objectArray2);
    }

    public Object createFromString(DeserializationContext objectArray, String string) {
        DeserializationContext deserializationContext = objectArray;
        objectArray = this.getValueClass();
        JsonParser jsonParser = deserializationContext.getParser();
        Serializable serializable = objectArray;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = string;
        return deserializationContext.handleMissingInstantiator((Class<?>)serializable, this, jsonParser, "no String-argument constructor/factory method to deserialize from String value ('%s')", objectArray);
    }

    public Object createFromInt(DeserializationContext deserializationContext, int n2) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = n2;
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no int/Int-argument constructor/factory method to deserialize from Number value (%s)", objectArray3);
    }

    public Object createFromLong(DeserializationContext deserializationContext, long l2) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = l2;
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no long/Long-argument constructor/factory method to deserialize from Number value (%s)", objectArray3);
    }

    public Object createFromBigInteger(DeserializationContext deserializationContext, BigInteger bigInteger) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = bigInteger;
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no BigInteger-argument constructor/factory method to deserialize from Number value (%s)", objectArray3);
    }

    public Object createFromDouble(DeserializationContext deserializationContext, double d2) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = d2;
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no double/Double-argument constructor/factory method to deserialize from Number value (%s)", objectArray3);
    }

    public Object createFromBigDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = bigDecimal;
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no BigDecimal/double/Double-argument constructor/factory method to deserialize from Number value (%s)", objectArray3);
    }

    public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl) {
        Class<?> clazz = objectArray3.getValueClass();
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = bl;
        return deserializationContext.handleMissingInstantiator(clazz, (ValueInstantiator)objectArray, null, "no boolean/Boolean-argument constructor/factory method to deserialize from boolean value (%s)", objectArray3);
    }

    public AnnotatedWithParams getDefaultCreator() {
        return null;
    }

    public AnnotatedWithParams getDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getArrayDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getWithArgsCreator() {
        return null;
    }

    @Deprecated
    public Object _createFromStringFallbacks(DeserializationContext objectArray, String string) {
        Object object;
        if (string.isEmpty() && objectArray.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return null;
        }
        if (this.canCreateFromBoolean() && objectArray.findCoercionAction(LogicalType.Boolean, Boolean.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
            object = string.trim();
            if ("true".equals(object)) {
                return this.createFromBoolean((DeserializationContext)objectArray, true);
            }
            if ("false".equals(object)) {
                return this.createFromBoolean((DeserializationContext)objectArray, false);
            }
        }
        DeserializationContext deserializationContext = objectArray;
        objectArray = this.getValueClass();
        object = deserializationContext.getParser();
        Serializable serializable = objectArray;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = string;
        return deserializationContext.handleMissingInstantiator((Class<?>)serializable, this, (JsonParser)object, "no String-argument constructor/factory method to deserialize from String value ('%s')", objectArray);
    }

    public static class Delegating
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final ValueInstantiator _delegate;

        public Delegating(ValueInstantiator valueInstantiator) {
            this._delegate = valueInstantiator;
        }

        @Override
        public ValueInstantiator createContextual(DeserializationContext object, BeanDescription beanDescription) {
            if ((object = delegating2._delegate.createContextual((DeserializationContext)object, beanDescription)) != delegating2._delegate) {
                Delegating delegating;
                Delegating delegating2 = delegating;
                delegating = new Delegating((ValueInstantiator)object);
            }
            return delegating2;
        }

        public ValueInstantiator delegate() {
            return this._delegate;
        }

        @Override
        public Class<?> getValueClass() {
            return this.delegate().getValueClass();
        }

        @Override
        public String getValueTypeDesc() {
            return this.delegate().getValueTypeDesc();
        }

        @Override
        public boolean canInstantiate() {
            return this.delegate().canInstantiate();
        }

        @Override
        public boolean canCreateFromString() {
            return this.delegate().canCreateFromString();
        }

        @Override
        public boolean canCreateFromInt() {
            return this.delegate().canCreateFromInt();
        }

        @Override
        public boolean canCreateFromLong() {
            return this.delegate().canCreateFromLong();
        }

        @Override
        public boolean canCreateFromDouble() {
            return this.delegate().canCreateFromDouble();
        }

        @Override
        public boolean canCreateFromBoolean() {
            return this.delegate().canCreateFromBoolean();
        }

        @Override
        public boolean canCreateUsingDefault() {
            return this.delegate().canCreateUsingDefault();
        }

        @Override
        public boolean canCreateUsingDelegate() {
            return this.delegate().canCreateUsingDelegate();
        }

        @Override
        public boolean canCreateUsingArrayDelegate() {
            return this.delegate().canCreateUsingArrayDelegate();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return this.delegate().canCreateFromObjectWith();
        }

        @Override
        public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
            return this.delegate().getFromObjectArguments(deserializationConfig);
        }

        @Override
        public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
            return this.delegate().getDelegateType(deserializationConfig);
        }

        @Override
        public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
            return this.delegate().getArrayDelegateType(deserializationConfig);
        }

        @Override
        public Object createUsingDefault(DeserializationContext deserializationContext) {
            return this.delegate().createUsingDefault(deserializationContext);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
            return this.delegate().createFromObjectWith(deserializationContext, objectArray);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext deserializationContext, SettableBeanProperty[] settableBeanPropertyArray, PropertyValueBuffer propertyValueBuffer) {
            return this.delegate().createFromObjectWith(deserializationContext, settableBeanPropertyArray, propertyValueBuffer);
        }

        @Override
        public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) {
            return this.delegate().createUsingDelegate(deserializationContext, object);
        }

        @Override
        public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) {
            return this.delegate().createUsingArrayDelegate(deserializationContext, object);
        }

        @Override
        public Object createFromString(DeserializationContext deserializationContext, String string) {
            return this.delegate().createFromString(deserializationContext, string);
        }

        @Override
        public Object createFromInt(DeserializationContext deserializationContext, int n2) {
            return this.delegate().createFromInt(deserializationContext, n2);
        }

        @Override
        public Object createFromLong(DeserializationContext deserializationContext, long l2) {
            return this.delegate().createFromLong(deserializationContext, l2);
        }

        @Override
        public Object createFromBigInteger(DeserializationContext deserializationContext, BigInteger bigInteger) {
            return this.delegate().createFromBigInteger(deserializationContext, bigInteger);
        }

        @Override
        public Object createFromDouble(DeserializationContext deserializationContext, double d2) {
            return this.delegate().createFromDouble(deserializationContext, d2);
        }

        @Override
        public Object createFromBigDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) {
            return this.delegate().createFromBigDecimal(deserializationContext, bigDecimal);
        }

        @Override
        public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl) {
            return this.delegate().createFromBoolean(deserializationContext, bl);
        }

        @Override
        public AnnotatedWithParams getDefaultCreator() {
            return this.delegate().getDefaultCreator();
        }

        @Override
        public AnnotatedWithParams getDelegateCreator() {
            return this.delegate().getDelegateCreator();
        }

        @Override
        public AnnotatedWithParams getArrayDelegateCreator() {
            return this.delegate().getArrayDelegateCreator();
        }

        @Override
        public AnnotatedWithParams getWithArgsCreator() {
            return this.delegate().getWithArgsCreator();
        }
    }

    public static class Base
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Class<?> _valueType;

        public Base(Class<?> clazz) {
            this._valueType = clazz;
        }

        public Base(JavaType javaType) {
            this._valueType = javaType.getRawClass();
        }

        @Override
        public String getValueTypeDesc() {
            return this._valueType.getName();
        }

        @Override
        public Class<?> getValueClass() {
            return this._valueType;
        }
    }

    public static interface Gettable {
        public ValueInstantiator getValueInstantiator();
    }
}

