/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.util.Set;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty[] settableBeanPropertyArray) {
        super(beanDeserializerBase);
        this._delegate = beanDeserializerBase;
        this._orderedProperties = settableBeanPropertyArray;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return this._delegate.unwrappingDeserializer(nameTransformer);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader objectIdReader) {
        BeanAsArrayDeserializer beanAsArrayDeserializer = beanDeserializerBase;
        BeanDeserializerBase beanDeserializerBase = beanAsArrayDeserializer._delegate.withObjectIdReader(objectIdReader);
        return new BeanAsArrayDeserializer(beanDeserializerBase, beanAsArrayDeserializer._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> set, Set<String> set2) {
        BeanAsArrayDeserializer beanAsArrayDeserializer = beanDeserializerBase;
        BeanDeserializerBase beanDeserializerBase = beanAsArrayDeserializer._delegate.withByNameInclusion(set, set2);
        return new BeanAsArrayDeserializer(beanDeserializerBase, beanAsArrayDeserializer._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean bl) {
        BeanAsArrayDeserializer beanAsArrayDeserializer = beanDeserializerBase;
        BeanDeserializerBase beanDeserializerBase = beanAsArrayDeserializer._delegate.withIgnoreAllUnknown(bl);
        return new BeanAsArrayDeserializer(beanDeserializerBase, beanAsArrayDeserializer._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        BeanAsArrayDeserializer beanAsArrayDeserializer = beanDeserializerBase;
        BeanDeserializerBase beanDeserializerBase = beanAsArrayDeserializer._delegate.withBeanProperties(beanPropertyMap);
        return new BeanAsArrayDeserializer(beanDeserializerBase, beanAsArrayDeserializer._orderedProperties);
    }

    @Override
    public BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext objectArray) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(jsonParser, (DeserializationContext)objectArray);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(jsonParser, (DeserializationContext)objectArray);
        }
        Object object = this._valueInstantiator.createUsingDefault((DeserializationContext)objectArray);
        jsonParser.setCurrentValue(object);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = this._orderedProperties.length;
        while (true) {
            Object object2 = JsonToken.END_ARRAY;
            if (jsonParser.nextToken() == object2) {
                return object;
            }
            if (n2 == n3) {
                JsonParser jsonParser2;
                if (!this._ignoreAllUnknown && objectArray.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = n3;
                    objectArray2.reportWrongTokenException(this, (JsonToken)((Object)object2), "Unexpected JSON values; expected at most %d properties (in JSON Array)", objectArray);
                }
                do {
                    jsonParser2 = jsonParser;
                    jsonParser2.skipChildren();
                } while (jsonParser2.nextToken() != JsonToken.END_ARRAY);
                return object;
            }
            object2 = settableBeanPropertyArray[n2];
            if (object2 != null) {
                try {
                    ((SettableBeanProperty)object2).deserializeAndSet(jsonParser, (DeserializationContext)objectArray, object);
                }
                catch (Exception exception) {
                    object2 = ((SettableBeanProperty)object2).getName();
                    this.wrapAndThrow(exception, object, (String)object2, (DeserializationContext)objectArray);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n2;
        }
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext objectArray, Object object) {
        JsonParser jsonParser2 = jsonParser;
        jsonParser2.setCurrentValue(object);
        if (!jsonParser2.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(jsonParser, (DeserializationContext)objectArray);
        }
        if (this._injectables != null) {
            this.injectValues((DeserializationContext)objectArray, object);
        }
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = this._orderedProperties.length;
        while (true) {
            Object object2 = JsonToken.END_ARRAY;
            if (jsonParser.nextToken() == object2) {
                return object;
            }
            if (n2 == n3) {
                JsonParser jsonParser3;
                if (!this._ignoreAllUnknown && objectArray.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = n3;
                    objectArray2.reportWrongTokenException(this, (JsonToken)((Object)object2), "Unexpected JSON values; expected at most %d properties (in JSON Array)", objectArray);
                }
                do {
                    jsonParser3 = jsonParser;
                    jsonParser3.skipChildren();
                } while (jsonParser3.nextToken() != JsonToken.END_ARRAY);
                return object;
            }
            object2 = settableBeanPropertyArray[n2];
            if (object2 != null) {
                try {
                    ((SettableBeanProperty)object2).deserializeAndSet(jsonParser, (DeserializationContext)objectArray, object);
                }
                catch (Exception exception) {
                    object2 = ((SettableBeanProperty)object2).getName();
                    this.wrapAndThrow(exception, object, (String)object2, (DeserializationContext)objectArray);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n2;
        }
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._deserializeFromNonArray(jsonParser, deserializationContext);
    }

    public Object _deserializeNonVanilla(JsonParser jsonParser, DeserializationContext objectArray) {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(jsonParser, (DeserializationContext)objectArray);
        }
        Object object = this._valueInstantiator.createUsingDefault((DeserializationContext)objectArray);
        jsonParser.setCurrentValue(object);
        if (this._injectables != null) {
            this.injectValues((DeserializationContext)objectArray, object);
        }
        Class<?> clazz = this._needViewProcesing ? objectArray.getActiveView() : null;
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = this._orderedProperties.length;
        while (true) {
            Object object2 = JsonToken.END_ARRAY;
            if (jsonParser.nextToken() == object2) {
                return object;
            }
            if (n2 == n3) {
                JsonParser jsonParser2;
                if (!this._ignoreAllUnknown) {
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = n3;
                    objectArray2.reportWrongTokenException(this, (JsonToken)((Object)object2), "Unexpected JSON values; expected at most %d properties (in JSON Array)", objectArray);
                }
                do {
                    jsonParser2 = jsonParser;
                    jsonParser2.skipChildren();
                } while (jsonParser2.nextToken() != JsonToken.END_ARRAY);
                return object;
            }
            object2 = settableBeanPropertyArray[n2];
            ++n2;
            if (object2 != null && (clazz == null || ((SettableBeanProperty)object2).visibleInView(clazz))) {
                try {
                    ((SettableBeanProperty)object2).deserializeAndSet(jsonParser, (DeserializationContext)objectArray, object);
                }
                catch (Exception exception) {
                    object2 = ((SettableBeanProperty)object2).getName();
                    this.wrapAndThrow(exception, object, (String)object2, (DeserializationContext)objectArray);
                }
                continue;
            }
            jsonParser.skipChildren();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final Object _deserializeUsingPropertyBased(JsonParser var1_1, DeserializationContext var2_2) {
        v0 = this;
        var3_3 = v0._propertyBasedCreator;
        var4_4 = var3_3.startBuilding(var1_1, var2_2, this._objectIdReader);
        var5_5 = v0._orderedProperties;
        var6_6 = v0._orderedProperties.length;
        var7_7 = 0;
        var8_8 = null;
        var9_9 = v0._needViewProcesing != false ? var2_2.getActiveView() : null;
        while (var1_1.nextToken() != JsonToken.END_ARRAY) {
            block10: {
                block12: {
                    block11: {
                        var10_10 = var7_7 < var6_6 ? var5_5[var7_7] : null;
                        if (var10_10 == null) {
                            while (true) {
                                var1_1.skipChildren();
                                break block10;
                                break;
                            }
                        }
                        if (var9_9 != null && !var10_10.visibleInView(var9_9)) ** continue;
                        if (var8_8 == null) break block11;
                        try {
                            var10_10.deserializeAndSet(var1_1, var2_2, var8_8);
                        }
                        catch (Exception var11_12) {
                            var10_10 = var10_10.getName();
                            this.wrapAndThrow(var11_12, var8_8, (String)var10_10, var2_2);
                        }
                        break block10;
                    }
                    var11_11 = var10_10.getName();
                    var12_13 = var3_3.findCreatorProperty((String)var11_11);
                    if (var4_4.readIdProperty((String)var11_11) && var12_13 == null) break block10;
                    if (var12_13 == null) break block12;
                    v1 = var12_13;
                    if (!var4_4.assignParameter(v1, v1.deserialize(var1_1, var2_2))) break block10;
                    try {
                        var8_8 = var3_3.build(var2_2, var4_4);
                        var1_1.setCurrentValue(var8_8);
                        if (var8_8.getClass() == this._beanType.getRawClass()) ** GOTO lbl51
                        var10_10 = this._beanType;
                    }
                    catch (Exception v2) {
                        this.wrapAndThrow(v2, this._beanType.getRawClass(), (String)var11_11, var2_2);
                    }
                    v3 = new Object[2];
                    var11_11 = v3;
                    var11_11[0] = ClassUtil.getTypeDescription((JavaType)var10_10);
                    v3[1] = ClassUtil.getClassDescription(var8_8);
                    var2_2.reportBadDefinition((JavaType)var10_10, String.format("Cannot support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", var11_11));
                    break block10;
                    break block10;
                }
                var4_4.bufferProperty((SettableBeanProperty)var10_10, var10_10.deserialize(var1_1, var2_2));
            }
            ++var7_7;
        }
        if (var8_8 == null) {
            try {
                var8_8 = var3_3.build(var2_2, var4_4);
            }
            catch (Exception v4) {
                return this.wrapInstantiationProblem(v4, var2_2);
            }
        }
        return var8_8;
    }

    public Object _deserializeFromNonArray(JsonParser jsonParser, DeserializationContext objectArray) {
        DeserializationContext deserializationContext = objectArray;
        objectArray = this.getValueType((DeserializationContext)objectArray);
        JsonToken jsonToken = jsonParser.currentToken();
        Serializable serializable = objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = ClassUtil.getTypeDescription(this._beanType);
        objectArray2[1] = jsonParser.currentToken();
        return deserializationContext.handleUnexpectedToken((JavaType)serializable, jsonToken, jsonParser, "Cannot deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array", objectArray);
    }
}

