/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.core.JacksonException;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.privatefasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;

public class BeanPropertyMap
implements Iterable<SettableBeanProperty>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final boolean _caseInsensitive;
    private int _hashMask;
    private int _size;
    private int _spillCount;
    private Object[] _hashArea;
    private final SettableBeanProperty[] _propsInOrder;
    private final Map<String, List<PropertyName>> _aliasDefs;
    private final Map<String, String> _aliasMapping;
    private final Locale _locale;

    public BeanPropertyMap(boolean bl, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, Locale locale) {
        Collection<SettableBeanProperty> collection2 = collection;
        this._caseInsensitive = bl;
        this._propsInOrder = collection2.toArray(new SettableBeanProperty[collection2.size()]);
        this._aliasDefs = map;
        this._locale = locale;
        this._aliasMapping = this._buildAliasMapping(map, bl, locale);
        this.init(collection);
    }

    @Deprecated
    public BeanPropertyMap(boolean bl, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map) {
        BeanPropertyMap beanPropertyMap = serializable;
        Serializable serializable = Locale.getDefault();
        beanPropertyMap(bl, collection, map, (Locale)serializable);
    }

    private BeanPropertyMap(BeanPropertyMap settableBeanPropertyArray, SettableBeanProperty settableBeanProperty, int n2, int n3) {
        this._caseInsensitive = settableBeanPropertyArray._caseInsensitive;
        this._locale = settableBeanPropertyArray._locale;
        this._hashMask = settableBeanPropertyArray._hashMask;
        this._size = settableBeanPropertyArray._size;
        this._spillCount = settableBeanPropertyArray._spillCount;
        this._aliasDefs = settableBeanPropertyArray._aliasDefs;
        this._aliasMapping = settableBeanPropertyArray._aliasMapping;
        this._hashArea = Arrays.copyOf(settableBeanPropertyArray._hashArea, settableBeanPropertyArray._hashArea.length);
        SettableBeanProperty[] settableBeanPropertyArray2 = Arrays.copyOf(settableBeanPropertyArray._propsInOrder, settableBeanPropertyArray._propsInOrder.length);
        settableBeanPropertyArray = settableBeanPropertyArray2;
        this._propsInOrder = settableBeanPropertyArray;
        this._hashArea[n2] = settableBeanProperty;
        settableBeanPropertyArray2[n3] = settableBeanProperty;
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, String string, int n2) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this._locale = beanPropertyMap._locale;
        this._hashMask = beanPropertyMap._hashMask;
        this._size = beanPropertyMap._size;
        this._spillCount = beanPropertyMap._spillCount;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._hashArea = Arrays.copyOf(beanPropertyMap._hashArea, beanPropertyMap._hashArea.length);
        int n3 = beanPropertyMap._propsInOrder.length;
        SettableBeanProperty[] settableBeanPropertyArray = Arrays.copyOf(beanPropertyMap._propsInOrder, n3 + 1);
        SettableBeanProperty[] settableBeanPropertyArray2 = settableBeanPropertyArray;
        this._propsInOrder = settableBeanPropertyArray2;
        settableBeanPropertyArray[n3] = settableBeanProperty;
        n3 = this._hashMask + 1;
        int n4 = n2 << 1;
        Object[] objectArray = this._hashArea;
        if (this._hashArea[n4] != null && objectArray[n4 = n3 + (n2 >> 1) << 1] != null) {
            int n5 = n3;
            n3 = this._spillCount;
            n4 = (n5 + (n5 >> 1) << 1) + n3;
            this._spillCount = n3 + 2;
            if (n4 >= objectArray.length) {
                this._hashArea = Arrays.copyOf(objectArray, objectArray.length + 4);
            }
        }
        this._hashArea[n4] = string;
        this._hashArea[n4 + 1] = settableBeanProperty;
    }

    public BeanPropertyMap(BeanPropertyMap beanPropertyMap, boolean bl) {
        settableBeanPropertyArray._caseInsensitive = bl;
        settableBeanPropertyArray._locale = beanPropertyMap._locale;
        settableBeanPropertyArray._aliasDefs = beanPropertyMap._aliasDefs;
        settableBeanPropertyArray._aliasMapping = beanPropertyMap._aliasMapping;
        SettableBeanProperty[] settableBeanPropertyArray = Arrays.copyOf(beanPropertyMap._propsInOrder, beanPropertyMap._propsInOrder.length);
        settableBeanPropertyArray._propsInOrder = settableBeanPropertyArray;
        settableBeanPropertyArray.init(Arrays.asList(settableBeanPropertyArray));
    }

    private static final int findSize(int n2) {
        if (n2 <= 5) {
            return 8;
        }
        if (n2 <= 12) {
            return 16;
        }
        int n3 = n2;
        n2 = n3 + (n3 >> 2);
        int n4 = 32;
        while (n4 < n2) {
            int n5 = n4;
            n4 = n5 + n5;
        }
        return n4;
    }

    public static BeanPropertyMap construct(MapperConfig<?> serializable, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, boolean bl) {
        serializable = serializable.getLocale();
        return new BeanPropertyMap(bl, collection, map, (Locale)serializable);
    }

    @Deprecated
    public static BeanPropertyMap construct(MapperConfig<?> mapperConfig, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map) {
        MapperConfig<?> mapperConfig2 = mapperConfig;
        boolean bl = mapperConfig2.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        Locale locale = mapperConfig2.getLocale();
        return new BeanPropertyMap(bl, collection, map, locale);
    }

    @Deprecated
    public static BeanPropertyMap construct(Collection<SettableBeanProperty> collection, boolean bl, Map<String, List<PropertyName>> map) {
        return new BeanPropertyMap(bl, collection, map);
    }

    private List<SettableBeanProperty> _properties() {
        ArrayList<SettableBeanProperty> arrayList;
        ArrayList<SettableBeanProperty> arrayList2 = arrayList;
        arrayList = new ArrayList<SettableBeanProperty>(this._size);
        int n2 = this._hashArea.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty == null) continue;
            arrayList2.add(settableBeanProperty);
        }
        return arrayList2;
    }

    private final SettableBeanProperty _find2(String string, int n2, Object object) {
        if (object == null) {
            BeanPropertyMap beanPropertyMap = this;
            return beanPropertyMap._findWithAlias(beanPropertyMap._aliasMapping.get(string));
        }
        BeanPropertyMap beanPropertyMap = this;
        int n3 = beanPropertyMap._hashMask + 1;
        Object object2 = beanPropertyMap._hashArea[n2 = n3 + (n2 >> 1) << 1];
        if (string.equals(object2)) {
            return (SettableBeanProperty)this._hashArea[n2 + 1];
        }
        if (object2 != null) {
            int n4 = n3;
            n3 = n2 + this._spillCount;
            for (n2 = (v206461) + ((v206461) >> 1) << 1; n2 < n3; n2 += 2) {
                object2 = this._hashArea[n2];
                if (object2 != string && !string.equals(object2)) {
                    continue;
                }
                return (SettableBeanProperty)this._hashArea[n2 + 1];
            }
        }
        BeanPropertyMap beanPropertyMap2 = this;
        return beanPropertyMap2._findWithAlias(beanPropertyMap2._aliasMapping.get(string));
    }

    private SettableBeanProperty _findWithAlias(String string) {
        if (string == null) {
            return null;
        }
        BeanPropertyMap beanPropertyMap = this;
        int n2 = beanPropertyMap._hashCode(string);
        int n3 = n2 << 1;
        Object object = beanPropertyMap._hashArea[n3];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        if (object == null) {
            return null;
        }
        return this._find2ViaAlias(string, n2, object);
    }

    private SettableBeanProperty _find2ViaAlias(String string, int n2, Object object) {
        BeanPropertyMap beanPropertyMap = this;
        int n3 = beanPropertyMap._hashMask + 1;
        Object object2 = beanPropertyMap._hashArea[n2 = n3 + (n2 >> 1) << 1];
        if (string.equals(object2)) {
            return (SettableBeanProperty)this._hashArea[n2 + 1];
        }
        if (object2 != null) {
            int n4 = n3;
            n3 = n2 + this._spillCount;
            for (n2 = (v206565) + ((v206565) >> 1) << 1; n2 < n3; n2 += 2) {
                object2 = this._hashArea[n2];
                if (object2 != string && !string.equals(object2)) {
                    continue;
                }
                return (SettableBeanProperty)this._hashArea[n2 + 1];
            }
        }
        return null;
    }

    private final int _findFromOrdered(SettableBeanProperty settableBeanProperty) {
        int n2 = this._propsInOrder.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._propsInOrder[i2] != settableBeanProperty) continue;
            return i2;
        }
        throw new IllegalStateException("Illegal state: property '" + settableBeanProperty.getName() + "' missing from _propsInOrder");
    }

    private final int _hashCode(String string) {
        return string.hashCode() & this._hashMask;
    }

    private Map<String, String> _buildAliasMapping(Map<String, List<PropertyName>> object, boolean bl, Locale locale) {
        if (object != null && !object.isEmpty()) {
            HashMap hashMap;
            Serializable serializable = hashMap;
            hashMap = new HashMap();
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                if (bl) {
                    string = string.toLowerCase(locale);
                }
                Iterator object2 = ((List)entry.getValue()).iterator();
                while (object2.hasNext()) {
                    String string2 = ((PropertyName)object2.next()).getSimpleName();
                    if (bl) {
                        string2 = string2.toLowerCase(locale);
                    }
                    ((HashMap)serializable).put(string2, string);
                }
            }
            return serializable;
        }
        return Collections.emptyMap();
    }

    public BeanPropertyMap withCaseInsensitivity(boolean bl) {
        if (this._caseInsensitive == bl) {
            return this;
        }
        return new BeanPropertyMap(this, bl);
    }

    public void init(Collection<SettableBeanProperty> collection) {
        Collection<SettableBeanProperty> collection2 = collection;
        this._size = collection2.size();
        int n2 = BeanPropertyMap.findSize(this._size);
        this._hashMask = n2 - 1;
        int n3 = n2 + (n2 >> 1);
        Object[] objectArray = new Object[n3 * 2];
        int n4 = 0;
        for (SettableBeanProperty settableBeanProperty : collection2) {
            if (settableBeanProperty == null) continue;
            BeanPropertyMap beanPropertyMap = this;
            String string = beanPropertyMap.getPropertyName(settableBeanProperty);
            int n5 = beanPropertyMap._hashCode(string);
            int n6 = n5 << 1;
            if (objectArray[n6] != null && objectArray[n6 = n2 + (n5 >> 1) << 1] != null) {
                n6 = (n3 << 1) + n4;
                n4 += 2;
                if (n6 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n6] = string;
            objectArray[n6 + 1] = settableBeanProperty;
        }
        BeanPropertyMap beanPropertyMap = this;
        beanPropertyMap._hashArea = objectArray;
        beanPropertyMap._spillCount = n4;
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n2;
        BeanPropertyMap beanPropertyMap = this;
        String string = beanPropertyMap.getPropertyName(settableBeanProperty);
        int n3 = beanPropertyMap._hashArea.length;
        for (n2 = 1; n2 < n3; n2 += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[n2];
            if (settableBeanProperty2 == null || !settableBeanProperty2.getName().equals(string)) continue;
            int n4 = this._findFromOrdered(settableBeanProperty2);
            return new BeanPropertyMap(this, settableBeanProperty, n2, n4);
        }
        n2 = this._hashCode(string);
        return new BeanPropertyMap(this, settableBeanProperty, string, n2);
    }

    public BeanPropertyMap assignIndexes() {
        int n2 = 0;
        int n3 = this._hashArea.length;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty == null) continue;
            int n4 = n2 + 1;
            settableBeanProperty.assignIndex(n2);
            n2 = n4;
        }
        return this;
    }

    public BeanPropertyMap renameAll(NameTransformer object) {
        if (object != null && object != NameTransformer.NOP) {
            ArrayList<SettableBeanProperty> arrayList;
            int n2 = this._propsInOrder.length;
            ArrayList<SettableBeanProperty> arrayList2 = arrayList;
            arrayList = new ArrayList<SettableBeanProperty>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                SettableBeanProperty settableBeanProperty = this._propsInOrder[i2];
                if (settableBeanProperty == null) {
                    arrayList2.add(settableBeanProperty);
                    continue;
                }
                arrayList2.add(this._rename(settableBeanProperty, (NameTransformer)object));
            }
            BeanPropertyMap beanPropertyMap = this;
            boolean bl = beanPropertyMap._caseInsensitive;
            object = beanPropertyMap._aliasDefs;
            Locale locale = beanPropertyMap._locale;
            return new BeanPropertyMap(bl, arrayList2, (Map<String, List<PropertyName>>)object, locale);
        }
        return this;
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection) {
        return this.withoutProperties(collection, null);
    }

    public BeanPropertyMap withoutProperties(Collection<String> object, Collection<String> object2) {
        ArrayList<SettableBeanProperty> arrayList;
        if ((object == null || object.isEmpty()) && object2 == null) {
            return this;
        }
        int n2 = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList2 = arrayList;
        arrayList = new ArrayList<SettableBeanProperty>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i2];
            if (settableBeanProperty == null || IgnorePropertiesUtil.shouldIgnore(settableBeanProperty.getName(), (Collection<String>)object, object2)) continue;
            arrayList2.add(settableBeanProperty);
        }
        BeanPropertyMap beanPropertyMap = this;
        boolean bl = beanPropertyMap._caseInsensitive;
        object = beanPropertyMap._aliasDefs;
        object2 = beanPropertyMap._locale;
        return new BeanPropertyMap(bl, arrayList2, (Map<String, List<PropertyName>>)object, (Locale)object2);
    }

    public void replace(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        int n2 = this._hashArea.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            Object[] objectArray = this._hashArea;
            if (this._hashArea[i2] != settableBeanProperty) continue;
            objectArray[i2] = settableBeanProperty2;
            this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty)] = settableBeanProperty2;
            return;
        }
        throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't replace");
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        ArrayList<SettableBeanProperty> arrayList;
        BeanPropertyMap beanPropertyMap = this;
        ArrayList<SettableBeanProperty> arrayList2 = arrayList;
        arrayList = new ArrayList<SettableBeanProperty>(this._size);
        String string = beanPropertyMap.getPropertyName(settableBeanProperty);
        boolean bl = false;
        int n2 = beanPropertyMap._hashArea.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            Object[] objectArray = this._hashArea;
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty2 == null) continue;
            if (!bl && (bl = string.equals(objectArray[i2 - 1]))) {
                this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty2)] = null;
                continue;
            }
            arrayList2.add(settableBeanProperty2);
        }
        if (bl) {
            this.init(arrayList2);
            return;
        }
        throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't remove");
    }

    public int size() {
        return this._size;
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    public boolean hasAliases() {
        return this._aliasDefs.isEmpty() ^ true;
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return this._properties().iterator();
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        return this._propsInOrder;
    }

    public final String getPropertyName(SettableBeanProperty settableBeanProperty) {
        return this._caseInsensitive ? settableBeanProperty.getName().toLowerCase(this._locale) : settableBeanProperty.getName();
    }

    public SettableBeanProperty find(int n2) {
        int n3 = this._hashArea.length;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty == null || n2 != settableBeanProperty.getPropertyIndex()) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public SettableBeanProperty find(String string) {
        if (string != null) {
            int n2;
            int n3;
            Object object;
            if (this._caseInsensitive) {
                string = string.toLowerCase(this._locale);
            }
            if ((object = this._hashArea[n3 = (n2 = string.hashCode() & this._hashMask) << 1]) != string && !string.equals(object)) {
                return this._find2(string, n2, object);
            }
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        throw new IllegalArgumentException("Cannot pass null property name");
    }

    public boolean findDeserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) {
        SettableBeanProperty settableBeanProperty = this.find(string);
        if (settableBeanProperty == null) {
            return false;
        }
        try {
            settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, object, string, deserializationContext);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("Properties=[");
        int n2 = 0;
        for (SettableBeanProperty settableBeanProperty : this) {
            if (n2++ > 0) {
                stringBuilder2.append(", ");
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.append(settableBeanProperty.getName());
            stringBuilder4.append('(');
            stringBuilder3.append(settableBeanProperty.getType());
            stringBuilder3.append(')');
        }
        stringBuilder2.append(']');
        if (!this._aliasDefs.isEmpty()) {
            StringBuilder stringBuilder5 = stringBuilder2;
            stringBuilder2.append("(aliases: ");
            stringBuilder5.append(this._aliasDefs);
            stringBuilder5.append(")");
        }
        return stringBuilder2.toString();
    }

    public SettableBeanProperty _rename(SettableBeanProperty object, NameTransformer object2) {
        if (object == null) {
            return object;
        }
        Serializable serializable = ((SettableBeanProperty)object).withSimpleName(((NameTransformer)object2).transform(((SettableBeanProperty)object).getName()));
        if ((object = ((SettableBeanProperty)serializable).getValueDeserializer()) != null && (object2 = ((JsonDeserializer)object).unwrappingDeserializer((NameTransformer)object2)) != object) {
            serializable = ((SettableBeanProperty)serializable).withValueDeserializer((JsonDeserializer<?>)object2);
        }
        return serializable;
    }

    public void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }
}

