/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.HashMap;

public class CreatorCollector {
    protected static final int C_DEFAULT = 0;
    protected static final int C_STRING = 1;
    protected static final int C_INT = 2;
    protected static final int C_LONG = 3;
    protected static final int C_BIG_INTEGER = 4;
    protected static final int C_DOUBLE = 5;
    protected static final int C_BIG_DECIMAL = 6;
    protected static final int C_BOOLEAN = 7;
    protected static final int C_DELEGATE = 8;
    protected static final int C_PROPS = 9;
    protected static final int C_ARRAY_DELEGATE = 10;
    protected static final String[] TYPE_DESCS = new String[]{"default", "from-String", "from-int", "from-long", "from-big-integer", "from-double", "from-big-decimal", "from-boolean", "delegate", "property-based", "array-delegate"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[11];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;

    public CreatorCollector(BeanDescription beanDescription, MapperConfig<?> mapperConfig) {
        this._beanDesc = beanDescription;
        this._canFixAccess = mapperConfig.canOverrideAccessModifiers();
        this._forceAccess = mapperConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    private JavaType _computeDelegateType(DeserializationContext deserializationContext, AnnotatedWithParams object, SettableBeanProperty[] object2) {
        if (this._hasNonDefaultCreator && object != null) {
            int n2 = 0;
            if (object2 != null) {
                int n3 = ((SettableBeanProperty[])object2).length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (object2[i2] != null) continue;
                    n2 = i2;
                    break;
                }
            }
            object2 = deserializationContext.getConfig();
            JavaType javaType = ((AnnotatedWithParams)object).getParameterType(n2);
            AnnotationIntrospector annotationIntrospector = object2.getAnnotationIntrospector();
            if (annotationIntrospector != null) {
                AnnotatedParameter annotatedParameter = ((AnnotatedWithParams)object).getParameter(n2);
                javaType = (object = annotationIntrospector.findDeserializer(annotatedParameter)) != null ? javaType.withValueHandler(deserializationContext.deserializerInstance(annotatedParameter, object)) : annotationIntrospector.refineDeserializationType((MapperConfig<?>)object2, annotatedParameter, javaType);
            }
            return javaType;
        }
        return null;
    }

    private <T extends AnnotatedMember> T _fixAccess(T t2) {
        if (t2 != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t2.getAnnotated()), this._forceAccess);
        }
        return t2;
    }

    public ValueInstantiator constructValueInstantiator(DeserializationContext settableBeanPropertyArray) {
        StdValueInstantiator stdValueInstantiator;
        CreatorCollector creatorCollector = object;
        DeserializationContext deserializationContext = settableBeanPropertyArray;
        CreatorCollector creatorCollector2 = object;
        DeserializationContext deserializationContext2 = settableBeanPropertyArray;
        CreatorCollector creatorCollector3 = object;
        settableBeanPropertyArray = settableBeanPropertyArray.getConfig();
        Serializable serializable = creatorCollector3._creators[8];
        serializable = creatorCollector2._computeDelegateType(deserializationContext2, (AnnotatedWithParams)serializable, creatorCollector3._delegateArgs);
        Serializable serializable2 = creatorCollector2._creators[10];
        serializable2 = creatorCollector._computeDelegateType(deserializationContext, (AnnotatedWithParams)serializable2, creatorCollector2._arrayDelegateArgs);
        SettableBeanProperty[] settableBeanPropertyArray2 = creatorCollector._beanDesc.getType();
        Serializable serializable3 = stdValueInstantiator;
        CreatorCollector creatorCollector4 = object;
        StdValueInstantiator stdValueInstantiator2 = serializable3;
        CreatorCollector creatorCollector5 = object;
        StdValueInstantiator stdValueInstantiator3 = serializable3;
        CreatorCollector creatorCollector6 = object;
        StdValueInstantiator stdValueInstantiator4 = serializable3;
        CreatorCollector creatorCollector7 = object;
        StdValueInstantiator stdValueInstantiator5 = serializable3;
        CreatorCollector creatorCollector8 = object;
        StdValueInstantiator stdValueInstantiator6 = serializable3;
        CreatorCollector creatorCollector9 = object;
        StdValueInstantiator stdValueInstantiator7 = serializable3;
        CreatorCollector creatorCollector10 = object;
        StdValueInstantiator stdValueInstantiator8 = serializable3;
        CreatorCollector creatorCollector11 = object;
        StdValueInstantiator stdValueInstantiator9 = serializable3;
        CreatorCollector creatorCollector12 = object;
        serializable3((DeserializationConfig)settableBeanPropertyArray, (JavaType)settableBeanPropertyArray2);
        Object object = creatorCollector12._creators[0];
        settableBeanPropertyArray = creatorCollector12._creators[8];
        settableBeanPropertyArray2 = ((CreatorCollector)object)._delegateArgs;
        serializable3 = creatorCollector12._creators[9];
        SettableBeanProperty[] settableBeanPropertyArray3 = creatorCollector12._propertyBasedArgs;
        stdValueInstantiator9.configureFromObjectSettings((AnnotatedWithParams)object, (AnnotatedWithParams)settableBeanPropertyArray, (JavaType)serializable, settableBeanPropertyArray2, (AnnotatedWithParams)serializable3, settableBeanPropertyArray3);
        object = creatorCollector11._creators[10];
        settableBeanPropertyArray = creatorCollector11._arrayDelegateArgs;
        stdValueInstantiator8.configureFromArraySettings((AnnotatedWithParams)object, (JavaType)serializable2, settableBeanPropertyArray);
        stdValueInstantiator7.configureFromStringCreator(creatorCollector10._creators[1]);
        stdValueInstantiator6.configureFromIntCreator(creatorCollector9._creators[2]);
        stdValueInstantiator5.configureFromLongCreator(creatorCollector8._creators[3]);
        stdValueInstantiator4.configureFromBigIntegerCreator(creatorCollector7._creators[4]);
        stdValueInstantiator3.configureFromDoubleCreator(creatorCollector6._creators[5]);
        stdValueInstantiator2.configureFromBigDecimalCreator(creatorCollector5._creators[6]);
        stdValueInstantiator.configureFromBooleanCreator(creatorCollector4._creators[7]);
        return stdValueInstantiator;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._creators[0] = this._fixAccess(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 1, bl);
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 2, bl);
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 3, bl);
    }

    public void addBigIntegerCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 4, bl);
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 5, bl);
    }

    public void addBigDecimalCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 6, bl);
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams, boolean bl) {
        this.verifyNonDup(annotatedWithParams, 7, bl);
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, boolean bl, SettableBeanProperty[] settableBeanPropertyArray, int n2) {
        if (annotatedWithParams.getParameterType(n2).isCollectionLikeType()) {
            if (this.verifyNonDup(annotatedWithParams, 10, bl)) {
                this._arrayDelegateArgs = settableBeanPropertyArray;
            }
        } else if (this.verifyNonDup(annotatedWithParams, 8, bl)) {
            this._delegateArgs = settableBeanPropertyArray;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams serializable, boolean n2, SettableBeanProperty[] settableBeanPropertyArray) {
        if (this.verifyNonDup((AnnotatedWithParams)serializable, 9, n2 != 0)) {
            if (settableBeanPropertyArray.length > 1) {
                HashMap hashMap;
                serializable = hashMap;
                hashMap = new HashMap();
                int n3 = settableBeanPropertyArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Integer n4;
                    String string = settableBeanPropertyArray[n2].getName();
                    if (string.isEmpty() && settableBeanPropertyArray[n2].getInjectableValueId() != null || (n4 = ((HashMap)serializable).put(string, n2)) == null) {
                        continue;
                    }
                    Object[] objectArray = new Object[4];
                    Serializable serializable2 = serializable = objectArray;
                    serializable2[0] = string;
                    serializable2[1] = n4;
                    serializable[2] = Integer.valueOf(n2);
                    objectArray[3] = ClassUtil.nameOf(this._beanDesc.getBeanClass());
                    throw new IllegalArgumentException(String.format("Duplicate creator property \"%s\" (index %s vs %d) for type %s ", (Object[])serializable));
                }
            }
            this._propertyBasedArgs = settableBeanPropertyArray;
        }
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[8] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[9] != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean verifyNonDup(AnnotatedWithParams var1_1, int var2_2, boolean var3_3) {
        block14: {
            block16: {
                block15: {
                    var4_4 = 1 << var2_2;
                    this._hasNonDefaultCreator = true;
                    var5_5 = this._creators[var2_2];
                    if (var5_5 == null) break block14;
                    if ((this._explicitCreators & var4_4) == 0) break block15;
                    if (!var3_3) {
                        return false;
                    }
                    break block16;
                }
                if (!(var3_3 ^ true)) break block14;
            }
            if (var5_5.getClass() == var1_1.getClass()) {
                var6_6 = var5_5.getRawParameterType(0);
                if (var6_6 == (var7_7 = var1_1.getRawParameterType(0))) {
                    if (this._isEnumValueOf(var1_1)) {
                        return false;
                    }
                    if (!this._isEnumValueOf(var5_5)) {
                        while (true) {
                            this._reportDuplicateCreator(var2_2, var3_3, var5_5, var1_1);
                            break;
                        }
                    }
                } else {
                    if (var7_7.isAssignableFrom(var6_6)) {
                        return false;
                    }
                    if (!var6_6.isAssignableFrom(var7_7)) {
                        if (var6_6.isPrimitive() == var7_7.isPrimitive()) ** continue;
                        if (var6_6.isPrimitive()) {
                            return false;
                        }
                    }
                }
            }
        }
        if (var3_3) {
            this._explicitCreators |= var4_4;
        }
        this._creators[var2_2] = this._fixAccess(var1_1);
        return true;
    }

    public void _reportDuplicateCreator(int n2, boolean bl, AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2) {
        String string = "Conflicting %s creators: already had %s creator %s, encountered another: %s";
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = TYPE_DESCS[n2];
        n2 = 1;
        String string2 = bl ? "explicitly marked" : "implicitly discovered";
        Object object = this;
        Object[] objectArray3 = objectArray2;
        Object[] objectArray4 = objectArray2;
        objectArray3[n2] = string2;
        objectArray4[2] = annotatedWithParams;
        objectArray3[3] = annotatedWithParams2;
        ((IllegalArgumentException)object)(String.format(string, objectArray4));
        throw object;
    }

    public boolean _isEnumValueOf(AnnotatedWithParams annotatedWithParams) {
        return ClassUtil.isEnumType(annotatedWithParams.getDeclaringClass()) && "valueOf".equals(annotatedWithParams.getName());
    }
}

