/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class FieldProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedField _annotated;
    protected final transient Field _field;
    protected final boolean _skipNulls;

    public FieldProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedField annotatedField) {
        super(beanPropertyDefinition, javaType, typeDeserializer, annotations);
        this._annotated = annotatedField;
        this._field = annotatedField.getAnnotated();
        this._skipNulls = NullsConstantProvider.isSkipper(this._nullProvider);
    }

    public FieldProperty(FieldProperty fieldProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(fieldProperty, jsonDeserializer, nullValueProvider);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
        this._skipNulls = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    public FieldProperty(FieldProperty fieldProperty, PropertyName propertyName) {
        super(fieldProperty, propertyName);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
        this._skipNulls = fieldProperty._skipNulls;
    }

    public FieldProperty(FieldProperty fieldProperty) {
        super(fieldProperty);
        this._annotated = fieldProperty._annotated;
        Field field = this._annotated.getAnnotated();
        if (field != null) {
            this._field = field;
            this._skipNulls = fieldProperty._skipNulls;
            return;
        }
        throw new IllegalArgumentException("Missing field (broken JDK (de)serialization?)");
    }

    @Override
    public SettableBeanProperty withName(PropertyName propertyName) {
        return new FieldProperty(this, propertyName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        NullValueProvider nullValueProvider = this._valueDeserializer;
        if (nullValueProvider == jsonDeserializer) {
            return this;
        }
        if (nullValueProvider == (nullValueProvider = this._nullProvider)) {
            nullValueProvider = jsonDeserializer;
        }
        return new FieldProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        return new FieldProperty(this, this._valueDeserializer, nullValueProvider);
    }

    @Override
    public void fixAccess(DeserializationConfig deserializationConfig) {
        ClassUtil.checkAndFixAccess(this._field, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Serializable serializable = ((FieldProperty)serializable)._annotated;
        return serializable == null ? null : (A)((AnnotatedMember)serializable).getAnnotation(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void deserializeAndSet(JsonParser var1_1, DeserializationContext var2_2, Object var3_3) {
        if (var1_1.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            while (true) {
                var2_2 = this._nullProvider.getNullValue((DeserializationContext)var2_2);
                break;
            }
        } else {
            var4_5 = this._valueTypeDeserializer;
            if (var4_5 == null) {
                var4_5 = this._valueDeserializer.deserialize(var1_1, (DeserializationContext)var2_2);
                if (var4_5 == null) {
                    if (!this._skipNulls) ** continue;
                    return;
                }
                var2_2 = var4_5;
            } else {
                var2_2 = this._valueDeserializer.deserializeWithType(var1_1, (DeserializationContext)var2_2, (TypeDeserializer)var4_5);
            }
        }
        try {
            this._field.set(var3_3, var2_2);
        }
        catch (Exception var3_4) {
            this._throwAsIOE(var1_1, var3_4, var2_2);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object deserializeSetAndReturn(JsonParser var1_1, DeserializationContext var2_2, Object var3_3) {
        if (var1_1.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return var3_3;
            }
            while (true) {
                var2_2 = this._nullProvider.getNullValue((DeserializationContext)var2_2);
                break;
            }
        } else {
            var4_4 = this._valueTypeDeserializer;
            if (var4_4 == null) {
                var4_4 = this._valueDeserializer.deserialize(var1_1, (DeserializationContext)var2_2);
                if (var4_4 == null) {
                    if (!this._skipNulls) ** continue;
                    return var3_3;
                }
                var2_2 = var4_4;
            } else {
                var2_2 = this._valueDeserializer.deserializeWithType(var1_1, (DeserializationContext)var2_2, (TypeDeserializer)var4_4);
            }
        }
        try {
            this._field.set(var3_3, var2_2);
        }
        catch (Exception var4_5) {
            this._throwAsIOE(var1_1, var4_5, var2_2);
        }
        return var3_3;
    }

    @Override
    public void set(Object object, Object object2) {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
    }

    @Override
    public Object setAndReturn(Object object, Object object2) {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
        return object;
    }

    public Object readResolve() {
        return new FieldProperty(this);
    }
}

