/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Constructor;

public final class InnerClassProperty
extends SettableBeanProperty.Delegating {
    private static final long serialVersionUID = 1L;
    protected final transient Constructor<?> _creator;
    protected AnnotatedConstructor _annotated;

    public InnerClassProperty(SettableBeanProperty settableBeanProperty, Constructor<?> constructor) {
        super(settableBeanProperty);
        this._creator = constructor;
    }

    public InnerClassProperty(SettableBeanProperty object, AnnotatedConstructor annotatedConstructor) {
        super((SettableBeanProperty)object);
        this._annotated = annotatedConstructor;
        object = annotatedConstructor == null ? null : annotatedConstructor.getAnnotated();
        this._creator = object;
        if (object != null) {
            return;
        }
        throw new IllegalArgumentException("Missing constructor (broken JDK (de)serialization?)");
    }

    @Override
    public SettableBeanProperty withDelegate(SettableBeanProperty settableBeanProperty) {
        if (settableBeanProperty == this.delegate) {
            return this;
        }
        return new InnerClassProperty(settableBeanProperty, this._creator);
    }

    @Override
    public void deserializeAndSet(JsonParser object, DeserializationContext deserializationContext, Object object2) {
        if (((JsonParser)object).currentToken() == JsonToken.VALUE_NULL) {
            object = this._valueDeserializer.getNullValue(deserializationContext);
        } else {
            TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
            if (typeDeserializer != null) {
                object = this._valueDeserializer.deserializeWithType((JsonParser)object, deserializationContext, typeDeserializer);
            } else {
                try {
                    typeDeserializer = this._creator.newInstance(object2);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = this._creator.getDeclaringClass().getName();
                    objectArray[1] = exception.getMessage();
                    ClassUtil.unwrapAndThrowAsIAE(exception, String.format("Failed to instantiate class %s, problem: %s", objectArray2));
                    typeDeserializer = null;
                }
                this._valueDeserializer.deserialize((JsonParser)object, deserializationContext, typeDeserializer);
                object = typeDeserializer;
            }
        }
        this.set(object2, object);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        return this.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    public Object readResolve() {
        return new InnerClassProperty((SettableBeanProperty)this, this._annotated);
    }

    public Object writeReplace() {
        if (this._annotated == null) {
            AnnotatedConstructor annotatedConstructor;
            AnnotatedConstructor annotatedConstructor2 = annotatedConstructor;
            annotatedConstructor = new AnnotatedConstructor(null, this._creator, null, null);
            return new InnerClassProperty((SettableBeanProperty)this, annotatedConstructor2);
        }
        return this;
    }
}

