/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.deser.impl.f;
import com.privatefasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JavaUtilCollectionsDeserializers {
    private static final int TYPE_SINGLETON_SET = 1;
    private static final int TYPE_SINGLETON_LIST = 2;
    private static final int TYPE_SINGLETON_MAP = 3;
    private static final int TYPE_UNMODIFIABLE_SET = 4;
    private static final int TYPE_UNMODIFIABLE_LIST = 5;
    private static final int TYPE_UNMODIFIABLE_MAP = 6;
    private static final int TYPE_SYNC_SET = 7;
    private static final int TYPE_SYNC_COLLECTION = 8;
    private static final int TYPE_SYNC_LIST = 9;
    private static final int TYPE_SYNC_MAP = 10;
    public static final int TYPE_AS_LIST = 11;
    private static final String PREFIX_JAVA_UTIL_COLLECTIONS = "java.util.Collections$";
    private static final String PREFIX_JAVA_UTIL_ARRAYS = "java.util.Arrays$";
    private static final String PREFIX_JAVA_UTIL_IMMUTABLE_COLL = "java.util.ImmutableCollections$";

    public static JsonDeserializer<?> findForCollection(DeserializationContext object, JavaType serializable) {
        object = serializable.getRawClass().getName();
        if (!((String)object).startsWith("java.util.")) {
            return null;
        }
        String string = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName((String)object);
        if (string != null) {
            object = null;
            String string2 = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(string);
            if (string2 != null) {
                if (string2.endsWith("Set")) {
                    object = JavaUtilCollectionsDeserializers.converter(4, serializable, Set.class);
                } else if (string2.endsWith("List")) {
                    object = JavaUtilCollectionsDeserializers.converter(5, serializable, List.class);
                }
            } else {
                string2 = JavaUtilCollectionsDeserializers._findSingletonTypeName(string);
                if (string2 != null) {
                    if (string2.endsWith("Set")) {
                        object = JavaUtilCollectionsDeserializers.converter(1, serializable, Set.class);
                    } else if (string2.endsWith("List")) {
                        object = JavaUtilCollectionsDeserializers.converter(2, serializable, List.class);
                    }
                } else if ((string = JavaUtilCollectionsDeserializers._findSyncTypeName(string)) != null) {
                    if (string.endsWith("Set")) {
                        object = JavaUtilCollectionsDeserializers.converter(7, serializable, Set.class);
                    } else if (string.endsWith("List")) {
                        object = JavaUtilCollectionsDeserializers.converter(9, serializable, List.class);
                    } else if (string.endsWith("Collection")) {
                        object = JavaUtilCollectionsDeserializers.converter(8, serializable, Collection.class);
                    }
                }
            }
            if (object == null) {
                object = null;
            } else {
                StdDelegatingDeserializer stdDelegatingDeserializer;
                serializable = stdDelegatingDeserializer;
                stdDelegatingDeserializer = new StdDelegatingDeserializer(object);
                object = serializable;
            }
            return object;
        }
        string = JavaUtilCollectionsDeserializers._findUtilArrayTypeName((String)object);
        if (string != null) {
            if (string.contains("List")) {
                return new StdDelegatingDeserializer(JavaUtilCollectionsDeserializers.converter(11, serializable, List.class));
            }
            return null;
        }
        if ((object = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName((String)object)) != null) {
            if (((String)object).contains("List")) {
                return new StdDelegatingDeserializer(JavaUtilCollectionsDeserializers.converter(11, serializable, List.class));
            }
            if (((String)object).contains("Set")) {
                return new StdDelegatingDeserializer(JavaUtilCollectionsDeserializers.converter(4, serializable, Set.class));
            }
            return null;
        }
        return null;
    }

    public static JsonDeserializer<?> findForMap(DeserializationContext object, JavaType javaType) {
        f f2;
        block12: {
            block13: {
                block10: {
                    String string;
                    block11: {
                        object = javaType.getRawClass().getName();
                        f2 = null;
                        string = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName((String)object);
                        if (string == null) break block10;
                        object = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(string);
                        if (object == null) break block11;
                        if (!((String)object).contains("Map")) break block12;
                        break block13;
                    }
                    object = JavaUtilCollectionsDeserializers._findSingletonTypeName(string);
                    if (object != null) {
                        if (((String)object).contains("Map")) {
                            f2 = JavaUtilCollectionsDeserializers.converter(3, javaType, Map.class);
                        }
                    } else {
                        object = JavaUtilCollectionsDeserializers._findSyncTypeName(string);
                        if (object != null && ((String)object).contains("Map")) {
                            f2 = JavaUtilCollectionsDeserializers.converter(10, javaType, Map.class);
                        }
                    }
                    break block12;
                }
                if ((object = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName((String)object)) == null || !((String)object).contains("Map")) break block12;
            }
            f2 = JavaUtilCollectionsDeserializers.converter(6, javaType, Map.class);
        }
        if (f2 == null) {
            object = null;
        } else {
            StdDelegatingDeserializer stdDelegatingDeserializer;
            object = stdDelegatingDeserializer;
            stdDelegatingDeserializer = new StdDelegatingDeserializer(f2);
        }
        return object;
    }

    public static f converter(int n2, JavaType javaType, Class<?> clazz) {
        return new f(n2, javaType.findSuperType(clazz));
    }

    private static String _findUtilArrayTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_ARRAYS)) {
            return string.substring(17);
        }
        return null;
    }

    private static String _findUtilCollectionsTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_COLLECTIONS)) {
            return string.substring(22);
        }
        return null;
    }

    private static String _findUtilCollectionsImmutableTypeName(String string) {
        if (string.startsWith(PREFIX_JAVA_UTIL_IMMUTABLE_COLL)) {
            return string.substring(31);
        }
        return null;
    }

    private static String _findSingletonTypeName(String string) {
        return string.startsWith("Singleton") ? string.substring(9) : null;
    }

    private static String _findSyncTypeName(String string) {
        return string.startsWith("Synchronized") ? string.substring(12) : null;
    }

    private static String _findUnmodifiableTypeName(String string) {
        return string.startsWith("Unmodifiable") ? string.substring(12) : null;
    }
}

