/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import java.util.Collection;
import java.util.Map;

public final class ManagedReferenceProperty
extends SettableBeanProperty.Delegating {
    private static final long serialVersionUID = 1L;
    protected final String _referenceName;
    protected final boolean _isContainer;
    protected final SettableBeanProperty _backProperty;

    public ManagedReferenceProperty(SettableBeanProperty settableBeanProperty, String string, SettableBeanProperty settableBeanProperty2, boolean bl) {
        super(settableBeanProperty);
        this._referenceName = string;
        this._backProperty = settableBeanProperty2;
        this._isContainer = bl;
    }

    @Override
    public SettableBeanProperty withDelegate(SettableBeanProperty settableBeanProperty) {
        throw new IllegalStateException("Should never try to reset delegate");
    }

    @Override
    public void fixAccess(DeserializationConfig deserializationConfig) {
        ManagedReferenceProperty managedReferenceProperty = this;
        managedReferenceProperty.delegate.fixAccess(deserializationConfig);
        managedReferenceProperty._backProperty.fixAccess(deserializationConfig);
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        this.set(object, this.delegate.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        return this.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public final void set(Object object, Object object2) {
        this.setAndReturn(object, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object setAndReturn(Object object, Object object2) {
        if (object2 == null) return this.delegate.setAndReturn(object, object2);
        if (this._isContainer) {
            if (object2 instanceof Object[]) {
                for (Object object3 : (Object[])object2) {
                    if (object3 == null) continue;
                    this._backProperty.set(object3, object);
                }
                return this.delegate.setAndReturn(object, object2);
            } else if (object2 instanceof Collection) {
                for (Object e2 : (Collection)object2) {
                    if (e2 == null) continue;
                    this._backProperty.set(e2, object);
                }
                return this.delegate.setAndReturn(object, object2);
            } else {
                if (!(object2 instanceof Map)) throw new IllegalStateException("Unsupported container type (" + object2.getClass().getName() + ") when resolving reference '" + this._referenceName + "'");
                for (Object v2 : ((Map)object2).values()) {
                    if (v2 == null) continue;
                    this._backProperty.set(v2, object);
                }
            }
            return this.delegate.setAndReturn(object, object2);
        } else {
            this._backProperty.set(object2, object);
        }
        return this.delegate.setAndReturn(object, object2);
    }
}

