/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import java.io.Serializable;

public class NullsConstantProvider
implements NullValueProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final NullsConstantProvider SKIPPER = new NullsConstantProvider(null);
    private static final NullsConstantProvider NULLER = new NullsConstantProvider(null);
    protected final Object _nullValue;
    protected final AccessPattern _access;

    public NullsConstantProvider(Object object) {
        this._nullValue = object;
        object = object == null ? AccessPattern.ALWAYS_NULL : AccessPattern.CONSTANT;
        this._access = object;
    }

    public static NullsConstantProvider skipper() {
        return SKIPPER;
    }

    public static NullsConstantProvider nuller() {
        return NULLER;
    }

    public static NullsConstantProvider forValue(Object object) {
        if (object == null) {
            return NULLER;
        }
        return new NullsConstantProvider(object);
    }

    public static boolean isSkipper(NullValueProvider nullValueProvider) {
        return nullValueProvider == SKIPPER;
    }

    public static boolean isNuller(NullValueProvider nullValueProvider) {
        return nullValueProvider == NULLER;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return this._access;
    }

    @Override
    public Object getNullValue(DeserializationContext deserializationContext) {
        return this._nullValue;
    }
}

