/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.exc.InvalidNullException;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import java.io.Serializable;

public class NullsFailProvider
implements NullValueProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _name;
    protected final JavaType _type;

    public NullsFailProvider(PropertyName propertyName, JavaType javaType) {
        this._name = propertyName;
        this._type = javaType;
    }

    public static NullsFailProvider constructForProperty(BeanProperty beanProperty) {
        BeanProperty beanProperty2 = beanProperty;
        return NullsFailProvider.constructForProperty(beanProperty2, beanProperty2.getType());
    }

    public static NullsFailProvider constructForProperty(BeanProperty beanProperty, JavaType javaType) {
        return new NullsFailProvider(beanProperty.getFullName(), javaType);
    }

    public static NullsFailProvider constructForRootValue(JavaType javaType) {
        return new NullsFailProvider(null, javaType);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getNullValue(DeserializationContext deserializationContext) {
        NullsFailProvider nullsFailProvider = serializable;
        Serializable serializable = nullsFailProvider._name;
        throw InvalidNullException.from(deserializationContext, (PropertyName)serializable, nullsFailProvider._type);
    }
}

