/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.impl;

import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindException;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.deser.SettableAnyProperty;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyValue;
import com.privatefasterxml.jackson.databind.deser.impl.h;
import com.privatefasterxml.jackson.databind.deser.impl.i;
import com.privatefasterxml.jackson.databind.deser.impl.j;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import java.util.BitSet;

public class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final ObjectIdReader _objectIdReader;
    protected final Object[] _creatorParameters;
    protected int _paramsNeeded;
    protected int _paramsSeen;
    protected final BitSet _paramsSeenBig;
    protected PropertyValue _buffered;
    protected Object _idValue;

    public PropertyValueBuffer(JsonParser jsonParser, DeserializationContext deserializationContext, int n2, ObjectIdReader objectIdReader) {
        ((PropertyValueBuffer)((Object)bitSet2))._parser = jsonParser;
        ((PropertyValueBuffer)((Object)bitSet2))._context = deserializationContext;
        ((PropertyValueBuffer)((Object)bitSet2))._paramsNeeded = n2;
        ((PropertyValueBuffer)((Object)bitSet2))._objectIdReader = objectIdReader;
        ((PropertyValueBuffer)((Object)bitSet2))._creatorParameters = new Object[n2];
        if (n2 < 32) {
            ((PropertyValueBuffer)((Object)bitSet2))._paramsSeenBig = null;
        } else {
            BitSet bitSet;
            PropertyValueBuffer propertyValueBuffer = bitSet2;
            BitSet bitSet2 = bitSet;
            bitSet = new BitSet();
            propertyValueBuffer._paramsSeenBig = bitSet2;
        }
    }

    public final boolean hasParameter(SettableBeanProperty settableBeanProperty) {
        BitSet bitSet = this._paramsSeenBig;
        if (bitSet == null) {
            return (this._paramsSeen >> settableBeanProperty.getCreatorIndex() & 1) == 1;
        }
        return bitSet.get(settableBeanProperty.getCreatorIndex());
    }

    public Object getParameter(SettableBeanProperty settableBeanProperty) {
        Object object;
        if (objectArray2.hasParameter(settableBeanProperty)) {
            object = objectArray2._creatorParameters[settableBeanProperty.getCreatorIndex()];
        } else {
            Object object2;
            SettableBeanProperty settableBeanProperty2 = settableBeanProperty;
            int n2 = settableBeanProperty2.getCreatorIndex();
            objectArray2._creatorParameters[n2] = object2 = objectArray2._findMissing(settableBeanProperty2);
            object = object2;
        }
        if (object == null && objectArray2._context.isEnabled(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES)) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = settableBeanProperty.getName();
            objectArray[1] = settableBeanProperty.getCreatorIndex();
            return objectArray2._context.reportInputMismatch(settableBeanProperty, "Null value for creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES` enabled", objectArray2);
        }
        return object;
    }

    public Object[] getParameters(SettableBeanProperty[] settableBeanPropertyArray) {
        int n2;
        if (this._paramsNeeded > 0) {
            int n3;
            if (this._paramsSeenBig == null) {
                PropertyValueBuffer propertyValueBuffer = this;
                n2 = propertyValueBuffer._paramsSeen;
                n3 = 0;
                int n4 = propertyValueBuffer._creatorParameters.length;
                while (n3 < n4) {
                    if ((n2 & 1) == 0) {
                        this._creatorParameters[n3] = this._findMissing(settableBeanPropertyArray[n3]);
                    }
                    ++n3;
                    n2 >>= 1;
                }
            } else {
                n2 = this._creatorParameters.length;
                n3 = 0;
                while ((n3 = this._paramsSeenBig.nextClearBit(n3)) < n2) {
                    this._creatorParameters[n3] = this._findMissing(settableBeanPropertyArray[n3]);
                    ++n3;
                }
            }
        }
        if (this._context.isEnabled(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES)) {
            for (n2 = 0; n2 < settableBeanPropertyArray.length; ++n2) {
                if (this._creatorParameters[n2] != null) continue;
                SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = settableBeanProperty.getName();
                objectArray[1] = settableBeanPropertyArray[n2].getCreatorIndex();
                this._context.reportInputMismatch(settableBeanProperty, "Null value for creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES` enabled", objectArray2);
            }
        }
        return this._creatorParameters;
    }

    public Object _findMissing(SettableBeanProperty serializable) {
        block7: {
            Object object;
            if (serializable.getInjectableValueId() != null) {
                return this._context.findInjectableValue(serializable.getInjectableValueId(), (BeanProperty)((Object)serializable), null);
            }
            if (serializable.isRequired()) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                object[0] = serializable.getName();
                objectArray[1] = serializable.getCreatorIndex();
                this._context.reportInputMismatch((BeanProperty)((Object)serializable), "Missing required creator property '%s' (index %d)", (Object[])object);
            }
            if (this._context.isEnabled(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES)) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                object[0] = serializable.getName();
                objectArray[1] = serializable.getCreatorIndex();
                this._context.reportInputMismatch((BeanProperty)((Object)serializable), "Missing creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES` enabled", (Object[])object);
            }
            try {
                object = serializable.getNullValueProvider().getAbsentValue(this._context);
                if (object == null) break block7;
                return object;
            }
            catch (DatabindException databindException) {
                object = serializable.getMember();
                if (object != null) {
                    SettableBeanProperty settableBeanProperty = serializable;
                    serializable = ((AnnotatedMember)object).getDeclaringClass();
                    databindException.prependPath((Object)serializable, settableBeanProperty.getName());
                }
                throw databindException;
            }
        }
        return serializable.getValueDeserializer().getAbsentValue(this._context);
    }

    public boolean readIdProperty(String string) {
        ObjectIdReader objectIdReader = ((PropertyValueBuffer)((Object)jsonParser))._objectIdReader;
        if (objectIdReader != null && string.equals(objectIdReader.propertyName.getSimpleName())) {
            PropertyValueBuffer propertyValueBuffer = jsonParser;
            PropertyValueBuffer propertyValueBuffer2 = jsonParser;
            JsonParser jsonParser = propertyValueBuffer2._parser;
            propertyValueBuffer._idValue = propertyValueBuffer._objectIdReader.readObjectReference(jsonParser, propertyValueBuffer2._context);
            return true;
        }
        return false;
    }

    public Object handleIdValue(DeserializationContext serializable, Object object) {
        ObjectIdReader objectIdReader = this._objectIdReader;
        if (objectIdReader != null) {
            Object object2 = this._idValue;
            if (object2 != null) {
                DeserializationContext deserializationContext = serializable;
                ObjectIdReader objectIdReader2 = objectIdReader;
                serializable = objectIdReader2.generator;
                deserializationContext.findObjectId(object2, (ObjectIdGenerator<?>)serializable, objectIdReader2.resolver).bindItem(object);
                serializable = this._objectIdReader.idProperty;
                if (serializable != null) {
                    return ((SettableBeanProperty)serializable).setAndReturn(object, this._idValue);
                }
            } else {
                ((DeserializationContext)serializable).reportUnresolvedObjectId(objectIdReader, object);
            }
        }
        return object;
    }

    public PropertyValue buffered() {
        return this._buffered;
    }

    public boolean isComplete() {
        return this._paramsNeeded <= 0;
    }

    public boolean assignParameter(SettableBeanProperty settableBeanProperty, Object object) {
        PropertyValueBuffer propertyValueBuffer = this;
        int n2 = settableBeanProperty.getCreatorIndex();
        propertyValueBuffer._creatorParameters[n2] = object;
        object = propertyValueBuffer._paramsSeenBig;
        if (object == null) {
            int n3 = this._paramsSeen;
            if (n3 != (n2 = n3 | 1 << n2)) {
                this._paramsSeen = n2;
                if (--this._paramsNeeded <= 0) {
                    return this._objectIdReader == null || this._idValue != null;
                }
            }
        } else if (!((BitSet)object).get(n2)) {
            PropertyValueBuffer propertyValueBuffer2 = this;
            propertyValueBuffer2._paramsSeenBig.set(n2);
            --propertyValueBuffer2._paramsNeeded;
        }
        return false;
    }

    public void bufferProperty(SettableBeanProperty settableBeanProperty, Object object) {
        this._buffered = new j(this._buffered, object, settableBeanProperty);
    }

    public void bufferAnyProperty(SettableAnyProperty settableAnyProperty, String string, Object object) {
        this._buffered = new h(this._buffered, object, settableAnyProperty, string);
    }

    public void bufferMapProperty(Object object, Object object2) {
        this._buffered = new i(this._buffered, object2, object);
    }
}

