/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import java.util.concurrent.atomic.AtomicBoolean;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser object, DeserializationContext deserializationContext) {
        Object object2;
        JsonToken jsonToken = ((JsonParser)object).currentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        if ((object2 = ((StdDeserializer)object2)._parseBoolean((JsonParser)object, deserializationContext, AtomicBoolean.class)) == null) {
            object2 = null;
        } else {
            AtomicBoolean atomicBoolean;
            object = atomicBoolean;
            atomicBoolean = new AtomicBoolean((Boolean)object2);
            object2 = object;
        }
        return object2;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return new AtomicBoolean(false);
    }
}

