/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.privatefasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.c;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JacksonStdImpl
public class CollectionDeserializer
extends ContainerDeserializerBase<Collection<Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = -1L;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, jsonDeserializer, typeDeserializer, valueInstantiator, null, null, null);
    }

    public CollectionDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, ValueInstantiator valueInstantiator, JsonDeserializer<Object> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl) {
        super(javaType, nullValueProvider, bl);
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer2;
    }

    public CollectionDeserializer(CollectionDeserializer collectionDeserializer) {
        super(collectionDeserializer);
        this._valueDeserializer = collectionDeserializer._valueDeserializer;
        this._valueTypeDeserializer = collectionDeserializer._valueTypeDeserializer;
        this._valueInstantiator = collectionDeserializer._valueInstantiator;
        this._delegateDeserializer = collectionDeserializer._delegateDeserializer;
    }

    public CollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        CollectionDeserializer collectionDeserializer = serializable;
        Serializable serializable = collectionDeserializer._containerType;
        ValueInstantiator valueInstantiator = collectionDeserializer._valueInstantiator;
        return new CollectionDeserializer((JavaType)serializable, jsonDeserializer2, typeDeserializer, valueInstantiator, jsonDeserializer, nullValueProvider, bl);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._valueTypeDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public CollectionDeserializer createContextual(DeserializationContext object, BeanProperty beanProperty) {
        void var5_17;
        Object object2;
        block9: {
            block11: {
                block10: {
                    object2 = null;
                    ValueInstantiator valueInstantiator = this._valueInstantiator;
                    if (valueInstantiator == null) break block9;
                    if (!valueInstantiator.canCreateUsingDelegate()) break block10;
                    object2 = this._valueInstantiator.getDelegateType(((DeserializationContext)object).getConfig());
                    if (object2 == null) {
                        JavaType javaType = this._containerType;
                        Object[] objectArray = new Object[2];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = javaType;
                        objectArray[1] = this._valueInstantiator.getClass().getName();
                        ((DeserializationContext)object).reportBadDefinition(javaType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", objectArray2));
                    }
                    break block11;
                }
                if (!this._valueInstantiator.canCreateUsingArrayDelegate()) break block9;
                object2 = this._valueInstantiator.getArrayDelegateType(((DeserializationContext)object).getConfig());
                if (object2 == null) {
                    JavaType javaType = this._containerType;
                    Object[] objectArray = new Object[2];
                    Object[] objectArray3 = objectArray;
                    objectArray[0] = javaType;
                    objectArray[1] = this._valueInstantiator.getClass().getName();
                    ((DeserializationContext)object).reportBadDefinition(javaType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", objectArray3));
                }
            }
            object2 = this.findDeserializer((DeserializationContext)object, (JavaType)object2, beanProperty);
        }
        JsonFormat.Feature feature = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY;
        Boolean bl = this.findFormatFeature((DeserializationContext)object, beanProperty, Collection.class, feature);
        JsonDeserializer<Object> jsonDeserializer2 = this._valueDeserializer;
        jsonDeserializer2 = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer2);
        Object object3 = this._containerType.getContentType();
        if (jsonDeserializer2 == null) {
            JsonDeserializer<Object> jsonDeserializer3 = ((DeserializationContext)object).findContextualValueDeserializer((JavaType)object3, beanProperty);
        } else {
            JsonDeserializer<?> jsonDeserializer4 = ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer2, beanProperty, (JavaType)object3);
        }
        object3 = this._valueTypeDeserializer;
        if (object3 != null) {
            object3 = ((TypeDeserializer)object3).forProperty(beanProperty);
        }
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, (JsonDeserializer<?>)var5_17);
        if (!Objects.equals(bl, this._unwrapSingle)) return this.withResolved((JsonDeserializer<?>)object2, (JsonDeserializer<?>)var5_17, (TypeDeserializer)object3, (NullValueProvider)object, bl);
        if (object != this._nullProvider) return this.withResolved((JsonDeserializer<?>)object2, (JsonDeserializer<?>)var5_17, (TypeDeserializer)object3, (NullValueProvider)object, bl);
        if (object2 != this._delegateDeserializer) return this.withResolved((JsonDeserializer<?>)object2, (JsonDeserializer<?>)var5_17, (TypeDeserializer)object3, (NullValueProvider)object, bl);
        if (var5_17 != this._valueDeserializer) return this.withResolved((JsonDeserializer<?>)object2, (JsonDeserializer<?>)var5_17, (TypeDeserializer)object3, (NullValueProvider)object, bl);
        if (object3 == this._valueTypeDeserializer) return this;
        return this.withResolved((JsonDeserializer<?>)object2, (JsonDeserializer<?>)var5_17, (TypeDeserializer)object3, (NullValueProvider)object, bl);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer;
        if (jsonDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            JsonParser jsonParser2 = jsonParser;
            return this._deserializeFromString(jsonParser2, deserializationContext, jsonParser2.getText());
        }
        return this.handleNonArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
    }

    public Collection<Object> createDefaultInstance(DeserializationContext deserializationContext) {
        return (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
    }

    @Override
    public Collection<Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) {
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext, collection);
        }
        return this.handleNonArray(jsonParser, deserializationContext, collection);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    public Collection<Object> _deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext, String object) {
        Class<?> clazz = this.handledType();
        if (object.isEmpty()) {
            object = this.logicalType();
            CoercionInputShape coercionInputShape = CoercionInputShape.EmptyString;
            if ((object = deserializationContext.findCoercionAction((LogicalType)((Object)object), clazz, coercionInputShape)) != null && object != CoercionAction.Fail) {
                return (Collection)this._deserializeFromEmptyString(jsonParser, deserializationContext, (CoercionAction)((Object)object), clazz, "empty String (\"\")");
            }
        } else if (StdDeserializer._isBlank(object)) {
            object = this.logicalType();
            CoercionAction coercionAction = CoercionAction.Fail;
            if ((object = deserializationContext.findCoercionFromBlankString((LogicalType)((Object)object), clazz, coercionAction)) != coercionAction) {
                return (Collection)this._deserializeFromEmptyString(jsonParser, deserializationContext, (CoercionAction)((Object)object), clazz, "blank String (all whitespace)");
            }
        }
        return this.handleNonArray(jsonParser, deserializationContext, this.createDefaultInstance(deserializationContext));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Object> _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) {
        Exception exception2;
        jsonParser.setCurrentValue(collection);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (jsonDeserializer.getObjectIdReader() != null) {
            return this._deserializeWithObjectId(jsonParser, deserializationContext, collection);
        }
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        while (true) {
            Object object;
            Object object2;
            block8: {
                block7: {
                    if ((object2 = jsonParser.nextToken()) == JsonToken.END_ARRAY) {
                        return collection;
                    }
                    try {
                        if (object2 != JsonToken.VALUE_NULL) break block7;
                        if (this._skipNullValues) continue;
                        object = this._nullProvider.getNullValue(deserializationContext);
                        break block8;
                    }
                    catch (Exception exception2) {
                        break;
                    }
                }
                object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
            }
            object2 = object;
            collection.add(object2);
        }
        if (deserializationContext != null && !deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(exception2);
        }
        Collection<Object> collection2 = collection;
        throw JsonMappingException.wrapWithPath((Throwable)exception2, collection2, collection2.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Collection<Object> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) {
        Exception exception2;
        block7: {
            Object object;
            block6: {
                TypeDeserializer typeDeserializer;
                Object object2;
                block5: {
                    object2 = ((ContainerDeserializerBase)t2)._unwrapSingle;
                    if (!(object2 == Boolean.TRUE || object2 == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY))) {
                        return (Collection)deserializationContext.handleUnexpectedToken(((ContainerDeserializerBase)t2)._containerType, jsonParser);
                    }
                    CollectionDeserializer collectionDeserializer = t2;
                    object2 = collectionDeserializer._valueDeserializer;
                    typeDeserializer = collectionDeserializer._valueTypeDeserializer;
                    try {
                        if (!jsonParser.hasToken(JsonToken.VALUE_NULL)) break block5;
                        if (((ContainerDeserializerBase)t2)._skipNullValues) {
                            return collection;
                        }
                        object = ((ContainerDeserializerBase)t2)._nullProvider.getNullValue(deserializationContext);
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                }
                object = typeDeserializer == null ? ((JsonDeserializer)object2).deserialize(jsonParser, deserializationContext) : ((JsonDeserializer)object2).deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
            }
            Object t2 = object;
            Collection<Object> collection2 = collection;
            collection2.add(t2);
            return collection2;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(exception2);
        }
        throw JsonMappingException.wrapWithPath((Throwable)exception2, Object.class, collection.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Object> _deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<Object> collection) {
        CollectionReferringAccumulator collectionReferringAccumulator;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        CollectionDeserializer collectionDeserializer = this;
        jsonParser.setCurrentValue(collection);
        JsonDeserializer<Object> jsonDeserializer = collectionDeserializer._valueDeserializer;
        TypeDeserializer typeDeserializer = collectionDeserializer._valueTypeDeserializer;
        CollectionReferringAccumulator collectionReferringAccumulator2 = collectionReferringAccumulator;
        collectionReferringAccumulator = new CollectionReferringAccumulator(this._containerType.getContentType().getRawClass(), collection);
        while (true) {
            UnresolvedForwardReference unresolvedForwardReference2;
            Object object;
            block11: {
                Exception exception2;
                block10: {
                    Object object2;
                    block9: {
                        block8: {
                            if ((object = jsonParser.nextToken()) == JsonToken.END_ARRAY) {
                                return collection;
                            }
                            try {
                                if (object != JsonToken.VALUE_NULL) break block8;
                                if (this._skipNullValues) continue;
                                object2 = this._nullProvider.getNullValue(deserializationContext);
                                break block9;
                            }
                            catch (Exception exception2) {
                                break block10;
                            }
                            catch (UnresolvedForwardReference unresolvedForwardReference2) {
                                break block11;
                            }
                        }
                        object2 = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                    }
                    object = object2;
                    collectionReferringAccumulator2.add(object);
                    continue;
                }
                if (deserializationContext != null && !deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
                    ClassUtil.throwIfRTE(exception2);
                }
                Collection<Object> collection2 = collection;
                throw JsonMappingException.wrapWithPath((Throwable)exception2, collection2, collection2.size());
            }
            object = collectionReferringAccumulator2.handleUnresolvedReference(unresolvedForwardReference2);
            unresolvedForwardReference2.getRoid().appendReferring((ReadableObjectId.Referring)object);
        }
    }

    public static class CollectionReferringAccumulator {
        private final Class<?> _elementType;
        private final Collection<Object> _result;
        private List<c> _accumulator;

        public CollectionReferringAccumulator(Class<?> clazz, Collection<Object> collection) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1._accumulator = arrayList2;
            v1._elementType = clazz;
            v1._result = collection;
        }

        public void add(Object object) {
            if (this._accumulator.isEmpty()) {
                this._result.add(object);
            } else {
                List<c> list = this._accumulator;
                list.get((int)(list.size() - 1)).b.add(object);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference unresolvedForwardReference) {
            c c2;
            c c3 = c2;
            CollectionReferringAccumulator collectionReferringAccumulator = this;
            c3(collectionReferringAccumulator, unresolvedForwardReference, collectionReferringAccumulator._elementType);
            this._accumulator.add(c3);
            return c2;
        }

        public void resolveForwardReference(Object object, Object object2) {
            CollectionReferringAccumulator collectionReferringAccumulator = iterator;
            Iterator<c> iterator = collectionReferringAccumulator._accumulator.iterator();
            ArrayList arrayList = collectionReferringAccumulator._result;
            while (iterator.hasNext()) {
                c c2 = (c)iterator.next();
                if (c2.hasId(object)) {
                    iterator.remove();
                    arrayList.add(object2);
                    arrayList.addAll(c2.b);
                    return;
                }
                arrayList = c2.b;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object + "] that wasn't previously seen as unresolved.");
        }
    }
}

