/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public abstract class ContainerDeserializerBase<T>
extends StdDeserializer<T>
implements ValueInstantiator.Gettable {
    protected final JavaType _containerType;
    protected final NullValueProvider _nullProvider;
    protected final boolean _skipNullValues;
    protected final Boolean _unwrapSingle;

    public ContainerDeserializerBase(JavaType javaType, NullValueProvider nullValueProvider, Boolean bl) {
        super(javaType);
        this._containerType = javaType;
        this._unwrapSingle = bl;
        this._nullProvider = nullValueProvider;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    public ContainerDeserializerBase(JavaType javaType) {
        this(javaType, null, null);
    }

    public ContainerDeserializerBase(ContainerDeserializerBase<?> containerDeserializerBase) {
        ContainerDeserializerBase<T> containerDeserializerBase2 = nullValueProvider;
        ContainerDeserializerBase<?> containerDeserializerBase3 = containerDeserializerBase;
        NullValueProvider nullValueProvider = containerDeserializerBase3._nullProvider;
        Boolean bl = containerDeserializerBase3._unwrapSingle;
        containerDeserializerBase2(containerDeserializerBase, nullValueProvider, bl);
    }

    public ContainerDeserializerBase(ContainerDeserializerBase<?> containerDeserializerBase, NullValueProvider nullValueProvider, Boolean bl) {
        super(containerDeserializerBase._containerType);
        this._containerType = containerDeserializerBase._containerType;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    @Override
    public JavaType getValueType() {
        return this._containerType;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        Object[] objectArray = this.getContentDeserializer();
        if (objectArray != null) {
            return objectArray.findBackReference(string);
        }
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = string;
        objectArray2[1] = this.getClass().getName();
        throw new IllegalArgumentException(String.format("Cannot handle managed/back reference '%s': type: container deserializer of type %s returned null for 'getContentDeserializer()'", objectArray));
    }

    public JavaType getContentType() {
        Serializable serializable = ((ContainerDeserializerBase)serializable)._containerType;
        if (serializable == null) {
            return TypeFactory.unknownType();
        }
        return ((JavaType)serializable).getContentType();
    }

    public abstract JsonDeserializer<Object> getContentDeserializer();

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        ValueInstantiator valueInstantiator = serializable.getValueInstantiator();
        if (valueInstantiator == null || !valueInstantiator.canCreateUsingDefault()) {
            Serializable serializable = serializable.getValueType();
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = serializable;
            deserializationContext.reportBadDefinition((JavaType)serializable, String.format("Cannot create empty instance of %s, no default Creator", objectArray2));
        }
        try {
            return valueInstantiator.createUsingDefault(deserializationContext);
        }
        catch (IOException iOException) {
            return ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    @Deprecated
    public <BOGUS> BOGUS wrapAndThrow(Throwable throwable, Object object, String string) {
        return this.wrapAndThrow(null, throwable, object, string);
    }

    public <BOGUS> BOGUS wrapAndThrow(DeserializationContext deserializationContext, Throwable throwable, Object object, String string) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        if (deserializationContext != null && !deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        if (throwable instanceof IOException && !(throwable instanceof JsonMappingException)) {
            throw (IOException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, ClassUtil.nonNull(string, "N/A"));
    }
}

