/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.d;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.StdDateFormat;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> _utilClasses = new HashSet<String>();

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (_utilClasses.contains(string)) {
            if (clazz == Calendar.class) {
                return new CalendarDeserializer();
            }
            if (clazz == java.util.Date.class) {
                return DateDeserializer.instance;
            }
            if (clazz == GregorianCalendar.class) {
                return new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> clazz) {
        return _utilClasses.contains(clazz.getName());
    }

    static {
        _utilClasses.add("java.util.Calendar");
        _utilClasses.add("java.util.GregorianCalendar");
        _utilClasses.add("java.util.Date");
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        protected final Constructor<Calendar> _defaultCtor;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._defaultCtor = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz) {
            super(clazz);
            this._defaultCtor = ClassUtil.findConstructor(clazz, false);
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string) {
            super(calendarDeserializer, dateFormat, string);
            this._defaultCtor = calendarDeserializer._defaultCtor;
        }

        public CalendarDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new CalendarDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(0L);
            return gregorianCalendar;
        }

        @Override
        public Calendar deserialize(JsonParser object, DeserializationContext deserializationContext) {
            Exception exception2;
            block7: {
                Constructor<Calendar> constructor;
                block6: {
                    DeserializationContext deserializationContext2;
                    if ((object = this._parseDate((JsonParser)object, deserializationContext)) == null) {
                        return null;
                    }
                    constructor = this._defaultCtor;
                    if (constructor == null) {
                        return deserializationContext.constructCalendar((java.util.Date)object);
                    }
                    try {
                        deserializationContext2 = deserializationContext;
                        constructor = constructor.newInstance(new Object[0]);
                    }
                    catch (Exception exception2) {}
                    ((Calendar)((Object)constructor)).setTimeInMillis(((java.util.Date)object).getTime());
                    TimeZone timeZone = deserializationContext2.getTimeZone();
                    if (timeZone == null) break block6;
                    ((Calendar)((Object)constructor)).setTimeZone(timeZone);
                    break block7;
                }
                return constructor;
            }
            return (Calendar)deserializationContext.handleInstantiationProblem(this.handledType(), object, exception2);
        }
    }

    @JacksonStdImpl
    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string) {
            super(dateDeserializer, dateFormat, string);
        }

        public DateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new DateDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new java.util.Date(0L);
        }

        @Override
        public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer timestampDeserializer, DateFormat dateFormat, String string) {
            super(timestampDeserializer, dateFormat, string);
        }

        public TimestampDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new TimestampDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new Timestamp(0L);
        }

        @Override
        public Timestamp deserialize(JsonParser object, DeserializationContext deserializationContext) {
            Object object2;
            if ((object2 = ((DateBasedDeserializer)object2)._parseDate((JsonParser)object, deserializationContext)) == null) {
                object2 = null;
            } else {
                Timestamp timestamp;
                object = timestamp;
                timestamp = new Timestamp(((java.util.Date)object2).getTime());
                object2 = object;
            }
            return object2;
        }
    }

    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer sqlDateDeserializer, DateFormat dateFormat, String string) {
            super(sqlDateDeserializer, dateFormat, string);
        }

        public SqlDateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new SqlDateDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new Date(0L);
        }

        @Override
        public Date deserialize(JsonParser object, DeserializationContext deserializationContext) {
            Object object2;
            if ((object2 = ((DateBasedDeserializer)object2)._parseDate((JsonParser)object, deserializationContext)) == null) {
                object2 = null;
            } else {
                Date date;
                object = date;
                date = new Date(((java.util.Date)object2).getTime());
                object2 = object;
            }
            return object2;
        }
    }

    public static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        public DateBasedDeserializer(Class<?> clazz) {
            super(clazz);
            this._customFormat = null;
            this._formatString = null;
        }

        public DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string;
        }

        public abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public LogicalType logicalType() {
            return LogicalType.DateTime;
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext serializable, BeanProperty object) {
            DateBasedDeserializer dateBasedDeserializer = this;
            Serializable serializable2 = dateBasedDeserializer.handledType();
            if ((object = dateBasedDeserializer.findFormatOverrides((DeserializationContext)serializable, (BeanProperty)object, (Class<?>)serializable2)) != null) {
                Object object2 = object;
                serializable2 = ((JsonFormat.Value)object2).getTimeZone();
                Boolean bl = ((JsonFormat.Value)object2).getLenient();
                if (((JsonFormat.Value)object2).hasPattern()) {
                    SimpleDateFormat simpleDateFormat;
                    Object object3 = object;
                    String string = ((JsonFormat.Value)object3).getPattern();
                    object = ((JsonFormat.Value)object3).hasLocale() ? ((JsonFormat.Value)object).getLocale() : ((DeserializationContext)serializable).getLocale();
                    SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
                    simpleDateFormat = new SimpleDateFormat(string, (Locale)object);
                    if (serializable2 == null) {
                        serializable2 = ((DeserializationContext)serializable).getTimeZone();
                    }
                    simpleDateFormat2.setTimeZone((TimeZone)serializable2);
                    if (bl != null) {
                        simpleDateFormat2.setLenient(bl);
                    }
                    return this.withDateFormat(simpleDateFormat2, string);
                }
                if (serializable2 != null) {
                    DateFormat dateFormat = ((DeserializationContext)serializable).getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        serializable = ((JsonFormat.Value)object).hasLocale() ? ((JsonFormat.Value)object).getLocale() : ((DeserializationContext)serializable).getLocale();
                        serializable = ((StdDateFormat)dateFormat).withTimeZone((TimeZone)serializable2).withLocale((Locale)serializable);
                        if (bl != null) {
                            serializable = ((StdDateFormat)serializable).withLenient(bl);
                        }
                    } else {
                        serializable = (DateFormat)dateFormat.clone();
                        ((DateFormat)serializable).setTimeZone((TimeZone)serializable2);
                        if (bl != null) {
                            ((DateFormat)serializable).setLenient(bl);
                        }
                    }
                    return this.withDateFormat((DateFormat)serializable, this._formatString);
                }
                if (bl != null) {
                    serializable = ((DeserializationContext)serializable).getConfig().getDateFormat();
                    object = this._formatString;
                    if (serializable.getClass() == StdDateFormat.class) {
                        serializable = ((StdDateFormat)serializable).withLenient(bl);
                        object = ((StdDateFormat)serializable).toPattern();
                    } else {
                        serializable = (DateFormat)((DateFormat)serializable).clone();
                        ((DateFormat)serializable).setLenient(bl);
                        if (serializable instanceof SimpleDateFormat) {
                            ((SimpleDateFormat)serializable).toPattern();
                        }
                    }
                    if (object == null) {
                        object = "[unknown]";
                    }
                    return this.withDateFormat((DateFormat)serializable, (String)object);
                }
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public java.util.Date _parseDate(JsonParser objectArray, DeserializationContext deserializationContext) {
            if (this._customFormat != null && objectArray.hasToken(JsonToken.VALUE_STRING)) {
                if ((objectArray = objectArray.getText().trim()).isEmpty()) {
                    if (d.a[this._checkFromStringCoercion(deserializationContext, (String)objectArray).ordinal()] != 1) {
                        return null;
                    }
                    return new java.util.Date(0L);
                }
                DateBasedDeserializer dateBasedDeserializer = this;
                DateFormat dateFormat = dateBasedDeserializer._customFormat;
                synchronized (dateFormat) {
                    Throwable throwable2;
                    try {
                        return dateBasedDeserializer._customFormat.parse((String)objectArray);
                    }
                    catch (ParseException parseException) {
                        Object[] objectArray2;
                        String string;
                        Object[] objectArray3;
                        Class<?> clazz;
                        DeserializationContext deserializationContext2;
                        try {
                            deserializationContext2 = deserializationContext;
                            clazz = this.handledType();
                            objectArray3 = objectArray;
                            string = "expected format \"%s\"";
                            objectArray2 = new Object[1];
                        }
                        catch (Throwable throwable2) {}
                        objectArray = objectArray2;
                        int n2 = 0;
                        objectArray2[n2] = this._formatString;
                        return (java.util.Date)deserializationContext2.handleWeirdStringValue(clazz, (String)objectArray3, string, objectArray);
                    }
                    throw throwable2;
                }
            }
            return super._parseDate((JsonParser)objectArray, deserializationContext);
        }
    }
}

