/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.e;
import com.privatefasterxml.jackson.databind.deser.std.f;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.CompactStringObjectMap;
import com.privatefasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.util.Objects;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected Object[] _enumsByIndex;
    private final Enum<?> _enumDefaultValue;
    protected final CompactStringObjectMap _lookupByName;
    protected CompactStringObjectMap _lookupByToString;
    protected final Boolean _caseInsensitive;
    protected final boolean _isFromIntValue;

    public EnumDeserializer(EnumResolver enumResolver, Boolean bl) {
        super(enumResolver.getEnumClass());
        this._lookupByName = enumResolver.constructLookup();
        this._enumsByIndex = enumResolver.getRawEnums();
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._caseInsensitive = bl;
        this._isFromIntValue = enumResolver.isFromIntValue();
    }

    public EnumDeserializer(EnumDeserializer enumDeserializer, Boolean bl) {
        super(enumDeserializer);
        this._lookupByName = enumDeserializer._lookupByName;
        this._enumsByIndex = enumDeserializer._enumsByIndex;
        this._enumDefaultValue = enumDeserializer._enumDefaultValue;
        this._caseInsensitive = bl;
        this._isFromIntValue = enumDeserializer._isFromIntValue;
    }

    @Deprecated
    public EnumDeserializer(EnumResolver enumResolver) {
        this(enumResolver, null);
    }

    @Deprecated
    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        return EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, null, null);
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig serializable, Class<?> clazz, AnnotatedMethod annotatedMethod, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        if (serializable.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), serializable.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        serializable = annotatedMethod.getParameterType(0);
        return new f(clazz, annotatedMethod, (JavaType)serializable, valueInstantiator, settableBeanPropertyArray);
    }

    public static JsonDeserializer<?> deserializerForNoArgsCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new f(clazz, annotatedMethod);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object _deserializeAltString(JsonParser object, DeserializationContext deserializationContext, CompactStringObjectMap serializable, String object2) {
        block18: {
            int n2;
            object = ((String)object2).trim();
            if (((String)object).isEmpty()) {
                if (objectArray2._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                    return objectArray2._enumDefaultValue;
                }
                if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    return null;
                }
                if (((String)object2).isEmpty()) {
                    object = objectArray2._findCoercionFromEmptyString(deserializationContext);
                    serializable = objectArray2.handledType();
                    object = objectArray2._checkCoercionFail(deserializationContext, (CoercionAction)((Object)object), (Class<?>)serializable, object2, "empty String (\"\")");
                } else {
                    object = objectArray2._findCoercionFromBlankString(deserializationContext);
                    serializable = objectArray2.handledType();
                    object = objectArray2._checkCoercionFail(deserializationContext, (CoercionAction)((Object)object), (Class<?>)serializable, object2, "blank String (all whitespace)");
                }
                int n3 = e.a[((Enum)object).ordinal()];
                if (n3 != 2 && n3 != 3) {
                    return null;
                }
                return objectArray2.getEmptyValue(deserializationContext);
            }
            if (Boolean.TRUE.equals(objectArray2._caseInsensitive)) {
                object2 = ((CompactStringObjectMap)serializable).findCaseInsensitive((String)object);
                if (object2 != null) {
                    return object2;
                }
            } else if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS) && !objectArray2._isFromIntValue && (n2 = ((String)object).charAt(0)) >= 48 && n2 <= 57) {
                Object[] objectArray;
                int n4;
                try {
                    n2 = Integer.parseInt((String)object);
                    if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                        return deserializationContext.handleWeirdStringValue(objectArray2._enumClass(), (String)object, "value looks like quoted Enum index, but `MapperFeature.ALLOW_COERCION_OF_SCALARS` prevents use", new Object[0]);
                    }
                    if (n2 < 0) break block18;
                    n4 = n2;
                    objectArray = objectArray2._enumsByIndex;
                }
                catch (NumberFormatException numberFormatException) {}
                if (n4 < objectArray2._enumsByIndex.length) {
                    return objectArray[n2];
                }
            }
        }
        if (objectArray2._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
            return objectArray2._enumDefaultValue;
        }
        if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        Class<?> clazz = objectArray2._enumClass();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ((CompactStringObjectMap)serializable).keys();
        return deserializationContext.handleWeirdStringValue(clazz, (String)object, "not one of the values accepted for Enum class: %s", objectArray2);
    }

    public EnumDeserializer withResolved(Boolean bl) {
        if (Objects.equals(this._caseInsensitive, bl)) {
            return this;
        }
        return new EnumDeserializer(this, bl);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext serializable, BeanProperty beanProperty) {
        JsonFormat.Feature feature;
        EnumDeserializer enumDeserializer = this;
        Class<?> clazz = enumDeserializer.handledType();
        if ((serializable = enumDeserializer.findFormatFeature((DeserializationContext)serializable, beanProperty, clazz, feature = JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) == null) {
            serializable = this._caseInsensitive;
        }
        return this.withResolved((Boolean)serializable);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this._enumDefaultValue;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            JsonParser jsonParser2 = jsonParser;
            return this._fromString(jsonParser2, deserializationContext, jsonParser2.getText());
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._isFromIntValue) {
                JsonParser jsonParser3 = jsonParser;
                return this._fromString(jsonParser3, deserializationContext, jsonParser3.getText());
            }
            JsonParser jsonParser4 = jsonParser;
            return this._fromInteger(jsonParser4, deserializationContext, jsonParser4.getIntValue());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass));
        }
        return this._deserializeOther(jsonParser, deserializationContext);
    }

    public Object _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String object) {
        CompactStringObjectMap compactStringObjectMap = deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringLookup(deserializationContext) : this._lookupByName;
        Object object2 = compactStringObjectMap.find((String)object);
        if (object2 == null) {
            object2 = ((String)object).trim();
            if (object2 != object && (object = compactStringObjectMap.find((String)object2)) != null) {
                object2 = object;
            } else {
                return this._deserializeAltString(jsonParser, deserializationContext, compactStringObjectMap, (String)object2);
            }
        }
        return object2;
    }

    public Object _fromInteger(JsonParser object, DeserializationContext serializable, int n2) {
        int n3;
        EnumDeserializer enumDeserializer = serializable2;
        object = enumDeserializer.logicalType();
        Class<?> clazz = enumDeserializer.handledType();
        if ((object = serializable.findCoercionAction((LogicalType)((Object)object), clazz, CoercionInputShape.Integer)) == CoercionAction.Fail) {
            if (serializable.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                Serializable serializable2 = ((EnumDeserializer)serializable2)._enumClass();
                object = n2;
                Serializable serializable3 = serializable2;
                serializable2 = new Object[]{};
                return serializable.handleWeirdNumberValue((Class<?>)serializable3, (Number)object, "not allowed to deserialize Enum value out of number: disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow", (Object[])serializable2);
            }
            clazz = ((StdDeserializer)serializable2).handledType();
            Integer n4 = n2;
            String string = "Integer value (" + n2 + ")";
            ((StdDeserializer)serializable2)._checkCoercionFail((DeserializationContext)serializable, (CoercionAction)((Object)object), clazz, n4, string);
        }
        if ((n3 = e.a[((Enum)object).ordinal()]) != 1) {
            if (n3 != 2) {
                if (n2 >= 0) {
                    Object[] objectArray = ((EnumDeserializer)serializable2)._enumsByIndex;
                    if (n2 < ((EnumDeserializer)serializable2)._enumsByIndex.length) {
                        return objectArray[n2];
                    }
                }
                if (((EnumDeserializer)serializable2)._enumDefaultValue != null && serializable.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                    return ((EnumDeserializer)serializable2)._enumDefaultValue;
                }
                if (!serializable.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    DeserializationContext deserializationContext = serializable;
                    Object[] objectArray = ((EnumDeserializer)serializable2)._enumClass();
                    serializable = Integer.valueOf(n2);
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = ((EnumDeserializer)serializable2)._enumsByIndex.length - 1;
                    return deserializationContext.handleWeirdNumberValue((Class<?>)objectArray2, (Number)serializable, "index value outside legal index range [0..%s]", objectArray);
                }
                return null;
            }
            return ((EnumDeserializer)serializable2).getEmptyValue((DeserializationContext)serializable);
        }
        return null;
    }

    public Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._enumClass(), jsonParser);
    }

    public Class<?> _enumClass() {
        return this.handledType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactStringObjectMap _getToStringLookup(DeserializationContext deserializationContext) {
        CompactStringObjectMap compactStringObjectMap = this._lookupByToString;
        if (compactStringObjectMap == null) {
            synchronized (this) {
                compactStringObjectMap = EnumResolver.constructUsingToString(deserializationContext.getConfig(), this._enumClass()).constructLookup();
                // MONITOREXIT @DISABLED, blocks:[1, 2, 4] lbl7 : MonitorExitStatement: MONITOREXIT : this
                this._lookupByToString = compactStringObjectMap;
            }
        }
        return compactStringObjectMap;
    }
}

