/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.privatefasterxml.jackson.databind.deser.SettableBeanProperty;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.privatefasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumMap;

public class EnumMapDeserializer
extends ContainerDeserializerBase<EnumMap<?, ?>>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _enumClass;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;

    public EnumMapDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider) {
        super(javaType, nullValueProvider, null);
        this._enumClass = javaType.getKeyType().getRawClass();
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
    }

    public EnumMapDeserializer(EnumMapDeserializer enumMapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider) {
        EnumMapDeserializer enumMapDeserializer2 = enumMapDeserializer;
        super(enumMapDeserializer2, nullValueProvider, enumMapDeserializer2._unwrapSingle);
        this._enumClass = enumMapDeserializer._enumClass;
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = enumMapDeserializer._valueInstantiator;
        this._delegateDeserializer = enumMapDeserializer._delegateDeserializer;
        this._propertyBasedCreator = enumMapDeserializer._propertyBasedCreator;
    }

    @Deprecated
    public EnumMapDeserializer(JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this(javaType, null, keyDeserializer, jsonDeserializer, typeDeserializer, null);
    }

    public EnumMapDeserializer withResolved(KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider) {
        if (keyDeserializer == this._keyDeserializer && nullValueProvider == this._nullProvider && jsonDeserializer == this._valueDeserializer && typeDeserializer == this._valueTypeDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resolve(DeserializationContext object) {
        Object object2 = settableBeanPropertyArray2._valueInstantiator;
        if (object2 == null) return;
        if (((ValueInstantiator)object2).canCreateUsingDelegate()) {
            object2 = settableBeanPropertyArray2._valueInstantiator.getDelegateType(((DeserializationContext)object).getConfig());
            if (object2 == null) {
                JavaType javaType = settableBeanPropertyArray2._containerType;
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = javaType;
                objectArray[1] = settableBeanPropertyArray2._valueInstantiator.getClass().getName();
                ((DeserializationContext)object).reportBadDefinition(javaType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", objectArray2));
            }
        } else {
            if (!settableBeanPropertyArray2._valueInstantiator.canCreateUsingArrayDelegate()) {
                if (!settableBeanPropertyArray2._valueInstantiator.canCreateFromObjectWith()) return;
                SettableBeanProperty[] settableBeanPropertyArray = settableBeanPropertyArray2;
                Object object3 = object;
                SettableBeanProperty[] settableBeanPropertyArray2 = settableBeanPropertyArray2._valueInstantiator.getFromObjectArguments(((DeserializationContext)object).getConfig());
                object = settableBeanPropertyArray2._valueInstantiator;
                boolean bl = ((DeserializationContext)object3).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
                settableBeanPropertyArray._propertyBasedCreator = PropertyBasedCreator.construct((DeserializationContext)object3, (ValueInstantiator)object, settableBeanPropertyArray2, bl);
                return;
            }
            object2 = settableBeanPropertyArray2._valueInstantiator.getArrayDelegateType(((DeserializationContext)object).getConfig());
            if (object2 == null) {
                JavaType javaType = settableBeanPropertyArray2._containerType;
                Object[] objectArray = new Object[2];
                Object[] objectArray3 = objectArray;
                objectArray3[0] = javaType;
                objectArray[1] = settableBeanPropertyArray2._valueInstantiator.getClass().getName();
                ((DeserializationContext)object).reportBadDefinition(javaType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", objectArray3));
            }
        }
        settableBeanPropertyArray2._delegateDeserializer = settableBeanPropertyArray2.findDeserializer((DeserializationContext)object, (JavaType)object2, null);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        KeyDeserializer keyDeserializer = nullValueProvider._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(nullValueProvider._containerType.getKeyType(), beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = nullValueProvider._valueDeserializer;
        Object object = nullValueProvider._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer((JavaType)object, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)object);
        object = nullValueProvider._valueTypeDeserializer;
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty(beanProperty);
        }
        EnumMapDeserializer enumMapDeserializer = nullValueProvider;
        NullValueProvider nullValueProvider = nullValueProvider.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer);
        return enumMapDeserializer.withResolved(keyDeserializer, jsonDeserializer, (TypeDeserializer)object, nullValueProvider);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this.constructMap(deserializationContext);
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingProperties(jsonParser, deserializationContext);
        }
        JsonDeserializer<Object> jsonDeserializer = this._delegateDeserializer;
        if (jsonDeserializer != null) {
            return (EnumMap)this._valueInstantiator.createUsingDelegate(deserializationContext, jsonDeserializer.deserialize(jsonParser, deserializationContext));
        }
        switch (jsonParser.currentTokenId()) {
            default: {
                return (EnumMap)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
            case 6: {
                return (EnumMap)this._deserializeFromString(jsonParser, deserializationContext);
            }
            case 3: {
                return (EnumMap)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            case 1: 
            case 2: 
            case 5: 
        }
        return this.deserialize(jsonParser, deserializationContext, this.constructMap(deserializationContext));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EnumMap<?, ?> deserialize(JsonParser var1_1, DeserializationContext var2_3, EnumMap var3_4) {
        block12: {
            block10: {
                block11: {
                    v0 = this;
                    var1_1.setCurrentValue(var3_4);
                    var4_5 = v0._valueDeserializer;
                    var5_6 = v0._valueTypeDeserializer;
                    if (var1_1.isExpectedStartObjectToken()) lbl-1000:
                    // 4 sources

                    {
                        while (true) {
                            var6_7 /* !! */  = var1_1.nextFieldName();
                            break;
                        }
                    } else {
                        var6_7 /* !! */  = var1_1.currentToken();
                        if (var6_7 /* !! */  != (var7_8 = JsonToken.FIELD_NAME)) {
                            if (var6_7 /* !! */  == JsonToken.END_OBJECT) {
                                return var3_4;
                            }
                            var6_7 /* !! */  = new Object[]{};
                            var2_3.reportWrongTokenException(this, (JsonToken)var7_8, null, var6_7 /* !! */ );
                        }
                        var6_7 /* !! */  = var1_1.currentName();
                    }
                    if (var6_7 /* !! */  == null) return var3_4;
                    var7_8 = (Enum)this._keyDeserializer.deserializeKey((String)var6_7 /* !! */ , var2_3);
                    var8_9 = var1_1.nextToken();
                    if (var7_8 != null) break block11;
                    if (!var2_3.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                        v1 = new Object[1];
                        var1_1 = v1;
                        v1[0] = this._containerType.getKeyType();
                        return (EnumMap)var2_3.handleWeirdStringValue(this._enumClass, (String)var6_7 /* !! */ , "value not one of declared Enum instance names for %s", var1_1);
                    }
                    var1_1.skipChildren();
                    ** GOTO lbl-1000
                }
                try {
                    if (var8_9 != JsonToken.VALUE_NULL) break block10;
                }
                catch (Exception var1_2) {
                    return (EnumMap)this.wrapAndThrow(var2_3, var1_2, var3_4, (String)var6_7 /* !! */ );
                }
                if (this._skipNullValues) ** GOTO lbl-1000
                v2 = this._nullProvider.getNullValue(var2_3);
lbl36:
                // 3 sources

                while (true) {
                    var6_7 /* !! */  = v2;
                    var3_4.put(var7_8, var6_7 /* !! */ );
                    ** continue;
                    break;
                }
            }
            if (var5_6 != null) break block12;
            v2 = var4_5.deserialize((JsonParser)var1_1, var2_3);
            ** GOTO lbl36
        }
        v2 = var4_5.deserializeWithType((JsonParser)var1_1, var2_3, var5_6);
        ** while (true)
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EnumMap<?, ?> constructMap(DeserializationContext deserializationContext) {
        ValueInstantiator valueInstantiator = ((EnumMapDeserializer)object)._valueInstantiator;
        if (valueInstantiator == null) {
            return new EnumMap(((EnumMapDeserializer)object)._enumClass);
        }
        try {
            if (valueInstantiator.canCreateUsingDefault()) return (EnumMap)((EnumMapDeserializer)object)._valueInstantiator.createUsingDefault(deserializationContext);
            EnumMapDeserializer enumMapDeserializer = object;
            Object object = enumMapDeserializer.handledType();
            valueInstantiator = enumMapDeserializer.getValueInstantiator();
            Serializable serializable = object;
            object = "no default constructor found";
            Object[] objectArray = new Object[]{};
            return (EnumMap)deserializationContext.handleMissingInstantiator((Class<?>)serializable, valueInstantiator, null, (String)object, objectArray);
        }
        catch (IOException iOException) {
            return (EnumMap)ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EnumMap<?, ?> _deserializeUsingProperties(JsonParser var1_1, DeserializationContext var2_5) {
        block15: {
            block14: {
                block13: {
                    block17: {
                        block16: {
                            var3_6 = this._propertyBasedCreator;
                            var4_7 = var3_6.startBuilding((JsonParser)var1_1, var2_5, null);
                            if (var1_1.isExpectedStartObjectToken()) lbl-1000:
                            // 5 sources

                            {
                                while (true) {
                                    var5_8 = var1_1.nextFieldName();
                                    break;
                                }
                            } else {
                                var5_8 = var1_1.hasToken(JsonToken.FIELD_NAME) != false ? var1_1.currentName() : null;
                            }
                            if (var5_8 == null) break block15;
                            var6_9 /* !! */  = var1_1.nextToken();
                            var7_10 = var3_6.findCreatorProperty((String)var5_8);
                            if (var7_10 == null) break block16;
                            v0 = var7_10;
                            if (!var4_7.assignParameter(v0, v0.deserialize((JsonParser)var1_1, var2_5))) ** GOTO lbl-1000
                            var1_1.nextToken();
                            try {
                                return this.deserialize((JsonParser)var1_1, var2_5, (EnumMap)var3_6.build(var2_5, var4_7));
                            }
                            catch (Exception var1_2) {
                                return (EnumMap)this.wrapAndThrow(var2_5, var1_2, this._containerType.getRawClass(), (String)var5_8);
                            }
                        }
                        var7_10 = (Enum)this._keyDeserializer.deserializeKey((String)var5_8, var2_5);
                        if (var7_10 != null) break block17;
                        if (!var2_5.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                            v1 = new Object[1];
                            var1_1 = v1;
                            v1[0] = this._containerType.getKeyType();
                            return (EnumMap)var2_5.handleWeirdStringValue(this._enumClass, (String)var5_8, "value not one of declared Enum instance names for %s", var1_1);
                        }
                        var1_1.nextToken();
                        var1_1.skipChildren();
                        ** GOTO lbl-1000
                    }
                    try {
                        if (var6_9 /* !! */  != JsonToken.VALUE_NULL) break block13;
                    }
                    catch (Exception var1_3) {
                        break block14;
                    }
                    if (this._skipNullValues) ** GOTO lbl-1000
                    v2 = this._nullProvider.getNullValue(var2_5);
lbl41:
                    // 3 sources

                    while (true) {
                        continue;
                        break;
                    }
                }
                var6_9 /* !! */  = this._valueTypeDeserializer;
                if (var6_9 /* !! */  != null) ** GOTO lbl48
                {
                    v2 = this._valueDeserializer.deserialize((JsonParser)var1_1, var2_5);
                    ** GOTO lbl41
lbl48:
                    // 1 sources

                    v2 = this._valueDeserializer.deserializeWithType((JsonParser)var1_1, var2_5, (TypeDeserializer)var6_9 /* !! */ );
                    ** continue;
                }
                var5_8 = v2;
                var4_7.bufferMapProperty(var7_10, var5_8);
                ** while (true)
            }
            this.wrapAndThrow(var2_5, var1_3, this._containerType.getRawClass(), (String)var5_8);
            return null;
        }
        try {
            return (EnumMap)var3_6.build(var2_5, var4_7);
        }
        catch (Exception var1_4) {
            this.wrapAndThrow(var2_5, var1_4, this._containerType.getRawClass(), (String)var5_8);
            return null;
        }
    }
}

