/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.NullValueProvider;
import com.privatefasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.privatefasterxml.jackson.databind.deser.std.StdDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.AccessPattern;
import java.util.EnumSet;
import java.util.Objects;

public class EnumSetDeserializer
extends StdDeserializer<EnumSet<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _enumType;
    protected JsonDeserializer<Enum<?>> _enumDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final boolean _skipNullValues;
    protected final Boolean _unwrapSingle;

    public EnumSetDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        super(EnumSet.class);
        this._enumType = javaType;
        if (javaType.isEnumType()) {
            EnumSetDeserializer enumSetDeserializer = this;
            enumSetDeserializer._enumDeserializer = jsonDeserializer;
            enumSetDeserializer._unwrapSingle = null;
            enumSetDeserializer._nullProvider = null;
            enumSetDeserializer._skipNullValues = false;
            return;
        }
        throw new IllegalArgumentException("Type " + javaType + " not Java Enum type");
    }

    @Deprecated
    public EnumSetDeserializer(EnumSetDeserializer enumSetDeserializer, JsonDeserializer<?> jsonDeserializer, Boolean bl) {
        EnumSetDeserializer enumSetDeserializer2 = nullValueProvider;
        NullValueProvider nullValueProvider = enumSetDeserializer._nullProvider;
        enumSetDeserializer2(enumSetDeserializer, jsonDeserializer, nullValueProvider, bl);
    }

    public EnumSetDeserializer(EnumSetDeserializer enumSetDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        super(enumSetDeserializer);
        this._enumType = enumSetDeserializer._enumType;
        this._enumDeserializer = jsonDeserializer;
        this._nullProvider = nullValueProvider;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
        this._unwrapSingle = bl;
    }

    private EnumSet constructSet() {
        return EnumSet.noneOf(this._enumType.getRawClass());
    }

    public EnumSetDeserializer withDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._enumDeserializer == jsonDeserializer) {
            return this;
        }
        EnumSetDeserializer enumSetDeserializer = this;
        NullValueProvider nullValueProvider = enumSetDeserializer._nullProvider;
        Boolean bl = enumSetDeserializer._unwrapSingle;
        return new EnumSetDeserializer(this, jsonDeserializer, nullValueProvider, bl);
    }

    @Deprecated
    public EnumSetDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, Boolean bl) {
        return this.withResolved(jsonDeserializer, this._nullProvider, bl);
    }

    public EnumSetDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        if (Objects.equals(this._unwrapSingle, bl) && this._enumDeserializer == jsonDeserializer && this._nullProvider == jsonDeserializer) {
            return this;
        }
        return new EnumSetDeserializer(this, jsonDeserializer, nullValueProvider, bl);
    }

    @Override
    public boolean isCachable() {
        return this._enumType.getValueHandler() == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this.constructSet();
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        EnumSetDeserializer enumSetDeserializer = this;
        Object object = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY;
        object = enumSetDeserializer.findFormatFeature(deserializationContext, beanProperty, EnumSet.class, (JsonFormat.Feature)((Object)object));
        JsonDeserializer<Object> jsonDeserializer = enumSetDeserializer._enumDeserializer;
        if (jsonDeserializer == null) {
            jsonDeserializer = deserializationContext.findContextualValueDeserializer(this._enumType, beanProperty);
        } else {
            JavaType javaType = this._enumType;
            jsonDeserializer = deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        return this.withResolved(jsonDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer), (Boolean)object);
    }

    @Override
    public EnumSet<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        EnumSet enumSet = this.constructSet();
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, enumSet);
        }
        return this._deserialize(jsonParser, deserializationContext, enumSet);
    }

    @Override
    public EnumSet<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, EnumSet<?> enumSet) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, enumSet);
        }
        return this._deserialize(jsonParser, deserializationContext, enumSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final EnumSet<?> _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, EnumSet enumSet) {
        Exception exception2;
        block8: {
            while (true) {
                Object object;
                Enum enum_;
                block7: {
                    block6: {
                        try {
                            enum_ = jsonParser.nextToken();
                            if (enum_ == JsonToken.END_ARRAY) break;
                            if (enum_ != JsonToken.VALUE_NULL) break block6;
                        }
                        catch (Exception exception2) {
                            break block8;
                        }
                        if (this._skipNullValues) continue;
                        object = this._nullProvider.getNullValue(deserializationContext);
                        break block7;
                    }
                    object = this._enumDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if ((enum_ = object) == null) continue;
                enumSet.add(enum_);
            }
            return enumSet;
        }
        EnumSet enumSet2 = enumSet;
        throw JsonMappingException.wrapWithPath((Throwable)exception2, (Object)enumSet2, enumSet2.size());
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    public EnumSet<?> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, EnumSet enumSet) {
        Exception exception2;
        block6: {
            block5: {
                Boolean bl = ((EnumSetDeserializer)((Object)enum_))._unwrapSingle;
                if (!(bl == Boolean.TRUE || bl == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY))) {
                    return (EnumSet)deserializationContext.handleUnexpectedToken(EnumSet.class, jsonParser);
                }
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return (EnumSet)deserializationContext.handleUnexpectedToken(((EnumSetDeserializer)((Object)enum_))._enumType, jsonParser);
                }
                try {
                    Enum<?> enum_ = ((EnumSetDeserializer)((Object)enum_))._enumDeserializer.deserialize(jsonParser, deserializationContext);
                    if (enum_ == null) break block5;
                }
                catch (Exception exception2) {
                    break block6;
                }
                enumSet.add(enum_);
            }
            return enumSet;
        }
        EnumSet enumSet2 = enumSet;
        throw JsonMappingException.wrapWithPath((Throwable)exception2, (Object)enumSet2, enumSet2.size());
    }
}

