/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.deser.std;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.util.VersionUtil;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.privatefasterxml.jackson.databind.deser.std.g;
import com.privatefasterxml.jackson.databind.deser.std.h;
import com.privatefasterxml.jackson.databind.exc.InvalidFormatException;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class, StringBuilder.class, StringBuffer.class};
    }

    public FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public static FromStringDeserializer<?> findDeserializer(Class<?> clazz) {
        block17: {
            int n2;
            block6: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block5: {
                                                            if (clazz != File.class) break block5;
                                                            n2 = 1;
                                                            break block6;
                                                        }
                                                        if (clazz != URL.class) break block7;
                                                        n2 = 2;
                                                        break block6;
                                                    }
                                                    if (clazz != URI.class) break block8;
                                                    n2 = 3;
                                                    break block6;
                                                }
                                                if (clazz != Class.class) break block9;
                                                n2 = 4;
                                                break block6;
                                            }
                                            if (clazz != JavaType.class) break block10;
                                            n2 = 5;
                                            break block6;
                                        }
                                        if (clazz != Currency.class) break block11;
                                        n2 = 6;
                                        break block6;
                                    }
                                    if (clazz != Pattern.class) break block12;
                                    n2 = 7;
                                    break block6;
                                }
                                if (clazz != Locale.class) break block13;
                                n2 = 8;
                                break block6;
                            }
                            if (clazz != Charset.class) break block14;
                            n2 = 9;
                            break block6;
                        }
                        if (clazz != TimeZone.class) break block15;
                        n2 = 10;
                        break block6;
                    }
                    if (clazz != InetAddress.class) break block16;
                    n2 = 11;
                    break block6;
                }
                if (clazz != InetSocketAddress.class) break block17;
                n2 = 12;
            }
            return new Std(clazz, n2);
        }
        if (clazz == StringBuilder.class) {
            return new h();
        }
        if (clazz == StringBuffer.class) {
            return new g();
        }
        return null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T deserialize(JsonParser object, DeserializationContext deserializationContext) {
        void var1_4;
        Object object2 = ((JsonParser)object).getValueAsString();
        if (object2 == null) {
            object2 = ((JsonParser)object).currentToken();
            if (object2 != JsonToken.START_OBJECT) {
                return (T)this._deserializeFromOther((JsonParser)object, deserializationContext, (JsonToken)((Object)object2));
            }
            object2 = this._valueClass;
            object2 = deserializationContext.extractScalarFromObject((JsonParser)object, this, (Class<?>)object2);
        }
        if (object2.isEmpty()) {
            return (T)this._deserializeFromEmptyString(deserializationContext);
        }
        if (this._shouldTrim()) {
            object = object2.trim();
            if (object != object2 && ((String)object).isEmpty()) {
                return (T)this._deserializeFromEmptyString(deserializationContext);
            }
            object2 = object;
        }
        try {
            return this._deserialize((String)object2, deserializationContext);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String string = "not a valid textual representation";
        String string2 = var1_4.getMessage();
        if (string2 != null) {
            string = "not a valid textual representation, problem: ".concat(string2);
        }
        throw deserializationContext.weirdStringException((String)object2, this._valueClass, string).withCause((Throwable)var1_4);
    }

    public abstract T _deserialize(String var1, DeserializationContext var2);

    public boolean _shouldTrim() {
        return true;
    }

    public Object _deserializeFromOther(JsonParser object, DeserializationContext deserializationContext, JsonToken jsonToken) {
        if (jsonToken == JsonToken.START_ARRAY) {
            return this._deserializeFromArray((JsonParser)object, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            if ((object = ((JsonParser)object).getEmbeddedObject()) == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._valueClass, (JsonParser)object);
    }

    public T _deserializeEmbedded(Object object, DeserializationContext objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray[0] = object.getClass().getName();
        objectArray3[1] = this._valueClass.getName();
        objectArray2.reportInputMismatch(this, "Don't know how to convert embedded Object of type %s into %s", objectArray);
        return null;
    }

    @Deprecated
    public final T _deserializeFromEmptyString() {
        return null;
    }

    public Object _deserializeFromEmptyString(DeserializationContext deserializationContext) {
        FromStringDeserializer fromStringDeserializer = this;
        Enum enum_ = fromStringDeserializer.logicalType();
        Object[] objectArray = fromStringDeserializer._valueClass;
        if ((enum_ = deserializationContext.findCoercionAction((LogicalType)enum_, (Class<?>)objectArray, CoercionInputShape.EmptyString)) == CoercionAction.Fail) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this._coercedTypeDesc();
            deserializationContext.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", objectArray);
        }
        if (enum_ == CoercionAction.AsNull) {
            return this.getNullValue(deserializationContext);
        }
        if (enum_ == CoercionAction.AsEmpty) {
            return this.getEmptyValue(deserializationContext);
        }
        return this._deserializeFromEmptyStringDefault(deserializationContext);
    }

    public Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) {
        return this.getNullValue(deserializationContext);
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        public static final int STD_FILE = 1;
        public static final int STD_URL = 2;
        public static final int STD_URI = 3;
        public static final int STD_CLASS = 4;
        public static final int STD_JAVA_TYPE = 5;
        public static final int STD_CURRENCY = 6;
        public static final int STD_PATTERN = 7;
        public static final int STD_LOCALE = 8;
        public static final int STD_CHARSET = 9;
        public static final int STD_TIME_ZONE = 10;
        public static final int STD_INET_ADDRESS = 11;
        public static final int STD_INET_SOCKET_ADDRESS = 12;
        protected static final String LOCALE_EXT_MARKER = "_#";
        protected final int _kind;

        public Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        private Locale _deserializeLocale(String string, DeserializationContext deserializationContext) {
            int n2 = this._firstHyphenOrUnderscore(string);
            if (n2 < 0) {
                return new Locale(string);
            }
            String string2 = string;
            string = string.substring(0, n2);
            String string3 = string2.substring(n2 + 1);
            int n3 = this._firstHyphenOrUnderscore(string3);
            if (n3 < 0) {
                return new Locale(string, string3);
            }
            String string4 = string3;
            String string5 = string4.substring(0, n3);
            int n4 = string4.indexOf(LOCALE_EXT_MARKER);
            if (n4 < 0) {
                return new Locale(string, string5, string3.substring(n3 + 1));
            }
            return this._deSerializeBCP47Locale(string3, n3, string, string5, n4);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Locale _deSerializeBCP47Locale(String var1_1, int var2_4, String var3_5, String var4_6, int var5_7) {
            this = "";
            if (var5_7 <= 0 || var5_7 <= var2_4) ** GOTO lbl-1000
            try {
                this = var1_1.substring(var2_4 + 1, var5_7);
            }
            catch (IllformedLocaleException v0) {
                return new Locale(var3_5, var4_6, (String)this);
            }
lbl-1000:
            // 2 sources

            {
                if ((var2_4 = (var1_1 = var1_1.substring(var5_7 + 2)).indexOf(95)) >= 0) ** GOTO lbl14
            }
            {
                var2_4 = var1_1.indexOf(45);
                if (var2_4 >= 0) ** GOTO lbl-1000
            }
            return new Locale.Builder().setLanguage(var3_5).setRegion(var4_6).setVariant((String)this).setScript(var1_1).build();
lbl-1000:
            // 1 sources

            {
                var1_2 = var1_1.charAt(0);
                return new Locale.Builder().setLanguage(var3_5).setRegion(var4_6).setVariant((String)this).setExtension(var1_2, var1_1.substring(var2_4 + 1)).build();
lbl14:
                // 1 sources

                var5_7 = var1_1.length();
            }
            {
                var6_8 = new Locale.Builder().setLanguage(var3_5).setRegion(var4_6).setVariant((String)this).setScript(var1_1.substring(0, var2_4));
                var7_9 = var2_4 + 1;
                if (var7_9 >= var5_7) return var6_8.build();
            }
            {
                var1_3 = var1_1.charAt(var7_9);
                var6_8 = var6_8.setExtension(var1_3, var1_1.substring(Math.min(var5_7, var2_4 + 3)));
                return var6_8.build();
            }
        }

        @Override
        public Object _deserialize(String string, DeserializationContext serializable) {
            switch (serializable2._kind) {
                default: {
                    VersionUtil.throwInternal();
                    return null;
                }
                case 12: {
                    int n2;
                    if (string.startsWith("[")) {
                        int n3 = string.lastIndexOf(93);
                        if (n3 != -1) {
                            int n4 = string.indexOf(58, n3);
                            n4 = n4 > -1 ? Integer.parseInt(string.substring(n4 + 1)) : 0;
                            return new InetSocketAddress(string.substring(0, ++n3), n4);
                        }
                        throw new InvalidFormatException(((DeserializationContext)serializable).getParser(), "Bracketed IPv6 address must contain closing bracket", (Object)string, InetSocketAddress.class);
                    }
                    int n5 = string.indexOf(58);
                    if (n5 >= 0 && string.indexOf(58, n2 = n5 + 1) < 0) {
                        n2 = Integer.parseInt(string.substring(n2));
                        return new InetSocketAddress(string.substring(0, n5), n2);
                    }
                    return new InetSocketAddress(string, 0);
                }
                case 11: {
                    return InetAddress.getByName(string);
                }
                case 10: {
                    return TimeZone.getTimeZone(string);
                }
                case 9: {
                    return Charset.forName(string);
                }
                case 8: {
                    return serializable2._deserializeLocale(string, (DeserializationContext)serializable);
                }
                case 7: {
                    return Pattern.compile(string);
                }
                case 6: {
                    return Currency.getInstance(string);
                }
                case 5: {
                    return ((DeserializationContext)serializable).getTypeFactory().constructFromCanonical(string);
                }
                case 4: {
                    try {
                        return ((DeserializationContext)serializable).findClass(string);
                    }
                    catch (Exception exception) {
                        Serializable serializable2 = serializable2._valueClass;
                        serializable = ClassUtil.getRootCause(exception);
                        return ((DeserializationContext)serializable).handleInstantiationProblem((Class<?>)serializable2, string, (Throwable)serializable);
                    }
                }
                case 3: {
                    return URI.create(string);
                }
                case 2: {
                    return new URL(string);
                }
                case 1: 
            }
            return new File(string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            int n2 = this._kind;
            if (n2 != 3) {
                if (n2 != 8) {
                    return super.getEmptyValue(deserializationContext);
                }
                return Locale.ROOT;
            }
            return URI.create("");
        }

        @Override
        public Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) {
            return this.getEmptyValue(deserializationContext);
        }

        @Override
        public boolean _shouldTrim() {
            return this._kind != 7;
        }

        public int _firstHyphenOrUnderscore(String string) {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 != '_' && c2 != '-') {
                    continue;
                }
                return i2;
            }
            return -1;
        }
    }
}

